/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PipeAdv
extends PipeAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)PipeAdv.class.getName());
    private static final String[] fields = new String[]{"Name", "Id"};

    public PipeAdv() {
    }

    public PipeAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(PipeAdv.getAdvertisementType()) && !PipeAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
        if (this.getPipeID().equals(ID.nullID)) {
            throw new IllegalArgumentException("Bad pipe ID in advertisement");
        }
        if (null == this.getType() || 0 == this.getType().length()) {
            throw new IllegalArgumentException("Bad pipe type in advertisement");
        }
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals("Id")) {
            try {
                URL pipeID = IDFactory.jxtaURL(elem.getTextValue());
                this.setPipeID(IDFactory.fromURL(pipeID));
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("ID is not a pipe ID");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable pipe ID in advertisement");
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad pipe ID in advertisement");
            }
            return true;
        }
        if (elem.getName().equals("Name")) {
            this.setName(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals("Type")) {
            this.setType(elem.getTextValue().trim());
            return true;
        }
        if (elem.getName().equals("Desc")) {
            this.setDesc(elem);
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument desc;
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        ID itsID = this.getPipeID();
        if (null == itsID || itsID.equals(ID.nullID)) {
            throw new IllegalStateException("Pipe has no assigned ID");
        }
        Element e = adv.createElement("Id", itsID.toString());
        adv.appendChild(e);
        if (null == this.getType() || 0 == this.getType().length()) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Pipe type not set. Defaulting to JxtaUnicast.\n This default is deprecated. Please set the pipe type in your code.");
            }
            this.setType("JxtaUnicast");
        }
        e = adv.createElement("Type", this.getType());
        adv.appendChild(e);
        if (this.getName() != null) {
            e = adv.createElement("Name", this.getName());
            adv.appendChild(e);
        }
        if ((desc = this.getDesc()) != null) {
            StructuredDocumentUtils.copyElements(adv, adv, desc);
        }
        return adv;
    }

    public final String[] getIndexFields() {
        return fields;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return PipeAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new PipeAdv();
        }

        public Advertisement newInstance(Element root) {
            return new PipeAdv(root);
        }
    }
}

