/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Enumeration;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.protocol.DiscoveryQueryMsg;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class DiscoveryQuery
extends DiscoveryQueryMsg {
    private static final Logger LOG = Logger.getLogger((String)DiscoveryQuery.class.getName());
    private static final String typeTag = "Type";
    private static final String peerAdvTag = "PeerAdv";
    private static final String thresholdTag = "Threshold";
    private static final String queryAttrTag = "Attr";
    private static final String queryValueTag = "Value";

    public DiscoveryQuery() {
    }

    public DiscoveryQuery(Element doc) {
        this.initialize(doc);
    }

    protected boolean handleElement(Element raw) {
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(typeTag)) {
            this.setDiscoveryType(Integer.parseInt(elem.getTextValue()));
            return true;
        }
        if (elem.getName().equals(thresholdTag)) {
            this.setThreshold(Integer.parseInt(elem.getTextValue()));
            return true;
        }
        if (elem.getName().equals(peerAdvTag)) {
            this.setPeerAdv(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(queryAttrTag)) {
            this.setAttr(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(queryValueTag)) {
            this.setValue(elem.getTextValue());
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        if (!doc.getName().equals(DiscoveryQuery.getAdvertisementType())) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        this.setDiscoveryType(-1);
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            Element elem = (Element)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element : " + elem.toString()));
        }
        if (0 != this.getDiscoveryType() && 1 != this.getDiscoveryType() && 2 != this.getDiscoveryType()) {
            throw new IllegalArgumentException("Type is not one of the required values.");
        }
        if (this.getThreshold() < 0) {
            throw new IllegalArgumentException("Threshold must not be less than zero.");
        }
        if (this.getDiscoveryType() != 0 && this.getThreshold() == 0) {
            throw new IllegalArgumentException("Threshold may not be zero.");
        }
        if (null == this.getAttr() && null != this.getValue()) {
            throw new IllegalArgumentException("Value specified without attribute.");
        }
    }

    public Document getDocument(MimeMediaType asMimeType) {
        String attr;
        StructuredTextDocument adv = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(asMimeType, DiscoveryQuery.getAdvertisementType());
        if (adv instanceof XMLDocument) {
            XMLDocument xmlDoc = (XMLDocument)adv;
            xmlDoc.addAttribute("xmlns:jxta", "http://jxta.org");
            xmlDoc.addAttribute("xml:space", "preserve");
        }
        Element e = adv.createElement((Object)typeTag, (Object)Integer.toString(this.getDiscoveryType()));
        adv.appendChild(e);
        int threshold = this.getThreshold();
        if (threshold < 0) {
            throw new IllegalStateException("threshold must be >= 0");
        }
        e = adv.createElement((Object)thresholdTag, (Object)Integer.toString(threshold));
        adv.appendChild(e);
        String peerAdv = this.getPeerAdv();
        if (peerAdv != null && peerAdv.length() > 0) {
            e = adv.createElement((Object)peerAdvTag, (Object)this.getPeerAdv());
            adv.appendChild(e);
        }
        if ((attr = this.getAttr()) != null && attr.length() > 0) {
            e = adv.createElement((Object)queryAttrTag, (Object)attr.trim());
            adv.appendChild(e);
            String value = this.getValue();
            if (value != null && value.length() > 0) {
                e = adv.createElement((Object)queryValueTag, (Object)value.trim());
                adv.appendChild(e);
            } else if (threshold < 0) {
                throw new IllegalStateException("Attribute specified, but no value was specified.");
            }
        }
        return adv;
    }

    public String toString() {
        try {
            StructuredTextDocument doc = (StructuredTextDocument)this.getDocument(MimeMediaType.XMLUTF8);
            return doc.toString();
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e);
        }
    }
}

