/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.protocol;

import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.Enumeration;
import java.util.Vector;
import net.jxta.codat.CodatID;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.protocol.ModuleClassAdv;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.AccessPointAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class AccessPointAdv
extends AccessPointAdvertisement {
    private static final Logger LOG = Logger.getLogger((String)ModuleClassAdv.class.getName());
    private static final String PID_TAG = "PID";
    private static final String EA_TAG = "EA";
    private static final String[] fields = new String[]{"PID"};

    public AccessPointAdv() {
    }

    public AccessPointAdv(PeerID pid, Vector addresses) {
        this.setPeerID(pid);
        this.setEndpointAddresses(addresses);
    }

    public AccessPointAdv(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(AccessPointAdv.getAdvertisementType()) && !AccessPointAdv.getAdvertisementType().equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.toString()));
        }
    }

    public final String[] getIndexFields() {
        return fields;
    }

    public static String getAdvertisementType() {
        return "jxta:APA";
    }

    public String getAdvType() {
        return AccessPointAdv.getAdvertisementType();
    }

    public final String getBaseAdvType() {
        return AccessPointAdv.getAdvertisementType();
    }

    public ID getID() {
        PeerID pid = this.getPeerID();
        if (null == pid || ID.nullID == pid) {
            throw new IllegalStateException("cannot build ID: no peer id");
        }
        CodatID hashID = null;
        try {
            String seed = this.getAdvType() + this.getPeerID().toString();
            ByteArrayInputStream in = new ByteArrayInputStream(seed.getBytes());
            hashID = IDFactory.newCodatID(PeerGroupID.worldPeerGroupID, seed.getBytes(), in);
        }
        catch (Exception ez) {
            throw new IllegalStateException("cannot build ID: " + ez.toString());
        }
        return hashID;
    }

    protected boolean handleElement(Element raw) {
        if (super.handleElement(raw)) {
            return true;
        }
        XMLElement elem = (XMLElement)raw;
        if (elem.getName().equals(PID_TAG)) {
            try {
                URL pID = IDFactory.jxtaURL(elem.getTextValue());
                this.setPeerID((PeerID)IDFactory.fromURL(pID));
            }
            catch (MalformedURLException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in advertisement");
            }
            catch (UnknownServiceException badID) {
                throw new IllegalArgumentException("Unusable ID in advertisement");
            }
            return true;
        }
        if (elem.getName().equals(EA_TAG)) {
            this.addEndpointAddress(elem.getTextValue());
            return true;
        }
        return false;
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredDocument adv = (StructuredDocument)super.getDocument(encodeAs);
        if (this.getPeerID() != null) {
            Element e = adv.createElement(PID_TAG, this.getPeerID().toString());
            adv.appendChild(e);
        }
        Enumeration enumeration = this.getEndpointAddresses();
        while (enumeration.hasMoreElements()) {
            Element e2 = adv.createElement(EA_TAG, enumeration.nextElement().toString());
            adv.appendChild(e2);
        }
        return adv;
    }

    public static class Instantiator
    implements AdvertisementFactory.Instantiator {
        public String getAdvertisementType() {
            return AccessPointAdv.getAdvertisementType();
        }

        public Advertisement newInstance() {
            return new AccessPointAdv();
        }

        public Advertisement newInstance(Element root) {
            return new AccessPointAdv(root);
        }
    }
}

