/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Document;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class WireHeader {
    private static final Logger LOG = Logger.getLogger((String)WireHeader.class.getName());
    public static final String Name = "JxtaWire";
    public static final String MsgIdTag = "MsgId";
    public static final String PipeIdTag = "PipeId";
    public static final String SrcTag = "SrcPeer";
    public static final String TTLTag = "TTL";
    public static final String PeerTag = "VisitedPeer";
    private ID srcPeer = ID.nullID;
    private ID pipeID = ID.nullID;
    private String msgId = null;
    private int TTL = Integer.MIN_VALUE;
    private Set peers = new HashSet();

    public WireHeader() {
    }

    public WireHeader(ID srcPeer, ID wireId, int ttl) {
        this.srcPeer = srcPeer;
        this.pipeID = wireId;
        this.TTL = ttl;
    }

    public WireHeader(Element root) {
        this();
        this.initialize(root);
    }

    public void setSrcPeer(ID p) {
        this.srcPeer = p;
    }

    public ID getSrcPeer() {
        return this.srcPeer;
    }

    public void setTTL(int t) {
        this.TTL = t;
    }

    public int getTTL() {
        return this.TTL;
    }

    public void addPeer(String peer) {
        this.peers.add(peer);
    }

    public void setPeers(Set v) {
        this.peers = new HashSet(v);
    }

    public boolean containsPeer(String peer) {
        return this.peers.contains(peer);
    }

    public String[] getPeers() {
        return this.peers.toArray(new String[0]);
    }

    public String getMsgId() {
        return this.msgId;
    }

    public void setMsgId(String id) {
        this.msgId = id;
    }

    public ID getPipeID() {
        return this.pipeID;
    }

    public void setPipeID(ID id) {
        this.pipeID = id;
    }

    protected boolean handleElement(XMLElement elem) {
        if (elem.getName().equals(SrcTag)) {
            try {
                URI pID = new URI(elem.getTextValue());
                this.setSrcPeer(IDFactory.fromURI(pID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerID ID in header: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals(MsgIdTag)) {
            this.msgId = elem.getTextValue();
            return true;
        }
        if (elem.getName().equals(PipeIdTag)) {
            try {
                URI pipeID = new URI(elem.getTextValue());
                this.setPipeID(IDFactory.fromURI(pipeID));
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad pipe ID in header");
            }
            return true;
        }
        if (elem.getName().equals(TTLTag)) {
            this.TTL = Integer.parseInt(elem.getTextValue());
            return true;
        }
        if (elem.getName().equals(PeerTag)) {
            this.peers.add(elem.getTextValue());
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XLMElement");
        }
        XMLElement doc = (XMLElement)root;
        String doctype = doc.getName();
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!doctype.equals(Name) && !Name.equals(typedoctype)) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doc.getName());
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Unhandled Element: " + elem.getName()));
        }
        if (null == this.getMsgId()) {
            throw new IllegalArgumentException("Header does not contain a message id");
        }
        if (ID.nullID == this.getPipeID()) {
            throw new IllegalArgumentException("Header does not contain a pipe id");
        }
        if (this.TTL <= 0) {
            throw new IllegalArgumentException("Illegal TTL value");
        }
    }

    public Document getDocument(MimeMediaType encodeAs) {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(encodeAs, Name);
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("xmlns:jxta", "http://jxta.org");
        }
        if (null == this.getMsgId()) {
            throw new IllegalArgumentException("Message id is not initialized");
        }
        if (ID.nullID == this.getPipeID()) {
            throw new IllegalArgumentException("PipeID is not initialized");
        }
        if (this.TTL <= 0) {
            throw new IllegalArgumentException("Illegal TTL value");
        }
        TextElement e = null;
        if (this.srcPeer != null && this.srcPeer != ID.nullID) {
            e = doc.createElement(SrcTag, this.srcPeer.toString());
            doc.appendChild((Element)e);
        }
        e = doc.createElement(PipeIdTag, this.getPipeID().toString());
        doc.appendChild((Element)e);
        e = doc.createElement(MsgIdTag, this.getMsgId());
        doc.appendChild((Element)e);
        e = doc.createElement(TTLTag, Integer.toString(this.TTL));
        doc.appendChild((Element)e);
        Iterator eachPeer = this.peers.iterator();
        while (eachPeer.hasNext()) {
            e = doc.createElement(PeerTag, (String)eachPeer.next());
            doc.appendChild((Element)e);
        }
        return doc;
    }
}

