/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.Set;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.id.ID;
import net.jxta.impl.pipe.NonBlockingOutputPipe;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class SecureOutputPipe
extends NonBlockingOutputPipe {
    private static final Logger LOG = Logger.getLogger((String)SecureOutputPipe.class.getName());

    public SecureOutputPipe(PeerGroup group, PipeResolver resolver, PipeAdvertisement pipeAdv, PeerID destPeer, Set peers) throws IOException {
        super(group, resolver, pipeAdv, destPeer, peers);
    }

    public synchronized boolean send(Message msg) throws IOException {
        boolean sent = false;
        int attempts = 1;
        while (!sent && !this.isClosed()) {
            try {
                sent = super.send(msg);
                if (sent) continue;
                this.wait(10 + (1 << Math.max(attempts, 20)));
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
            }
        }
        if (!sent && this.isClosed()) {
            IOException failed = new IOException("Could not enqueue " + msg + " for sending. Pipe is closed.");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)failed, (Throwable)failed);
            }
            throw failed;
        }
        return sent;
    }

    protected EndpointAddress mkAddress(ID destPeer, ID pipeID) {
        EndpointAddress addr = new EndpointAddress("jxtatls", destPeer.getUniqueValue().toString(), "PipeService", pipeID.toString());
        return addr;
    }
}

