/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.pipe;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.id.ID;
import net.jxta.impl.pipe.PipeResolver;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.util.UnbiasedQueue;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class NonBlockingOutputPipe
implements PipeResolver.Listener,
OutputPipe,
Runnable {
    private static final Logger LOG = Logger.getLogger((String)NonBlockingOutputPipe.class.getName());
    private static final long IDLEWORKERLINGER = 10000L;
    private static final long QUERYINTERVALMIN = 15000L;
    private static final long QUERYTIMEOUTMIN = 60000L;
    private volatile boolean closed = false;
    private boolean migrated = false;
    private PeerGroup myGroup = null;
    private EndpointService endpoint = null;
    private PipeResolver myPipeResolver = null;
    private PipeAdvertisement pAdv = null;
    private PeerID destPeer = null;
    private Set resolvablePeers = null;
    private EndpointAddress destAddress = null;
    private Messenger destMessenger = null;
    private volatile Thread serviceThread = null;
    private long nextVerifyAt = 0L;
    private UnbiasedQueue queue = UnbiasedQueue.synchronizedQueue(new UnbiasedQueue(50, false));
    private workerState workerstate;
    private int queryID = -1;

    public NonBlockingOutputPipe(PeerGroup g, PipeResolver r, PipeAdvertisement pAdv, PeerID destPeer, Set peers) {
        this.myGroup = g;
        this.myPipeResolver = r;
        this.pAdv = pAdv;
        this.destPeer = destPeer;
        this.resolvablePeers = new HashSet(peers);
        this.endpoint = g.getEndpointService();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("Constructing for " + this.getPipeID()));
        }
        this.workerstate = workerState.ACQUIREMESSENGER;
        this.startServiceThread();
    }

    protected void finalize() {
        this.close();
    }

    public synchronized void close() {
        if (!this.closed) {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Closing queue for " + this.getPipeID()));
            }
            this.queue.close();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public final String getType() {
        return this.pAdv.getType();
    }

    public final ID getPipeID() {
        return this.pAdv.getPipeID();
    }

    public final String getName() {
        return this.pAdv.getName();
    }

    public final PipeAdvertisement getAdvertisement() {
        return this.pAdv;
    }

    public boolean send(Message msg) throws IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Queuing " + msg + " for pipe " + this.getPipeID()));
        }
        boolean pushed = false;
        while (!this.queue.isClosed()) {
            try {
                pushed = this.queue.push(msg, 250L);
                break;
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
            }
        }
        if (!pushed && this.queue.isClosed()) {
            IOException failed = new IOException("Could not enqueue " + msg + " for sending. Pipe is closed.");
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)failed, (Throwable)failed);
            }
            throw failed;
        }
        this.startServiceThread();
        return pushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long absoluteTimeoutAt = -1L;
        long nextQueryAt = -1L;
        try {
            try {}
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                NonBlockingOutputPipe nonBlockingOutputPipe = this;
                synchronized (nonBlockingOutputPipe) {
                    if (this.serviceThread == Thread.currentThread()) {
                        this.serviceThread = null;
                    }
                }
                Object var14_13 = null;
                if (!LOG.isEnabledFor((Priority)Level.INFO)) return;
                LOG.info((Object)("Thread exit : " + Thread.currentThread().getName() + "\n\tworker state : " + this.workerstate + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued()));
                return;
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (!LOG.isEnabledFor((Priority)Level.INFO)) throw throwable;
            LOG.info((Object)("Thread exit : " + Thread.currentThread().getName() + "\n\tworker state : " + this.workerstate + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued()));
            throw throwable;
        }
        while (workerState.CLOSED != this.workerstate) {
            block61: {
                NonBlockingOutputPipe nonBlockingOutputPipe = this;
                synchronized (nonBlockingOutputPipe) {
                    block63: {
                        block62: {
                            LOG.debug((Object)("NON-BLOCKING WORKER AT STATE : " + this.workerstate + (workerState.SENDMESSAGES == this.workerstate ? "\n\t" + TimeUtils.toRelativeTimeMillis(this.nextVerifyAt, TimeUtils.timeNow()) + " until verify." : "")));
                            if (workerState.STARTVERIFY != this.workerstate && workerState.STARTMIGRATE != this.workerstate) break block62;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                if (null == this.destPeer) {
                                    LOG.debug((Object)("Starting re-resolve for '" + this.getPipeID()));
                                } else {
                                    LOG.debug((Object)("Starting verify for '" + this.getPipeID() + "' to : " + this.destPeer));
                                }
                            }
                            NonBlockingOutputPipe nonBlockingOutputPipe2 = this;
                            this.queryID = nonBlockingOutputPipe2.myPipeResolver.getNextQueryID();
                            this.myPipeResolver.addListener((PipeID)this.getPipeID(), this, this.queryID);
                            absoluteTimeoutAt = TimeUtils.toAbsoluteTimeMillis(Math.max(60000L, 60000L));
                            nextQueryAt = TimeUtils.timeNow();
                            if (workerState.STARTVERIFY == this.workerstate) {
                                this.workerstate = workerState.PENDINGVERIFY;
                                break block63;
                            } else if (workerState.STARTMIGRATE == this.workerstate) {
                                this.workerstate = workerState.PENDINGMIGRATE;
                            }
                            break block63;
                        }
                        if (workerState.PENDINGVERIFY == this.workerstate || workerState.PENDINGMIGRATE == this.workerstate) {
                            long sleep;
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Pipe " + (workerState.PENDINGVERIFY == this.workerstate ? "verify" : "migrate") + "in progress. Continues for " + TimeUtils.toRelativeTimeMillis(absoluteTimeoutAt, TimeUtils.timeNow()) + "ms. Next query in " + TimeUtils.toRelativeTimeMillis(nextQueryAt, TimeUtils.timeNow()) + "ms."));
                            }
                            if (TimeUtils.toRelativeTimeMillis(absoluteTimeoutAt, TimeUtils.timeNow()) <= 0L) {
                                this.myPipeResolver.removeListener((PipeID)this.getPipeID(), this.queryID);
                                if (workerState.PENDINGVERIFY == this.workerstate) {
                                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                        LOG.info((Object)("Pipe '" + this.getPipeID() + "' has migrated from " + this.destPeer));
                                    }
                                    this.workerstate = workerState.STARTMIGRATE;
                                    continue;
                                }
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)("Pipe '" + this.getPipeID() + "' cannot be migrated and is being closed"));
                                }
                                this.workerstate = workerState.CLOSED;
                                this.close();
                                continue;
                            }
                            if (TimeUtils.toRelativeTimeMillis(nextQueryAt, TimeUtils.timeNow()) <= 0L) {
                                if (null != this.destPeer) {
                                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                        LOG.debug((Object)("Sending out verify query (" + this.queryID + ") for '" + this.getPipeID() + "' to : " + this.destPeer));
                                    }
                                    this.myPipeResolver.sendPipeQuery(this.pAdv, Collections.singleton(this.destPeer), this.queryID);
                                } else {
                                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                        LOG.debug((Object)("Sending out resolve query (" + this.queryID + ") for " + this.getPipeID()));
                                    }
                                    this.myPipeResolver.sendPipeQuery(this.pAdv, this.resolvablePeers, this.queryID);
                                }
                                nextQueryAt = TimeUtils.toAbsoluteTimeMillis(Math.max(15000L, 24000L));
                            }
                            if ((sleep = TimeUtils.toRelativeTimeMillis(Math.min(nextQueryAt, absoluteTimeoutAt), TimeUtils.timeNow())) >= 0L) {
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("Waiting " + sleep + "ms for response for (" + this.queryID + ") for " + this.getPipeID()));
                                }
                                try {
                                    this.wait(sleep);
                                }
                                catch (InterruptedException woken) {
                                    Thread.interrupted();
                                }
                            }
                        } else {
                            if (workerState.ACQUIREMESSENGER == this.workerstate) {
                                if (null == this.destMessenger || this.destMessenger.isClosed()) {
                                    this.destMessenger = null;
                                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                        LOG.debug((Object)("Getting messenger to '" + this.destPeer + "' for pipe " + (PipeID)this.getPipeID()));
                                    }
                                    this.destAddress = this.mkAddress(this.destPeer, this.getPipeID());
                                    this.destMessenger = this.endpoint.getMessenger(this.destAddress);
                                    if (this.destMessenger == null) {
                                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                            LOG.warn((Object)("Could not get messenger to : " + this.destPeer + ". "));
                                        }
                                        if (this.migrated) {
                                            this.workerstate = workerState.CLOSED;
                                            this.close();
                                        } else {
                                            this.workerstate = workerState.STARTMIGRATE;
                                        }
                                        this.myPipeResolver.removeListener((PipeID)this.getPipeID(), this.queryID);
                                        this.queryID = -1;
                                        this.destPeer = null;
                                        this.destAddress = null;
                                        continue;
                                    }
                                    this.migrated = false;
                                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("Using existing messenger to : " + this.destPeer));
                                }
                                this.workerstate = workerState.SENDMESSAGES;
                                this.nextVerifyAt = TimeUtils.toAbsoluteTimeMillis(1200000L);
                                continue;
                            }
                            if (workerState.SENDMESSAGES == this.workerstate) {
                                if (TimeUtils.toRelativeTimeMillis(this.nextVerifyAt, TimeUtils.timeNow()) <= 0L) {
                                    this.workerstate = workerState.STARTVERIFY;
                                    this.myPipeResolver.removeListener((PipeID)this.getPipeID(), this.queryID);
                                    this.queryID = -1;
                                }
                            } else {
                                if (workerState.CLOSED == this.workerstate) {
                                    this.queue.clear();
                                    if (null != this.destMessenger) {
                                        this.destMessenger.close();
                                        this.destMessenger = null;
                                    }
                                    this.serviceThread = null;
                                    break;
                                }
                                LOG.warn((Object)("Unrecognized state in worker thread : " + this.workerstate));
                            }
                        }
                    }
                    if (workerState.SENDMESSAGES != this.workerstate) continue;
                }
                Message msg = null;
                try {
                    msg = (Message)this.queue.pop(10000L);
                }
                catch (InterruptedException woken) {
                    Thread.interrupted();
                    continue;
                }
                if (null == msg) {
                    NonBlockingOutputPipe woken = this;
                    synchronized (woken) {
                        if (null == this.queue.peek()) {
                            if (this.closed) {
                                this.workerstate = workerState.CLOSED;
                                continue;
                            }
                            this.serviceThread = null;
                            break;
                        }
                        continue;
                    }
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending " + msg + " on " + this.getPipeID()));
                }
                if (!this.destMessenger.isClosed()) {
                    try {
                        this.destMessenger.sendMessageB(msg, null, null);
                    }
                    catch (IOException failed) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block61;
                        LOG.warn((Object)("Failure sending " + msg + " on " + this.getPipeID()), (Throwable)failed);
                    }
                }
            }
            if (!this.destMessenger.isClosed()) continue;
            NonBlockingOutputPipe nonBlockingOutputPipe = this;
            synchronized (nonBlockingOutputPipe) {
                this.workerstate = workerState.ACQUIREMESSENGER;
                this.destMessenger = null;
            }
        }
        Object var14_12 = null;
        if (!LOG.isEnabledFor((Priority)Level.INFO)) return;
        LOG.info((Object)("Thread exit : " + Thread.currentThread().getName() + "\n\tworker state : " + this.workerstate + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued()));
    }

    private synchronized void startServiceThread() {
        if (null == this.serviceThread && !this.closed) {
            this.serviceThread = new Thread(this.myGroup.getHomeThreadGroup(), this, "Worker Thread for NonBlockingOutputPipe : " + this.getPipeID());
            this.serviceThread.setDaemon(true);
            this.serviceThread.start();
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Thread start : " + this.serviceThread.getName() + "\n\tworker state : " + this.workerstate + "\tqueue closed : " + this.queue.isClosed() + "\tnumber in queue : " + this.queue.getCurrentInQueue() + "\tnumber queued : " + this.queue.getNumEnqueued() + "\tnumber dequeued : " + this.queue.getNumDequeued()));
            }
        }
    }

    protected EndpointAddress mkAddress(ID destPeer, ID pipeID) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), "PipeService", pipeID.toString());
        return addr;
    }

    public synchronized boolean pipeNAKEvent(PipeResolver.Event event) {
        if ((this.workerstate == workerState.PENDINGVERIFY || this.workerstate == workerState.ACQUIREMESSENGER || this.workerstate == workerState.SENDMESSAGES) && event.getPeerID().equals(this.destPeer) && event.getQueryID() == this.queryID) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Pipe '" + this.getPipeID() + "' is closed at " + event.getPeerID()));
            }
            this.workerstate = workerState.STARTMIGRATE;
            this.myPipeResolver.removeListener((PipeID)this.getPipeID(), this.queryID);
            this.queryID = -1;
            this.destPeer = null;
            this.destAddress = null;
            if (null != this.destMessenger) {
                this.destMessenger.close();
                this.destMessenger = null;
            }
            this.notify();
            return true;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Ignoring NAK from " + event.getPeerID()));
        }
        return false;
    }

    public synchronized boolean pipeResolveEvent(PipeResolver.Event event) {
        if ((this.workerstate == workerState.PENDINGVERIFY || this.workerstate == workerState.PENDINGMIGRATE) && event.getQueryID() == this.queryID) {
            if (this.workerstate == workerState.PENDINGVERIFY && !event.getPeerID().equals(this.destPeer)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Ignoring response from " + event.getPeerID()));
                }
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Pipe '" + this.getPipeID() + "' is verified for " + this.destPeer));
            }
            this.workerstate = workerState.ACQUIREMESSENGER;
            this.migrated = true;
            this.destPeer = event.getPeerID();
            if (this.workerstate == workerState.PENDINGMIGRATE && LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Pipe '" + this.getPipeID() + "' has migrated to " + this.destPeer));
            }
            this.notify();
            return true;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Ignoring resolve from " + event.getPeerID()));
        }
        return false;
    }

    static class workerState {
        public static final workerState STARTMIGRATE = new workerState(){

            public String toString() {
                return "STARTMIGRATE";
            }
        };
        public static final workerState PENDINGMIGRATE = new workerState(){

            public String toString() {
                return "PENDINGMIGRATE";
            }
        };
        public static final workerState STARTVERIFY = new workerState(){

            public String toString() {
                return "STARTVERIFY";
            }
        };
        public static final workerState PENDINGVERIFY = new workerState(){

            public String toString() {
                return "PENDINGVERIFY";
            }
        };
        public static final workerState ACQUIREMESSENGER = new workerState(){

            public String toString() {
                return "ACQUIREMESSENGER";
            }
        };
        public static final workerState SENDMESSAGES = new workerState(){

            public String toString() {
                return "SENDMESSAGES";
            }
        };
        public static final workerState CLOSED = new workerState(){

            public String toString() {
                return "CLOSED";
            }
        };

        private workerState() {
        }
    }
}

