/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.MessageTransport;
import net.jxta.exception.PeerGroupException;
import net.jxta.exception.ServiceNotFoundException;
import net.jxta.exception.ViolationException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.peergroup.CompatibilityEquater;
import net.jxta.impl.peergroup.GenericPeerGroup;
import net.jxta.impl.peergroup.StdPeerGroupParamAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.platform.ModuleClassID;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StdPeerGroup
extends GenericPeerGroup
implements CompatibilityEquater {
    private static final Logger LOG = Logger.getLogger((String)StdPeerGroup.class.getName());
    private volatile boolean initialized = false;
    private volatile boolean started = false;
    private Hashtable applications = new Hashtable();
    private Hashtable protocols = new Hashtable();
    private Cm cm = null;
    public static final StructuredTextDocument stdCompatStatement = StdPeerGroup.mkCS();
    public static final String stdUri = "http://www.jxta.org/download/jxta.jar";
    public static final String stdProvider = "sun.com";
    static final String compatKey1 = "Efmt";
    static final String compatKey2 = "Bind";
    static final String compatVal1 = "JDK1.4.1";
    static final String compatVal2 = "V2.0 Ref Impl";
    private ModuleImplAdvertisement allPurposeImplAdv = null;
    Vector disabledModules = new Vector();

    private static StructuredTextDocument mkCS() {
        StructuredTextDocument doc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Comp");
        TextElement e = doc.createElement(compatKey1, compatVal1);
        doc.appendChild((Element)e);
        e = doc.createElement(compatKey2, compatVal2);
        doc.appendChild((Element)e);
        return doc;
    }

    protected ModuleImplAdvertisement mkImplAdvBuiltin(ModuleSpecID specID, String code, String descr) {
        ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        implAdv.setModuleSpecID(specID);
        implAdv.setCompat(stdCompatStatement);
        implAdv.setCode(code);
        implAdv.setUri(stdUri);
        implAdv.setProvider(stdProvider);
        implAdv.setDescription(descr);
        return implAdv;
    }

    public boolean compatible(Element compat) {
        return StdPeerGroup.isCompatible(compat);
    }

    public static boolean isCompatible(Element compat) {
        boolean oneOk = false;
        boolean twoOk = false;
        try {
            Enumeration hisChildren = compat.getChildren();
            int i = 0;
            while (hisChildren.hasMoreElements()) {
                if (++i > 2) {
                    return false;
                }
                Element e = (Element)hisChildren.nextElement();
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                if (compatKey1.equals(key) && compatVal1.equals(val)) {
                    oneOk = true;
                    continue;
                }
                if (compatKey2.equals(key) && compatVal2.equals(val)) {
                    twoOk = true;
                    continue;
                }
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oneOk && twoOk;
    }

    protected void loadAllModules(Hashtable modules, ModuleClassID thisClassOnly, boolean privileged) {
        Enumeration allKeys = modules.keys();
        while (allKeys.hasMoreElements()) {
            ModuleClassID classID = (ModuleClassID)allKeys.nextElement();
            Object value = modules.get(classID);
            if (thisClassOnly != null && !thisClassOnly.equals(classID)) continue;
            if (this.disabledModules.contains(classID)) {
                if (value instanceof ModuleClassID) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Module disabled by configuration : " + classID));
                    }
                } else if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Module disabled by configuration : " + ((ModuleImplAdvertisement)value).getDescription()));
                }
                modules.remove(classID);
                if (thisClassOnly == null) continue;
                break;
            }
            if (value instanceof Module) {
                if (thisClassOnly == null) continue;
                break;
            }
            try {
                Module theModule = null;
                if (value instanceof ModuleImplAdvertisement) {
                    theModule = this.loadModule((ID)classID, (ModuleImplAdvertisement)value, privileged);
                } else if (value instanceof ModuleSpecID) {
                    theModule = this.loadModule(classID, (ModuleSpecID)value, 1, privileged);
                } else {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("Skipping: " + classID + " Unsupported module descriptor : " + value.getClass().getName()));
                    }
                    modules.remove(classID);
                    if (thisClassOnly == null) continue;
                    break;
                }
                if (theModule == null) {
                    throw new PeerGroupException("Could not find a loadable implementation for : " + classID);
                }
                modules.put(classID, theModule);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Could not load module for class ID " + classID), (Throwable)e);
                }
                if (value instanceof ModuleClassID) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Will be missing from peer group: " + classID.toString() + " (" + e.getMessage() + ")."));
                    }
                } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Will be missing from peer group: " + ((ModuleImplAdvertisement)value).getDescription() + " (" + e.getMessage() + ")."));
                }
                modules.remove(classID);
            }
            if (thisClassOnly == null) continue;
            break;
        }
    }

    public int startApp(String[] arg) {
        if (!this.initialized) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Group has not been initialized or init failed.");
            }
            return -1;
        }
        if (this.started) {
            return 0;
        }
        this.started = true;
        super.startApp(arg);
        this.loadAllModules(this.applications, null, false);
        int res = 0;
        Enumeration appKeys = this.applications.keys();
        while (appKeys.hasMoreElements()) {
            Object appKey = appKeys.nextElement();
            Module app = (Module)this.applications.get(appKey);
            int tmp = app.startApp(arg);
            if (tmp != 0) {
                this.applications.remove(appKey);
            } else {
                this.applications.put(appKey, app);
            }
            res += tmp;
        }
        return res;
    }

    public void stopApp() {
        Module module;
        Iterator modules = this.applications.values().iterator();
        while (modules.hasNext()) {
            module = null;
            try {
                module = (Module)modules.next();
                module.stopApp();
            }
            catch (Exception any) {
                if (module == null || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Failed to stop application: " + module.getClass().getName()), (Throwable)any);
            }
        }
        this.applications.clear();
        modules = this.protocols.values().iterator();
        while (modules.hasNext()) {
            module = null;
            try {
                module = (Module)modules.next();
                module.stopApp();
            }
            catch (Exception any) {
                if (module == null || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Failed to stop protocol : " + module.getClass().getName()), (Throwable)any);
            }
        }
        this.protocols.clear();
        if (this.cm != null) {
            this.cm.stop();
            this.cm = null;
        }
        super.stopApp();
    }

    protected synchronized void initFirst(PeerGroup parent, ID assignedID, Advertisement impl) throws PeerGroupException {
        block38: {
            Module m;
            if (this.initialized) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"You cannot initialize a PeerGroup more than once !");
                }
                return;
            }
            super.initFirst(parent, assignedID, impl);
            try {
                this.cm = new Cm(this.getHomeThreadGroup(), this.getPeerGroupID().getUniqueValue().toString(), true, 3600000L, false);
            }
            catch (Exception e) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Error during creation of local store", (Throwable)e);
                }
                throw new PeerGroupException("Error during creation of local store", e);
            }
            SrdiIndex.clearSrdi(this);
            ModuleImplAdvertisement implAdv = (ModuleImplAdvertisement)impl;
            ConfigParams conf = this.getConfigAdvertisement();
            if (conf != null) {
                Iterator eachService = conf.getServiceParamsEntrySet().iterator();
                while (eachService.hasNext()) {
                    Map.Entry anEntry = (Map.Entry)eachService.next();
                    TextElement e = (TextElement)anEntry.getValue();
                    if (!e.getChildren("isOff").hasMoreElements()) continue;
                    this.disabledModules.addElement(anEntry.getKey());
                }
                conf = null;
            }
            StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv(implAdv.getParam());
            this.applications = paramAdv.getApps();
            Hashtable initServices = paramAdv.getServices();
            this.protocols = paramAdv.getProtos();
            this.loadAllModules(initServices, peerinfoClassID, true);
            Module peerInfoModule = (Module)initServices.get(peerinfoClassID);
            if (peerInfoModule != null) {
                this.addService(peerinfoClassID, (Service)peerInfoModule);
            }
            this.loadAllModules(initServices, endpointClassID, true);
            Module endp = (Module)initServices.get(endpointClassID);
            this.addService(endpointClassID, (Service)endp);
            initServices.remove(endpointClassID);
            this.loadAllModules(this.protocols, null, true);
            this.loadAllModules(initServices, null, true);
            Enumeration allKeys = initServices.keys();
            while (allKeys.hasMoreElements()) {
                ModuleClassID classID = (ModuleClassID)allKeys.nextElement();
                m = (Module)initServices.get(classID);
                if (m instanceof Service) {
                    this.addService(classID, (Service)m);
                    continue;
                }
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)("Suspicious service: " + classID + " is not an instance of Service."));
                LOG.warn((Object)"It will not be registered as a service.");
            }
            try {
                this.checkServices();
            }
            catch (ServiceNotFoundException e) {
                LOG.fatal((Object)"Missing peer group service", (Throwable)e);
                throw new PeerGroupException("Missing peer group service", e);
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Unhandled Throwable", e);
                throw new PeerGroupException("Unhandled Throwable", e);
            }
            HashMap<ModuleClassID, Module> allStart = new HashMap<ModuleClassID, Module>(this.protocols.size() + initServices.size() + 1);
            allStart.put(endpointClassID, endp);
            allStart.putAll(initServices);
            allStart.putAll(this.protocols);
            long modulesToGo = allStart.size();
            long maxIterations = modulesToGo * modulesToGo + 1L;
            boolean progress = true;
            while (progress && modulesToGo > 0L && maxIterations-- > 0L) {
                progress = false;
                Iterator eachModule = allStart.entrySet().iterator();
                block23: while (eachModule.hasNext()) {
                    int res;
                    Map.Entry anEntry = eachModule.next();
                    m = (Module)anEntry.getValue();
                    try {
                        res = m.startApp(null);
                    }
                    catch (Throwable all) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)("Exception in startApp() : " + m), all);
                        }
                        res = -1;
                    }
                    switch (res) {
                        case 0: {
                            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                                LOG.info((Object)("Module started : " + m));
                            }
                            eachModule.remove();
                            maxIterations = --modulesToGo * modulesToGo + 1L;
                        }
                        case 1: {
                            progress = true;
                        }
                        case 2: {
                            continue block23;
                        }
                    }
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Module failed to start (" + res + ") : " + m));
                    }
                    eachModule.remove();
                    maxIterations = --modulesToGo * modulesToGo + 1L;
                    try {
                        if (m instanceof Service) {
                            this.removeService((ModuleClassID)anEntry.getKey(), (Service)m);
                        }
                    }
                    catch (ServiceNotFoundException ignored) {
                    }
                    catch (ViolationException ignored) {
                        // empty catch block
                    }
                    this.protocols.remove(anEntry.getKey());
                }
            }
            if (allStart.size() > 0) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    StringBuffer failed = new StringBuffer("No progress is being made in starting services. Giving up.");
                    failed.append("\nThe following services refused to start: ");
                    Iterator sequence = allStart.values().iterator();
                    while (sequence.hasNext()) {
                        failed.append("\n\t");
                        failed.append(sequence.next().toString());
                    }
                    LOG.error((Object)failed);
                }
                throw new PeerGroupException("No progress is being made in starting services. Giving up.");
            }
            try {
                this.checkServices();
            }
            catch (ServiceNotFoundException e) {
                LOG.fatal((Object)"Missing peer group service", (Throwable)e);
                throw new PeerGroupException("Missing peer group service", e);
            }
            catch (Throwable e) {
                LOG.fatal((Object)"Unhandled Throwable", e);
                throw new PeerGroupException("Unhandled Throwable", e);
            }
            DiscoveryService disco = this.getDiscoveryService();
            if (disco != null) {
                try {
                    disco.publish(disco.getImplAdvertisement(), 31536000000L, 1209600000L);
                    disco.publish(implAdv, 31536000000L, 1209600000L);
                }
                catch (Exception nevermind) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block38;
                    LOG.warn((Object)"Failed to publish Impl adv within group.", (Throwable)nevermind);
                }
            }
        }
        this.initialized = true;
    }

    protected synchronized void initLast() throws PeerGroupException {
        super.initLast();
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Group : " + this.getPeerGroupID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tCompatibility Statement :\n\t\t\t");
            StringBuffer indent = new StringBuffer(stdCompatStatement.toString().trim());
            int from = indent.length();
            while (from > 0) {
                int returnAt = indent.lastIndexOf("\n", from);
                from = returnAt - 1;
                if (returnAt < 0 || returnAt == indent.length()) continue;
                indent.insert(returnAt + 1, "\t\t\t");
            }
            configInfo.append(indent);
            Iterator eachProto = this.protocols.entrySet().iterator();
            if (eachProto.hasNext()) {
                configInfo.append("\n\t\tProtocols :");
            }
            while (eachProto.hasNext()) {
                Map.Entry anEntry = eachProto.next();
                ModuleClassID aMCID = (ModuleClassID)anEntry.getKey();
                Module anMT = (Module)anEntry.getValue();
                configInfo.append("\n\t\t\t" + aMCID + "\t" + (anMT instanceof MessageTransport ? ((MessageTransport)((Object)anMT)).getProtocolName() : anMT.getClass().getName()));
            }
            Iterator eachApp = this.applications.entrySet().iterator();
            if (eachApp.hasNext()) {
                configInfo.append("\n\t\tApplications :");
            }
            while (eachApp.hasNext()) {
                Map.Entry anEntry = eachApp.next();
                ModuleClassID aMCID = (ModuleClassID)anEntry.getKey();
                Object anApp = anEntry.getValue();
                if (anApp instanceof ModuleImplAdvertisement) {
                    ModuleImplAdvertisement adv = (ModuleImplAdvertisement)anApp;
                    configInfo.append("\n\t\t\t" + aMCID + "\t" + adv.getCode());
                    continue;
                }
                configInfo.append("\n\t\t\t" + aMCID + "\t" + anApp.getClass().getName());
            }
            LOG.info((Object)configInfo);
        }
    }

    public ModuleImplAdvertisement getAllPurposePeerGroupImplAdvertisement() throws Exception {
        if (this.allPurposeImplAdv != null) {
            return (ModuleImplAdvertisement)this.allPurposeImplAdv.clone();
        }
        ModuleImplAdvertisement implAdv = this.mkImplAdvBuiltin(PeerGroup.allPurposePeerGroupSpecID, StdPeerGroup.class.getName(), "General Purpose Peer Group Implementation");
        TextElement paramElement = (TextElement)((Object)implAdv.getParam());
        StdPeerGroupParamAdv paramAdv = new StdPeerGroupParamAdv();
        Hashtable<ModuleClassID, ModuleImplAdvertisement> services = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        ModuleImplAdvertisement moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refEndpointSpecID, "net.jxta.impl.endpoint.EndpointServiceImpl", "Reference Implementation of the Endpoint service");
        services.put(PeerGroup.endpointClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refResolverSpecID, "net.jxta.impl.resolver.ResolverServiceImpl", "Reference Implementation of the Resolver service");
        services.put(PeerGroup.resolverClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refMembershipSpecID, "net.jxta.impl.membership.none.NoneMembershipService", "Reference Implementation of the None Membership service");
        services.put(PeerGroup.membershipClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(refAccessSpecID, "net.jxta.impl.access.always.AlwaysAccessService", "Reference Implementation of the Always Access service");
        services.put(PeerGroup.accessClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refDiscoverySpecID, "net.jxta.impl.discovery.DiscoveryServiceImpl", "Reference Implementation of the Discovery service");
        services.put(PeerGroup.discoveryClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refRendezvousSpecID, "net.jxta.impl.rendezvous.RendezVousServiceImpl", "Reference Implementation of the Rendezvous service");
        services.put(PeerGroup.rendezvousClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPipeSpecID, "net.jxta.impl.pipe.PipeServiceImpl", "Reference Implementation of the Pipe service");
        services.put(PeerGroup.pipeClassID, moduleAdv);
        moduleAdv = this.mkImplAdvBuiltin(PeerGroup.refPeerinfoSpecID, "net.jxta.impl.peer.PeerInfoServiceImpl", "Reference Implementation of the Peerinfo service");
        services.put(PeerGroup.peerinfoClassID, moduleAdv);
        paramAdv.setServices(services);
        Hashtable protos = new Hashtable();
        paramAdv.setProtos(protos);
        ModuleImplAdvertisement newAppAdv = (ModuleImplAdvertisement)AdvertisementFactory.newAdvertisement(ModuleImplAdvertisement.getAdvertisementType());
        newAppAdv.setModuleSpecID(PeerGroup.refShellSpecID);
        newAppAdv.setCompat(implAdv.getCompat());
        newAppAdv.setUri(implAdv.getUri());
        newAppAdv.setProvider(implAdv.getProvider());
        newAppAdv.setDescription("JXTA Shell Reference Implementation");
        newAppAdv.setCode("net.jxta.impl.shell.bin.Shell.Shell");
        Hashtable<ModuleClassID, ModuleImplAdvertisement> newApps = new Hashtable<ModuleClassID, ModuleImplAdvertisement>();
        newApps.put(PeerGroup.applicationClassID, newAppAdv);
        paramAdv.setApps(newApps);
        paramElement = (TextElement)((Object)paramAdv.getDocument(MimeMediaType.XMLUTF8));
        implAdv.setParam(paramElement);
        this.allPurposeImplAdv = implAdv;
        return (ModuleImplAdvertisement)implAdv.clone();
    }

    public Cm getCacheManager() {
        return this.cm;
    }
}

