/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peergroup;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.JxtaError;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.protocol.HTTPAdv;
import net.jxta.impl.protocol.PSEConfigAdv;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.RdvConfigAdv;
import net.jxta.impl.protocol.TCPAdv;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.TransportAdvertisement;

public class ConfigDialog
extends Frame
implements ItemListener {
    Frame mainFrame;
    PlatformConfig configAdv;
    HTTPAdv httpAdv;
    TCPAdv tcpAdv;
    static GridBagConstraints stdConstr;
    static GridBagConstraints centerConstr;
    static GridBagConstraints centerLastConstr;
    static GridBagConstraints fillConstr;
    static GridBagConstraints leftLineConstr;
    static GridBagConstraints startLineConstr;
    static GridBagConstraints midLineConstr;
    static GridBagConstraints midLineEastConstr;
    static GridBagConstraints rightLineConstr;
    static GridBagConstraints leftPanelConstr;
    static GridBagConstraints rightPanelConstr;
    Label helpLabel;
    IdPanel idPanel;
    IPTptPanel httpPanel;
    IPTptPanel tcpPanel;
    RdvPanel rdvPanel;
    RelayPanel relayPanel;
    DebugPanel debugPanel;
    SecPanel secPanel;
    Button ok;
    Button cancel;
    PagesPanel pages;
    boolean done;
    boolean canceled;

    public void itemStateChanged(ItemEvent e) {
        this.rdvPanel.http.setEnabled(this.httpPanel.getState());
        this.rdvPanel.tcp.setEnabled(this.tcpPanel.getState());
        this.relayPanel.http.setEnabled(this.httpPanel.getState());
        this.relayPanel.tcp.setEnabled(this.tcpPanel.getState());
    }

    public ConfigDialog(File homeDir, PlatformConfig cadv) {
        Enumeration relays;
        String jpn;
        String pn;
        int index;
        String configModeT;
        String defaultInterfaceAddressT;
        String configModeH;
        String defaultInterfaceAddressH;
        String defaultProxyNameH;
        IllegalStateException failure;
        XMLElement param;
        ArrayList<String> rdvs;
        boolean onlySeeds;
        boolean isRendezvous;
        String dftDebugLevel;
        GridBagConstraints fillInsetConstr;
        block52: {
            super("JXTA Configurator");
            this.mainFrame = this;
            this.pages = new PagesPanel();
            this.done = false;
            this.canceled = false;
            stdConstr = new GridBagConstraints();
            ConfigDialog.stdConstr.gridwidth = 0;
            ConfigDialog.stdConstr.gridheight = 1;
            ConfigDialog.stdConstr.gridx = 0;
            ConfigDialog.stdConstr.gridy = -1;
            ConfigDialog.stdConstr.fill = 0;
            ConfigDialog.stdConstr.weightx = 1.0;
            ConfigDialog.stdConstr.anchor = 18;
            ConfigDialog.stdConstr.insets = new Insets(0, 0, 0, 0);
            fillConstr = (GridBagConstraints)stdConstr.clone();
            ConfigDialog.fillConstr.fill = 2;
            centerConstr = (GridBagConstraints)stdConstr.clone();
            ConfigDialog.centerConstr.anchor = 11;
            centerLastConstr = (GridBagConstraints)centerConstr.clone();
            ConfigDialog.centerLastConstr.weighty = 1.0;
            midLineConstr = new GridBagConstraints();
            ConfigDialog.midLineConstr.anchor = 13;
            ConfigDialog.midLineConstr.weightx = 0.0;
            midLineEastConstr = (GridBagConstraints)midLineConstr.clone();
            ConfigDialog.midLineEastConstr.anchor = 13;
            ConfigDialog.midLineEastConstr.weightx = 1.0;
            rightLineConstr = (GridBagConstraints)midLineConstr.clone();
            ConfigDialog.rightLineConstr.gridwidth = 0;
            ConfigDialog.rightLineConstr.weightx = 1.0;
            ConfigDialog.rightLineConstr.anchor = 17;
            leftLineConstr = (GridBagConstraints)midLineConstr.clone();
            ConfigDialog.leftLineConstr.gridx = 0;
            ConfigDialog.leftLineConstr.weightx = 0.0;
            ConfigDialog.leftLineConstr.anchor = 17;
            ConfigDialog.leftLineConstr.insets = new Insets(0, 20, 0, 20);
            startLineConstr = (GridBagConstraints)midLineConstr.clone();
            ConfigDialog.startLineConstr.gridx = 0;
            ConfigDialog.startLineConstr.weightx = 1.0;
            ConfigDialog.startLineConstr.anchor = 17;
            ConfigDialog.startLineConstr.fill = 0;
            ConfigDialog.startLineConstr.insets = new Insets(0, 0, 0, 0);
            fillInsetConstr = (GridBagConstraints)fillConstr.clone();
            fillInsetConstr.insets = new Insets(5, 5, 5, 5);
            leftPanelConstr = (GridBagConstraints)fillConstr.clone();
            ConfigDialog.leftPanelConstr.gridwidth = 1;
            rightPanelConstr = (GridBagConstraints)fillConstr.clone();
            ConfigDialog.rightPanelConstr.gridwidth = 0;
            ConfigDialog.rightPanelConstr.gridx = -1;
            this.configAdv = cadv;
            dftDebugLevel = this.configAdv.getDebugLevel();
            isRendezvous = false;
            onlySeeds = false;
            rdvs = new ArrayList<String>();
            try {
                XMLElement param2 = (XMLElement)((Object)this.configAdv.getServiceParam(PeerGroup.rendezvousClassID));
                if (param2 == null) break block52;
                try {
                    Advertisement adv = AdvertisementFactory.newAdvertisement(param2);
                    if (adv instanceof RdvConfigAdv) {
                        RdvConfigAdv rdvConfigAdv = (RdvConfigAdv)adv;
                        isRendezvous = RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS == rdvConfigAdv.getConfiguration();
                        onlySeeds = rdvConfigAdv.getUseOnlySeeds();
                        Iterator<URI> eachRdv = Arrays.asList(rdvConfigAdv.getSeedRendezvous()).iterator();
                        while (eachRdv.hasNext()) {
                            rdvs.add(((Object)eachRdv.next()).toString());
                        }
                    }
                }
                catch (NoSuchElementException notRdvConfigAdv) {
                    IllegalStateException failure2 = new IllegalStateException("Broken Platform Config. Cannot proceed.");
                    failure2.initCause(notRdvConfigAdv);
                }
            }
            catch (Exception thatsbad) {
                IllegalStateException failure3 = new IllegalStateException("Broken Platform Config. Cannot proceed.");
                failure3.initCause(thatsbad);
            }
        }
        boolean isJxtaProxy = true;
        try {
            StructuredDocument param3 = this.configAdv.getServiceParam(PeerGroup.proxyClassID);
            if (param3 == null || param3.getChildren("isOff").hasMoreElements()) {
                isJxtaProxy = false;
            }
        }
        catch (Exception nobigdeal) {
            nobigdeal.printStackTrace();
        }
        boolean isRelay = false;
        boolean useRelay = false;
        Vector<String> httpRelays = new Vector<String>();
        Vector<String> tcpRelays = new Vector<String>();
        try {
            XMLElement param4 = (XMLElement)((Object)this.configAdv.getServiceParam(PeerGroup.relayProtoClassID));
            if (param4 != null) {
                Enumeration relayTCPEnum = param4.getChildren("tcpaddr");
                while (relayTCPEnum.hasMoreElements()) {
                    tcpRelays.addElement(((XMLElement)relayTCPEnum.nextElement()).getTextValue());
                }
                Enumeration relayHTTPEnum = param4.getChildren("httpaddr");
                while (relayHTTPEnum.hasMoreElements()) {
                    httpRelays.addElement(((XMLElement)relayHTTPEnum.nextElement()).getTextValue());
                }
                Enumeration relayServer = param4.getChildren("isServer");
                isRelay = relayServer.hasMoreElements() && "true".equals(((XMLElement)relayServer.nextElement()).getTextValue());
                Enumeration relayClient = param4.getChildren("isClient");
                useRelay = relayClient.hasMoreElements() && "true".equals(((XMLElement)relayClient.nextElement()).getTextValue());
            }
        }
        catch (Exception nobigdeal) {
            nobigdeal.printStackTrace();
        }
        boolean tcpDefault = true;
        boolean httpDefault = true;
        try {
            Enumeration httpChilds;
            param = (XMLElement)((Object)this.configAdv.getServiceParam(PeerGroup.httpProtoClassID));
            if (param.getChildren("isOff").hasMoreElements()) {
                httpDefault = false;
            }
            if (!(httpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                throw new IllegalStateException("Missing HTTP Advertisment");
            }
            param = (XMLElement)httpChilds.nextElement();
            this.httpAdv = (HTTPAdv)AdvertisementFactory.newAdvertisement(param);
        }
        catch (Exception thatsbad) {
            if (thatsbad instanceof RuntimeException) {
                throw (RuntimeException)thatsbad;
            }
            failure = new IllegalStateException("Broken Platform Config. Cannot proceed.");
            failure.initCause(thatsbad);
        }
        try {
            Enumeration tcpChilds;
            param = (XMLElement)((Object)this.configAdv.getServiceParam(PeerGroup.tcpProtoClassID));
            if (param.getChildren("isOff").hasMoreElements()) {
                tcpDefault = false;
            }
            if (!(tcpChilds = param.getChildren(TransportAdvertisement.getAdvertisementType())).hasMoreElements()) {
                throw new IllegalStateException("Missing TCP Advertisment");
            }
            param = (XMLElement)tcpChilds.nextElement();
            this.tcpAdv = (TCPAdv)AdvertisementFactory.newAdvertisement(param);
        }
        catch (Exception thatsbad) {
            if (thatsbad instanceof RuntimeException) {
                throw (RuntimeException)thatsbad;
            }
            failure = new IllegalStateException("Broken Platform Config. Cannot proceed.");
            failure.initCause(thatsbad);
        }
        boolean clientDefaultH = this.httpAdv.isClientEnabled();
        boolean serverDefaultH = this.httpAdv.isServerEnabled();
        boolean proxyDefaultH = this.httpAdv.isProxyEnabled();
        String defaultServerNameH = this.httpAdv.getServer();
        if (null != defaultServerNameH && 0 == defaultServerNameH.trim().length()) {
            defaultServerNameH = null;
        }
        if (null != (defaultProxyNameH = this.httpAdv.getProxy()) && 0 == defaultProxyNameH.trim().length()) {
            defaultProxyNameH = null;
        }
        if (null != (defaultInterfaceAddressH = this.httpAdv.getInterfaceAddress()) && 0 == defaultInterfaceAddressH.trim().length()) {
            defaultInterfaceAddressH = null;
        }
        if (null == (configModeH = this.httpAdv.getConfigMode())) {
            configModeH = "auto";
        }
        boolean clientDefaultT = this.tcpAdv.isClientEnabled();
        boolean serverDefaultT = this.tcpAdv.isServerEnabled();
        boolean relayDefaultT = false;
        String defaultServerNameT = this.tcpAdv.getServer();
        if (null != defaultServerNameT && 0 == defaultServerNameT.trim().length()) {
            defaultServerNameT = null;
        }
        if (null != (defaultInterfaceAddressT = this.tcpAdv.getInterfaceAddress()) && 0 == defaultInterfaceAddressT.trim().length()) {
            defaultInterfaceAddressT = null;
        }
        if (null == (configModeT = this.tcpAdv.getConfigMode())) {
            configModeT = "auto";
        }
        String defaultProxyPortH = "8080";
        String defaultServerPortH = "9700";
        String defaultPortH = Integer.toString(this.httpAdv.getPort());
        String defaultServerPortT = "9701";
        String defaultPortT = Integer.toString(this.tcpAdv.getPort());
        if (defaultProxyNameH != null) {
            index = defaultProxyNameH.lastIndexOf(":");
            if (index <= 0 || index == defaultProxyNameH.length()) {
                throw new RuntimeException("Bad Proxy server. Cannot proceed.");
            }
            defaultProxyPortH = defaultProxyNameH.substring(index + 1);
            defaultProxyNameH = defaultProxyNameH.substring(0, index);
        }
        if (defaultServerNameH != null && (index = defaultServerNameH.lastIndexOf(":")) != -1) {
            if (0 == index || index == defaultServerNameH.length()) {
                throw new RuntimeException("Bad HTTP server name. Cannot proceed.");
            }
            defaultServerPortH = defaultServerNameH.substring(index + 1);
            defaultServerNameH = defaultServerNameH.substring(0, index);
        } else {
            defaultServerNameH = "";
            defaultServerPortH = "9700";
        }
        if (defaultServerNameT != null && (index = defaultServerNameT.lastIndexOf(":")) != -1) {
            if (0 == index || index == defaultServerNameT.length()) {
                throw new RuntimeException("Bad TCP server name . Cannot proceed.");
            }
            defaultServerPortT = defaultServerNameT.substring(index + 1);
            defaultServerNameT = defaultServerNameT.substring(0, index);
        } else {
            defaultServerNameT = "";
            defaultServerPortT = "9701";
        }
        if (defaultPortT == null || defaultPortT.equals("")) {
            defaultPortT = "9701";
        }
        if (defaultPortH == null || defaultPortH.equals("")) {
            defaultPortH = "9700";
        }
        if ("".equals(pn = this.configAdv.getName()) && (jpn = System.getProperty("jxta.peer.name")) != null) {
            pn = jpn;
        }
        boolean needSecurityConfig = true;
        try {
            Advertisement adv;
            XMLElement param5 = (XMLElement)((Object)this.configAdv.getServiceParam(PeerGroup.membershipClassID));
            if (param5 != null && (adv = AdvertisementFactory.newAdvertisement(param5)) instanceof PSEConfigAdv) {
                needSecurityConfig = false;
            }
        }
        catch (Exception nobigdeal) {
            nobigdeal.printStackTrace();
        }
        this.helpLabel = new Label("See \"http://shell.jxta.org/index.html\" for config help", 1);
        this.helpLabel.setBackground(new Color(220, 220, 220));
        this.helpLabel.setForeground(Color.black);
        this.idPanel = new IdPanel(pn);
        this.debugPanel = new DebugPanel(dftDebugLevel);
        this.tcpPanel = new IPTptPanel(1, tcpDefault, "TCP Settings", "Enable if direct LAN connection.", this, defaultInterfaceAddressT, defaultPortT, clientDefaultT, serverDefaultT, defaultServerNameT, defaultServerPortT, false, "", "", this.tcpAdv.getPublicAddressOnly(), this.tcpAdv.getMulticastState());
        this.httpPanel = new IPTptPanel(0, httpDefault, "HTTP Settings", "Must enable if behind Firewall or NAT", this, defaultInterfaceAddressH, defaultPortH, clientDefaultH, serverDefaultH, defaultServerNameH, defaultServerPortH, proxyDefaultH, defaultProxyNameH, defaultProxyPortH, this.httpAdv.getPublicAddressOnly());
        this.relayPanel = new RelayPanel(this, "Relay Settings", isRelay, useRelay);
        this.relayPanel.http.setEnabled(this.httpPanel.getState());
        this.relayPanel.tcp.setEnabled(this.tcpPanel.getState());
        if (tcpRelays != null) {
            relays = tcpRelays.elements();
            while (relays.hasMoreElements()) {
                this.relayPanel.tcp.addItem((String)relays.nextElement());
            }
        }
        if (httpRelays != null) {
            relays = httpRelays.elements();
            while (relays.hasMoreElements()) {
                this.relayPanel.http.addItem((String)relays.nextElement());
            }
        }
        this.rdvPanel = new RdvPanel("Rendezvous Settings", isRendezvous, isJxtaProxy, onlySeeds);
        Enumeration e = Collections.enumeration(rdvs);
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s.startsWith("tcp://")) {
                this.rdvPanel.tcp.addItem(s.substring(6));
                continue;
            }
            if (!s.startsWith("http://")) continue;
            this.rdvPanel.http.addItem(s.substring(7));
        }
        this.rdvPanel.http.setEnabled(this.httpPanel.getState());
        this.rdvPanel.tcp.setEnabled(this.tcpPanel.getState());
        this.ok = new Button("  OK  ");
        this.cancel = new Button("Cancel");
        Panel okPanel = new Panel();
        okPanel.add(this.ok);
        okPanel.add(this.cancel);
        PanelGBL basicsPanel = this.pages.addPage("Basic", "Basic settings");
        GridBagConstraints centerWConstr = (GridBagConstraints)centerConstr.clone();
        centerWConstr.weighty = 1.0;
        basicsPanel.add((Component)this.idPanel, centerWConstr);
        PanelGBL advancedPanel = this.pages.addPage("Advanced", "Experienced Users Only");
        advancedPanel.add((Component)this.debugPanel, fillInsetConstr);
        advancedPanel.add((Component)this.tcpPanel, fillInsetConstr);
        advancedPanel.add((Component)this.httpPanel, fillInsetConstr);
        PanelGBL rdvrouterPanel = this.pages.addPage("Rendezvous/Relays", "Experienced Users Only");
        rdvrouterPanel.add((Component)this.rdvPanel, fillInsetConstr);
        rdvrouterPanel.add((Component)this.relayPanel, fillInsetConstr);
        Button loadButton = new Button("Download relay and rendezvous lists");
        rdvrouterPanel.add((Component)loadButton, fillInsetConstr);
        if (needSecurityConfig) {
            this.secPanel = new SecPanel();
            PanelGBL securityPanel = this.pages.addPage("Security", "Security Settings");
            securityPanel.add((Component)this.secPanel, centerWConstr);
        }
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        this.add((Component)this.helpLabel, fillConstr);
        this.add((Component)this.pages, fillInsetConstr);
        this.add((Component)okPanel, centerLastConstr);
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AutoLoader a = new AutoLoader(ConfigDialog.this.mainFrame, ConfigDialog.this.rdvPanel.tcp, ConfigDialog.this.rdvPanel.http, ConfigDialog.this.relayPanel.tcp, ConfigDialog.this.relayPanel.http, "http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2", "http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2", false);
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.saveValues();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConfigDialog.this.beCanceled();
            }
        });
        this.helpLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ConfigDialog.this.helpLabel.setForeground(Color.black);
                ConfigDialog.this.helpLabel.setText("See \"http://shell.jxta.org/index.html\" for config help");
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConfigDialog.this.beCanceled();
            }
        });
        this.pack();
        this.show();
    }

    public synchronized boolean untilDone() {
        try {
            while (!this.done) {
                this.wait();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        if (this.canceled) {
            throw new JxtaError("Canceled during configuration");
        }
        return this.done;
    }

    private synchronized void beDone() {
        this.done = true;
        this.notify();
        this.dispose();
    }

    private synchronized void beCanceled() {
        this.canceled = true;
        this.done = true;
        this.notify();
        this.dispose();
    }

    private boolean verifyPort(String portName, String ports, boolean dynamicok) {
        int p1;
        if (null == ports || 0 == ports.trim().length()) {
            ports = "0";
        }
        try {
            p1 = Integer.parseInt(ports);
        }
        catch (Exception ex) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(portName + " port number must be an integer: " + ports);
            return false;
        }
        if (p1 > 65535 || p1 < (dynamicok ? 0 : 1)) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText(portName + " port number must be an integer between " + (dynamicok ? "0" : "1") + " and 65535, found " + p1);
            return false;
        }
        return true;
    }

    private boolean verifyAddr(String proto, boolean serverOn, String localAddress, String localPort, String publicAddress, String publicPort) {
        if (serverOn && publicAddress.length() > 0) {
            if (!this.verifyPort(proto + " local", localPort, false)) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Dynamic tcp port selection not supported when server public address is specified.");
                this.pages.showPage("Advanced");
                return false;
            }
            if (!this.verifyPort(proto + " public", publicPort, false)) {
                this.pages.showPage("Advanced");
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Dynamic tcp port selection not supported for server public address.");
                return false;
            }
        } else if (!this.verifyPort(proto + " local", localPort, true)) {
            this.pages.showPage("Advanced");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadBootStrapping(String urlString, HostListPanel list) {
        block15: {
            if (urlString.equals("")) {
                return true;
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText("Trying " + urlString + "...");
            inp = null;
            try {
                try {
                    inp = new URL(urlString).openStream();
                    l = new BufferedReader(new InputStreamReader(inp));
                    valid = 0;
                    while ((s = l.readLine()) != null) {
                        if (!list.addItem(s)) continue;
                        ++valid;
                    }
                    if (valid != 0) break block15;
                    this.helpLabel.setForeground(Color.red.darker());
                    this.helpLabel.setText(urlString + ": not a valid list.");
                    var7_11 = false;
                    var9_12 = null;
                    if (null == inp) return var7_11;
                }
                catch (MalformedURLException e) {
                    this.helpLabel.setForeground(Color.red.darker());
                    this.helpLabel.setText(urlString + ": malformed URL.");
                    var5_9 = false;
                    var9_14 = null;
                    if (null == inp) return var5_9;
                    try {
                        inp.close();
                        return var5_9;
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    return var5_9;
                }
                catch (IOException e) {
                    this.helpLabel.setForeground(Color.red.darker());
                    this.helpLabel.setText(urlString + ": not accessible. " + (this.httpPanel.proxyAddr.getState() != false ? "" : "You might need a proxy."));
                    var5_10 = false;
                    var9_15 = null;
                    if (null == inp) return var5_10;
                    ** try [egrp 2[TRYBLOCK] [7 : 311->318)] { 
lbl44:
                    // 1 sources

                    inp.close();
                    return var5_10;
lbl46:
                    // 1 sources

                    catch (Exception ignored) {
                        // empty catch block
                    }
                    return var5_10;
                }
            }
            catch (Throwable var8_22) {
                var9_16 = null;
                if (null == inp) throw var8_22;
                ** try [egrp 2[TRYBLOCK] [7 : 311->318)] { 
lbl54:
                // 1 sources

                inp.close();
                throw var8_22;
lbl56:
                // 1 sources

                catch (Exception ignored) {
                    // empty catch block
                }
                throw var8_22;
            }
            try {}
            catch (Exception ignored) {
                // empty catch block
                return var7_11;
            }
            inp.close();
            return var7_11;
        }
        var9_13 = null;
        if (null != inp) {
            try {}
            catch (Exception ignored) {}
            inp.close();
        }
        this.helpLabel.setForeground(Color.black);
        this.helpLabel.setText("Done loading Boostrapping info");
        return true;
    }

    private boolean verifyInput() {
        if (0 == this.idPanel.getName().length()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("A peer name is required.");
            this.pages.showPage("Basic");
            return false;
        }
        if (null != this.secPanel) {
            String principal = this.secPanel.getPrincipal();
            String passwd = this.secPanel.getPassword();
            String vpasswd = this.secPanel.getVerifyPassword();
            if (principal.length() == 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Please configure your secure username and password");
                this.secPanel.clearPrincipal();
                this.pages.showPage("Security");
                return false;
            }
            if (passwd.length() < 8) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password must be at least 8 letters");
                this.secPanel.clearPasswords();
                this.pages.showPage("Security");
                return false;
            }
            if (passwd.compareTo(vpasswd) != 0) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Password does not match Verify Password");
                this.secPanel.clearPasswords();
                this.pages.showPage("Security");
                return false;
            }
            File certFile = this.secPanel.getCertFile();
            if (!(null == certFile || certFile.exists() && certFile.isFile())) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Invalid Root Certificate File");
                this.secPanel.clearPasswords();
                this.pages.showPage("Security");
                return false;
            }
        }
        if (!this.httpPanel.getState() && !this.tcpPanel.getState()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("At least one of TCP or HTTP must be enabled.");
            this.pages.showPage("Advanced");
            return false;
        }
        if (this.tcpPanel.getState() && !this.tcpPanel.clientEnabled.getState() && !this.tcpPanel.publicAddr.getState()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Must enable incoming and/or outcoming to enable TCP");
            this.pages.showPage("Advanced");
            return false;
        }
        if (this.httpPanel.getState() && !this.httpPanel.clientEnabled.getState() && !this.httpPanel.publicAddr.getState()) {
            this.helpLabel.setForeground(Color.red.darker());
            this.helpLabel.setText("Must enable incoming and/or outcoming to enable HTTP");
            this.pages.showPage("Advanced");
            return false;
        }
        if (this.httpPanel.getState()) {
            boolean valid = this.verifyAddr("HTTP", this.httpPanel.publicAddr.getState(), this.httpPanel.getInterfaceAddress(), this.httpPanel.ifAddr.getPort(), this.httpPanel.publicAddr.getHost(), this.httpPanel.publicAddr.getPort());
            if (!valid) {
                return valid;
            }
            if (!this.checkRelayEnabled(this.httpPanel, this.relayPanel, this.helpLabel)) {
                return false;
            }
        }
        if (this.tcpPanel.getState()) {
            boolean valid = this.verifyAddr("TCP", this.tcpPanel.publicAddr.getState(), this.tcpPanel.getInterfaceAddress(), this.tcpPanel.ifAddr.getPort(), this.tcpPanel.publicAddr.getHost(), this.tcpPanel.publicAddr.getPort());
            if (!valid) {
                return valid;
            }
            if (!this.checkRelayEnabled(this.tcpPanel, this.relayPanel, this.helpLabel)) {
                return false;
            }
        }
        if (this.relayPanel.useRelay.getState()) {
            String[] addrs;
            String errorMsg = null;
            if (this.tcpPanel.getState() && this.httpPanel.getState()) {
                String[] tcpaddrs = this.relayPanel.tcp.getItems();
                String[] httpaddrs = this.relayPanel.http.getItems();
                if (tcpaddrs.length == 0 && httpaddrs.length == 0) {
                    errorMsg = "Must provide at least one TCP or HTTP Relay address";
                }
            } else if (this.tcpPanel.getState()) {
                addrs = this.relayPanel.tcp.getItems();
                if (addrs.length == 0) {
                    errorMsg = "Must provide at least one TCP Relay address";
                }
            } else if (this.httpPanel.getState() && (addrs = this.relayPanel.http.getItems()).length == 0) {
                errorMsg = "Must provide at least one HTTP Relay address";
            }
            if (errorMsg != null) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(errorMsg);
                this.pages.showPage("Rendezvous/Relays");
                return false;
            }
        }
        if (this.httpPanel.proxyAddr.getState() && !this.verifyPort("HTTP proxy", this.httpPanel.proxyAddr.getPort(), false)) {
            this.pages.showPage("Basic");
            return false;
        }
        return true;
    }

    private boolean checkRelayEnabled(IPTptPanel transportPanel, RelayPanel relayPanel, Label helpLabel) {
        if (!transportPanel.publicAddr.useMe.getState() && !relayPanel.useRelay.getState()) {
            helpLabel.setForeground(Color.red.darker());
            helpLabel.setText("Must use a relay if incoming connections are disabled");
            this.pages.showPage("Rendezvous/Relays");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveValues() {
        try {
            if (!this.verifyInput()) {
                return;
            }
            this.configAdv.setName(this.idPanel.getName());
            this.httpAdv.setConfigMode(this.httpPanel.getConfigMode());
            chosenIntf = this.httpPanel.getInterfaceAddress();
            if (chosenIntf.startsWith("A")) {
                this.httpAdv.setInterfaceAddress(null);
            } else {
                this.httpAdv.setInterfaceAddress(chosenIntf);
            }
            this.httpAdv.setPort(Integer.parseInt(this.httpPanel.ifAddr.getPort()));
            this.httpAdv.setProxyEnabled(this.httpPanel.proxyAddr.getState());
            if (0 == this.httpPanel.proxyAddr.getHost().trim().length()) {
                this.httpAdv.setProxy(null);
            } else {
                this.httpAdv.setProxy(this.httpPanel.proxyAddr.getHost() + ":" + this.httpPanel.proxyAddr.getPort());
            }
            routers = this.relayPanel.http.getItems();
            this.httpAdv.setClientEnabled(this.httpPanel.clientEnabled.getState());
            this.httpAdv.setServerEnabled(this.httpPanel.publicAddr.getState());
            if (0 == this.httpPanel.publicAddr.getHost().trim().length()) {
                this.httpAdv.setServer(null);
            } else {
                this.httpAdv.setServer(this.httpPanel.publicAddr.getHost() + ":" + this.httpPanel.publicAddr.getPort());
            }
            this.httpAdv.setPublicAddressOnly(this.httpPanel.getPubAddrOnly());
            this.tcpAdv.setConfigMode(this.tcpPanel.getConfigMode());
            chosenIntf = this.tcpPanel.getInterfaceAddress();
            if (chosenIntf.startsWith("A")) {
                this.tcpAdv.setInterfaceAddress(null);
            } else {
                this.tcpAdv.setInterfaceAddress(chosenIntf);
            }
            try {
                theTcpPort = Integer.parseInt(this.tcpPanel.ifAddr.getPort());
                this.tcpAdv.setPort(theTcpPort);
                if (0 == theTcpPort) {
                    this.tcpAdv.setStartPort(0);
                    this.tcpAdv.setEndPort(0);
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            this.tcpAdv.setClientEnabled(this.tcpPanel.clientEnabled.getState());
            this.tcpAdv.setServerEnabled(this.tcpPanel.publicAddr.getState());
            if (0 == this.tcpPanel.publicAddr.getHost().trim().length()) {
                this.tcpAdv.setServer(null);
            } else {
                this.tcpAdv.setServer(this.tcpPanel.publicAddr.getHost() + ":" + this.tcpPanel.publicAddr.getPort());
            }
            this.tcpAdv.setMulticastState(this.tcpPanel.multicast.getState());
            this.tcpAdv.setPublicAddressOnly(this.tcpPanel.getPubAddrOnly());
            if (null != this.secPanel) {
                System.setProperty("net.jxta.tls.principal", this.secPanel.getPrincipal());
                System.setProperty("net.jxta.tls.password", this.secPanel.getPassword());
            }
            rdvConf = (RdvConfigAdv)AdvertisementFactory.newAdvertisement(RdvConfigAdv.getAdvertisementType());
            rdvConf.setConfiguration(this.rdvPanel.isRdv.getState() != false ? RdvConfigAdv.RendezVousConfiguration.RENDEZVOUS : RdvConfigAdv.RendezVousConfiguration.EDGE);
            rdvConf.setUseOnlySeeds(this.rdvPanel.useOnlySeeds.getState());
            eachTcpRdv = Arrays.asList(this.rdvPanel.tcp.getItems()).iterator();
            while (eachTcpRdv.hasNext()) {
                rdvConf.addSeedRendezvous("tcp://" + eachTcpRdv.next().toString());
            }
            eachHttpRdv = Arrays.asList(this.rdvPanel.http.getItems()).iterator();
            while (eachHttpRdv.hasNext()) {
                rdvConf.addSeedRendezvous("http://" + eachHttpRdv.next().toString());
            }
            rdvDoc = (XMLDocument)rdvConf.getDocument(MimeMediaType.XMLUTF8);
            this.configAdv.putServiceParam(PeerGroup.rendezvousClassID, rdvDoc);
            proxy = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            if (!this.rdvPanel.isProxy.getState()) {
                proxy.appendChild(proxy.createElement("isOff"));
            }
            this.configAdv.putServiceParam(PeerGroup.proxyClassID, proxy);
            relay = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            elm = null;
            if (this.relayPanel.isRelay.getState()) {
                e = relay.createElement("isServer", "true");
                relay.appendChild((Element)e);
            } else {
                e = relay.createElement("isServer", "false");
                relay.appendChild((Element)e);
            }
            relay.appendChild(relay.createElement("ServerMaximumClients"));
            relay.appendChild(relay.createElement("ServerLeaseInSeconds"));
            if (this.relayPanel.useRelay.getState()) {
                e = relay.createElement("isClient", "true");
                relay.appendChild((Element)e);
            } else {
                e = relay.createElement("isClient", "false");
                relay.appendChild((Element)e);
            }
            relay.appendChild(relay.createElement("ClientMaximumServers"));
            relay.appendChild(relay.createElement("ClientLeaseInSeconds"));
            relay.appendChild(relay.createElement("ClientQueueSize", "20"));
            relays = this.relayPanel.http.getItems();
            i = relays.length;
            while (i-- > 0) {
                e = relay.createElement("httpaddr", relays[i]);
                relay.appendChild((Element)e);
            }
            relays = this.relayPanel.tcp.getItems();
            i = relays.length;
            while (i-- > 0) {
                e = relay.createElement("tcpaddr", relays[i]);
                relay.appendChild((Element)e);
            }
            if (!this.relayPanel.isRelay.getState() && !this.relayPanel.useRelay.getState()) {
                relay.appendChild(relay.createElement("isOff"));
            }
            this.configAdv.putServiceParam(PeerGroup.relayProtoClassID, relay);
            endp = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            endp.appendChild(endp.createElement("MessengerQueueSize", "20"));
            this.configAdv.putServiceParam(PeerGroup.endpointClassID, endp);
            if (null != this.secPanel) {
                block41: {
                    certFile = this.secPanel.getCertFile();
                    pseConf = (PSEConfigAdv)AdvertisementFactory.newAdvertisement(PSEConfigAdv.getAdvertisementType());
                    if (null != certFile) {
                        fr = null;
                        try {
                            fr = new FileReader(certFile);
                            br = new BufferedReader(fr);
                            certString = PSEUtils.loadBase64Object(br, "CERTIFICATE");
                            pseConf.setCert(certString);
                            fr = new FileReader(certFile);
                            br = new BufferedReader(fr);
                            key_base64 = PSEUtils.loadBase64Object(br, "ENCRYPTED PRIVATE KEY");
                            if (null == key_base64) {
                                br.reset();
                                key_base64 = PSEUtils.loadBase64Object(br, "ENCRYPTED " + pseConf.getCertificate().getPublicKey().getAlgorithm() + " PRIVATE KEY");
                            }
                            pseConf.setEncryptedPrivateKey(key_base64, pseConf.getCertificate().getPublicKey().getAlgorithm());
                            var21_24 = null;
                            ** if (null == fr) goto lbl-1000
                        }
                        catch (Throwable var20_30) {
                            var21_26 = null;
                            if (null != fr) {
                                try {
                                    fr.close();
                                }
                                catch (IOException ignored) {
                                    // empty catch block
                                }
                            }
                            throw var20_30;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                fr.close();
                            }
                            catch (IOException ignored) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block41;
                            catch (IOException failed) {
                                System.err.println("Reading Cert failed : " + failed);
                                var21_25 = null;
                                if (null != fr) {
                                    try {
                                        fr.close();
                                    }
                                    catch (IOException ignored) {}
                                }
                                break block41;
                            }
                        }
                    }
                    info = PSEUtils.genCert(this.secPanel.getPrincipal(), null);
                    pseConf.setCertificate(info.cert);
                    pseConf.setPrivateKey(info.subjectPkey, this.secPanel.getPassword().toCharArray());
                }
                pseDoc = (XMLDocument)pseConf.getDocument(MimeMediaType.XMLUTF8);
                this.configAdv.putServiceParam(PeerGroup.membershipClassID, pseDoc);
            }
            tdoc = (StructuredDocument)this.httpAdv.getDocument(MimeMediaType.XMLUTF8);
            this.configAdv.putServiceParam(PeerGroup.httpProtoClassID, this.wrapParm(tdoc, this.httpPanel.getState()));
            tdoc = (StructuredDocument)this.tcpAdv.getDocument(MimeMediaType.XMLUTF8);
            this.configAdv.putServiceParam(PeerGroup.tcpProtoClassID, this.wrapParm(tdoc, this.tcpPanel.getState()));
            this.configAdv.setDebugLevel(this.debugPanel.getDebugLevel());
        }
        catch (Throwable bad) {
            bad.printStackTrace();
            this.beCanceled();
        }
        this.beDone();
    }

    private StructuredDocument wrapParm(StructuredDocument srcAdv, boolean enabled) {
        try {
            XMLDocument doc = (XMLDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
            StructuredDocumentUtils.copyElements(doc, doc, srcAdv);
            if (!enabled) {
                doc.appendChild(doc.createElement("isOff"));
            }
            return doc;
        }
        catch (Throwable ez1) {
            ez1.printStackTrace();
            return null;
        }
    }

    static class RelayPanel
    extends BorderPanelGBL
    implements ItemListener {
        Checkbox isRelay;
        Checkbox useRelay;
        public HostListPanel http;
        public HostListPanel tcp;
        private ItemListener listener;

        public void itemStateChanged(ItemEvent e) {
            this.listener.itemStateChanged(e);
        }

        public RelayPanel(ItemListener l, String title, boolean actAsRelay, boolean useARelay) {
            super(title);
            this.listener = l;
            this.isRelay = new Checkbox("Act as a Relay", null, actAsRelay);
            this.useRelay = new Checkbox("Use a relay (Required if behind firewall/NAT)", null, useARelay);
            this.http = new HostListPanel("http", "Available HTTP relays");
            this.tcp = new HostListPanel("tcp", "Available TCP relays");
            this.add((Component)this.isRelay, stdConstr);
            this.add((Component)this.useRelay, stdConstr);
            this.add((Component)this.tcp, leftPanelConstr);
            this.add((Component)this.http, rightPanelConstr);
        }
    }

    static class RdvPanel
    extends BorderPanelGBL {
        public Checkbox isRdv;
        public Checkbox useOnlySeeds;
        public Checkbox isProxy;
        public HostListPanel http;
        public HostListPanel tcp;

        RdvPanel(String title, boolean isRendezVous, boolean isJxtaProxy, boolean onlySeeds) {
            super(title);
            this.isRdv = new Checkbox("Act as a Rendezvous", null, isRendezVous);
            this.useOnlySeeds = new Checkbox("Use only configured rendezvous", null, onlySeeds);
            this.isProxy = new Checkbox("Act as a JxtaProxy", null, isJxtaProxy);
            this.http = new HostListPanel("http", "Available HTTP rendez-vous");
            this.tcp = new HostListPanel("tcp", "Available TCP rendez-vous");
            this.add((Component)this.isRdv, startLineConstr);
            this.add((Component)this.useOnlySeeds, rightLineConstr);
            this.add((Component)this.isProxy, stdConstr);
            this.add((Component)this.tcp, leftPanelConstr);
            this.add((Component)this.http, rightPanelConstr);
        }
    }

    static class DebugPanel
    extends PanelGBL {
        private Choice debugLevel = new Choice();

        public String getDebugLevel() {
            return this.debugLevel.getSelectedItem();
        }

        public DebugPanel(String dftDebugLevel) {
            this.debugLevel.addItem("error");
            this.debugLevel.addItem("warn");
            this.debugLevel.addItem("info");
            this.debugLevel.addItem("debug");
            this.debugLevel.addItem("user default");
            this.debugLevel.select(dftDebugLevel);
            this.add((Component)new Label("Trace Level"), leftLineConstr);
            this.add((Component)this.debugLevel, rightLineConstr);
        }
    }

    class SecPanel
    extends PanelGBL
    implements ActionListener {
        private TextField principal;
        private TextField passwd;
        private TextField vpasswd;
        private Label principalLabel = new Label("Secure Username", 2);
        private Label secLabel = new Label("Password", 2);
        private Label vsecLabel = new Label("Verify Password", 2);
        private Button file;
        private TextField certFile;
        private Label please1 = new Label("Please note your secure username and password");
        private Label please2 = new Label("They will be required for all future access");
        private boolean passwordEntered = false;

        public String getPrincipal() {
            return this.principal.getText();
        }

        public String getPassword() {
            return this.passwd.getText();
        }

        public String getVerifyPassword() {
            return this.vpasswd.getText();
        }

        public File getCertFile() {
            String filepath = this.certFile.getText();
            if (0 == filepath.length()) {
                return null;
            }
            return new File(filepath);
        }

        public void clearPasswords() {
            this.passwd.setText("");
            this.vpasswd.setText("");
        }

        public void clearPrincipal() {
            this.principal.setText("");
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.file) {
                FileDialog getFile = new FileDialog((Frame)ConfigDialog.this, "Select Root Certificate File", 0);
                getFile.setDirectory(System.getProperty("user.home"));
                getFile.show();
                String inDir = getFile.getDirectory();
                String theFile = getFile.getFile();
                if (null != inDir && null != theFile) {
                    String fullPath = inDir + theFile;
                    this.certFile.setText(fullPath);
                }
            }
        }

        public void setState(boolean state) {
            this.principalLabel.setEnabled(state);
            this.passwd.setEnabled(state);
            this.vpasswd.setEnabled(state);
            this.secLabel.setEnabled(state);
            this.vsecLabel.setEnabled(state);
        }

        public SecPanel() {
            this.principal = new TextField(System.getProperty("net.jxta.tls.principal", ""), 20);
            this.passwd = new TextField(System.getProperty("net.jxta.tls.password", ""), 20);
            this.vpasswd = new TextField(System.getProperty("net.jxta.tls.password", ""), 20);
            this.passwd.setEchoChar('*');
            this.vpasswd.setEchoChar('*');
            this.file = new Button("Import Root Certificate File...");
            this.certFile = new TextField("", 40);
            this.certFile.setEditable(false);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 24;
            this.add((Component)this.principalLabel, constraints);
            ++constraints.gridx;
            constraints.anchor = 23;
            this.add((Component)this.principal, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 22;
            this.add((Component)this.secLabel, constraints);
            ++constraints.gridx;
            constraints.anchor = 21;
            this.add((Component)this.passwd, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 22;
            this.add((Component)this.vsecLabel, constraints);
            ++constraints.gridx;
            constraints.anchor = 21;
            this.add((Component)this.vpasswd, constraints);
            constraints.gridx = 0;
            constraints.gridy += 2;
            constraints.anchor = 21;
            this.add((Component)this.file, constraints);
            ++constraints.gridx;
            constraints.anchor = 10;
            this.add((Component)this.certFile, constraints);
            constraints.gridx = 0;
            constraints.gridy += 2;
            constraints.gridwidth = 2;
            constraints.anchor = 21;
            this.add((Component)this.please1, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.gridwidth = 2;
            constraints.anchor = 25;
            this.add((Component)this.please2, constraints);
            this.file.addActionListener(this);
            this.setState(true);
        }
    }

    class IdPanel
    extends PanelGBL
    implements ItemListener {
        private TextField peerName;

        public String getName() {
            return this.peerName.getText().trim();
        }

        public void setState(boolean state) {
            ConfigDialog.this.httpPanel.useMe.setState(state);
        }

        public boolean getState() {
            return ConfigDialog.this.httpPanel.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
        }

        public IdPanel(String defaultPeer) {
            this.peerName = new TextField(defaultPeer, 20);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 23;
            this.add((Component)new Label("Peer Name", 2), constraints);
            ++constraints.gridx;
            constraints.anchor = 23;
            this.add((Component)this.peerName, constraints);
            ++constraints.gridx;
            constraints.anchor = 23;
            this.add((Component)new Label("(Mandatory)"), constraints);
        }
    }

    static class IPTptPanel
    extends BorderPanelGBL
    implements ItemListener {
        public static final int TYPE_HTTP = 0;
        public static final int TYPE_TCP = 1;
        public Checkbox useMe;
        public Checkbox pubAddrOnly;
        public Checkbox multicast;
        public Checkbox clientEnabled;
        IfAddrPanel ifAddr;
        HostPortPanel publicAddr;
        HostPortPanel proxyAddr;
        public ItemListener listener;

        public void setState(boolean state) {
            this.useMe.setState(state);
            this.ifAddr.setEnabled(state);
            this.publicAddr.setEnabled(state);
            if (this.multicast != null) {
                this.multicast.setEnabled(state);
            }
            this.clientEnabled.setEnabled(state);
            this.pubAddrOnly.setEnabled(state);
            if (null != this.proxyAddr) {
                this.proxyAddr.setEnabled(state);
            }
        }

        public boolean getState() {
            return this.useMe.getState();
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.useMe) {
                this.setState(this.useMe.getState());
                this.listener.itemStateChanged(e);
            }
        }

        public String getInterfaceAddress() {
            return this.ifAddr.getAddress().trim();
        }

        public String getConfigMode() {
            return this.ifAddr.getMode();
        }

        public boolean getPubAddrOnly() {
            return this.pubAddrOnly.getState();
        }

        public void setPubAddrOnly(boolean state) {
            this.pubAddrOnly.setState(state);
        }

        public IPTptPanel(int type, boolean defaultState, String name, String desc, ItemListener listener, String defaultInterfaceAddr, String defaultPort, boolean clientState, boolean serverState, String defaultPublicAddr, String defaultPublicPort, boolean proxyOn, String defaultProxyAddr, String defaultProxyPort, boolean pubAddrOnlyState) {
            this(type, defaultState, name, desc, listener, defaultInterfaceAddr, defaultPort, clientState, serverState, defaultPublicAddr, defaultPublicPort, proxyOn, defaultProxyAddr, defaultProxyPort, pubAddrOnlyState, false);
        }

        public IPTptPanel(int type, boolean defaultState, String name, String desc, ItemListener listener, String defaultInterfaceAddr, String defaultPort, boolean clientState, boolean serverState, String defaultPublicAddr, String defaultPublicPort, boolean proxyOn, String defaultProxyAddr, String defaultProxyPort, boolean pubAddrOnlyState, boolean multicastState) {
            super(name, desc);
            this.listener = listener;
            this.ifAddr = new IfAddrPanel(defaultInterfaceAddr, defaultPort);
            this.useMe = new Checkbox("Enabled", null, defaultState);
            if (type == 1) {
                this.multicast = new Checkbox("Multicast", null, multicastState);
            }
            this.clientEnabled = new Checkbox("Enable Outgoing connections", null, clientState);
            this.pubAddrOnly = new Checkbox("Hide private addresses", null, pubAddrOnlyState);
            this.publicAddr = new HostPortPanel(this, "Enable Incoming Connections", "(Optional) Public address", defaultPublicAddr, defaultPublicPort, serverState);
            this.proxyAddr = new HostPortPanel(this, "Use proxy", "Proxy Address", defaultProxyAddr, defaultProxyPort, proxyOn);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.anchor = 23;
            this.add((Component)this.useMe, constraints);
            if (type == 1) {
                constraints.anchor = 24;
                this.add((Component)this.multicast, constraints);
            }
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 21;
            this.add((Component)this.ifAddr, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 21;
            this.add((Component)this.clientEnabled, constraints);
            constraints.anchor = 13;
            this.add((Component)this.pubAddrOnly, constraints);
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 21;
            this.add((Component)this.publicAddr, constraints);
            this.publicAddr.setState(serverState);
            if (type != 1) {
                constraints.gridx = 0;
                ++constraints.gridy;
                constraints.anchor = 25;
                this.add((Component)this.proxyAddr, constraints);
                this.proxyAddr.setState(proxyOn);
            }
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }
    }

    static class IfAddrPanel
    extends Panel
    implements ItemListener {
        private Checkbox manual;
        private CardLayout addrLayout;
        private Panel addrPanel;
        private Choice ips = new Choice();
        private TextField interfaceAddr;
        private TextField localPort;

        private void setManual(boolean m) {
            this.addrLayout.show(this.addrPanel, m ? "man" : "auto");
            this.validate();
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.manual.setEnabled(enabled);
            this.ips.setEnabled(enabled);
            this.interfaceAddr.setEnabled(enabled);
            this.localPort.setEnabled(enabled);
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.manual) {
                this.setManual(this.manual.getState());
            }
        }

        public String getAddress() {
            if (this.manual.getState()) {
                return this.interfaceAddr.getText().trim();
            }
            return this.ips.getSelectedItem().trim();
        }

        public String getPort() {
            return this.localPort.getText().trim();
        }

        public String getMode() {
            return this.manual.getState() ? "manual" : "auto";
        }

        public IfAddrPanel(String defaultInterfaceAddr, String defaultPort) {
            super(new FlowLayout(3, 0, 0));
            boolean modeManual = false;
            this.ips.add("Any/All Local Addresses");
            try {
                InetAddress defaultIntf;
                Iterator allIntf = IPUtils.getAllLocalAddresses();
                boolean sawValid = false;
                while (allIntf.hasNext()) {
                    InetAddress anAddr = (InetAddress)allIntf.next();
                    if (IPUtils.LOOPBACK.equals(anAddr)) continue;
                    this.ips.add(anAddr.getHostAddress());
                    sawValid = true;
                }
                if (!sawValid) {
                    modeManual = true;
                }
                if (defaultInterfaceAddr != null && !IPUtils.ANYADDRESS.equals(defaultIntf = InetAddress.getByName(defaultInterfaceAddr))) {
                    modeManual = true;
                    allIntf = IPUtils.getAllLocalAddresses();
                    while (allIntf.hasNext()) {
                        InetAddress anAddr = (InetAddress)allIntf.next();
                        if (!defaultIntf.equals(anAddr)) continue;
                        modeManual = false;
                        this.ips.select(defaultInterfaceAddr);
                    }
                }
            }
            catch (Exception e) {
                modeManual = true;
            }
            this.manual = new Checkbox("Manual", null, modeManual);
            this.add(this.manual);
            Panel autoPanel = new Panel(new FlowLayout(3));
            autoPanel.add(this.ips);
            Panel manPanel = new Panel(new FlowLayout(3));
            this.interfaceAddr = new TextField(defaultInterfaceAddr, 20);
            manPanel.add(this.interfaceAddr);
            this.addrLayout = new CardLayout();
            this.addrPanel = new Panel(this.addrLayout);
            this.addrPanel.add((Component)manPanel, "man");
            this.addrPanel.add((Component)autoPanel, "auto");
            this.add(this.addrPanel);
            this.localPort = new TextField(defaultPort, 6);
            this.add(this.localPort);
            this.manual.addItemListener(this);
            this.setManual(modeManual);
        }
    }

    static class HostListPanel
    extends PanelGBL
    implements ActionListener,
    ItemListener {
        private TextField host = new TextField("", 16);
        private TextField port = new TextField("", 4);
        private Button insert = new Button(" + ");
        private Button remove = new Button(" - ");
        private String protocol;
        private List list = new List(3, true);
        private Label listLabel;

        public void setState(boolean state) {
            this.list.setEnabled(state);
            this.host.setEnabled(state);
            this.port.setEnabled(state);
            this.insert.setEnabled(state);
            this.remove.setEnabled(state);
            this.listLabel.setEnabled(state);
        }

        public boolean getState() {
            return this.host.isEnabled();
        }

        public void itemStateChanged(ItemEvent e) {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.insert) {
                StringBuffer addHost = new StringBuffer(this.host.getText());
                if (-1 == this.host.getText().indexOf(58)) {
                    addHost.append(':');
                    addHost.append(this.port.getText());
                }
                if (this.addItem(addHost.toString())) {
                    this.host.setText("");
                    this.host.setCaretPosition(0);
                    this.port.setText("");
                    this.port.setCaretPosition(0);
                }
                return;
            }
            if (e.getSource() == this.remove) {
                int[] sel = this.list.getSelectedIndexes();
                int i = sel.length;
                while (i-- > 0) {
                    this.list.remove(sel[i]);
                }
                return;
            }
            if (e.getSource() == this.list) {
                String cmd = e.getActionCommand();
                int colonAt = cmd.indexOf(58);
                String newHost = cmd.substring(0, colonAt);
                String newPort = cmd.substring(colonAt + 1);
                this.host.setText(newHost);
                this.host.setCaretPosition(newHost.length());
                this.port.setText(newPort);
                this.port.setCaretPosition(newHost.length());
            }
        }

        public HostListPanel(String protocol, String lstLabel) {
            this(protocol, lstLabel, true);
        }

        public HostListPanel(String protocol, String lstLabel, boolean defaultState) {
            this.listLabel = new Label(lstLabel);
            this.protocol = protocol;
            PanelGBL p1 = new PanelGBL();
            PanelGBL p2 = new PanelGBL();
            GridBagConstraints c1 = (GridBagConstraints)leftLineConstr.clone();
            c1.insets = new Insets(0, 0, 0, 0);
            p1.add((Component)this.host, c1);
            p1.add((Component)this.port, rightLineConstr);
            p1.add((Component)this.list, fillConstr);
            p2.add((Component)this.insert, fillConstr);
            p2.add((Component)this.remove, fillConstr);
            GridBagConstraints c2 = (GridBagConstraints)rightLineConstr.clone();
            c2.anchor = 18;
            c2.insets = new Insets(4, 2, 2, 8);
            this.add((Component)this.listLabel, stdConstr);
            this.add((Component)p1, c1);
            this.add((Component)p2, c2);
            this.setState(defaultState);
            this.insert.addActionListener(this);
            this.remove.addActionListener(this);
            this.list.addActionListener(this);
        }

        public boolean addItem(String item) {
            int i = item.lastIndexOf(58);
            if (i == -1) {
                return false;
            }
            try {
                String ips = item.substring(0, i);
                String ports = item.substring(i + 1);
                int port = Integer.parseInt(ports);
                if (port < 1 || port > 65535) {
                    return false;
                }
                String additem = ips.trim() + ":" + ports;
                try {
                    while (true) {
                        this.list.remove(additem);
                    }
                }
                catch (IllegalArgumentException notThere) {
                    this.list.add(additem);
                }
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String[] getItems() {
            return this.list.getItems();
        }
    }

    static class AutoLoader
    extends Dialog
    implements ActionListener,
    ItemListener {
        HostListPanel tcpRdv;
        HostListPanel httpRdv;
        HostListPanel tcpRly;
        HostListPanel httpRly;
        Button load;
        Button quit;
        TextField rdvURL;
        TextField rlyURL;
        HostPortPanel httpProxy;
        Label helpLabel;
        boolean once;
        String helpText = "Edit the URLs below and click \"Load\". Leave blank those you do not want to load.";

        private boolean loadList(TextField urlField, HostListPanel tcpList, HostListPanel httpList) {
            String urlString = urlField.getText();
            if (urlString.equals("")) {
                return true;
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText("Trying " + urlString + "...");
            InputStream inp = null;
            try {
                String s;
                inp = new URL(urlString).openStream();
                BufferedReader l = new BufferedReader(new InputStreamReader(inp));
                int valid = 0;
                while ((s = l.readLine()) != null) {
                    if ((s = s.toLowerCase()).startsWith(tcpList.getProtocol() + "://")) {
                        if (!tcpList.addItem(s.substring(6))) continue;
                        ++valid;
                        continue;
                    }
                    if (!s.startsWith(httpList.getProtocol()) || !httpList.addItem(s.substring(7))) continue;
                    ++valid;
                }
                if (valid == 0) {
                    this.helpLabel.setForeground(Color.red.darker());
                    this.helpLabel.setText(urlString + ": not a valid list.");
                    return false;
                }
            }
            catch (MalformedURLException e) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(urlString + ": malformed URL.");
                return false;
            }
            catch (IOException e) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText(urlString + ": not accessible. " + (this.httpProxy.getState() ? "" : "You might need a proxy."));
                return false;
            }
            try {
                inp.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.helpLabel.setForeground(Color.black);
            this.helpLabel.setText(this.helpText);
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.quit) {
                this.dispose();
                return;
            }
            try {
                if (this.httpProxy.getState()) {
                    System.setProperty("http.proxyHost", this.httpProxy.getHost());
                    System.setProperty("http.proxyPort", this.httpProxy.getPort());
                }
            }
            catch (SecurityException ee) {
                this.helpLabel.setForeground(Color.red.darker());
                this.helpLabel.setText("Could not  turn-on proxying due to security restrictions.");
            }
            if (this.loadList(this.rdvURL, this.tcpRdv, this.httpRdv) && this.loadList(this.rlyURL, this.tcpRly, this.httpRly) && this.once) {
                this.dispose();
            }
        }

        public void itemStateChanged(ItemEvent e) {
        }

        public AutoLoader(Frame owner, HostListPanel tcpRdv, HostListPanel httpRdv, HostListPanel tcpRly, HostListPanel httpRly, String rdvsURL, String relaysURL, boolean once) {
            super(owner, "Load list from URL", true);
            this.once = once;
            if (once) {
                this.helpText = "Edit the URLs below and click \"Done\". Leave blank those you do not want to load.";
            }
            this.setLayout(new BorderLayout());
            Panel cent = new Panel(this, new GridLayout(0, 1, 0, 0)){
                private final /* synthetic */ AutoLoader this$0;
                {
                    this.this$0 = this$0;
                    super(x0);
                }

                public Insets getInsets() {
                    return new Insets(0, 5, 0, 5);
                }
            };
            this.tcpRdv = tcpRdv;
            this.httpRdv = httpRdv;
            this.tcpRly = tcpRly;
            this.httpRly = httpRly;
            this.rdvURL = new TextField(rdvsURL, 50);
            this.rlyURL = new TextField(relaysURL, 50);
            this.httpProxy = new HostPortPanel(this, "Use HTTP Proxy : ", null, "", "8080", false);
            this.helpLabel = new Label(this.helpText, 1);
            this.helpLabel.setBackground(new Color(220, 220, 220));
            this.helpLabel.setForeground(Color.black);
            this.load = new Button(once ? " Done " : " Load ");
            this.quit = new Button(once ? " Cancel " : " Dismiss ");
            Panel okPanel = new Panel();
            okPanel.add(this.load);
            okPanel.add(this.quit);
            Panel urlPanel1 = new Panel(new FlowLayout(2));
            Panel urlPanel2 = new Panel(new FlowLayout(2));
            Panel urlPanel3 = new Panel(new FlowLayout(0));
            urlPanel1.add(new Label("Rendez-vous list:"));
            urlPanel2.add(new Label("Relay list:"));
            urlPanel1.add(this.rdvURL);
            urlPanel2.add(this.rlyURL);
            urlPanel3.add(this.httpProxy);
            this.add((Component)this.helpLabel, "North");
            cent.add(new Label("See also: http://platform.jxta.org/java/rendezvous.html"));
            cent.add(urlPanel1);
            cent.add(urlPanel2);
            cent.add(urlPanel3);
            this.add((Component)cent, "Center");
            this.add((Component)okPanel, "South");
            this.helpLabel.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ AutoLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public void mouseClicked(MouseEvent e) {
                    this.this$0.helpLabel.setForeground(Color.black);
                    this.this$0.helpLabel.setText(this.this$0.helpText);
                }
            });
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ AutoLoader this$0;
                {
                    this.this$0 = this$0;
                }

                public void windowClosing(WindowEvent e) {
                    this.this$0.dispose();
                }
            });
            this.load.addActionListener(this);
            this.quit.addActionListener(this);
            this.pack();
            this.show();
        }
    }

    static class HostPortPanel
    extends PanelGBL
    implements ItemListener {
        public Checkbox useMe;
        private Label addressLabel;
        private TextField host;
        private TextField port;
        private ItemListener listener;

        HostPortPanel(ItemListener l, String checkLabel, String addrLabel, String defaultHost, String defaultPort, boolean defaultState) {
            this.listener = l;
            this.useMe = new Checkbox(checkLabel, defaultState);
            this.host = new TextField(defaultHost, 20);
            this.port = new TextField(defaultPort, 6);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.weightx = 1.0;
            constraints.weighty = 1.0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = null == addrLabel ? 2 : 3;
            constraints.anchor = 23;
            if (null != checkLabel) {
                this.add((Component)this.useMe, constraints);
                if (null != addrLabel) {
                    ++constraints.gridy;
                    constraints.gridx = 0;
                    constraints.anchor = 25;
                } else {
                    ++constraints.gridx;
                    constraints.gridx = -1;
                }
            }
            if (null != addrLabel) {
                constraints.gridwidth = 1;
                this.addressLabel = new Label(addrLabel, 2);
                this.add((Component)this.addressLabel, constraints);
            }
            constraints.gridx = -1;
            this.add((Component)this.host, constraints);
            this.add((Component)this.port, constraints);
            this.setState(defaultState);
            this.useMe.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent e) {
            this.setState(this.useMe.getState());
            if (null != this.listener) {
                this.listener.itemStateChanged(e);
            }
        }

        public boolean getState() {
            return this.useMe.getState() && this.isEnabled();
        }

        public void setEnabled(boolean enabling) {
            super.setEnabled(enabling);
            this.useMe.setEnabled(enabling);
            if (null != this.addressLabel) {
                this.addressLabel.setEnabled(this.useMe.getState());
            }
            this.host.setEnabled(this.useMe.getState());
            this.port.setEnabled(this.useMe.getState());
        }

        public void setState(boolean state) {
            this.useMe.setState(state);
            if (null != this.addressLabel) {
                this.addressLabel.setEnabled(state);
            }
            this.host.setEnabled(state);
            this.port.setEnabled(state);
        }

        public String getHost() {
            return this.host.getText().trim();
        }

        public String getPort() {
            return this.port.getText().trim();
        }
    }

    static class PagesPanel
    extends Panel
    implements ActionListener {
        Panel buttons;
        Panel pages;
        CardLayout l = new CardLayout();

        public void actionPerformed(ActionEvent e) {
            this.l.show(this.pages, e.getActionCommand());
        }

        public PagesPanel() {
            super(new BorderLayout());
            this.pages = new Panel(this.l);
            this.buttons = new Panel(new FlowLayout(0, 0, 0));
            this.add((Component)this.pages, "Center");
            this.add((Component)this.buttons, "North");
        }

        public PanelGBL addPage(String buttonName, String comment) {
            BorderPanelGBL p = new BorderPanelGBL(buttonName, comment, 1);
            this.pages.add((Component)p, buttonName);
            Button b = new Button(buttonName);
            this.buttons.add(b);
            b.addActionListener(this);
            return p;
        }

        public void showPage(String pageName) {
            this.l.show(this.pages, pageName);
        }
    }

    static class BorderPanelGBL
    extends PanelGBL {
        public static final int NONE = 0;
        public static final int RAISED = 1;
        public static final int LOWERED = 2;
        public static final int GROOVE = 3;
        public static final int BUMP = 4;
        int style = 3;
        String title;
        int ascent = 0;
        int descent = 0;
        int leading = 0;
        int titleWidth = 0;
        GridBagLayout lay = new GridBagLayout();

        public BorderPanelGBL(String title) {
            this.title = title;
        }

        public BorderPanelGBL(String title, String advice) {
            super(advice);
            this.title = title;
        }

        public BorderPanelGBL(String title, String advice, int s) {
            super(advice);
            this.title = title;
            if (s < 0 && s > 4) {
                return;
            }
            if (s == 1 || s == 2) {
                this.title = null;
            }
            this.style = s;
        }

        private void checkMetrics() {
            Font font = this.getFont();
            if (this.title == null || font == null) {
                this.ascent = 2;
            } else {
                FontMetrics fmetrics = this.getFontMetrics(font);
                this.ascent = fmetrics.getAscent();
                this.descent = fmetrics.getDescent();
                this.leading = fmetrics.getLeading();
                this.titleWidth = fmetrics.stringWidth(this.title);
            }
            this.insets = new Insets(this.descent + this.ascent + this.leading + 2, 7, 7, 7);
        }

        public Insets getInsets() {
            this.checkMetrics();
            return this.insets;
        }

        private void paintLowered(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.black);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(this.getBackground());
            g.drawRect(2, this.ascent - 1, d.width - 5, d.height - this.ascent - 1);
        }

        private void paintRaised(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.black);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(this.getBackground());
            g.drawRect(2, this.ascent - 1, d.width - 5, d.height - this.ascent - 1);
        }

        private void paintGroove(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.black);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(Color.black);
            g.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
            g.drawString(this.title, 12, this.ascent + 1);
            g.setColor(Color.white);
            g.drawString(this.title, 13, this.ascent + 2);
            g.clearRect(0, 0, d.width, 1);
        }

        private void paintBump(Graphics g) {
            this.checkMetrics();
            if (this.ascent == 0) {
                return;
            }
            Dimension d = this.getSize();
            g.setColor(Color.white);
            g.drawRect(1, this.ascent - 2, d.width - 4, d.height - this.ascent);
            g.setColor(Color.black);
            g.drawRect(2, this.ascent - 1, d.width - 4, d.height - this.ascent);
            g.setColor(Color.white);
            g.clearRect(10, 0, this.titleWidth + 6, this.descent + this.ascent + this.leading + 1);
            g.drawString(this.title, 12, this.ascent + 1);
            g.setColor(Color.black);
            g.drawString(this.title, 13, this.ascent + 2);
            g.clearRect(0, 0, d.width, 1);
        }

        public void paint(Graphics g) {
            switch (this.style) {
                case 3: {
                    this.paintGroove(g);
                    break;
                }
                case 4: {
                    this.paintBump(g);
                    break;
                }
                case 1: {
                    this.paintRaised(g);
                    break;
                }
                case 2: {
                    this.paintLowered(g);
                }
            }
            super.paint(g);
        }
    }

    static class PanelGBL
    extends Panel {
        protected Insets insets = new Insets(0, 0, 0, 0);
        GridBagLayout lay = new GridBagLayout();
        private static final GridBagConstraints constrLabel = new GridBagConstraints();

        public PanelGBL(String label) {
            this();
            this.add((Component)new Label(label, 0), constrLabel);
        }

        public PanelGBL() {
            this.setLayout(this.lay);
        }

        public Insets getInsets() {
            return this.insets;
        }

        static {
            PanelGBL.constrLabel.gridwidth = 0;
            PanelGBL.constrLabel.gridheight = 1;
            PanelGBL.constrLabel.gridy = -1;
            PanelGBL.constrLabel.weightx = 2.0;
            PanelGBL.constrLabel.weighty = 1.0;
            PanelGBL.constrLabel.anchor = 18;
            PanelGBL.constrLabel.fill = 2;
        }
    }
}

