/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.peer;

import java.util.Enumeration;
import java.util.LinkedList;
import net.jxta.document.Element;
import net.jxta.document.TextElement;
import net.jxta.meter.MonitorFilter;
import net.jxta.meter.MonitorReport;
import net.jxta.meter.PeerMonitorInfo;
import net.jxta.util.documentSerializable.DocumentSerializable;
import net.jxta.util.documentSerializable.DocumentSerializableUtilities;
import net.jxta.util.documentSerializable.DocumentSerializationException;

public class RemoteMonitorResponse
implements DocumentSerializable {
    public static final String MONITOR_REGISTERED = "monitorRegistered";
    public static final String MONITOR_REMOVED = "monitorGone";
    public static final String CUMULATIVE_REPORT_RESPONSE = "cumulativeReport";
    public static final String MONITOR_REPORT_RESPONSE = "monitorReport";
    public static final String INVALID_FILTER = "invalidFilter";
    public static final String INVALID_REPORT_RATE = "invalidReportRate";
    public static final String VALID_FILTER = "validFilter";
    public static final String SERVICE_NOT_SUPPORTED = "serviceNotSupported";
    public static final String METERING_NOT_SUPPORTED = "metereringNotSupported";
    public static final String METERING_SUPPORTED = "meteringSupported";
    public static final String METERING_REQUEST_DENIED = "meteringRequestDenied";
    public static final String PEER_MONITOR_INFO = "peerMonitorInfo";
    public static final String LEASE_ENDED = "leaseOver";
    public static final String LEASE_RENEWED = "leaseRenewed";
    private String responseType;
    private int requestId;
    private int leaseId;
    private MonitorReport monitorReport;
    private boolean isCumulative;
    private MonitorFilter monitorFilter;
    private long lease = -1L;
    private PeerMonitorInfo peerMonitorInfo;
    private long[] reportRates;
    private LinkedList supportedModuleClassIDs;
    static /* synthetic */ Class class$net$jxta$meter$MonitorReport;
    static /* synthetic */ Class class$net$jxta$meter$MonitorFilter;
    static /* synthetic */ Class class$net$jxta$meter$PeerMonitorInfo;

    public RemoteMonitorResponse() {
    }

    private RemoteMonitorResponse(String responseType, int requestId) {
        this.responseType = responseType;
        this.requestId = requestId;
    }

    public long getLease() {
        return this.lease;
    }

    public boolean isCumulative() {
        return this.isCumulative;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getLeaseId() {
        return this.leaseId;
    }

    public MonitorReport getMonitorReport() {
        return this.monitorReport;
    }

    public MonitorFilter getMonitorFilter() {
        return this.monitorFilter;
    }

    public PeerMonitorInfo getPeerMonitorInfo() {
        return this.peerMonitorInfo;
    }

    public boolean isMonitorRegistered() {
        return this.responseType.equals(MONITOR_REGISTERED);
    }

    public boolean isMonitorRemoved() {
        return this.responseType.equals(MONITOR_REMOVED);
    }

    public boolean isCumulativeReport() {
        return this.responseType.equals(CUMULATIVE_REPORT_RESPONSE);
    }

    public boolean isMonitorReport() {
        return this.responseType.equals(MONITOR_REPORT_RESPONSE);
    }

    public boolean isValidFilter() {
        return this.responseType.equals(VALID_FILTER);
    }

    public boolean isInvalidFilter() {
        return this.responseType.equals(INVALID_FILTER);
    }

    public boolean isInvalidReportRate() {
        return this.responseType.equals(INVALID_REPORT_RATE);
    }

    public boolean isServiceNotSupported() {
        return this.responseType.equals(SERVICE_NOT_SUPPORTED);
    }

    public boolean isMeteringNotSupported() {
        return this.responseType.equals(METERING_NOT_SUPPORTED);
    }

    public boolean isMeteringSupported() {
        return this.responseType.equals(METERING_SUPPORTED);
    }

    public boolean isRequestDenied() {
        return this.responseType.equals(METERING_REQUEST_DENIED);
    }

    public boolean isPeerMonitorInfo() {
        return this.responseType.equals(PEER_MONITOR_INFO);
    }

    public boolean isLeaseRenewed() {
        return this.responseType.equals(LEASE_RENEWED);
    }

    public static RemoteMonitorResponse createMonitorRegisteredResponse(int requestId, int leaseId, long lease) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(MONITOR_REGISTERED, requestId);
        remoteMonitorResponse.leaseId = leaseId;
        remoteMonitorResponse.lease = lease;
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createMonitorRemovedResponse(int requestId) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(MONITOR_REMOVED, requestId);
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createLeaseEndedResponse(int requestId, int leaseId) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(LEASE_ENDED, requestId);
        remoteMonitorResponse.leaseId = leaseId;
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createCumulativeReportResponse(int requestId, MonitorReport monitorReport) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(CUMULATIVE_REPORT_RESPONSE, requestId);
        remoteMonitorResponse.monitorReport = monitorReport;
        remoteMonitorResponse.isCumulative = true;
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createMonitorReportResponse(int requestId, MonitorReport monitorReport) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(MONITOR_REPORT_RESPONSE, requestId);
        remoteMonitorResponse.monitorReport = monitorReport;
        remoteMonitorResponse.isCumulative = false;
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createInvalidReportRateResponse(int requestId) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(INVALID_REPORT_RATE, requestId);
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createServiceNotSupportedResponse(int requestId) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(SERVICE_NOT_SUPPORTED, requestId);
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createInvalidFilterResponse(int requestId) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(INVALID_FILTER, requestId);
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createDeniedResponse(int requestId) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(METERING_REQUEST_DENIED, requestId);
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createPeerMonitorInfoResponse(int requestId, PeerMonitorInfo peerMonitorInfo) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(PEER_MONITOR_INFO, requestId);
        remoteMonitorResponse.peerMonitorInfo = peerMonitorInfo;
        return remoteMonitorResponse;
    }

    public static RemoteMonitorResponse createLeaseRenewedResponse(int requestId, int leaseId, long lease) {
        RemoteMonitorResponse remoteMonitorResponse = new RemoteMonitorResponse(LEASE_RENEWED, requestId);
        remoteMonitorResponse.leaseId = leaseId;
        remoteMonitorResponse.lease = lease;
        return remoteMonitorResponse;
    }

    public void serializeTo(Element element2) throws DocumentSerializationException {
        DocumentSerializableUtilities.addString(element2, "responseType", this.responseType);
        DocumentSerializableUtilities.addInt(element2, "requestId", this.requestId);
        if (this.monitorReport != null) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, MONITOR_REPORT_RESPONSE, this.monitorReport);
        }
        if (this.monitorFilter != null) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, "monitorFilter", this.monitorFilter);
        }
        if (this.lease > 0L) {
            DocumentSerializableUtilities.addLong(element2, "lease", this.lease);
        }
        if (this.leaseId > -1) {
            DocumentSerializableUtilities.addInt(element2, "leaseId", this.leaseId);
        }
        if (this.isCumulative) {
            DocumentSerializableUtilities.addBoolean(element2, "isCumulative", this.isCumulative);
        }
        if (this.peerMonitorInfo != null) {
            DocumentSerializableUtilities.addDocumentSerializable(element2, PEER_MONITOR_INFO, this.peerMonitorInfo);
        }
    }

    public void initializeFrom(Element element2) throws DocumentSerializationException {
        Enumeration e = element2.getChildren();
        while (e.hasMoreElements()) {
            TextElement childElement = (TextElement)e.nextElement();
            String tagName = (String)childElement.getKey();
            if (tagName.equals("responseType")) {
                this.responseType = DocumentSerializableUtilities.getString(childElement);
                continue;
            }
            if (tagName.equals("requestId")) {
                this.requestId = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals(MONITOR_REPORT_RESPONSE)) {
                this.monitorReport = (MonitorReport)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, class$net$jxta$meter$MonitorReport == null ? RemoteMonitorResponse.class$("net.jxta.meter.MonitorReport") : class$net$jxta$meter$MonitorReport);
                continue;
            }
            if (tagName.equals("monitorFilter")) {
                this.monitorFilter = (MonitorFilter)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, class$net$jxta$meter$MonitorFilter == null ? RemoteMonitorResponse.class$("net.jxta.meter.MonitorFilter") : class$net$jxta$meter$MonitorFilter);
                continue;
            }
            if (tagName.equals("lease")) {
                this.lease = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("leaseId")) {
                this.leaseId = DocumentSerializableUtilities.getInt(childElement);
                continue;
            }
            if (tagName.equals("isCumulative")) {
                this.isCumulative = DocumentSerializableUtilities.getBoolean(childElement);
                continue;
            }
            if (!tagName.equals(PEER_MONITOR_INFO)) continue;
            this.peerMonitorInfo = (PeerMonitorInfo)DocumentSerializableUtilities.getDocumentSerializable((Element)childElement, class$net$jxta$meter$PeerMonitorInfo == null ? RemoteMonitorResponse.class$("net.jxta.meter.PeerMonitorInfo") : class$net$jxta$meter$PeerMonitorInfo);
        }
    }
}

