/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.credential.Credential;
import net.jxta.credential.CredentialPCLSupport;
import net.jxta.document.Attributable;
import net.jxta.document.Attribute;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class PSECredential
implements Credential,
CredentialPCLSupport {
    private static final Logger LOG = Logger.getLogger((String)PSECredential.class.getName());
    private static Timer expirationTimer = new Timer(true);
    private PSEMembershipService source;
    private ID peerGroupID = null;
    private ID peerID = null;
    private ID keyID = null;
    private CertPath certs = null;
    private PrivateKey privateKey = null;
    private TimerTask becomesValidTask = null;
    private TimerTask expiresTask = null;
    private boolean valid = true;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    protected PSECredential(PSEMembershipService source, ID keyID, CertPath certChain, PrivateKey privateKey) throws IOException {
        this.source = source;
        this.peerID = source.group.getPeerID();
        this.peerGroupID = source.group.getPeerGroupID();
        this.setKeyID(keyID);
        this.setCertificateChain(certChain);
        this.setPrivateKey(privateKey);
    }

    public PSECredential(Element root) {
        this.initialize(root);
    }

    public PSECredential(PSEMembershipService source, Element root) {
        this.source = source;
        this.initialize(root);
        if (!this.peerGroupID.equals(source.group.getPeerGroupID())) {
            throw new IllegalArgumentException("Credential is from a different group. " + this.peerGroupID + " != " + source.group.getPeerGroupID());
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof PSECredential) {
            PSECredential asCred = (PSECredential)target;
            boolean result = this.peerID.equals(asCred.peerID) && this.source.group.getPeerGroupID().equals(asCred.source.group.getPeerGroupID());
            return result &= this.certs.equals(asCred.certs);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        if (null != this.becomesValidTask) {
            this.becomesValidTask.cancel();
        }
        if (null != this.expiresTask) {
            this.expiresTask.cancel();
        }
        super.finalize();
    }

    public int hashCode() {
        int result = this.peerID.hashCode() * this.source.group.getPeerGroupID().hashCode() * this.certs.hashCode();
        if (0 == result) {
            result = 1;
        }
        return result;
    }

    public String toString() {
        return "\"" + this.getSubject() + "\" " + this.getPeerID() + " [" + this.source + " / " + this.getPeerGroupID() + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    public ID getPeerGroupID() {
        return this.peerGroupID;
    }

    private void setPeerGroupID(ID newID) {
        this.peerGroupID = newID;
    }

    public ID getPeerID() {
        return this.peerID;
    }

    private void setPeerID(PeerID peerID) {
        this.peerID = peerID;
    }

    public boolean isExpired() {
        try {
            ((X509Certificate)this.certs.getCertificates().get(0)).checkValidity();
            return false;
        }
        catch (CertificateExpiredException expired) {
            return true;
        }
        catch (CertificateNotYetValidException notyet) {
            return true;
        }
    }

    public boolean isValid() {
        return this.valid && !this.isExpired();
    }

    void setValid(boolean valid) {
        boolean oldValid = this.isValid();
        this.valid = valid;
        if (oldValid != valid) {
            this.support.firePropertyChange("valid", oldValid, valid);
        }
    }

    public Object getSubject() {
        return ((X509Certificate)this.certs.getCertificates().get(0)).getSubjectDN();
    }

    public Service getSourceService() {
        return this.source;
    }

    public StructuredDocument getDocument(MimeMediaType encodeAs) throws Exception {
        if (null == this.privateKey) {
            throw new IllegalStateException("This credential is not a local credential and document cannot be created.");
        }
        StructuredDocument doc = StructuredDocumentFactory.newStructuredDocument(encodeAs, "jxta:Cred");
        if (doc instanceof XMLDocument) {
            ((XMLDocument)doc).addAttribute("xmlns:jxta", "http://jxta.org");
            ((XMLDocument)doc).addAttribute("xml:space", "preserve");
            ((Attributable)((Object)doc)).addAttribute("type", "jxta:PSECred");
        }
        if (doc instanceof Attributable) {
            ((Attributable)((Object)doc)).addAttribute("type", "jxta:PSECred");
        }
        Element e = doc.createElement("PeerGroupID", this.getPeerGroupID().toString());
        doc.appendChild(e);
        e = doc.createElement("PeerID", this.getPeerID().toString());
        doc.appendChild(e);
        net.jxta.impl.protocol.Certificate certChain = new net.jxta.impl.protocol.Certificate();
        List<? extends Certificate> certsList = this.certs.getCertificates();
        certChain.setCertificates(certsList);
        StructuredDocument certsDoc = (StructuredDocument)certChain.getDocument(encodeAs);
        if (certsDoc instanceof Attributable) {
            ((Attributable)((Object)certsDoc)).addAttribute("type", certsDoc.getKey().toString());
        }
        StructuredDocumentUtils.copyElements(doc, doc, certsDoc, "Certificate");
        ArrayList<ByteArrayInputStream> someStreams = new ArrayList<ByteArrayInputStream>(3);
        someStreams.add(new ByteArrayInputStream(this.getPeerGroupID().toString().getBytes("UTF-8")));
        someStreams.add(new ByteArrayInputStream(this.getPeerID().toString().getBytes("UTF-8")));
        Iterator<? extends Certificate> eachCert = certsList.iterator();
        while (eachCert.hasNext()) {
            X509Certificate aCert = (X509Certificate)eachCert.next();
            someStreams.add(new ByteArrayInputStream(aCert.getEncoded()));
        }
        SequenceInputStream signStream = new SequenceInputStream(Collections.enumeration(someStreams));
        byte[] sig = PSEUtils.computeSignature("SHA1withRSA", this.privateKey, signStream);
        e = doc.createElement("Signature", PSEUtils.base64Encode(sig));
        doc.appendChild(e);
        return doc;
    }

    public X509Certificate getCertificate() {
        return (X509Certificate)this.certs.getCertificates().get(0);
    }

    public X509Certificate[] getCertificateChain() {
        List<? extends Certificate> certList = this.certs.getCertificates();
        return certList.toArray(new X509Certificate[certList.size()]);
    }

    private void setCertificateChain(CertPath certChain) {
        this.certs = certChain;
        Date now = new Date();
        Date becomesValid = ((X509Certificate)this.certs.getCertificates().get(0)).getNotBefore();
        Date expires = ((X509Certificate)this.certs.getCertificates().get(0)).getNotAfter();
        if (becomesValid.compareTo(now) > 0) {
            if (null != this.becomesValidTask) {
                this.becomesValidTask.cancel();
            }
            this.becomesValidTask = new TimerTask(){

                public void run() {
                    PSECredential.this.support.firePropertyChange("expired", false, true);
                    if (PSECredential.this.valid) {
                        PSECredential.this.support.firePropertyChange("valid", false, true);
                    }
                }
            };
            expirationTimer.schedule(this.becomesValidTask, becomesValid);
        }
        if (null != this.expiresTask) {
            this.expiresTask.cancel();
        }
        if (expires.compareTo(now) > 0) {
            this.expiresTask = new TimerTask(){

                public void run() {
                    PSECredential.this.support.firePropertyChange("expired", true, false);
                    if (PSECredential.this.valid) {
                        PSECredential.this.support.firePropertyChange("valid", true, false);
                    }
                }
            };
            expirationTimer.schedule(this.expiresTask, expires);
        }
        boolean nowGood = null == this.becomesValidTask && null != this.expiresTask;
        this.support.firePropertyChange("expired", true, nowGood);
        this.setValid(nowGood);
    }

    public PrivateKey getPrivateKey() {
        if (null == this.privateKey) {
            throw new IllegalStateException("This credential is not a local credential and cannot be used for signing.");
        }
        return this.privateKey;
    }

    private void setPrivateKey(PrivateKey privateKey) {
        if (null == privateKey) {
            throw new NullPointerException("private key must not be null");
        }
        this.privateKey = privateKey;
    }

    public ID getKeyID() {
        return this.keyID;
    }

    private void setKeyID(ID keyID) {
        this.keyID = keyID;
    }

    public Signature getSigner(String algorithm) throws NoSuchAlgorithmException {
        if (null == this.privateKey) {
            throw new IllegalStateException("This credential is not a local credential and cannot be used for signing.");
        }
        Signature sign = Signature.getInstance(algorithm);
        try {
            sign.initSign(this.privateKey);
        }
        catch (InvalidKeyException failed) {
            IllegalStateException failure = new IllegalStateException("Invalid private key");
            failure.initCause(failed);
            throw failure;
        }
        return sign;
    }

    public Signature getSignatureVerifier(String algorithm) throws NoSuchAlgorithmException {
        Signature verify = Signature.getInstance(algorithm);
        try {
            verify.initVerify((X509Certificate)this.certs.getCertificates().get(0));
        }
        catch (InvalidKeyException failed) {
            IllegalStateException failure = new IllegalStateException("Invalid certificate");
            failure.initCause(failed);
            throw failure;
        }
        return verify;
    }

    protected boolean handleElement(XMLElement elem) {
        if (elem.getName().equals("PeerGroupID")) {
            try {
                ID pid = IDFactory.fromURI(new URI(elem.getTextValue()));
                this.setPeerGroupID((PeerGroupID)pid);
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad PeerGroupID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a group id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals("PeerID")) {
            try {
                ID pid = IDFactory.fromURI(new URI(elem.getTextValue()));
                this.setPeerID((PeerID)pid);
            }
            catch (URISyntaxException badID) {
                throw new IllegalArgumentException("Bad Peer ID in advertisement: " + elem.getTextValue());
            }
            catch (ClassCastException badID) {
                throw new IllegalArgumentException("Id is not a peer id: " + elem.getTextValue());
            }
            return true;
        }
        if (elem.getName().equals("Certificate")) {
            if (null == elem.getAttribute("type")) {
                elem.addAttribute("type", net.jxta.impl.protocol.Certificate.getMessageType());
            }
            net.jxta.impl.protocol.Certificate certChain = new net.jxta.impl.protocol.Certificate(elem);
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                this.certs = cf.generateCertPath(Arrays.asList(certChain.getCertificates()));
            }
            catch (CertificateException failure) {
                throw new IllegalArgumentException("bad certificates in chain.");
            }
            return true;
        }
        if (elem.getName().equals("Signature")) {
            if (null == this.certs) {
                throw new IllegalArgumentException("Signature out of order in Credential.");
            }
            ArrayList<ByteArrayInputStream> someStreams = new ArrayList<ByteArrayInputStream>(3);
            try {
                byte[] signatureToCompare = PSEUtils.base64Decode(new StringReader(elem.getTextValue()));
                someStreams.add(new ByteArrayInputStream(this.getPeerGroupID().toString().getBytes("UTF-8")));
                someStreams.add(new ByteArrayInputStream(this.getPeerID().toString().getBytes("UTF-8")));
                Iterator<? extends Certificate> eachCert = this.certs.getCertificates().iterator();
                while (eachCert.hasNext()) {
                    X509Certificate aCert = (X509Certificate)eachCert.next();
                    someStreams.add(new ByteArrayInputStream(aCert.getEncoded()));
                }
                SequenceInputStream signStream = new SequenceInputStream(Collections.enumeration(someStreams));
                if (!PSEUtils.verifySignature("SHA1withRSA", this.getCertificate(), signatureToCompare, signStream)) {
                    throw new IllegalArgumentException("Certificated did not match");
                }
            }
            catch (Throwable failed) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to validate signature ", failed);
                }
                throw new IllegalArgumentException("Failed to validate signature " + failed.getMessage());
            }
            return true;
        }
        return false;
    }

    protected void initialize(Element root) {
        String doctype;
        if (!XMLElement.class.isInstance(root)) {
            throw new IllegalArgumentException(this.getClass().getName() + " only supports XMLElement");
        }
        XMLElement doc = (XMLElement)root;
        String typedoctype = "";
        Attribute itsType = doc.getAttribute("type");
        if (null != itsType) {
            typedoctype = itsType.getValue();
        }
        if (!(doctype = doc.getName()).equals("jxta:PSECred") && !typedoctype.equals("jxta:PSECred")) {
            throw new IllegalArgumentException("Could not construct : " + this.getClass().getName() + "from doc containing a " + doctype);
        }
        Enumeration elements = doc.getChildren();
        while (elements.hasMoreElements()) {
            XMLElement elem = (XMLElement)elements.nextElement();
            if (this.handleElement(elem) || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
            LOG.warn((Object)("Unhandled element '" + elem.getName() + "' in " + doc.getName()));
        }
        if (null == this.getSubject()) {
            throw new IllegalArgumentException("subject was never initialized.");
        }
        if (null == this.getPeerGroupID()) {
            throw new IllegalArgumentException("peer group was never initialized.");
        }
        if (null == this.getPeerID()) {
            throw new IllegalArgumentException("peer id was never initialized.");
        }
        if (null == this.certs) {
            throw new IllegalArgumentException("certificates were never initialized.");
        }
    }

    static {
        expirationTimer.schedule((TimerTask)new TimerThreadNamer("PSECredential Expiration Timer"), 0L);
    }
}

