/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import net.jxta.impl.membership.pse.KeyStoreManager;
import net.jxta.impl.membership.pse.PSEConfig;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class FileKeyStoreManager
implements KeyStoreManager {
    private static final transient Logger LOG = Logger.getLogger((String)PSEConfig.class.getName());
    private static final String DEFAULT_KEYSTORE_TYPE = "jks";
    private static final String DEFAULT_KEYSTORE_FILENAME = "jxta_keystore";
    private String keystore_type;
    private String keystore_provider;
    private File keystore_base;
    private File keystore_location;

    public FileKeyStoreManager(String type, String provider, File location) throws NoSuchProviderException, KeyStoreException {
        if (null == type) {
            type = DEFAULT_KEYSTORE_TYPE;
            provider = null;
        }
        if ("pkcs12".equalsIgnoreCase(type)) {
            if ("BC".equals(provider)) {
                provider = null;
            }
            boolean hasJDK15 = System.getProperty("java.specification.version", "0.0").compareTo("1.5") >= 0;
            provider = hasJDK15 ? null : "BC";
            if (location.isDirectory()) {
                location = new File(location, DEFAULT_KEYSTORE_FILENAME);
            }
        } else if ("PSE".equalsIgnoreCase(type) && location.isDirectory()) {
            this.keystore_base = new File(location, "pse");
            location = new File(location, "pse/etc/passwd");
        }
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("pse location = " + location));
        }
        this.keystore_type = type;
        this.keystore_provider = provider;
        this.keystore_location = location;
        if (null == this.keystore_provider) {
            KeyStore.getInstance(this.keystore_type);
        } else {
            KeyStore.getInstance(this.keystore_type, this.keystore_provider);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized(null);
    }

    public boolean isInitialized(char[] store_password) {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(this.keystore_location.toURL().openStream(), store_password);
            return true;
        }
        catch (Exception failed) {
            return false;
        }
    }

    public void createKeyStore(char[] store_password) throws KeyStoreException, IOException {
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(null, store_password);
            this.saveKeyStore(store, store_password);
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public KeyStore loadKeyStore(char[] password) throws KeyStoreException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Loading (" + this.keystore_type + "," + this.keystore_provider + ") store from " + this.keystore_location));
        }
        try {
            KeyStore store = null == this.keystore_provider ? KeyStore.getInstance(this.keystore_type) : KeyStore.getInstance(this.keystore_type, this.keystore_provider);
            store.load(this.keystore_location.toURL().openStream(), password);
            return store;
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (NoSuchProviderException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchProviderException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void saveKeyStore(KeyStore store, char[] password) throws KeyStoreException, IOException {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Writing " + store + " to " + this.keystore_location));
        }
        try {
            FileOutputStream os = new FileOutputStream(this.keystore_location);
            store.store(os, password);
        }
        catch (NoSuchAlgorithmException failed) {
            KeyStoreException failure = new KeyStoreException("NoSuchAlgorithmException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
        catch (CertificateException failed) {
            KeyStoreException failure = new KeyStoreException("CertificateException during keystore processing");
            failure.initCause(failed);
            throw failure;
        }
    }

    public void eraseKeyStore() throws IOException {
        if (null != this.keystore_base) {
            FileKeyStoreManager.removeDir(this.keystore_base);
        } else if (this.keystore_location.isFile() && this.keystore_location.canWrite()) {
            this.keystore_location.delete();
        } else {
            throw new UnsupportedOperationException("Unable to delete");
        }
    }

    private static void removeDir(File aDir) throws IOException {
        File[] list = aDir.listFiles();
        for (int i = 0; list != null && i < list.length; ++i) {
            try {
                if (list[i].isDirectory()) {
                    FileKeyStoreManager.removeDir(list[i]);
                    continue;
                }
                list[i].delete();
                continue;
            }
            catch (IOException badFile) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("problem working with file : " + list[i]), (Throwable)badFile);
            }
        }
        aDir.delete();
    }
}

