/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.membership.pse;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Iterator;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.id.ID;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.membership.pse.StringAuthenticator;
import net.jxta.membership.InteractiveAuthenticator;
import net.jxta.peer.PeerID;
import net.jxta.util.AwtUtils;

public final class DialogAuthenticator
extends StringAuthenticator
implements InteractiveAuthenticator {
    DialogAuthenticator(PSEMembershipService source, AuthenticationCredential application) {
        super(source, application);
        AwtUtils.initAsDaemon();
    }

    DialogAuthenticator(PSEMembershipService source, AuthenticationCredential application, X509Certificate seedCert, EncryptedPrivateKeyInfo seedKey) {
        super(source, application, seedCert, seedKey);
        AwtUtils.initAsDaemon();
    }

    public String getMethodName() {
        return "DialogAuthentication";
    }

    public boolean interact() {
        PasswordDialog p = new PasswordDialog(this.source.group.getPeerID(), this.seedCert, this.seedKey);
        p.showDialog();
        if (p.wasCanceled()) {
            this.setAuth1_KeyStorePassword((char[])null);
            this.setAuth2Identity((ID)null);
            this.setAuth3_IdentityPassword((char[])null);
        } else {
            this.setAuth1_KeyStorePassword(p.getKeyStorePassword());
            this.setAuth2Identity(p.getIdentity());
            this.setAuth3_IdentityPassword(p.getIdentityPassword());
        }
        return !p.wasCanceled();
    }

    private class PasswordDialog
    extends JDialog
    implements ActionListener {
        private boolean initKeyStore;
        private PeerID seedPeer;
        private X509Certificate seedCert;
        private EncryptedPrivateKeyInfo seedKey;
        private JLabel storePassLabel;
        private JPasswordField storePassField;
        private JLabel identityLabel;
        private JComboBox identityList;
        private JLabel identityPassLabel;
        private JPasswordField identityPassField;
        private JButton okButton;
        private JButton cancelButton;
        private boolean canceled;

        PasswordDialog(PeerID seedPeer, X509Certificate seedCert, EncryptedPrivateKeyInfo seedKey) {
            super(JOptionPane.getRootFrame(), null != seedCert ? "Initialize JXTA Keystore" : "JXTA Secure Login", true);
            this.canceled = true;
            this.setDefaultCloseOperation(2);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ PasswordDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent e) {
                    PasswordDialog.access$002(this.this$1, true);
                }
            });
            this.seedPeer = seedPeer;
            this.seedCert = seedCert;
            this.seedKey = seedKey;
            this.initKeyStore = null != seedCert;
            JPanel contentPane = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 1, new Insets(4, 4, 4, 4), 0, 0);
            this.storePassField = new JPasswordField("", 10);
            if (!this.initKeyStore) {
                this.storePassField.addKeyListener(new PasswordDialogKeyHandler());
            }
            if (!this.initKeyStore) {
                this.identityList = new JComboBox();
            } else {
                JComboEntry seedEntry = new JComboEntry(seedPeer, seedCert);
                Object[] names = new Object[]{seedEntry};
                this.identityList = new JComboBox<Object>(names);
                this.identityList.setMaximumRowCount(1);
            }
            this.identityPassField = new JPasswordField("", 10);
            this.identityPassField.addKeyListener(new PasswordDialogKeyHandler());
            this.storePassLabel = new JLabel("Key Store Password");
            this.storePassLabel.setLabelFor(this.storePassField);
            contentPane.add((Component)this.storePassLabel, c);
            c.gridx = 1;
            contentPane.add((Component)this.storePassField, c);
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 21;
            this.identityLabel = new JLabel("Identity");
            this.identityLabel.setLabelFor(this.identityList);
            contentPane.add((Component)this.identityLabel, c);
            c.gridx = 1;
            c.fill = 1;
            contentPane.add((Component)this.identityList, c);
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 0;
            this.identityPassLabel = new JLabel("Identity Password");
            this.identityPassLabel.setLabelFor(this.identityPassField);
            contentPane.add((Component)this.identityPassLabel, c);
            c.gridx = 1;
            contentPane.add((Component)this.identityPassField, c);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            buttonPanel.add(this.okButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            buttonPanel.add(this.cancelButton);
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 2;
            c.anchor = 26;
            c.fill = 3;
            this.cancelButton.addActionListener(this);
            contentPane.add((Component)buttonPanel, c);
            this.setContentPane(contentPane);
        }

        private void setOKState() {
            boolean enableOK = false;
            if (this.initKeyStore) {
                enableOK = null != PSEUtils.pkcs5_Decrypt_pbePrivateKey(this.identityPassField.getPassword(), this.seedCert.getPublicKey().getAlgorithm(), this.seedKey);
                this.storePassLabel.setEnabled(enableOK);
                this.storePassField.setEnabled(enableOK);
            } else {
                boolean enableIdentityList = false;
                PeerID[] roots = DialogAuthenticator.this.getIdentities(this.storePassField.getPassword());
                if (null != roots) {
                    Iterator<PeerID> eachRoot = Arrays.asList(roots).iterator();
                    while (eachRoot.hasNext()) {
                        ID aPeer = eachRoot.next();
                        try {
                            X509Certificate aCert = DialogAuthenticator.this.source.getPSEConfig().getTrustedCertificate(aPeer);
                            JComboEntry anEntry = new JComboEntry(aPeer, aCert);
                            if (!enableIdentityList) {
                                enableIdentityList = true;
                                this.identityList.removeAllItems();
                                this.identityList.setSelectedIndex(-1);
                            }
                            this.identityList.addItem(anEntry);
                            this.identityList.setSelectedIndex(0);
                        }
                        catch (Exception ignore) {}
                    }
                }
                if (enableIdentityList) {
                    this.identityList.setMaximumRowCount(this.identityList.getItemCount());
                } else {
                    this.identityList.removeAllItems();
                    this.identityList.setSelectedIndex(-1);
                    this.identityPassField.setText("");
                }
                this.identityLabel.setEnabled(enableIdentityList);
                this.identityList.setEnabled(enableIdentityList);
                this.identityPassLabel.setEnabled(enableIdentityList);
                this.identityPassField.setEnabled(enableIdentityList);
            }
            if (null != this.getIdentity() && null != this.getKeyStorePassword() && null != this.getIdentityPassword()) {
                DialogAuthenticator.this.setAuth1_KeyStorePassword(this.getKeyStorePassword());
                DialogAuthenticator.this.setAuth2Identity(this.getIdentity());
                DialogAuthenticator.this.setAuth3_IdentityPassword(this.getIdentityPassword());
                enableOK = DialogAuthenticator.this.isReadyForJoin();
            }
            this.okButton.setEnabled(enableOK);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.okButton == e.getSource()) {
                this.canceled = false;
                this.dispose();
            } else if (this.cancelButton == e.getSource()) {
                this.canceled = true;
                this.dispose();
            }
        }

        public void showDialog() {
            this.pack();
            this.setLocationRelativeTo(null);
            this.setOKState();
            this.setVisible(true);
        }

        public char[] getKeyStorePassword() {
            if (!this.storePassField.isEnabled()) {
                return null;
            }
            char[] result = this.storePassField.getPassword();
            return result;
        }

        public ID getIdentity() {
            if (!this.identityList.isEnabled()) {
                return null;
            }
            JComboEntry selectedIdentity = (JComboEntry)this.identityList.getSelectedItem();
            if (null == selectedIdentity) {
                return null;
            }
            return selectedIdentity.itsID;
        }

        public char[] getIdentityPassword() {
            if (!this.identityPassField.isEnabled()) {
                return null;
            }
            char[] result = this.identityPassField.getPassword();
            return result;
        }

        public boolean wasCanceled() {
            return this.canceled;
        }

        static /* synthetic */ boolean access$002(PasswordDialog x0, boolean x1) {
            x0.canceled = x1;
            return x0.canceled;
        }

        private class PasswordDialogKeyHandler
        extends KeyAdapter {
            private PasswordDialogKeyHandler() {
            }

            public void keyReleased(KeyEvent e) {
                PasswordDialog.this.setOKState();
            }
        }
    }

    private static class JComboEntry {
        ID itsID;
        X509Certificate itsCertificate;
        String itsName;

        JComboEntry(ID entryID, X509Certificate itsCert) {
            this.itsID = entryID;
            this.itsCertificate = itsCert;
            this.itsName = PSEUtils.getCertSubjectCName(this.itsCertificate);
            if (null == this.itsName) {
                this.itsName = "< no common name >";
            }
            if (this.itsName.endsWith("-CA")) {
                this.itsName = this.itsName.substring(0, this.itsName.length() - 3);
            }
        }

        public String toString() {
            return this.itsName;
        }
    }
}

