/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.loader;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.impl.peergroup.CompatibilityEquater;
import net.jxta.platform.JxtaLoader;
import net.jxta.platform.ModuleSpecID;
import net.jxta.protocol.ModuleImplAdvertisement;

public class RefJxtaLoader
extends JxtaLoader {
    private CompatibilityEquater equator;
    private Map classes = new HashMap();

    public RefJxtaLoader(URL[] urls, CompatibilityEquater equator) {
        this(urls, RefJxtaLoader.class.getClassLoader(), equator);
    }

    public RefJxtaLoader(URL[] urls, ClassLoader loader, CompatibilityEquater equator) {
        super(urls, loader);
        this.equator = equator;
    }

    protected Class loadClass(String name, URL url, boolean resolve) throws ClassNotFoundException {
        try {
            return this.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            if (url != null) {
                this.addURL(url);
                return this.loadClass(name, resolve);
            }
            throw e;
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> newClass = this.findLoadedClass(name);
        if (newClass == null) {
            try {
                newClass = super.loadClass(name, false);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (newClass == null) {
            try {
                newClass = this.findSystemClass(name);
                if (newClass != null) {
                    return newClass;
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (newClass == null) {
                try {
                    newClass = Thread.currentThread().getContextClassLoader().loadClass(name);
                    if (newClass != null) {
                        return newClass;
                    }
                }
                catch (ClassNotFoundException ez1) {
                    // empty catch block
                }
            }
        }
        if (resolve) {
            this.resolveClass(newClass);
        }
        return newClass;
    }

    public synchronized Class findClass(ModuleSpecID spec) throws ClassNotFoundException {
        Map compats = (Map)this.classes.get(spec);
        if (null == compats) {
            throw new ClassNotFoundException(spec.toString());
        }
        Iterator eachCompat = compats.entrySet().iterator();
        while (eachCompat.hasNext()) {
            StructuredDocument asDoc;
            Map.Entry anEntry = eachCompat.next();
            String aCompat = (String)anEntry.getKey();
            try {
                asDoc = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, new StringReader(aCompat));
            }
            catch (IOException ignored) {
                continue;
            }
            if (!this.equator.compatible(asDoc)) continue;
            return (Class)anEntry.getValue();
        }
        throw new ClassNotFoundException(spec.toString());
    }

    public Class loadClass(ModuleSpecID spec) throws ClassNotFoundException {
        Class found = this.findClass(spec);
        this.resolveClass(found);
        return found;
    }

    public Class loadClass(String name, URL url) throws ClassNotFoundException {
        return this.loadClass(name, url, true);
    }

    public synchronized Class defineClass(ModuleImplAdvertisement impl) throws ClassFormatError {
        Class loaded;
        String asString = impl.getCompat().toString();
        HashMap<String, Class> compats = (HashMap<String, Class>)this.classes.get(impl.getModuleSpecID());
        if (null == compats) {
            compats = new HashMap<String, Class>();
            this.classes.put(impl.getModuleSpecID(), compats);
        }
        if (null == (loaded = (Class)compats.get(asString))) {
            try {
                loaded = this.loadClass(impl.getCode(), new URL(impl.getUri()), false);
            }
            catch (ClassNotFoundException failed) {
                throw new NoClassDefFoundError("Could not locate class '" + impl.getCode() + "' at : " + impl.getUri());
            }
            catch (MalformedURLException failed) {
                throw new ClassFormatError("Cannot load class '" + impl.getCode() + "' from : " + impl.getUri());
            }
            compats.put(asString, loaded);
        }
        return loaded;
    }
}

