/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.binaryID;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import net.jxta.impl.id.binaryID.PeerBinaryID;
import net.jxta.impl.id.binaryID.PeerGroupBinaryID;
import net.jxta.impl.id.binaryID.PipeBinaryID;
import net.jxta.impl.util.BASE64InputStream;
import net.jxta.impl.util.BASE64OutputStream;
import net.jxta.peergroup.PeerGroupID;
import org.apache.log4j.Logger;

public class DigestTool {
    private static final Logger LOG = Logger.getLogger((String)DigestTool.class.getName());
    public static final boolean debug = true;
    public static final String SHAOne = "SHA-1";
    public static final String SHA128 = "SHA-128";
    public static final String SHA256 = "SHA-256";
    public static final String SHA384 = "SHA-384";
    public static final String SHA512 = "SHA-512";
    public final String functionSeperator = "~";
    String algorithmType;

    public DigestTool() {
        this.algorithmType = SHAOne;
    }

    public DigestTool(String algorithmType) {
        this.algorithmType = algorithmType;
    }

    public final PipeBinaryID createPipeID(PeerGroupID peerGroupID, String clearTextID, String function) {
        byte[] digest = this.generateHash(clearTextID, function);
        PipeBinaryID pipe = new PipeBinaryID(peerGroupID, digest, false);
        return pipe;
    }

    public final PeerGroupBinaryID createPeerGroupID(PeerGroupID parentPeerGroupID, String clearTextID, String function) {
        byte[] digest = this.generateHash(clearTextID, function);
        PeerGroupBinaryID peerGroupID = new PeerGroupBinaryID(parentPeerGroupID, digest, false);
        return peerGroupID;
    }

    public final PeerBinaryID createPeerID(PeerGroupID peerGroupID, String clearTextID, String function) {
        byte[] digest = this.generateHash(clearTextID, function);
        PeerBinaryID peerID = new PeerBinaryID(peerGroupID, digest, false);
        return peerID;
    }

    public final String generateHashString(String clearTextID) {
        try {
            StringWriter base64 = new StringWriter();
            BASE64OutputStream encode = new BASE64OutputStream(base64);
            encode.write(this.generateHash(clearTextID));
            encode.close();
            return base64.toString();
        }
        catch (Exception failed) {
            LOG.error((Object)"Unable to encode hash value.", (Throwable)failed);
            throw new RuntimeException("Unable to encode hash value.");
        }
    }

    public final String generateHashString(String clearTextID, String function) {
        try {
            StringWriter base64 = new StringWriter();
            BASE64OutputStream encode = new BASE64OutputStream(base64);
            encode.write(this.generateHash(clearTextID, function));
            encode.close();
            return base64.toString();
        }
        catch (Exception failed) {
            LOG.error((Object)"Unable to encode hash value.", (Throwable)failed);
            throw new RuntimeException("Unable to encode hash value.");
        }
    }

    public final byte[] generateHash(String clearTextID) {
        return this.generateHash(clearTextID, null);
    }

    public final byte[] generateHash(String clearTextID, String function) {
        String id = function == null ? clearTextID : clearTextID + "~" + function;
        byte[] buffer = id.getBytes();
        MessageDigest algorithm = null;
        try {
            algorithm = MessageDigest.getInstance(this.algorithmType);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot load selected Digest Hash implementation", (Throwable)e);
            return null;
        }
        algorithm.reset();
        algorithm.update(buffer);
        try {
            byte[] digest1 = algorithm.digest();
            return digest1;
        }
        catch (Exception de) {
            LOG.error((Object)"Failed to creat a digest.", (Throwable)de);
            return null;
        }
    }

    public final boolean test(String clearTextID, String function, String testHash) {
        String id = clearTextID + "~" + function;
        return this.test(id, testHash);
    }

    public final boolean test(String clearTextID, String testHash) {
        byte[] digest2;
        byte[] digest1 = this.generateHash(clearTextID);
        try {
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BASE64InputStream decoder = new BASE64InputStream(new StringReader(testHash));
            while (-1 != (c = decoder.read())) {
                bos.write(c);
            }
            digest2 = bos.toByteArray();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to create a digest.", (Throwable)e);
            return false;
        }
        if (digest1.length != digest2.length) {
            return false;
        }
        for (int i = 0; i < digest1.length; ++i) {
            if (digest1[i] == digest2[i]) continue;
            return false;
        }
        return true;
    }

    public final boolean test(String clearTextID, byte[] testHash) {
        byte[] digest1 = this.generateHash(clearTextID);
        if (digest1.length != testHash.length) {
            return false;
        }
        for (int i = 0; i < testHash.length; ++i) {
            if (digest1[i] == testHash[i]) continue;
            return false;
        }
        return true;
    }
}

