/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.UUID;

import java.net.URI;
import java.net.URL;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.IDFormat;
import net.jxta.impl.id.UUID.ModuleClassID;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import org.apache.log4j.Logger;

public class ModuleSpecID
extends net.jxta.platform.ModuleSpecID {
    private static final transient Logger LOG = Logger.getLogger((String)ModuleSpecID.class.getName());
    private static final int moduleClassIdOffset = 0;
    private static final int moduleSpecIdOffset = 16;
    private static final int padOffset = 32;
    private static final int padSize = 31;
    protected IDBytes id;

    protected ModuleSpecID() {
        this.id = new IDBytes();
        this.id.bytes[63] = 6;
    }

    protected ModuleSpecID(IDBytes id) {
        this.id = id;
    }

    protected ModuleSpecID(UUID classUUID, UUID specUUID) {
        this();
        this.id.longIntoBytes(0, classUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, classUUID.getLeastSignificantBits());
        this.id.longIntoBytes(16, specUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, specUUID.getLeastSignificantBits());
    }

    public ModuleSpecID(ModuleClassID classID) {
        this(classID.getClassUUID(), UUIDFactory.newUUID());
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof ModuleSpecID) {
            ModuleSpecID msidTarget = (ModuleSpecID)target;
            if (!this.getIDFormat().equals(msidTarget.getIDFormat())) {
                return false;
            }
            if (this.id == msidTarget.id) {
                return true;
            }
            boolean result = this.id.equals(msidTarget.id);
            if (result) {
                msidTarget.id = this.id;
            }
            return result;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public Object getUniqueValue() {
        return this.getIDFormat() + "-" + (String)this.id.getUniqueValue();
    }

    public URL getURL() {
        return IDFormat.getURL((String)this.getUniqueValue());
    }

    public net.jxta.platform.ModuleClassID getBaseClass() {
        return new ModuleClassID(this.getClassUUID(), new UUID(0L, 0L));
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleClassID classId) {
        return this.getClassUUID().equals(((ModuleClassID)classId).getClassUUID());
    }

    public boolean isOfSameBaseClass(net.jxta.platform.ModuleSpecID specId) {
        return this.getClassUUID().equals(((ModuleSpecID)specId).getClassUUID());
    }

    protected UUID getClassUUID() {
        UUID result = new UUID(this.id.bytesIntoLong(0), this.id.bytesIntoLong(8));
        return result;
    }

    protected UUID getSpecUUID() {
        UUID result = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        return result;
    }

    public URI toURI() {
        return IDFormat.toURI((String)this.getUniqueValue());
    }
}

