/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.id.CBID;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import net.jxta.impl.id.CBID.IDFormat;
import net.jxta.impl.id.UUID.IDBytes;
import net.jxta.impl.id.UUID.UUID;
import net.jxta.impl.id.UUID.UUIDFactory;
import org.apache.log4j.Logger;

public class PeerGroupID
extends net.jxta.impl.id.UUID.PeerGroupID {
    private static final transient Logger LOG = Logger.getLogger((String)PeerGroupID.class.getName());

    protected PeerGroupID(IDBytes id) {
        super(id);
    }

    protected PeerGroupID(UUID groupUUID) {
        super(groupUUID);
    }

    public PeerGroupID() {
        this(UUIDFactory.newUUID());
    }

    public PeerGroupID(byte[] seed) {
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException caught) {
            digester = null;
        }
        if (digester == null) {
            throw new ProviderException("SHA1 digest algorithm not found");
        }
        byte[] digest = digester.digest(seed);
        byte[] buf16 = new byte[16];
        System.arraycopy(digest, 0, buf16, 0, 16);
        UUID groupUUID = UUIDFactory.newUUID(buf16);
        this.id.longIntoBytes(0, groupUUID.getMostSignificantBits());
        this.id.longIntoBytes(8, groupUUID.getLeastSignificantBits());
    }

    public PeerGroupID(PeerGroupID parent, byte[] seed) {
        this(seed);
        UUID parentUUID = parent.getUUID();
        this.id.longIntoBytes(16, parentUUID.getMostSignificantBits());
        this.id.longIntoBytes(24, parentUUID.getLeastSignificantBits());
    }

    public String getIDFormat() {
        return IDFormat.INSTANTIATOR.getSupportedIDFormat();
    }

    public net.jxta.peergroup.PeerGroupID getParentPeerGroupID() {
        UUID parentUUID = new UUID(this.id.bytesIntoLong(16), this.id.bytesIntoLong(24));
        if (0L == parentUUID.getMostSignificantBits() && 0L == parentUUID.getLeastSignificantBits()) {
            return null;
        }
        PeerGroupID groupID = new PeerGroupID(parentUUID);
        return (net.jxta.peergroup.PeerGroupID)IDFormat.translateToWellKnown(groupID);
    }

    public UUID getUUID() {
        return super.getUUID();
    }
}

