/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.security.auth.x500.X500Principal;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.Messenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.impl.endpoint.LoopbackMessenger;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsManager;
import net.jxta.impl.endpoint.tls.TlsMessenger;
import net.jxta.impl.membership.pse.PSECredential;
import net.jxta.impl.membership.pse.PSEMembershipService;
import net.jxta.impl.membership.pse.PSEUtils;
import net.jxta.impl.membership.pse.StringAuthenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.platform.Module;
import net.jxta.protocol.ModuleImplAdvertisement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TlsTransport
implements Module,
MessageSender,
MessageReceiver {
    private static final Logger LOG = Logger.getLogger((String)TlsTransport.class.getName());
    static final boolean ACT_AS_SERVER = true;
    private PeerGroup group = null;
    ID assignedID = null;
    EndpointService endpoint = null;
    PSEMembershipService membership = null;
    private membershipPCL membershipListener = null;
    X509Certificate[] serviceCert = null;
    PSECredential credential = null;
    private credentialPCL credentialListener = null;
    EndpointAddress localPeerAddr = null;
    EndpointAddress localTlsPeerAddr = null;
    PeerID localPeerId = null;
    long MIN_IDLE_RECONNECT = 60000L;
    long CONNECTION_IDLE_TIMEOUT = 300000L;
    long RETRMAXAGE = 120000L;
    private TlsManager manager = null;
    ThreadGroup myThreadGroup = null;

    public TlsTransport() {
        try {
            long override_long;
            String override_str;
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.idletimeout");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.CONNECTION_IDLE_TIMEOUT = override_long * 60000L;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Adjusting TLS connection idle timeout to " + this.CONNECTION_IDLE_TIMEOUT + " millis."));
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.minidlereconnect");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.MIN_IDLE_RECONNECT = override_long * 60000L;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Adjusting TLS min reconnection idle to " + this.MIN_IDLE_RECONNECT + " millis."));
                    }
                }
            }
            catch (NumberFormatException badvalue) {
                // empty catch block
            }
            try {
                override_str = jxtaRsrcs.getString("impl.endpoint.tls.connection.maxretryage");
                if (null != override_str && (override_long = Long.parseLong(override_str.trim())) >= 1L) {
                    this.RETRMAXAGE = override_long * 60000L;
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Adjusting TLS maximum retry queue age to " + this.RETRMAXAGE + " millis."));
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.MIN_IDLE_RECONNECT = Math.min(this.MIN_IDLE_RECONNECT, this.CONNECTION_IDLE_TIMEOUT);
            this.RETRMAXAGE = Math.min(this.RETRMAXAGE, this.CONNECTION_IDLE_TIMEOUT);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (null == target) {
            return false;
        }
        if (target instanceof TlsTransport) {
            TlsTransport likeMe = (TlsTransport)target;
            if (!this.getProtocolName().equals(likeMe.getProtocolName())) {
                return false;
            }
            return this.localTlsPeerAddr.equals(likeMe.localTlsPeerAddr);
        }
        return false;
    }

    PeerGroup getPeerGroup() {
        return this.group;
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        this.group = group;
        this.assignedID = assignedID;
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = TlsTransport.mkAddress(group.getPeerID(), null, null);
        this.localTlsPeerAddr = new EndpointAddress(JTlsDefs.tlsPName, this.localPeerId.getUniqueValue().toString(), null, null);
        ModuleImplAdvertisement implAdvertisement = (ModuleImplAdvertisement)impl;
        this.myThreadGroup = new ThreadGroup(group.getHomeThreadGroup(), "TLSTransport " + this.localTlsPeerAddr);
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring TLS Transport : " + assignedID);
            configInfo.append("\n\tImplementation:");
            configInfo.append("\n\t\tModule Spec ID: " + implAdvertisement.getModuleSpecID());
            configInfo.append("\n\t\tImpl Description : " + implAdvertisement.getDescription());
            configInfo.append("\n\t\tImpl URI : " + implAdvertisement.getUri());
            configInfo.append("\n\t\tImpl Code : " + implAdvertisement.getCode());
            configInfo.append("\n\tGroup Params:");
            configInfo.append("\n\t\tGroup: " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID: " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID: " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            configInfo.append("\n\t\tProtocol: " + JTlsDefs.tlsPName);
            configInfo.append("\n\t\tOutgoing Connections Enabled: " + Boolean.TRUE);
            configInfo.append("\n\t\tIncoming Connections Enabled: true");
            configInfo.append("\n\t\tMinimum idle for reconnect : " + this.MIN_IDLE_RECONNECT + " millis");
            configInfo.append("\n\t\tConnection idle timeout : " + this.CONNECTION_IDLE_TIMEOUT + " millis");
            configInfo.append("\n\t\tRetry queue maximum age : " + this.RETRMAXAGE + " millis");
            configInfo.append("\n\t\tPeerID : " + this.localPeerId);
            configInfo.append("\n\t\tRoute through : " + this.localPeerAddr);
            configInfo.append("\n\t\tPublic Address : " + this.localTlsPeerAddr);
            LOG.info((Object)configInfo);
        }
    }

    public synchronized int startApp(String[] args) {
        this.endpoint = this.group.getEndpointService();
        if (this.endpoint.addMessageTransport(this) == null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Transport registration refused");
            }
            return -1;
        }
        MembershipService groupMembership = this.group.getMembershipService();
        if (null == groupMembership) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Stalled until there is a membership service");
            }
            return 2;
        }
        if (!(groupMembership instanceof PSEMembershipService)) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"TLS Transport requires PSE Membership Service");
            }
            return -1;
        }
        this.membership = (PSEMembershipService)groupMembership;
        membershipPCL mpcl = new membershipPCL();
        this.membership.addPropertyChangeListener(mpcl);
        try {
            this.serviceCert = this.membership.getPSEConfig().getTrustedCertificateChain(this.assignedID);
            Enumeration eachCred = this.membership.getCurrentCredentials();
            while (eachCred.hasMoreElements()) {
                PSECredential aCred = (PSECredential)eachCred.nextElement();
                mpcl.propertyChange(new PropertyChangeEvent(this.membership, "addCredential", null, aCred));
            }
        }
        catch (IOException failed) {
            this.serviceCert = null;
        }
        catch (KeyStoreException failed) {
            this.serviceCert = null;
        }
        this.manager = new TlsManager(this);
        try {
            this.endpoint.addIncomingMessageListener(this.manager, "TlsTransport", null);
        }
        catch (Throwable e2) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"TLS could not register listener...as good as dead", e2);
            }
            return -1;
        }
        return 0;
    }

    public void stopApp() {
        this.endpoint.removeIncomingMessageListener("TlsTransport", null);
        this.endpoint.removeMessageTransport(this);
        this.manager.close();
        this.manager = null;
        this.membership.removePropertyChangeListener(this.membershipListener);
        this.membershipListener = null;
        this.membership = null;
        PSECredential temp = this.credential;
        this.credential = null;
        if (null != temp) {
            temp.removePropertyChangeListener(this.credentialListener);
            this.credentialListener = null;
        }
    }

    public boolean isConnectionOriented() {
        return false;
    }

    public boolean allowsRouting() {
        return false;
    }

    public Object transportControl(Object operation, Object Value2) {
        return null;
    }

    public EndpointAddress getPublicAddress() {
        return (EndpointAddress)this.localTlsPeerAddr.clone();
    }

    public EndpointService getEndpointService() {
        return this.endpoint;
    }

    public Iterator getPublicAddresses() {
        return Collections.singletonList(this.getPublicAddress()).iterator();
    }

    public String getProtocolName() {
        return JTlsDefs.tlsPName;
    }

    public boolean isPropagateEnabled() {
        return false;
    }

    public boolean isPropagationSupported() {
        return false;
    }

    public void propagate(Message srcMsg, String pName, String pParam, String prunePeer) throws IOException {
    }

    public boolean ping(EndpointAddress addr) {
        return null != this.getMessenger(addr, null);
    }

    public Messenger getMessenger(EndpointAddress addr, Object hintIgnored) {
        EndpointAddress plainAddress;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("getMessenger for " + addr));
        }
        if ((plainAddress = new EndpointAddress(addr, null, null)).equals(this.localTlsPeerAddr)) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"returning LoopbackMessenger");
            }
            return new TlsLoopbackMessenger(this.endpoint, plainAddress, addr, this.localPeerAddr);
        }
        EndpointAddress dstPAddr = TlsTransport.mkAddress("urn:jxta:" + addr.getProtocolAddress(), null, null);
        TlsConn conn = this.manager.getTlsConn(dstPAddr);
        if (conn == null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)("Cannot get a TLS connection for " + dstPAddr));
            }
            return null;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)"TlsMessanger with TlsConn DONE");
        }
        return new TlsMessenger(addr, conn, this);
    }

    void processReceivedMessage(Message msg) {
        block3: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"processReceivedMessage starts");
            }
            msg.setMessageProperty(TlsTransport.class, this);
            try {
                this.endpoint.demux(msg);
            }
            catch (Throwable e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Failure demuxing an incoming message", e);
            }
        }
    }

    private static final EndpointAddress mkAddress(String destPeer, String serv, String parm) {
        ID asID = null;
        try {
            asID = IDFactory.fromURI(new URI(destPeer));
        }
        catch (URISyntaxException caught) {
            throw new IllegalArgumentException(caught.getMessage());
        }
        return TlsTransport.mkAddress(asID, serv, parm);
    }

    private static final EndpointAddress mkAddress(ID destPeer, String serv, String parm) {
        EndpointAddress addr = new EndpointAddress("jxta", destPeer.getUniqueValue().toString(), serv, parm);
        return addr;
    }

    class membershipPCL
    implements PropertyChangeListener {
        membershipPCL() {
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            Object passkey;
            ByteArrayInputStream bis;
            X500Principal credSubjectDN;
            Exception failure;
            String evtProp = evt.getPropertyName();
            PSECredential cred = (PSECredential)evt.getNewValue();
            if ("addCredential".equals(evtProp) && null == TlsTransport.this.serviceCert) {
                failure = null;
                try {
                    X509Certificate peerCert = TlsTransport.this.membership.getPSEConfig().getTrustedCertificate(TlsTransport.this.group.getPeerID());
                    credSubjectDN = cred.getCertificate().getSubjectX500Principal();
                    X500Principal peerCertSubjectDN = peerCert.getSubjectX500Principal();
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Checking credential cert for match to peer cert\n\tcred subject=" + credSubjectDN + "\n\tpeer subject=" + peerCertSubjectDN));
                    }
                    if (peerCertSubjectDN.equals(credSubjectDN)) {
                        PrivateKey credKey = cred.getPrivateKey();
                        bis = new ByteArrayInputStream(credKey.getEncoded());
                        passkey = PSEUtils.base64Encode(PSEUtils.computeSignature("SHA1withRSA", credKey, bis));
                        PSEUtils.IssuerInfo info = new PSEUtils.IssuerInfo();
                        info.cert = cred.getCertificate();
                        info.subjectPkey = cred.getPrivateKey();
                        String cname = PSEUtils.getCertSubjectCName(info.cert);
                        if (null != cname && cname.endsWith("-CA")) {
                            cname = cname.substring(0, cname.length() - 3);
                        }
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Generating new service cert for '" + cname + "'"));
                        }
                        PSEUtils.IssuerInfo serviceinfo = PSEUtils.genCert(cname, info);
                        Certificate[] serviceChain = new X509Certificate[]{serviceinfo.cert, serviceinfo.issuer};
                        TlsTransport.this.membership.getPSEConfig().setKey(TlsTransport.this.assignedID, serviceChain, serviceinfo.subjectPkey, ((String)passkey).toCharArray());
                        TlsTransport.this.serviceCert = serviceChain;
                    }
                }
                catch (IOException failed) {
                    failure = failed;
                }
                catch (KeyStoreException failed) {
                    failure = failed;
                }
                catch (InvalidKeyException failed) {
                    failure = failed;
                }
                catch (SignatureException failed) {
                    failure = failed;
                }
                if (null != failure) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Failure building service certificate", (Throwable)failure);
                    }
                    return;
                }
            }
            if ("addCredential".equals(evtProp)) {
                block27: {
                    failure = null;
                    try {
                        X509Certificate credCert = cred.getCertificate();
                        credSubjectDN = credCert.getSubjectX500Principal();
                        X500Principal serviceIssuerDN = TlsTransport.this.serviceCert[0].getIssuerX500Principal();
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Checking credential cert for match to service issuer cert\n\tcred subject=" + credSubjectDN + "\n\t  svc issuer=" + serviceIssuerDN));
                        }
                        if (!credSubjectDN.equals(serviceIssuerDN)) break block27;
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)"Setting credential/certfile ");
                        }
                        PrivateKey peerCredKey = cred.getPrivateKey();
                        bis = new ByteArrayInputStream(peerCredKey.getEncoded());
                        passkey = PSEUtils.base64Encode(PSEUtils.computeSignature("SHA1withRSA", peerCredKey, bis)).toCharArray();
                        AuthenticationCredential authCred = new AuthenticationCredential(TlsTransport.this.group, "StringAuthentication", null);
                        StringAuthenticator auth = null;
                        try {
                            auth = (StringAuthenticator)TlsTransport.this.membership.apply(authCred);
                        }
                        catch (Exception failed) {
                            // empty catch block
                        }
                        if (null != auth) {
                            auth.setAuth1_KeyStorePassword((String)null);
                            auth.setAuth2Identity(TlsTransport.this.assignedID);
                            auth.setAuth3_IdentityPassword((char[])passkey);
                            if (auth.isReadyForJoin()) {
                                TlsTransport.this.credential = (PSECredential)TlsTransport.this.membership.join(auth);
                            } else {
                                LOG.error((Object)"Could not authenticate service certificate");
                            }
                        }
                        TlsTransport.this.credentialListener = new credentialPCL();
                        TlsTransport.this.credential.addPropertyChangeListener(TlsTransport.this.credentialListener);
                    }
                    catch (IOException failed) {
                        failure = failed;
                    }
                    catch (PeerGroupException failed) {
                        failure = failed;
                    }
                    catch (InvalidKeyException failed) {
                        failure = failed;
                    }
                    catch (SignatureException failed) {
                        failure = failed;
                    }
                }
                if (null != failure) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Failure building service credential", (Throwable)failure);
                    }
                    return;
                }
            }
        }
    }

    class credentialPCL
    implements PropertyChangeListener {
        credentialPCL() {
        }

        public synchronized void propertyChange(PropertyChangeEvent evt) {
            if (TlsTransport.this.credential == evt.getSource() && !TlsTransport.this.credential.isValid()) {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Clearing credential/certfile ");
                }
                TlsTransport.this.credential.removePropertyChangeListener(this);
                TlsTransport.this.credential = null;
            }
        }
    }

    class TlsLoopbackMessenger
    extends LoopbackMessenger {
        TlsLoopbackMessenger(EndpointService ep, EndpointAddress src, EndpointAddress dest, EndpointAddress logicalDest) {
            super(ep, src, dest, logicalDest);
        }

        public boolean sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
            message.setMessageProperty(class$net$jxta$impl$endpoint$tls$TlsTransport == null ? (class$net$jxta$impl$endpoint$tls$TlsTransport = TlsTransport.class$("net.jxta.impl.endpoint.tls.TlsTransport")) : class$net$jxta$impl$endpoint$tls$TlsTransport, TlsTransport.this);
            return super.sendMessageBImpl(message, service, serviceParam);
        }
    }
}

