/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tls;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.tls.JTlsDefs;
import net.jxta.impl.endpoint.tls.TlsConn;
import net.jxta.impl.endpoint.tls.TlsSocket;
import net.jxta.impl.endpoint.tls.TlsTransport;
import net.jxta.impl.util.TimeUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class TlsManager
implements EndpointListener {
    private static final transient Logger LOG = Logger.getLogger((String)TlsManager.class.getName());
    private TlsTransport transport = null;
    private Map connections = new HashMap();

    TlsManager(TlsTransport tp) {
        this.transport = tp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Shutting down all connections");
        }
        Map map = this.connections;
        synchronized (map) {
            Iterator eachConnection = this.connections.values().iterator();
            while (eachConnection.hasNext()) {
                block7: {
                    TlsConn aConnection = (TlsConn)eachConnection.next();
                    try {
                        aConnection.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                    }
                    catch (IOException ignored) {
                        if (!LOG.isEnabledFor((Priority)Level.INFO)) break block7;
                        LOG.info((Object)("Non-fatal problem shutting down connection to " + aConnection));
                    }
                }
                eachConnection.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TlsConn getTlsConn(EndpointAddress dstAddr) {
        if (null == this.transport.credential) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Not authenticated. Cannot open connections.");
            }
            return null;
        }
        boolean startHandshake = false;
        String paddr = dstAddr.getProtocolAddress();
        TlsConn conn = null;
        Object object = this.connections;
        synchronized (object) {
            conn = (TlsConn)this.connections.get(paddr);
            if (null != conn && (TlsConn.HandshakeState.CONNECTIONDEAD == conn.getHandshakeState() || TlsConn.HandshakeState.HANDSHAKEFAILED == conn.getHandshakeState())) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Removing connection for: " + paddr));
                }
                this.connections.remove(paddr);
                conn = null;
            }
            if (null == conn) {
                try {
                    conn = new TlsConn(this.transport, dstAddr, true);
                }
                catch (Exception failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Failed making connection to " + paddr), (Throwable)failed);
                    }
                    return null;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Adding connection for: " + paddr));
                }
                this.connections.put(paddr, conn);
                startHandshake = true;
            }
        }
        if (startHandshake) {
            try {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Start of client handshake for " + paddr));
                }
                conn.finishHandshake();
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Failed making connection to " + paddr), e);
                }
                Map failed = this.connections;
                synchronized (failed) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing connection for: " + paddr));
                    }
                    this.connections.remove(paddr);
                }
                try {
                    conn.close(TlsConn.HandshakeState.HANDSHAKEFAILED);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return null;
            }
        }
        while (true) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("getting " + conn));
            }
            object = conn;
            synchronized (object) {
                TlsConn.HandshakeState currentState = conn.getHandshakeState();
                if (TlsConn.HandshakeState.SERVERSTART == currentState || TlsConn.HandshakeState.CLIENTSTART == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Sleeping until handshake starts for " + paddr));
                    }
                    try {
                        conn.wait(1000L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                    continue;
                }
                if (TlsConn.HandshakeState.HANDSHAKESTARTED == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Handshake in progress for " + paddr));
                    }
                    try {
                        conn.wait(200L);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                    }
                    continue;
                }
                if (TlsConn.HandshakeState.HANDSHAKEFINISHED == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)("Returning active connection to " + paddr));
                    }
                    conn.lastAccessed = TimeUtils.timeNow();
                    return conn;
                }
                if (TlsConn.HandshakeState.HANDSHAKEFAILED == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Handshake failed. " + paddr + " unreachable"));
                    }
                    return null;
                }
                if (TlsConn.HandshakeState.CONNECTIONDEAD == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Connection dead for " + paddr));
                    }
                    return null;
                }
                if (TlsConn.HandshakeState.CONNECTIONCLOSING == currentState) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Connection closing for " + paddr));
                    }
                    return null;
                }
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Unhandled Handshake state: " + currentState));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processIncomingMessage(Message msg, EndpointAddress srcAddr, EndpointAddress dstAddr) {
        TlsSocket bound;
        boolean retrans;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Starts for " + msg));
        }
        if (null == this.transport.credential) {
            return;
        }
        MessageElement retryElement = msg.getMessageElement("jxtatls", "MARKRetr");
        boolean bl = retrans = null != retryElement;
        if (retrans) {
            msg.removeMessageElement(retryElement);
            retryElement = null;
        }
        int seqN = TlsManager.getMsgSequenceNumber(msg);
        String paddr = srcAddr.getProtocolAddress();
        TlsConn conn = null;
        boolean serverStart = false;
        Map map = this.connections;
        synchronized (map) {
            conn = (TlsConn)this.connections.get(paddr);
            if (null != conn) {
                if (1 == seqN) {
                    TlsConn tlsConn = conn;
                    synchronized (tlsConn) {
                        long idle = TimeUtils.toRelativeTimeMillis(TimeUtils.timeNow(), conn.lastAccessed);
                        if (idle > this.transport.MIN_IDLE_RECONNECT) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)("Restarting : " + conn + " which has been idle for " + idle + " millis"));
                            }
                            try {
                                conn.close(TlsConn.HandshakeState.CONNECTIONDEAD);
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (TlsConn.HandshakeState.CONNECTIONDEAD == conn.getHandshakeState() || TlsConn.HandshakeState.HANDSHAKEFAILED == conn.getHandshakeState()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing connection for: " + paddr));
                    }
                    this.connections.remove(paddr);
                    conn = null;
                }
            }
            if (null == conn) {
                if (1 == seqN) {
                    try {
                        conn = new TlsConn(this.transport, srcAddr, false);
                    }
                    catch (Exception failed) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)("Failed making connection for" + paddr), (Throwable)failed);
                        }
                        return;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Adding connection for: " + paddr));
                    }
                    this.connections.put(paddr, conn);
                    serverStart = true;
                } else {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)(msg + " is not start of handshake (seqn#" + seqN + ") for " + paddr));
                    }
                    msg.clear();
                    return;
                }
            }
        }
        if (serverStart) {
            try {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Start of SERVER handshake for " + paddr));
                }
                conn.tlsSocket.input.queueIncomingMessage(msg);
                conn.finishHandshake();
                conn.lastAccessed = TimeUtils.timeNow();
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Handshake complete for SERVER TLS for: " + paddr));
                }
                return;
            }
            catch (Throwable e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("TLS Handshake failure for connection: " + paddr), e);
                }
                Map failed = this.connections;
                synchronized (failed) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing connection for: " + paddr));
                    }
                    this.connections.remove(paddr);
                }
                try {
                    conn.close(TlsConn.HandshakeState.HANDSHAKEFAILED);
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                return;
            }
        }
        while (true) {
            TlsConn.HandshakeState currentState;
            TlsConn ignored = conn;
            synchronized (ignored) {
                if (retrans) {
                    ++conn.retrans;
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("retrans received, " + conn.retrans + " total."));
                    }
                    retrans = false;
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Process incoming message for " + conn));
                }
                if (TlsConn.HandshakeState.HANDSHAKESTARTED != (currentState = conn.getHandshakeState()) && TlsConn.HandshakeState.HANDSHAKEFINISHED != currentState && TlsConn.HandshakeState.CONNECTIONCLOSING != currentState) {
                    if (TlsConn.HandshakeState.CONNECTIONDEAD == currentState) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("Connection failed, discarding msg with seqn#" + seqN + " for " + paddr));
                        }
                        return;
                    }
                    if (TlsConn.HandshakeState.SERVERSTART == currentState || TlsConn.HandshakeState.CLIENTSTART == currentState) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Sleeping msg with seqn#" + seqN + " until handshake starts for " + paddr));
                        }
                        try {
                            conn.wait(60000L);
                        }
                        catch (InterruptedException woken) {
                            Thread.interrupted();
                        }
                        continue;
                    }
                    if (TlsConn.HandshakeState.HANDSHAKEFAILED == currentState) {
                        if (LOG.isEnabledFor((Priority)Level.INFO)) {
                            LOG.info((Object)("Handshake failed, discarding msg with seqn#" + seqN + " for " + paddr));
                        }
                        return;
                    }
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("Unexpected state : " + currentState));
                    }
                }
            }
            if (TlsConn.HandshakeState.HANDSHAKESTARTED == currentState || TlsConn.HandshakeState.HANDSHAKEFINISHED == currentState || TlsConn.HandshakeState.CONNECTIONCLOSING == currentState) break;
        }
        Message.ElementIterator eachACK = msg.getMessageElements("jxtatls", JTlsDefs.ACKS);
        while (eachACK.hasNext()) {
            MessageElement elt = (MessageElement)eachACK.next();
            eachACK.remove();
            int sackCount = (int)elt.getByteLength() / 4 - 1;
            try {
                DataInputStream dis = new DataInputStream(elt.getStream());
                int seqack = dis.readInt();
                int[] sacs = new int[sackCount];
                for (int eachSac = 0; eachSac < sackCount; ++eachSac) {
                    sacs[eachSac] = dis.readInt();
                }
                Arrays.sort(sacs);
                conn.tlsSocket.output.ackReceived(seqack, sacs);
            }
            catch (IOException failed) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"Failure processing ACK", (Throwable)failed);
            }
        }
        if (0 == seqN) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Queue " + msg + " seqn#" + seqN + " for " + conn));
        }
        if (null != (bound = conn.tlsSocket)) {
            bound.input.queueIncomingMessage(msg);
        }
    }

    private static int getMsgSequenceNumber(Message msg) {
        int seqN = 0;
        Message.ElementIterator eachElement = msg.getMessageElements("jxtatls", JTlsDefs.BLOCKS);
        while (eachElement.hasNext()) {
            MessageElement elt = (MessageElement)eachElement.next();
            try {
                seqN = Integer.parseInt(elt.getElementName());
                break;
            }
            catch (NumberFormatException e) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Bad tls record name=" + elt.getElementName()));
                }
                eachElement.remove();
            }
        }
        return seqN;
    }
}

