/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.tcp;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.impl.endpoint.IPUtils;
import net.jxta.impl.endpoint.tcp.TcpConnection;
import net.jxta.impl.endpoint.tcp.TcpMessenger;
import net.jxta.impl.endpoint.tcp.TcpTransport;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class IncomingUnicastServer
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)IncomingUnicastServer.class.getName());
    private final TcpTransport owner;
    private final InetAddress serverBindLocalInterface;
    private final int serverBindStartLocalPort;
    private int serverBindPreferedLocalPort;
    private final int serverBindEndLocalPort;
    private ServerSocket serverSocket;
    private volatile boolean closed = false;
    private Thread acceptThread = null;

    public IncomingUnicastServer(TcpTransport owner, InetAddress serverInterface, int preferedPort, int startPort, int endPort) throws IOException, SecurityException {
        this.owner = owner;
        this.serverBindLocalInterface = serverInterface;
        this.serverBindPreferedLocalPort = preferedPort;
        this.serverBindStartLocalPort = startPort;
        this.serverBindEndLocalPort = endPort;
        this.openServerSocket();
    }

    public synchronized boolean start(ThreadGroup inGroup) {
        if (this.acceptThread != null) {
            return false;
        }
        this.acceptThread = new Thread(inGroup, this, "TCP Unicast Server Connection Listener");
        this.acceptThread.setDaemon(true);
        this.acceptThread.start();
        return true;
    }

    public synchronized void stop() {
        this.closed = true;
        Thread temp = this.acceptThread;
        if (null != temp) {
            temp.interrupt();
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized InetSocketAddress getLocalSocketAddress() {
        ServerSocket localSocket = this.serverSocket;
        if (null != localSocket) {
            return (InetSocketAddress)localSocket.getLocalSocketAddress();
        }
        return null;
    }

    int getStartPort() {
        return this.serverBindStartLocalPort;
    }

    int getEndPort() {
        return this.serverBindEndLocalPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block46: {
            IncomingUnicastServer incomingUnicastServer;
            try {
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Server is ready to accept connections");
                }
                while (!this.closed) {
                    Socket inputSocket;
                    try {
                        if (null == this.serverSocket || this.serverSocket.isClosed()) {
                            this.openServerSocket();
                            if (null == this.serverSocket) break;
                        }
                        inputSocket = this.serverSocket.accept();
                        if (this.closed) {
                            break;
                        }
                    }
                    catch (InterruptedIOException woken) {
                        continue;
                    }
                    catch (IOException e1) {
                        if (this.closed) break;
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)("[1] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort()), (Throwable)e1);
                        continue;
                    }
                    catch (SecurityException e2) {
                        if (this.closed) break;
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)("[2] ServerSocket.accept() failed on " + this.serverSocket.getInetAddress() + ":" + this.serverSocket.getLocalPort()), (Throwable)e2);
                        continue;
                    }
                    try {
                        TcpMessenger newMessenger;
                        block40: {
                            TcpConnection newConnect = new TcpConnection(inputSocket, this.owner);
                            if (!newConnect.isConnected()) continue;
                            newMessenger = new TcpMessenger(newConnect.getDestinationAddress(), newConnect, this.owner);
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Registering connection from " + inputSocket.getInetAddress().getHostAddress() + ":" + inputSocket.getPort()));
                            }
                            try {
                                MessengerEvent event = new MessengerEvent(this.owner, newMessenger, newConnect.getConnectionAddress());
                                this.owner.messengerReadyEvent(newMessenger, newConnect.getConnectionAddress());
                            }
                            catch (Throwable all) {
                                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block40;
                                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                            }
                        }
                        newMessenger.start();
                    }
                    catch (OutOfMemoryError oom) {
                        try {
                            Thread.sleep(2000L);
                            inputSocket.close();
                        }
                        catch (Throwable any) {
                        }
                    }
                    catch (Throwable all) {
                        block41: {
                            try {
                                inputSocket.close();
                            }
                            catch (Throwable any) {
                                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block41;
                                LOG.error((Object)"Failed to close dead socket", any);
                            }
                        }
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)"Failed to create connection", all);
                    }
                }
                Object var6_14 = null;
                incomingUnicastServer = this;
            }
            catch (Throwable throwable) {
                Object var6_16 = null;
                IncomingUnicastServer incomingUnicastServer2 = this;
                synchronized (incomingUnicastServer2) {
                    this.closed = true;
                    ServerSocket temp = this.serverSocket;
                    this.serverSocket = null;
                    if (null != temp) {
                        try {
                            temp.close();
                        }
                        catch (IOException ignored) {
                            // empty catch block
                        }
                    }
                    this.acceptThread = null;
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)"Server has been shut down.");
                }
                throw throwable;
            }
            synchronized (incomingUnicastServer) {
                this.closed = true;
                ServerSocket temp = this.serverSocket;
                this.serverSocket = null;
                if (null != temp) {
                    try {
                        temp.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                this.acceptThread = null;
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)"Server has been shut down.");
            }
            break block46;
            {
                catch (Throwable all) {
                    if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                        LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                    }
                    Object var6_15 = null;
                    IncomingUnicastServer incomingUnicastServer3 = this;
                    synchronized (incomingUnicastServer3) {
                        this.closed = true;
                        ServerSocket temp = this.serverSocket;
                        this.serverSocket = null;
                        if (null != temp) {
                            try {
                                temp.close();
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                        this.acceptThread = null;
                    }
                    if (LOG.isEnabledFor((Priority)Level.INFO)) {
                        LOG.info((Object)"Server has been shut down.");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openServerSocket() throws IOException, SecurityException {
        this.serverSocket = null;
        while (true) {
            try {
                IncomingUnicastServer incomingUnicastServer = this;
                synchronized (incomingUnicastServer) {
                    this.serverSocket = -1 != this.serverBindPreferedLocalPort ? new ServerSocket(this.serverBindPreferedLocalPort, 50, this.serverBindLocalInterface) : IPUtils.openServerSocketInRange(this.serverBindStartLocalPort, this.serverBindEndLocalPort, 50, this.serverBindLocalInterface);
                }
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Server will accept connections at " + this.serverSocket.getLocalSocketAddress()));
                }
                return;
            }
            catch (BindException e0) {
                if (-1 != this.serverBindStartLocalPort) {
                    this.serverBindPreferedLocalPort = 0 == this.serverBindStartLocalPort ? 0 : -1;
                    continue;
                }
                this.closed = true;
                if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                    LOG.fatal((Object)("Cannot bind ServerSocket on " + this.serverBindLocalInterface + ":" + this.serverBindPreferedLocalPort), (Throwable)e0);
                }
                return;
            }
            break;
        }
    }
}

