/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.servlethttp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.impl.endpoint.servlethttp.ServletHttpTransport;
import net.jxta.impl.endpoint.transportMeter.TransportBindingMeter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class HttpClientMessenger
extends BlockingMessenger {
    private static final Logger LOG = Logger.getLogger((String)HttpClientMessenger.class.getName());
    private static String DEFAULT_RECEIVER_QUERY_STRING;
    private URL senderURL = null;
    private EndpointService endpointService = null;
    private MessageElement srcAddressElement = null;
    private EndpointAddress logicalDest = null;
    private ServletHttpTransport servletHttpTransport;
    private TransportBindingMeter transportBindingMeter;
    private transient long lastUsed = System.currentTimeMillis();
    private BackChannelListener listener = null;
    private static boolean neverWarned;

    public HttpClientMessenger(EndpointService endpointService, ServletHttpTransport servletHttpTransport, String peerId, EndpointAddress destAddr) throws IOException {
        super(endpointService.getGroup().getPeerGroupID(), destAddr, true);
        String protoAddr;
        this.endpointService = endpointService;
        this.servletHttpTransport = servletHttpTransport;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("peerId" + peerId));
        }
        if ((protoAddr = destAddr.getProtocolAddress()).charAt(0) != '[') {
            int lastColon = protoAddr.lastIndexOf(58);
            if (protoAddr.indexOf(58) != lastColon) {
                protoAddr = "[" + protoAddr.substring(0, lastColon) + "]" + protoAddr.substring(lastColon);
            }
        }
        protoAddr = "http://" + protoAddr;
        URL receiverURL = new URL(protoAddr.toString() + "/" + peerId + DEFAULT_RECEIVER_QUERY_STRING + "," + destAddr);
        this.senderURL = new URL(protoAddr.toString());
        EndpointAddress srcAddr = new EndpointAddress("jxta", peerId, null, null);
        this.srcAddressElement = new StringMessageElement("EndpointSourceAddress", srcAddr.toString(), null);
        this.logicalDest = this.retreiveLogicalDestinationAddress();
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("connected to " + this.logicalDest.toString()));
        }
        this.listener = new BackChannelListener(receiverURL, endpointService, this.transportBindingMeter, this);
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("created messenger for " + destAddr));
        }
    }

    void doshutdown() {
        this.shutdown();
    }

    public synchronized void closeImpl() {
        if (this.isClosed()) {
            return;
        }
        super.close();
        if (this.logicalDest == null || this.listener == null) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("close messenger to " + this.logicalDest.toString()));
        }
        BackChannelListener back = this.listener;
        this.listener = null;
        back.stopReceiving();
    }

    public boolean sendMessageBImpl(Message message, String service, String serviceParam) throws IOException {
        if (this.isClosed()) {
            IOException failure = new IOException("Messenger was closed, it cannot be used to send messages.");
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)failure, (Throwable)failure);
            }
            throw failure;
        }
        message.replaceMessageElement("jxta", this.srcAddressElement);
        EndpointAddress destAddressToUse = this.getDestAddressToUse(service, serviceParam);
        StringMessageElement dstAddressElement = new StringMessageElement("EndpointDestinationAddress", destAddressToUse.toString(), (MessageElement)null);
        message.replaceMessageElement("jxta", dstAddressElement);
        try {
            this.doSend(message);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return true;
    }

    public EndpointAddress getLogicalDestinationImpl() {
        return this.logicalDest;
    }

    public boolean isIdleImpl() {
        return this.isClosed() || System.currentTimeMillis() - this.lastUsed > 900000L;
    }

    private EndpointAddress retreiveLogicalDestinationAddress() throws IOException {
        byte[] peerIdBytes = null;
        long beginConnectTime = 0L;
        long connectTime = 0L;
        HttpURLConnection urlConn = (HttpURLConnection)this.senderURL.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setRequestMethod("GET");
        urlConn.setAllowUserInteraction(false);
        urlConn.setUseCaches(false);
        try {
            int code = urlConn.getResponseCode();
            if (code != 200) {
                throw new IOException("Message not accepted: HTTP status code=" + code + " reason=" + urlConn.getResponseMessage());
            }
        }
        catch (IOException ioe) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Peer URL could not be connected. May be down. ", (Throwable)ioe);
            }
            throw ioe;
        }
        int msglength = urlConn.getContentLength();
        if (msglength > 0) {
            InputStream inputStream = urlConn.getInputStream();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("message body (" + msglength + ") starts"));
            }
            peerIdBytes = new byte[msglength];
            int bytesRead = 0;
            while (bytesRead != msglength) {
                bytesRead = inputStream.read(peerIdBytes, bytesRead, msglength - bytesRead);
            }
            String peerIdString = new String(peerIdBytes);
            return new EndpointAddress("jxta", peerIdString, null, null);
        }
        throw new IOException("Could not get destination logical address");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(Message msg) throws IOException {
        long beginConnectTime = 0L;
        long connectTime = 0L;
        WireFormatMessage serialed = WireFormatMessageFactory.toWire(msg, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
        MimeMediaType encoding = serialed.getContentEncoding();
        for (int n = 0; n < 2; ++n) {
            URL tempURL = new URL(this.senderURL, "");
            HttpURLConnection urlConn = (HttpURLConnection)tempURL.openConnection();
            urlConn.setDoOutput(true);
            urlConn.setDoInput(true);
            urlConn.setRequestMethod("POST");
            urlConn.setAllowUserInteraction(false);
            urlConn.setUseCaches(false);
            if (null != encoding) {
                urlConn.setRequestProperty("content-encoding", serialed.getContentEncoding().toString());
            }
            urlConn.setRequestProperty("content-length", Integer.toString((int)serialed.getByteLength()));
            urlConn.setRequestProperty("content-type", serialed.getMimeType().toString());
            OutputStream out = urlConn.getOutputStream();
            serialed.sendToStream(out);
            out.flush();
            int code = 200;
            try {
                code = urlConn.getResponseCode();
            }
            catch (IOException ioe) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Http 1.0 proxy seems in use");
                }
                urlConn.disconnect();
                continue;
            }
            try {
                if (code == -1) {
                    if (LOG.isEnabledFor((Priority)Level.WARN) && neverWarned) {
                        LOG.warn((Object)"Obsolete http proxy does not issue HTTP_OK response. Assuming OK");
                        neverWarned = false;
                    }
                    code = 200;
                }
                if (code != 200) {
                    throw new IOException("Message not accepted: HTTP status code=" + code + " reason=" + urlConn.getResponseMessage());
                }
                this.lastUsed = System.currentTimeMillis();
                break;
            }
            finally {
                urlConn.disconnect();
            }
        }
    }

    private static String getBackChannelName(URL url) {
        return url.getHost() + ":" + url.getPort();
    }

    static {
        String javaspec = System.getProperty("java.specification.version");
        DEFAULT_RECEIVER_QUERY_STRING = null == javaspec || javaspec.compareTo("1.4") < 0 ? "?120000,-1" : "?120000,120000";
        neverWarned = true;
    }

    private static class BackChannelListener
    implements Runnable {
        private volatile URL backChannelURL = null;
        private EndpointService endpointService = null;
        private TransportBindingMeter transportBindingMeter = null;
        private volatile boolean isStopped = false;
        private Thread backChannelThread = null;
        private HttpClientMessenger frontChannel = null;

        private BackChannelListener(URL backChannelURL, EndpointService endpointService, TransportBindingMeter transportBindingMeter, HttpClientMessenger frontChannel) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("new BackChannelListener for " + backChannelURL));
            }
            this.backChannelURL = backChannelURL;
            this.endpointService = endpointService;
            this.transportBindingMeter = transportBindingMeter;
            this.frontChannel = frontChannel;
            this.backChannelThread = new Thread((Runnable)this, "HttpClientMessenger backChannel to " + backChannelURL);
            this.backChannelThread.setDaemon(true);
            this.backChannelThread.start();
        }

        protected void stopReceiving() {
            if (this.isStopped) {
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("stopReceiving for " + this.backChannelURL));
            }
            this.isStopped = true;
            this.backChannelThread.interrupt();
            HttpClientMessenger front = this.frontChannel;
            this.frontChannel = null;
            if (front != null) {
                front.close();
            }
        }

        protected boolean isStopReceiving() {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("isStopReceiving for " + this.backChannelURL + " is " + this.isStopped));
            }
            return this.isStopped;
        }

        public void run() {
            try {
                long beginConnectTime = 0L;
                long connectTime = 0L;
                URLConnection conn = null;
                if (LOG.isEnabledFor((Priority)Level.INFO)) {
                    LOG.info((Object)("Start receiving messages from " + this.backChannelURL));
                }
                InputStream inputStream = null;
                while (!this.isStopReceiving()) {
                    try {
                        long messageReceivedTime = connectTime;
                        while (!this.isStopReceiving()) {
                            if (conn != null) {
                                int responseCode;
                                block27: {
                                    try {
                                        conn.connect();
                                    }
                                    catch (IOException ioe) {
                                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block27;
                                        LOG.warn((Object)("Unable to reconnect to " + this.backChannelURL), (Throwable)ioe);
                                    }
                                }
                                try {
                                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                        LOG.debug((Object)("Waiting for response code from " + this.backChannelURL));
                                    }
                                    if ((responseCode = ((HttpURLConnection)conn).getResponseCode()) != 200) {
                                        throw new IOException("HTTP Failure: " + ((HttpURLConnection)conn).getResponseCode() + " : " + ((HttpURLConnection)conn).getResponseMessage());
                                    }
                                }
                                catch (RuntimeException wrapper) {
                                    conn = null;
                                    continue;
                                }
                                catch (ConnectException ce) {
                                    this.stopReceiving();
                                    continue;
                                }
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("Response " + responseCode + " for Connection : " + this.backChannelURL + "\n\tContent-Type : " + conn.getHeaderField("Content-Type") + "\tContent-Length : " + conn.getHeaderField("Content-Length") + "\tTransfer-Encoding : " + conn.getHeaderField("Transfer-Encoding")));
                                }
                                inputStream = conn.getInputStream();
                            }
                            if (conn == null) {
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("Opening new connection to " + this.backChannelURL));
                                }
                                conn = (HttpURLConnection)this.backChannelURL.openConnection();
                                conn.setDoOutput(false);
                                conn.setDoInput(true);
                                ((HttpURLConnection)conn).setRequestMethod("GET");
                                conn.setAllowUserInteraction(false);
                                conn.setUseCaches(false);
                                continue;
                            }
                            Message incomingMsg = null;
                            try {
                                incomingMsg = WireFormatMessageFactory.fromWire(inputStream, EndpointServiceImpl.DEFAULT_MESSAGE_TYPE, null);
                            }
                            catch (EOFException e) {
                                conn = null;
                                inputStream.close();
                                continue;
                            }
                            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                LOG.debug((Object)("Received " + incomingMsg + " from " + this.backChannelURL));
                            }
                            try {
                                this.endpointService.demux(incomingMsg);
                            }
                            catch (Throwable e) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Failure demuxing an incoming message", e);
                                }
                                throw e;
                            }
                        }
                    }
                    catch (IOException e) {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Failed to read message from " + this.backChannelURL), (Throwable)e);
                        }
                        this.stopReceiving();
                        break;
                    }
                }
            }
            catch (Throwable argh) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Backchannel listener exiting because of uncaught exception", argh);
                }
                this.stopReceiving();
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Stop receiving messages from " + this.backChannelURL));
            }
        }
    }
}

