/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint.router;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import net.jxta.credential.Credential;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.cm.Srdi;
import net.jxta.impl.cm.SrdiIndex;
import net.jxta.impl.endpoint.router.BadRoute;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.endpoint.router.RouteCM;
import net.jxta.impl.protocol.PlatformConfig;
import net.jxta.impl.protocol.ResolverQuery;
import net.jxta.impl.protocol.ResolverResponse;
import net.jxta.impl.protocol.RouteQuery;
import net.jxta.impl.protocol.RouteResponse;
import net.jxta.impl.protocol.SrdiMessageImpl;
import net.jxta.impl.util.TimeUtils;
import net.jxta.membership.MembershipService;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ResolverQueryMsg;
import net.jxta.protocol.ResolverResponseMsg;
import net.jxta.protocol.ResolverSrdiMsg;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.protocol.SrdiMessage;
import net.jxta.resolver.QueryHandler;
import net.jxta.resolver.ResolverService;
import net.jxta.resolver.SrdiHandler;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class RouteResolver
implements QueryHandler,
SrdiHandler,
Srdi.SrdiInterface {
    private static final transient Logger LOG = Logger.getLogger((String)RouteResolver.class.getName());
    private boolean useRouteResolver = true;
    private PeerGroup group = null;
    private ResolverService resolver = null;
    private EndpointRouter router = null;
    private EndpointAddress localPeerAddr = null;
    private ID localPeerId = null;
    public final String routerSName = "EndpointRouter";
    private RouteCM routeCM = null;
    private int qid = 0;
    private MembershipService membership = null;
    private Credential credential = null;
    private StructuredDocument credentialDoc = null;
    private SrdiIndex srdiIndex = null;
    private static final String srdiIndexerFileName = "routerSrdi";
    private Srdi srdi = null;
    private static final int NACKROUTE_QUERYID = -1;
    private static final long BADROUTE_EXPIRATION = 120000L;

    protected boolean useRouteResolver() {
        return this.useRouteResolver;
    }

    protected void disableRouteResolver() {
        this.useRouteResolver = false;
    }

    protected void enableRouteResolver() {
        this.useRouteResolver = true;
    }

    RouteResolver() {
    }

    public void init(PeerGroup group, ID assignedID, Advertisement impl, EndpointRouter router) throws PeerGroupException {
        Enumeration param;
        PlatformConfig confAdv = (PlatformConfig)group.getConfigAdvertisement();
        StructuredDocument paramBlock = null;
        if (confAdv != null) {
            paramBlock = confAdv.getServiceParam(assignedID);
        }
        if (paramBlock != null && (param = paramBlock.getChildren("useRouteResolver")).hasMoreElements()) {
            this.useRouteResolver = Boolean.getBoolean(((TextElement)param.nextElement()).getTextValue());
        }
        this.group = group;
        this.router = router;
        this.localPeerId = group.getPeerID();
        this.localPeerAddr = new EndpointAddress("jxta", this.localPeerId.getUniqueValue().toString(), null, null);
    }

    public int startApp(String[] arg) {
        block7: {
            this.resolver = this.group.getResolverService();
            this.membership = this.group.getMembershipService();
            if (null == this.resolver) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Endpoint Router start stalled until resolver service available");
                }
                return 2;
            }
            if (null == this.membership) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Endpoint Router start stalled until membership service available");
                }
                return 2;
            }
            this.resolver.registerHandler("EndpointRouter", this);
            this.srdiIndex = new SrdiIndex(this.group, srdiIndexerFileName);
            this.srdi = new Srdi(this.group, "EndpointRouter", this, this.srdiIndex, 0L, 0L);
            this.resolver.registerSrdiHandler("EndpointRouter", this);
            try {
                Enumeration enumeration = this.membership.getCurrentCredentials();
                if (enumeration.hasMoreElements()) {
                    this.credential = (Credential)enumeration.nextElement();
                    this.credentialDoc = this.credential.getDocument(MimeMediaType.XMLUTF8);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block7;
                LOG.error((Object)"failed to get credential", (Throwable)e);
            }
        }
        this.routeCM = this.router.getRouteCM();
        return 0;
    }

    public void stopApp() {
        this.resolver.unregisterHandler("EndpointRouter");
        this.resolver.unregisterSrdiHandler("EndpointRouter");
        this.srdiIndex.stop();
        this.resolver = null;
        this.srdi = null;
        this.membership = null;
    }

    protected void findRoute(EndpointAddress peer) {
        block21: {
            RouteAdvertisement myRoute = this.router.getMyLocalRoute();
            if (myRoute == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Cannot issue a find route if we don't know our own route");
                }
                return;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Find route for peer = " + peer));
            }
            try {
                RouteQuery doc = null;
                BadRoute badRoute = this.router.getBadRoute(peer);
                if (badRoute != null) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("findRoute sends query: known bad Hops" + badRoute.display()));
                    }
                    doc = new RouteQuery(EndpointRouter.addr2pid(peer), myRoute, badRoute.getHops());
                } else {
                    doc = new RouteQuery(EndpointRouter.addr2pid(peer), myRoute, null);
                }
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending query for peer : " + peer));
                }
                ResolverQuery query = new ResolverQuery("EndpointRouter", this.credentialDoc, this.localPeerId.toString(), doc.toString(), this.qid++);
                if (this.group.isRendezvous()) {
                    Vector results = null;
                    if (this.srdiIndex != null) {
                        results = this.srdiIndex.query("route", "DstPID", EndpointRouter.addr2pid(peer).toString(), 10);
                        if (results != null && results.size() > 0) {
                            Vector clean = this.cleanupAnyEdges(query.getSrc(), results);
                            if (clean.size() > 0) {
                                query.incrementHopCount();
                                this.srdi.forwardQuery(clean, query, 1);
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)"found an srdi entry forwarding query to SRDI peer");
                                }
                                return;
                            }
                        } else {
                            PeerID destPeer = this.srdi.getReplicaPeer(EndpointRouter.addr2pid(peer).toString());
                            if (destPeer != null && !destPeer.equals(this.localPeerId)) {
                                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    LOG.debug((Object)("processQuery srdiIndex DHT forward :" + destPeer));
                                }
                                this.srdi.forwardQuery(destPeer.toString(), (ResolverQueryMsg)query);
                                return;
                            }
                        }
                    }
                }
                this.resolver = this.group.getResolverService();
                if (this.resolver != null) {
                    this.resolver.sendQuery(null, query);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)"find route query sent");
                    }
                } else if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"cannot get the resolver service");
                }
            }
            catch (Exception ee) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block21;
                LOG.warn((Object)"Exception in findRoute", (Throwable)ee);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processResponse(ResolverResponseMsg response) {
        block36: {
            block34: {
                block35: {
                    block32: {
                        if (!this.useRouteResolver) {
                            return;
                        }
                        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            RouteResolver.LOG.debug((Object)"processResponse got a response");
                        }
                        ip = null;
                        doc = null;
                        ip = new StringReader(response.getResponse());
                        asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip);
                        doc = new RouteResponse(asDoc);
                        var6_6 = null;
                        try {
                            if (null != ip) {
                                ip.close();
                                ip = null;
                            }
                            break block32;
                        }
                        catch (Throwable ignored) {}
                        break block32;
                        {
                            catch (Throwable e) {
                                if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                                    RouteResolver.LOG.debug((Object)"processResponse: malformed response - discard", e);
                                }
                                var6_7 = null;
                                try {
                                    if (null != ip) {
                                        ip.close();
                                        ip = null;
                                    }
                                }
                                catch (Throwable ignored) {
                                    // empty catch block
                                }
                                return;
                            }
                        }
                        catch (Throwable var5_13) {
                            var6_8 = null;
                            try {
                                if (null != ip) {
                                    ip.close();
                                    ip = null;
                                }
                            }
                            catch (Throwable ignored) {
                                // empty catch block
                            }
                            throw var5_13;
                        }
                    }
                    dstRoute = doc.getDestRoute();
                    srcRoute = doc.getSrcRoute();
                    queryId = response.getQueryId();
                    if (dstRoute == null || srcRoute == null) {
                        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            RouteResolver.LOG.debug((Object)"processResponse: malformed response - discard.");
                        }
                        return;
                    }
                    routingPeer = this.router.pid2addr(srcRoute.getDestPeerID());
                    destPeer = this.router.pid2addr(dstRoute.getDestPeerID());
                    if (routingPeer == null || destPeer == null) {
                        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            RouteResolver.LOG.debug((Object)"processResponse: malformed PeerID in response - discard.");
                        }
                        return;
                    }
                    if (queryId == -1) {
                        badHop = dstRoute.nextHop(EndpointRouter.addr2pid(routingPeer));
                        badPeer = null;
                        badPeer = badHop != null ? badHop.getPeerID() : dstRoute.getDestPeerID();
                        this.processBadRoute(badPeer, dstRoute);
                        return;
                    }
                    if (!this.router.isLocalRoute(this.router.pid2addr(srcRoute.getDestPeerID())) && !this.router.isRoutedRoute(this.router.pid2addr(srcRoute.getDestPeerID()))) {
                        this.router.updateRouteAdv(srcRoute);
                    }
                    if (!destPeer.equals(routingPeer)) break block35;
                    if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RouteResolver.LOG.debug((Object)"learn route directly from the destination");
                    }
                    break block36;
                }
                if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    RouteResolver.LOG.debug((Object)("learn route:" + routingPeer));
                }
                try {
                    candidateRoute = RouteAdvertisement.newRoute(EndpointRouter.addr2pid(destPeer), EndpointRouter.addr2pid(routingPeer), (Vector)dstRoute.getVectorHops().clone());
                    RouteAdvertisement.cleanupLoop(candidateRoute, (PeerID)this.localPeerId);
                    if (candidateRoute.size() == 0) {
                        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            RouteResolver.LOG.debug((Object)"Route response outdated: NACK responder");
                        }
                        this.generateNACKRoute(EndpointRouter.addr2pid(routingPeer), EndpointRouter.addr2pid(destPeer), dstRoute.getVectorHops());
                        return;
                    }
                    candidateRouter = this.router.pid2addr(candidateRoute.getFirstHop().getPeerID());
                    if (this.router.ensureLocalRoute(candidateRouter, null) != null) ** GOTO lbl103
                    routeToRouter = this.router.getRoute(candidateRouter, false);
                    if (routeToRouter == null) {
                        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            RouteResolver.LOG.debug((Object)"Route response useless: no route to next router hop");
                        }
                        return;
                    }
                    if (RouteAdvertisement.stichRoute(candidateRoute, routeToRouter, (PeerID)this.localPeerId)) {
                        this.router.setRoute(candidateRoute, false);
                    } else {
                        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            RouteResolver.LOG.debug((Object)"Route response error stiching route response");
                        }
                        return;
lbl103:
                        // 1 sources

                        this.router.setRoute(candidateRoute, false);
                    }
                }
                catch (Exception ex) {
                    if (!RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) break block34;
                    RouteResolver.LOG.debug((Object)("Route response exception when building response route" + ex));
                    RouteResolver.LOG.debug((Object)("               bad dstRoute: " + dstRoute.display()));
                }
            }
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"finish process route response successfully");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBadRoute(PeerID badHop, RouteAdvertisement dest) {
        EndpointAddress addr = this.router.pid2addr(dest.getDestPeerID());
        if (addr == null) {
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) return;
            LOG.debug((Object)"remove bad route has a bad route info - discard");
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("remove bad route info for dest " + dest.display()));
            if (badHop != null) {
                LOG.debug((Object)("remove bad route bad hop " + badHop));
            }
        }
        try {
            BadRoute badRoute;
            RouteAdvertisement currentRoute = this.router.getRoute(addr, false);
            if (currentRoute == null) {
                return;
            }
            if (!currentRoute.equals(dest)) {
                if (!badHop.equals(EndpointRouter.addr2pid(addr))) {
                    if (badHop == null) return;
                    if (!currentRoute.containsHop(badHop)) {
                        return;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("current route is bad because it contains known bad hop" + badHop));
                    }
                } else if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("current route is bad because it contains known bad destination" + badHop));
                }
            }
            if ((badRoute = this.router.getBadRoute(addr)) != null) {
                Long nextTry = badRoute.getExpiration();
                if (nextTry <= System.currentTimeMillis()) {
                    nextTry = new Long(TimeUtils.toAbsoluteTimeMillis(120000L));
                    badRoute.setExpiration(nextTry);
                }
                Vector badHops = badRoute.getHops();
                if (badHop != null && !badHops.contains(badHop)) {
                    badHops.add(badHop);
                    nextTry = new Long(TimeUtils.toAbsoluteTimeMillis(120000L));
                    badRoute.setHops(badHops);
                    badRoute.setExpiration(nextTry);
                }
                this.router.setBadRoute(addr, badRoute);
                return;
            }
            Vector<PeerID> badHops = new Vector<PeerID>();
            if (badHop != null) {
                badHops.add(badHop);
            }
            badRoute = new BadRoute(dest, new Long(TimeUtils.toAbsoluteTimeMillis(120000L)), badHops);
            this.router.setBadRoute(addr, badRoute);
            this.routeCM.flushRoute(addr);
            this.router.removeRoute(addr);
            return;
        }
        catch (Exception ex) {
            if (!LOG.isEnabledFor((Priority)Level.WARN)) return;
            LOG.warn((Object)"exception during bad route removal", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int processQuery(ResolverQueryMsg query) {
        block53: {
            if (!this.useRouteResolver) {
                return 0;
            }
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"processQuery starts");
            }
            routeQuery = null;
            ip = null;
            ip = new StringReader(query.getQuery());
            asDoc = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, ip);
            routeQuery = new RouteQuery(asDoc);
            var7_6 = null;
            try {
                if (null != ip) {
                    ip.close();
                    ip = null;
                }
                break block53;
            }
            catch (Throwable ignored) {}
            break block53;
            {
                catch (Throwable e) {
                    if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RouteResolver.LOG.debug((Object)"Malformed Route query ", e);
                    }
                    var5_15 = 0;
                    var7_7 = null;
                    try {
                        if (null != ip) {
                            ip.close();
                            ip = null;
                        }
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                    return var5_15;
                }
            }
            catch (Throwable var6_17) {
                var7_8 = null;
                try {
                    if (null != ip) {
                        ip.close();
                        ip = null;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                throw var6_17;
            }
        }
        pId = routeQuery.getDestPeerID();
        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
            RouteResolver.LOG.debug((Object)("processQuery: looking for route to " + pId));
        }
        srcRoute = routeQuery.getSrcRoute();
        badHops = routeQuery.getBadHops();
        if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG) && badHops != null) {
            RouteResolver.LOG.debug((Object)"processQuery: bad Hops");
            for (i = 0; i < badHops.size(); ++i) {
                RouteResolver.LOG.debug((Object)("processQuery:   :" + ((PeerID)badHops.elementAt(i)).toString()));
            }
        }
        if (srcRoute != null) {
            if (!srcRoute.getDestPeerID().equals(this.localPeerId)) {
                try {
                    if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RouteResolver.LOG.debug((Object)("processQuery: publishing sender route info " + srcRoute.getDestPeerID()));
                    }
                    if (this.router.isLocalRoute(this.router.pid2addr(srcRoute.getDestPeerID())) || this.router.isRoutedRoute(this.router.pid2addr(srcRoute.getDestPeerID()))) ** GOTO lbl75
                    this.routeCM.publishRoute(srcRoute);
                }
                catch (Exception e) {
                    if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RouteResolver.LOG.debug((Object)"Could not publish Route Adv from query - discard", (Throwable)e);
                    }
                    return 0;
                }
            }
        } else {
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"No src Route in route query - discard ");
            }
            return 0;
        }
lbl75:
        // 3 sources

        if (pId == null) {
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"Malformed route query request, no PeerId - discard");
            }
            return 0;
        }
        queryId = query.getQueryId();
        qReqAddr = this.router.pid2addr(pId);
        route = null;
        found = false;
        if (qReqAddr.equals(this.localPeerAddr)) {
            found = true;
            route = this.router.getMyLocalRoute();
        } else if (this.router.isLocalRoute(qReqAddr)) {
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"processQuery: peer has direct route to destination ");
            }
            found = true;
            route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
            ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
            ap.setPeerID(pId);
            route.setDest(ap);
        } else {
            route = this.router.getRoute(qReqAddr, false);
            if (route != null) {
                found = true;
                for (i = 0; i < badHops.size(); ++i) {
                    if (EndpointRouter.addr2pid(qReqAddr).equals((PeerID)badHops.elementAt(i))) {
                        this.processBadRoute((PeerID)badHops.elementAt(i), route);
                        found = false;
                        break;
                    }
                    if (!route.containsHop((PeerID)badHops.elementAt(i))) continue;
                    if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RouteResolver.LOG.debug((Object)("processQuery: peer has bad route due to " + ((PeerID)badHops.elementAt(i)).toString()));
                    }
                    this.processBadRoute((PeerID)badHops.elementAt(i), route);
                    found = false;
                    break;
                }
            }
        }
        if (!found) {
            if (!this.group.isRendezvous()) {
                if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    RouteResolver.LOG.debug((Object)"discard query forwarding as not a rendezvous");
                }
                return 0;
            }
            if (query.getHopCount() < 2 && (results = this.srdiIndex.query("route", "DstPID", pId.toString(), 10)).size() > 0) {
                if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    RouteResolver.LOG.debug((Object)("processQuery srdiIndex lookup match :" + results.size()));
                }
                if ((clean = this.cleanupAnyEdges(query.getSrc(), results)).size() > 0) {
                    if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        RouteResolver.LOG.debug((Object)"found an srdi entry forwarding query to SRDI peer");
                    }
                    query.incrementHopCount();
                    this.srdi.forwardQuery(clean, query, 1);
                    return 0;
                }
            }
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"did not find a route or SRDI index");
            }
            return -1;
        }
        try {
            if (route == null) {
                if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    RouteResolver.LOG.debug((Object)"we should have had a route at this point");
                }
                return 0;
            }
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)("processQuery: we have a route build route response" + route.display()));
            }
            if ((myRoute = this.router.getMyLocalRoute()) == null) {
                return 0;
            }
            routeResponse = new RouteResponse();
            routeResponse.setDestRoute(route);
            routeResponse.setSrcRoute(myRoute);
            if (routeResponse == null) {
                if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    RouteResolver.LOG.debug((Object)"error creating route response");
                }
                return 0;
            }
            res = query.makeResponse();
            res.setCredential(this.credentialDoc);
            res.setResponse(routeResponse.toString());
            this.resolver.sendResponse(query.getSrc(), res);
            return 0;
        }
        catch (Exception ee) {
            if (RouteResolver.LOG.isEnabledFor((Priority)Level.DEBUG)) {
                RouteResolver.LOG.debug((Object)"processQuery: error while processing query ", (Throwable)ee);
            }
            return 0;
        }
    }

    protected void generateNACKRoute(PeerID src, PeerID dest, Vector origHops) {
        if (this.resolver == null) {
            return;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("generate NACK Route response " + src));
        }
        if (this.router.isPendingRouteQuery(this.router.pid2addr(src))) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("drop NACK due to pending route discovery " + src));
            }
            return;
        }
        RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement ap = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        ap.setPeerID(dest);
        route.setDest(ap);
        route.setHops(origHops);
        RouteAdvertisement routeSrc = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
        AccessPointAdvertisement apSrc = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
        apSrc.setPeerID((PeerID)this.localPeerId);
        routeSrc.setDest(apSrc);
        RouteResponse routeResponse = new RouteResponse();
        routeResponse.setDestRoute(route);
        routeResponse.setSrcRoute(routeSrc);
        if (routeResponse == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"error creating route NACKresponse");
            }
            return;
        }
        ResolverResponse res = new ResolverResponse("EndpointRouter", this.credentialDoc, -1, routeResponse.toString());
        this.resolver.sendResponse(src.toString(), res);
    }

    public boolean processSrdi(ResolverSrdiMsg message) {
        SrdiMessageImpl srdiMsg;
        try {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Received a SRDI messsage in group" + this.group.getPeerGroupName()));
            }
            srdiMsg = new SrdiMessageImpl(new ByteArrayInputStream(message.getPayload().getBytes()));
        }
        catch (Exception e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"corrupted SRDI message", (Throwable)e);
            }
            return false;
        }
        PeerID pid = srdiMsg.getPeerID();
        if (pid.equals(this.localPeerId)) {
            return false;
        }
        Iterator eachEntry = srdiMsg.getEntries().iterator();
        while (eachEntry.hasNext()) {
            SrdiMessage.Entry entry = (SrdiMessage.Entry)eachEntry.next();
            if (entry.key.equals(this.localPeerId.toString())) continue;
            String value = entry.value;
            if (value == null) {
                value = "";
            }
            this.srdiIndex.add(srdiMsg.getPrimaryKey(), "DstPID", entry.key, pid, entry.expiration);
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Primary Key [" + srdiMsg.getPrimaryKey() + "] key [DstPID]" + " value [" + entry.key + "] exp [" + entry.expiration + "]"));
        }
        return true;
    }

    public void pushEntries(boolean all) {
        this.pushSrdi(null, all);
    }

    protected void pushSrdi(String peer, boolean all) {
        block5: {
            Vector<SrdiMessage.Entry> routeIx = new Vector<SrdiMessage.Entry>();
            Iterator iterator = this.router.getAllRoutedRouteAddresses();
            while (iterator.hasNext()) {
                PeerID pid = EndpointRouter.addr2pid((EndpointAddress)iterator.next());
                SrdiMessage.Entry entry = new SrdiMessage.Entry(pid.toString(), "", Long.MAX_VALUE);
                routeIx.addElement(entry);
            }
            try {
                if (routeIx.size() == 0) {
                    return;
                }
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", routeIx);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Sending a SRDI messsage of [All=" + all + "] routes"));
                }
                this.srdi.replicateEntries(srdiMsg);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"SRDI Push failed", (Throwable)e);
            }
        }
    }

    protected void pushSrdi(ID peer, PeerID id) {
        block5: {
            try {
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", id.toString(), null, new Long(Long.MAX_VALUE));
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sending a router SRDI message add route " + id));
                }
                if (peer == null) {
                    PeerID destPeer = this.srdi.getReplicaPeer(id.toString());
                    peer = destPeer;
                }
                if (!this.localPeerId.equals(peer)) {
                    this.srdi.pushSrdi(peer, srdiMsg);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"SRDI push failed", (Throwable)e);
            }
        }
    }

    protected void removeSrdi(String peer, PeerID id) {
        block4: {
            try {
                PeerID destPeer;
                SrdiMessageImpl srdiMsg = new SrdiMessageImpl(this.group.getPeerID(), 1, "route", id.toString(), null, new Long(0L));
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("sending a router SRDI message delete route " + id));
                }
                if (peer == null && (destPeer = this.srdi.getReplicaPeer(id.toString())) != null && !destPeer.equals(this.localPeerId)) {
                    this.srdi.pushSrdi(destPeer, srdiMsg);
                }
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block4;
                LOG.debug((Object)"Removing srdi entry failed", (Throwable)e);
            }
        }
    }

    public void messageSendFailed(PeerID peerid, OutgoingMessageEvent e) {
        this.removeSrdiIndex(peerid);
    }

    protected Vector cleanupAnyEdges(String src, Vector results) {
        Vector<PeerID> clean = new Vector<PeerID>(results.size());
        PeerID pid = null;
        Vector rpvId = this.srdi.getGlobalPeerView();
        for (int i = 0; i < results.size(); ++i) {
            pid = (PeerID)results.elementAt(i);
            if (src.equals(pid.toString()) || this.localPeerId.equals(pid)) continue;
            if (rpvId.contains(pid)) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("valid rdv for SRDI forward " + pid));
                }
                clean.add(pid);
                continue;
            }
            this.srdiIndex.remove(pid);
        }
        return clean;
    }

    protected Vector getGlobalPeerView() {
        return this.srdi.getGlobalPeerView();
    }

    protected void removeSrdiIndex(PeerID pid) {
        this.srdiIndex.remove(pid);
    }
}

