/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.jxta.document.Document;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.ByteArrayMessageElement;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.impl.endpoint.JxtaMessageMessageElement;
import net.jxta.impl.endpoint.WireFormatMessage;
import net.jxta.impl.endpoint.WireFormatMessageFactory;
import net.jxta.util.LimitInputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class WireFormatMessageBinary
implements WireFormatMessage {
    private static final Logger LOG = Logger.getLogger((String)WireFormatMessageBinary.class.getName());
    protected static final byte HAS_TYPE = 1;
    protected static final byte HAS_ENCODING = 2;
    protected static final byte HAS_SIGNATURE = 4;
    protected static final int MESSAGE_VERSION = 0;
    private static final MimeMediaType[] myTypes = new MimeMediaType[]{new MimeMediaType("application/x-jxta-msg")};
    private static final MimeMediaType[] myContentEncodings = new MimeMediaType[]{null};
    public static final WireFormatMessageFactory.Instantiator INSTANTIATOR = new Instantiator();
    private Message msg;
    private int msgModCount;
    private MimeMediaType type;
    private MimeMediaType contentEncoding;
    private binaryMessageProxy msgProxy;

    private WireFormatMessageBinary(Message msg, MimeMediaType type, MimeMediaType[] preferedContentEncodings) throws IOException {
        if (null == msg) {
            throw new IllegalArgumentException("Null message!");
        }
        this.msg = msg;
        this.msgModCount = msg.getMessageModCount();
        if (null == type) {
            throw new IllegalArgumentException("Null mime type!");
        }
        int matchedIdx = -1;
        for (int eachType = 0; eachType < myTypes.length; ++eachType) {
            if (!type.equalsIngoringParams(myTypes[eachType])) continue;
            matchedIdx = eachType;
            break;
        }
        if (-1 == matchedIdx) {
            throw new IllegalArgumentException("Unsupported mime type!");
        }
        this.type = type;
        this.contentEncoding = myContentEncodings[0];
        this.msgProxy = new binaryMessageProxy(msg, type);
    }

    public boolean equals(Object obj) {
        throw new UnsupportedOperationException("don't do this");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("don't do this");
    }

    public String getFileExtension() {
        return "???";
    }

    public MimeMediaType getMimeType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream() throws IOException {
        if (this.msg.getMessageModCount() != this.msgModCount) {
            throw new IllegalStateException("message was unexpectedly modified!");
        }
        this.msg.modifiable = false;
        try {
            InputStream result;
            InputStream inputStream = result = this.msgProxy.getStream();
            return inputStream;
        }
        finally {
            this.msg.modifiable = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToStream(OutputStream sendTo) throws IOException {
        if (this.msg.getMessageModCount() != this.msgModCount) {
            throw new IllegalStateException("message was unexpectedly modified!");
        }
        this.msg.modifiable = false;
        try {
            this.msgProxy.sendToStream(sendTo);
        }
        finally {
            this.msg.modifiable = true;
        }
    }

    public long getByteLength() {
        if (this.msg.getMessageModCount() != this.msgModCount) {
            throw new IllegalStateException("message was unexpectedly modified!");
        }
        return this.msgProxy.getByteLength();
    }

    public MimeMediaType getContentEncoding() {
        return this.contentEncoding;
    }

    static class binaryElementProxy {
        byte namespaceid;
        binaryElementProxy sig;
        MessageElement element;
        byte[] header;

        binaryElementProxy(byte namespaceid, MessageElement element2) throws IOException {
            this.namespaceid = namespaceid;
            this.element = element2;
            MessageElement sig = element2.getSignature();
            if (null != sig) {
                this.sig = new binaryElementProxy(namespaceid, sig);
            }
            this.buildHeader();
        }

        void buildHeader() throws IOException {
            long dataLen;
            byte[] elementName = this.element.getElementName().getBytes("UTF8");
            byte[] elementType = null;
            if (!MimeMediaType.AOS.equals(this.element.getMimeType())) {
                elementType = this.element.getMimeType().toString().getBytes("UTF8");
            }
            ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(256);
            DataOutputStream header = new DataOutputStream(headerBytes);
            header.writeBytes("jxel");
            header.writeByte(this.namespaceid);
            header.writeByte((null != elementType ? 1 : 0) | (null != this.sig ? 4 : 0));
            header.writeShort(elementName.length);
            header.write(elementName, 0, elementName.length);
            if (null != elementType) {
                header.writeShort(elementType.length);
                header.write(elementType, 0, elementType.length);
            }
            if ((dataLen = this.element.getByteLength()) > Integer.MAX_VALUE) {
                throw new IllegalStateException("WireFormatMessageBinary does not support elements longer than 4GB");
            }
            header.writeInt((int)dataLen);
            header.flush();
            header.close();
            headerBytes.flush();
            headerBytes.close();
            this.header = headerBytes.toByteArray();
        }

        public long getByteLength() {
            long size = 0L;
            size += (long)this.header.length;
            size += this.element.getByteLength();
            if (null != this.sig) {
                size += this.sig.getByteLength();
            }
            return size;
        }

        public InputStream getStream() throws IOException {
            ArrayList<InputStream> streamParts = new ArrayList<InputStream>();
            streamParts.add(new ByteArrayInputStream(this.header));
            streamParts.add(this.element.getStream());
            if (null != this.sig) {
                streamParts.add(this.sig.getStream());
            }
            return new SequenceInputStream(Collections.enumeration(streamParts));
        }

        public void sendToStream(OutputStream sendTo) throws IOException {
            sendTo.write(this.header);
            this.element.sendToStream(sendTo);
            if (null != this.sig) {
                this.sig.sendToStream(sendTo);
            }
        }
    }

    static class binaryMessageProxy
    implements Document {
        Message message;
        MimeMediaType type;
        List elements = new ArrayList();
        HashMap namespaceIDs = new HashMap();
        List namespaces = new ArrayList();
        byte[] header;

        binaryMessageProxy(Message msg, MimeMediaType type) throws IOException {
            this.message = msg;
            this.type = type;
            this.assignNamespaceIds();
            Message.ElementIterator eachElement = this.message.getMessageElements();
            while (eachElement.hasNext()) {
                MessageElement anElement = (MessageElement)eachElement.next();
                byte namespaceid = ((Integer)this.namespaceIDs.get(eachElement.getNamespace())).byteValue();
                this.elements.add(new binaryElementProxy(namespaceid, anElement));
            }
            this.buildHeader();
        }

        public String getFileExtension() {
            return "???";
        }

        public MimeMediaType getMimeType() {
            return this.type;
        }

        public InputStream getStream() throws IOException {
            ArrayList<InputStream> streamParts = new ArrayList<InputStream>();
            streamParts.add(new ByteArrayInputStream(this.header));
            ListIterator eachElement = this.elements.listIterator();
            while (eachElement.hasNext()) {
                binaryElementProxy anElement = (binaryElementProxy)eachElement.next();
                streamParts.add(anElement.getStream());
            }
            SequenceInputStream theStream = new SequenceInputStream(Collections.enumeration(streamParts));
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Returning " + theStream.getClass().getName() + "@" + System.identityHashCode(theStream) + " for " + this.message));
            }
            return theStream;
        }

        public void sendToStream(OutputStream sendTo) throws IOException {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Sending " + this.message + " to " + sendTo.getClass().getName() + "@" + System.identityHashCode(sendTo)));
            }
            sendTo.write(this.header);
            ListIterator eachElement = this.elements.listIterator();
            while (eachElement.hasNext()) {
                binaryElementProxy anElement = (binaryElementProxy)eachElement.next();
                anElement.sendToStream(sendTo);
            }
        }

        public long getByteLength() {
            long size = 0L;
            size += (long)this.header.length;
            Iterator eachElement = this.elements.iterator();
            while (eachElement.hasNext()) {
                binaryElementProxy anElement = (binaryElementProxy)eachElement.next();
                size += anElement.getByteLength();
            }
            return size;
        }

        private void assignNamespaceIds() {
            int id = 0;
            Iterator namespaces = this.message.getMessageNamespaces();
            this.namespaceIDs.put("", new Integer(id++));
            this.namespaces.add("");
            this.namespaceIDs.put("jxta", new Integer(id++));
            this.namespaces.add("jxta");
            while (namespaces.hasNext()) {
                String namespace = (String)namespaces.next();
                if (this.namespaceIDs.get(namespace) != null) continue;
                this.namespaceIDs.put(namespace, new Integer(id++));
                this.namespaces.add(namespace);
            }
            if (id >= 256) {
                throw new IllegalStateException("WireFormatMessageBinary does not support more than 255 namespaces");
            }
        }

        private void buildHeader() throws IOException {
            ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(256);
            DataOutputStream header = new DataOutputStream(headerBytes);
            header.writeBytes("jxmg");
            header.writeByte(0);
            header.writeShort(this.namespaces.size() - 2);
            for (int eachNamespace = 2; eachNamespace < this.namespaces.size(); ++eachNamespace) {
                byte[] elementName = ((String)this.namespaces.get(eachNamespace)).getBytes("UTF8");
                header.writeShort(elementName.length);
                header.write(elementName, 0, elementName.length);
            }
            header.writeShort(this.elements.size());
            header.flush();
            header.close();
            headerBytes.flush();
            headerBytes.close();
            this.header = headerBytes.toByteArray();
        }
    }

    static class Instantiator
    implements WireFormatMessageFactory.Instantiator {
        public MimeMediaType[] getSupportedMimeTypes() {
            return myTypes;
        }

        public MimeMediaType[] getSupportedContentEncodings() {
            return myContentEncodings;
        }

        public Message fromWire(InputStream is, MimeMediaType type, MimeMediaType contentEncoding) throws IOException {
            Message msg = new Message();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Reading " + msg + " from " + is));
            }
            DataInputStream dis = new DataInputStream(is);
            HashMap idToNamespace = Instantiator.readHeader(dis);
            int elementCnt = dis.readShort();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("fromWire : message element count " + elementCnt + " from " + is));
            }
            int eachElement = 0;
            do {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("fromWire : read element " + eachElement + " of " + elementCnt + " from " + is + " for " + msg));
                }
                Object[] anElement = null;
                try {
                    anElement = this.readMessageElement(dis, is);
                }
                catch (IOException failed) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)("Failure reading element " + eachElement + " of " + elementCnt + " from " + is + " for " + msg), (Throwable)failed);
                    }
                    throw failed;
                }
                if (null == anElement) break;
                String namespace = (String)idToNamespace.get(anElement[0]);
                if (null == namespace) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Element identified a namespace which was not defined for this message.");
                    }
                    throw new IOException("Element identified a namespace which was not defined for this message.");
                }
                msg.addMessageElement(namespace, (MessageElement)anElement[1]);
                ++eachElement;
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("fromWire : add element (name='" + ((MessageElement)anElement[1]).getElementName() + "') #" + eachElement + " of #" + elementCnt + " elements from " + dis.toString()));
            } while (0 == elementCnt || eachElement < elementCnt);
            if (elementCnt != 0 && eachElement != elementCnt) {
                throw new IOException("Found wrong number of elements in message.");
            }
            return msg;
        }

        public WireFormatMessage toWire(Message msg, MimeMediaType type, MimeMediaType[] preferedContentEncoding) {
            try {
                return new WireFormatMessageBinary(msg, type, preferedContentEncoding);
            }
            catch (IOException caught) {
                throw new IllegalStateException("Could not build wire format for message due to " + caught.getMessage());
            }
        }

        private static HashMap readHeader(DataInputStream dis) throws IOException {
            char[] msgsig = new char[4];
            try {
                msgsig[0] = (char)dis.readByte();
            }
            catch (EOFException failed) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"EOF reading message at first byte of header.", (Throwable)failed);
                }
                throw failed;
            }
            msgsig[1] = (char)dis.readByte();
            msgsig[2] = (char)dis.readByte();
            msgsig[3] = (char)dis.readByte();
            if (msgsig[0] != 'j' || msgsig[1] != 'x' || msgsig[2] != 'm' || msgsig[3] != 'g') {
                IOException failure = new IOException("Not a message (incorrect signature '" + msgsig[0] + msgsig[1] + msgsig[2] + msgsig[3] + "') ");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)failure);
                }
                throw failure;
            }
            if (dis.readByte() != 0) {
                IOException failure = new IOException("Message not version 0");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)failure, (Throwable)failure);
                }
                throw failure;
            }
            int namespaceCnt = dis.readShort();
            if (namespaceCnt > 253) {
                IOException failure = new IOException("Message contains too many namespaces (>253)");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)failure, (Throwable)failure);
                }
                throw failure;
            }
            HashMap<Integer, String> id2namespace = new HashMap<Integer, String>(2 + namespaceCnt);
            id2namespace.put(new Integer(0), "");
            id2namespace.put(new Integer(1), "jxta");
            int id = 2;
            for (int i = 0; i < namespaceCnt; ++i) {
                try {
                    String namespace = Instantiator.readString(dis);
                    id2namespace.put(new Integer(id++), namespace);
                    continue;
                }
                catch (IOException caught) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Error Processing namespace", (Throwable)caught);
                    }
                    throw caught;
                }
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Read Message Header with " + (namespaceCnt + 2) + " namespaces from " + dis.toString()));
            }
            return id2namespace;
        }

        private Object[] readMessageElement(DataInputStream dis, InputStream is) throws IOException {
            char[] elsig = new char[4];
            try {
                elsig[0] = (char)dis.readByte();
            }
            catch (EOFException allDone) {
                return null;
            }
            elsig[1] = (char)dis.readByte();
            elsig[2] = (char)dis.readByte();
            elsig[3] = (char)dis.readByte();
            if (elsig[0] != 'j' || elsig[1] != 'x' || elsig[2] != 'e' || elsig[3] != 'l') {
                IOException failure = new IOException("Not a message element (incorrect signature '" + elsig[0] + elsig[1] + elsig[2] + elsig[3] + "') ");
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)failure, (Throwable)failure);
                }
                throw failure;
            }
            byte nsid = dis.readByte();
            byte flags = dis.readByte();
            String name = Instantiator.readString(dis);
            MimeMediaType type = null;
            if ((flags & 1) != 0) {
                String typeString = Instantiator.readString(dis);
                try {
                    type = new MimeMediaType(typeString);
                }
                catch (IllegalArgumentException uhoh) {
                    throw new IOException("Bad MimeType in message element header : " + uhoh.getMessage());
                }
            } else {
                type = MimeMediaType.AOS;
            }
            int dataLen = dis.readInt();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("element : nsid = " + nsid + " name = '" + name + "' type = '" + type + "' flags = " + Integer.toBinaryString(flags) + " datalen = " + dataLen));
            }
            Object[] res = new Object[2];
            res[0] = new Integer(nsid & 0xFF);
            byte[] value = null;
            Message submsg = null;
            if (type.equalsIngoringParams(myTypes[0])) {
                LimitInputStream subis = new LimitInputStream(is, dataLen);
                submsg = WireFormatMessageFactory.fromWire(subis, type, null);
            } else {
                if (dataLen > Integer.MAX_VALUE) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"WireFormatMessageBinary does not support elements longer than 2GB");
                    }
                    throw new IllegalStateException("WireFormatMessageBinary does not support elements longer than 2GB");
                }
                value = new byte[dataLen];
                String mayFail = null;
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    mayFail = is.toString();
                }
                try {
                    dis.readFully(value);
                }
                catch (EOFException failed) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.error((Object)("had tried to read " + dataLen + " from " + mayFail + " which is now " + is));
                    }
                    throw failed;
                }
            }
            MessageElement sig = null;
            if ((flags & 4) != 0) {
                Object[] sigRes = this.readMessageElement(dis, is);
                sig = (MessageElement)sigRes[1];
            }
            res[1] = null != value ? new ByteArrayMessageElement(name, type, value, sig) : new JxtaMessageMessageElement(name, type, submsg, sig);
            return res;
        }

        private static String readString(DataInputStream dis) throws IOException {
            short len = dis.readShort();
            if (len < 0) {
                throw new IOException("Bad string length in message");
            }
            byte[] bytes = new byte[len];
            dis.readFully(bytes);
            return new String(bytes, "UTF8");
        }
    }
}

