/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.WeakHashMap;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.ChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.ListenerAdaptor;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.EndpointServiceImpl;
import net.jxta.peergroup.PeerGroup;
import net.jxta.service.Service;

public class EndpointServiceInterface
implements EndpointService {
    EndpointServiceImpl theRealThing = null;
    private ListenerAdaptor listenerAdaptor = null;
    private WeakHashMap channelCache = new WeakHashMap();

    public EndpointServiceInterface(EndpointServiceImpl s) {
        this.theRealThing = s;
        this.listenerAdaptor = new ListenerAdaptor(this.theRealThing.getGroup().getHomeThreadGroup());
    }

    public void init(PeerGroup pg, ID id, Advertisement ia) {
    }

    public int startApp(String[] arg) {
        return 0;
    }

    public void stopApp() {
    }

    public Advertisement getImplAdvertisement() {
        return this.theRealThing.getImplAdvertisement();
    }

    public Service getInterface() {
        return this;
    }

    public PeerGroup getGroup() {
        return this.theRealThing.getGroup();
    }

    public Messenger getCanonicalMessenger(EndpointAddress addr, Object hint) {
        return this.theRealThing.getCanonicalMessenger(addr, hint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messenger getMessengerImmediate(EndpointAddress addr, Object hint) {
        EndpointServiceInterface endpointServiceInterface = this;
        synchronized (endpointServiceInterface) {
            Messenger m;
            Reference existing = (Reference)this.channelCache.get(addr);
            if (existing != null && (m = (Messenger)existing.get()) != null && (m.getState() & 0x3FF) != 0) {
                return m;
            }
        }
        EndpointAddress plainAddr = new EndpointAddress(addr, null, null);
        Messenger found = this.theRealThing.getCanonicalMessenger(plainAddr, hint);
        if (found == null) {
            return null;
        }
        ChannelMessenger res = (ChannelMessenger)found.getChannelMessenger(this.theRealThing.getGroup().getPeerGroupID(), addr.getServiceName(), addr.getServiceParameter());
        EndpointServiceInterface endpointServiceInterface2 = this;
        synchronized (endpointServiceInterface2) {
            Messenger m;
            Reference existing = (Reference)this.channelCache.get(addr);
            if (existing != null && (m = (Messenger)existing.get()) != null && (m.getState() & 0x3FF) != 0) {
                return m;
            }
            res.setMessageWatcher(this.listenerAdaptor);
            this.channelCache.put(res.getDestinationAddressObject(), new WeakReference<ChannelMessenger>(res));
        }
        return res;
    }

    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        Messenger m = this.getMessengerImmediate(addr, hint);
        if (m == null) {
            return null;
        }
        m.resolve();
        try {
            m.waitState(515020, 60000L);
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        int state = m.getState();
        if ((state & 0x70000) != 0) {
            return null;
        }
        if ((state & 0x6DBCC) == 0) {
            return null;
        }
        return m;
    }

    public void propagate(Message srcMsg, String serviceName, String serviceParam) throws IOException {
        this.theRealThing.propagate(srcMsg, serviceName, serviceParam);
    }

    public void demux(Message msg) {
        this.theRealThing.demux(msg);
    }

    public void processIncomingMessage(Message message, EndpointAddress source, EndpointAddress destination) {
        this.theRealThing.processIncomingMessage(message, source, destination);
    }

    public boolean ping(EndpointAddress addr) {
        return this.theRealThing.ping(addr);
    }

    public MessengerEventListener addMessageTransport(MessageTransport transpt) {
        return this.theRealThing.addMessageTransport(transpt);
    }

    public boolean removeMessageTransport(MessageTransport transpt) {
        return this.theRealThing.removeMessageTransport(transpt);
    }

    public Iterator getAllMessageTransports() {
        return this.theRealThing.getAllMessageTransports();
    }

    public MessageTransport getMessageTransport(String name) {
        return this.theRealThing.getMessageTransport(name);
    }

    public boolean addIncomingMessageListener(EndpointListener listener, String serviceName, String serviceParam) {
        return this.theRealThing.addIncomingMessageListener(listener, serviceName, serviceParam);
    }

    public void addIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        this.theRealThing.addIncomingMessageFilterListener(listener, namespace, name);
    }

    public void addOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        this.theRealThing.addOutgoingMessageFilterListener(listener, namespace, name);
    }

    public MessageFilterListener removeIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        return this.theRealThing.removeIncomingMessageFilterListener(listener, namespace, name);
    }

    public MessageFilterListener removeOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        return this.theRealThing.removeOutgoingMessageFilterListener(listener, namespace, name);
    }

    public EndpointListener removeIncomingMessageListener(String serviceName, String serviceParam) {
        return this.theRealThing.removeIncomingMessageListener(serviceName, serviceParam);
    }

    public boolean addMessengerEventListener(MessengerEventListener listener, int prio) {
        return this.theRealThing.addMessengerEventListener(listener, prio);
    }

    public boolean removeMessengerEventListener(MessengerEventListener listener, int prio) {
        return this.theRealThing.removeMessengerEventListener(listener, prio);
    }

    public void finalize() {
        this.listenerAdaptor.shutdown();
    }

    public boolean getMessenger(MessengerEventListener listener, EndpointAddress addr, Object hint) {
        Messenger m = this.getMessengerImmediate(addr, hint);
        if (m == null) {
            return false;
        }
        if (!this.listenerAdaptor.watchMessenger(listener, m)) {
            return false;
        }
        m.resolve();
        return true;
    }

    public Messenger getMessenger(EndpointAddress addr) {
        return this.getMessenger(addr, null);
    }
}

