/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredDocumentUtils;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.TextElement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointListener;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.MessageFilterListener;
import net.jxta.endpoint.MessageReceiver;
import net.jxta.endpoint.MessageSender;
import net.jxta.endpoint.MessageTransport;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.endpoint.ThreadedMessenger;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.BlockingMessenger;
import net.jxta.impl.endpoint.EndpointServiceInterface;
import net.jxta.impl.endpoint.QuotaIncomingMessageListener;
import net.jxta.impl.endpoint.endpointMeter.EndpointMeter;
import net.jxta.impl.endpoint.endpointMeter.EndpointServiceMonitor;
import net.jxta.impl.endpoint.endpointMeter.InboundMeter;
import net.jxta.impl.endpoint.endpointMeter.OutboundMeter;
import net.jxta.impl.endpoint.endpointMeter.PropagationMeter;
import net.jxta.impl.endpoint.relay.RelayClient;
import net.jxta.impl.endpoint.router.EndpointRouter;
import net.jxta.impl.peergroup.RefPeerGroup;
import net.jxta.impl.util.FastHashMap;
import net.jxta.impl.util.SequenceIterator;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.AccessPointAdvertisement;
import net.jxta.protocol.ConfigParams;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;
import net.jxta.service.Service;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class EndpointServiceImpl
implements EndpointService,
MessengerEventListener {
    EndpointServiceMonitor endpointServiceMonitor;
    private static final Logger LOG = Logger.getLogger((String)EndpointServiceImpl.class.getName());
    public static final MimeMediaType DEFAULT_MESSAGE_TYPE = new MimeMediaType("application/x-jxta-msg");
    public static final String ENDPOINTSERVICE_NAME = "EndpointService";
    public static final String MESSAGE_EMPTY_NS = "";
    public static final String MESSAGE_JXTA_NS = "jxta";
    public static final String MESSAGE_SOURCE_NS = "jxta";
    public static final String MESSAGE_SOURCE_NAME = "EndpointSourceAddress";
    public static final String MESSAGE_DESTINATION_NS = "jxta";
    public static final String MESSAGE_DESTINATION_NAME = "EndpointDestinationAddress";
    public static final String MESSAGE_SRCPEERHDR_NS = "jxta";
    public static final String MESSAGE_SRCPEERHDR_NAME = "EndpointHeaderSrcPeer";
    private boolean initialized = false;
    private EndpointMeter endpointMeter;
    private PropagationMeter propagationMeter;
    private int vmQueueSize = 20;
    private boolean useParentEndpoint = true;
    private ModuleImplAdvertisement implAdv = null;
    private ID assignedID = null;
    private PeerGroup group = null;
    private String localPeerId = null;
    private EndpointService parentEndpoint = null;
    private String myServiceName = null;
    private PeerGroup parentGroup = null;
    private ArrayList messageTransports = new ArrayList();
    private List[] passiveMessengerListeners = new List[]{new Vector(), new Vector(), new Vector()};
    private Map incomingMessageListeners = new FastHashMap(16);
    private Map messengerMap = new WeakHashMap(32);
    private List incomingFilterListeners = new ArrayList();
    private List outgoingFilterListeners = new ArrayList();

    public synchronized void init(PeerGroup group, ID assignedID, Advertisement impl) throws PeerGroupException {
        if (this.initialized) {
            throw new PeerGroupException("Cannot initialize service more than once");
        }
        this.implAdv = (ModuleImplAdvertisement)impl;
        this.assignedID = assignedID;
        this.group = group;
        this.localPeerId = group.getPeerID().toString();
        this.myServiceName = "EndpointService:" + group.getPeerGroupID().getUniqueValue().toString();
        ConfigParams confAdv = group.getConfigAdvertisement();
        StructuredDocument paramBlock = null;
        if (confAdv != null) {
            paramBlock = confAdv.getServiceParam(assignedID);
        }
        if (paramBlock != null) {
            Enumeration param;
            block12: {
                param = paramBlock.getChildren("MessengerQueueSize");
                if (param.hasMoreElements()) {
                    String textQSz = ((TextElement)param.nextElement()).getTextValue();
                    try {
                        this.vmQueueSize = Integer.parseInt(textQSz.trim());
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) break block12;
                        LOG.warn((Object)"could not parse MessengerQueueSize string", (Throwable)e);
                    }
                }
            }
            if ((param = paramBlock.getChildren("UseParentEndpoint")).hasMoreElements()) {
                String textUPE = ((TextElement)param.nextElement()).getTextValue();
                this.useParentEndpoint = textUPE.trim().equalsIgnoreCase("true");
            }
        }
        this.parentGroup = ((RefPeerGroup)group).getParentGroup();
        if (this.useParentEndpoint && this.parentGroup != null) {
            this.parentEndpoint = this.parentGroup.getEndpointService();
            this.parentEndpoint.addMessengerEventListener(this, 0);
        }
        this.initialized = true;
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            StringBuffer configInfo = new StringBuffer("Configuring Endpoint Service : " + assignedID);
            configInfo.append("\n\tImplementation :");
            configInfo.append("\n\t\tImpl Description : " + this.implAdv.getDescription());
            configInfo.append("\n\t\tImpl URI : " + this.implAdv.getUri());
            configInfo.append("\n\t\tImpl Code : " + this.implAdv.getCode());
            configInfo.append("\n\tGroup Params :");
            configInfo.append("\n\t\tGroup : " + group.getPeerGroupName());
            configInfo.append("\n\t\tGroup ID : " + group.getPeerGroupID());
            configInfo.append("\n\t\tPeer ID : " + group.getPeerID());
            configInfo.append("\n\tConfiguration :");
            if (null == this.parentGroup) {
                configInfo.append("\n\t\tHome Group : (none)");
            } else {
                configInfo.append("\n\t\tHome Group : " + this.parentGroup.getPeerGroupName() + " / " + this.parentGroup.getPeerGroupID());
            }
            configInfo.append("\n\t\tVirtual Messenger Queue Size : " + this.vmQueueSize);
            if (group.getPeerGroupID().equals(PeerGroupID.worldPeerGroupID)) {
                configInfo.append("\n\tQuota Incoming Message Params :");
                configInfo.append("\n\t\tMax message size : " + QuotaIncomingMessageListener.GmaxMsgSize);
                configInfo.append("\n\t\tMax message senders : " + QuotaIncomingMessageListener.GmaxSenders);
            }
            LOG.info((Object)configInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startApp(String[] args) {
        if (this.parentEndpoint != null) {
            Iterator parentMTs = this.parentEndpoint.getAllMessageTransports();
            EndpointServiceImpl endpointServiceImpl = this;
            synchronized (endpointServiceImpl) {
                while (parentMTs.hasNext()) {
                    this.addProtoToAdv((MessageTransport)parentMTs.next());
                }
            }
        }
        return 0;
    }

    public void stopApp() {
        if (this.parentEndpoint != null) {
            this.parentEndpoint.removeMessengerEventListener(this, 0);
        }
        for (int i = 0; i < 3; ++i) {
            List list = this.passiveMessengerListeners[i];
            if (list == null) continue;
            list.clear();
        }
        if (this.incomingMessageListeners != null) {
            try {
                this.incomingMessageListeners.clear();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PeerGroup getGroup() {
        return this.group;
    }

    public Service getInterface() {
        return new EndpointServiceInterface(this);
    }

    public Advertisement getImplAdvertisement() {
        return this.implAdv;
    }

    private void propagateThroughAll(Iterator eachProto, Message myMsg, String serviceName, String serviceParam, Metrics metrics) {
        while (eachProto.hasNext()) {
            try {
                MessageTransport aTransport = (MessageTransport)eachProto.next();
                if (!(aTransport instanceof MessageSender)) continue;
                MessageSender sender = (MessageSender)aTransport;
                Message m = this.processFilters((Message)myMsg.clone(), sender.getPublicAddress(), new EndpointAddress(this.group.getPeerGroupID(), serviceName, serviceParam), false);
                if (m == null) {
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)"   message discarded upon filter decision");
                    continue;
                }
                sender.propagate(m, serviceName, serviceParam, null);
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                LOG.warn((Object)"Failed to send on endpoint protocol. ", (Throwable)e);
            }
        }
    }

    public void propagate(Message srcMsg, String serviceName, String serviceParam) throws IOException {
        long startPropagationTime = 0L;
        Metrics metrics = new Metrics();
        Message myMsg = (Message)srcMsg.clone();
        StringMessageElement srcHdrElement = new StringMessageElement(MESSAGE_SRCPEERHDR_NAME, this.localPeerId, (MessageElement)null);
        myMsg.replaceMessageElement("jxta", srcHdrElement);
        Iterator eachProto = this.getAllLocalTransports();
        this.propagateThroughAll(eachProto, myMsg, serviceName, serviceParam, metrics);
        if (this.parentEndpoint != null) {
            eachProto = this.parentEndpoint.getAllMessageTransports();
            this.propagateThroughAll(eachProto, myMsg, this.myServiceName, serviceName + "/" + serviceParam, metrics);
        }
    }

    private Message processFilters(Message message, EndpointAddress srcAddress, EndpointAddress dstAddress, boolean incoming) {
        Iterator eachFilter;
        Iterator iterator = eachFilter = incoming ? this.incomingFilterListeners.iterator() : this.outgoingFilterListeners.iterator();
        while (eachFilter.hasNext()) {
            FilterListenerAndMask aFilter = (FilterListenerAndMask)eachFilter.next();
            Message.ElementIterator eachElement = message.getMessageElements();
            while (eachElement.hasNext()) {
                MessageElement anElement = (MessageElement)eachElement.next();
                if (null != aFilter.namespace && !aFilter.namespace.equals(eachElement.getNamespace()) || null != aFilter.name && !aFilter.name.equals(anElement.getElementName()) || null != (message = aFilter.listener.filterMessage(message, srcAddress, dstAddress))) continue;
                return null;
            }
        }
        return message;
    }

    private EndpointAddress demangleAddress(EndpointAddress mangled) {
        String serviceName = mangled.getServiceName();
        if (!serviceName.startsWith("EndpointService:")) {
            return mangled;
        }
        String serviceParam = mangled.getServiceParameter();
        if (null == serviceParam) {
            return new EndpointAddress(mangled, null, null);
        }
        int slashAt = serviceParam.indexOf(47);
        if (-1 == slashAt) {
            return new EndpointAddress(mangled, serviceParam, null);
        }
        return new EndpointAddress(mangled, serviceParam.substring(0, slashAt), serviceParam.substring(slashAt + 1));
    }

    public void processIncomingMessage(Message msg, EndpointAddress srcAddress, EndpointAddress dstAddress) {
        block17: {
            MessageElement srcPeerElement = msg.getMessageElement("jxta", MESSAGE_SRCPEERHDR_NAME);
            if (null != srcPeerElement) {
                msg.removeMessageElement(srcPeerElement);
                String srcPeer = srcPeerElement.toString();
                if (this.localPeerId.equals(srcPeer)) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("processIncomingMessage : " + msg.toString() + " is a propagate loopback. Discarded"));
                    }
                    return;
                }
            }
            Message origMessage = msg;
            EndpointAddress demangledAddress = null;
            String decodedServiceName = null;
            String decodedServiceParam = null;
            if (dstAddress != null) {
                demangledAddress = this.demangleAddress(dstAddress);
                decodedServiceName = demangledAddress.getServiceName();
                decodedServiceParam = demangledAddress.getServiceParameter();
            }
            if ((msg = this.processFilters(msg, srcAddress, demangledAddress, true)) == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"demux : message discarded during filter processing");
                }
                return;
            }
            if (null == decodedServiceName || 0 == decodedServiceName.length()) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("demux : dest serviceName must not be null, discarding message " + msg.toString()));
                }
                return;
            }
            if (demangledAddress != dstAddress) {
                decodedServiceName = dstAddress.getServiceName() + "/" + decodedServiceName;
            }
            EndpointListener h = null;
            if (null != decodedServiceParam) {
                h = (EndpointListener)this.incomingMessageListeners.get(decodedServiceName + "/" + decodedServiceParam);
            }
            if (h == null) {
                h = (EndpointListener)this.incomingMessageListeners.get(decodedServiceName);
            }
            if (h == null) {
                h = (EndpointListener)this.incomingMessageListeners.get(decodedServiceName + decodedServiceParam);
            }
            if (h == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("demux: no listener for '" + dstAddress + "' in group " + this.group));
                }
                return;
            }
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("demux: calling listener '" + dstAddress + "' for " + msg.toString()));
                }
                long beginProcessing = 0L;
                h.processIncomingMessage(msg, srcAddress, demangledAddress);
            }
            catch (Throwable all) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block17;
                LOG.warn((Object)("demux : Uncaught throwable from listener for " + dstAddress), all);
            }
        }
    }

    public void demux(Message msg) {
        MessageElement dstAddressElement = msg.getMessageElement("jxta", MESSAGE_DESTINATION_NAME);
        if (null == dstAddressElement) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("demux : " + msg.toString() + " has no destination address. Discarded"));
            }
            return;
        }
        msg.removeMessageElement(dstAddressElement);
        EndpointAddress dstAddress = new EndpointAddress(dstAddressElement.toString());
        Object srcAddress = null;
        MessageElement srcAddressElement = msg.getMessageElement("jxta", MESSAGE_SOURCE_NAME);
        if (null == srcAddressElement) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("demux : " + msg.toString() + " has no source address. Discarded"));
            }
            return;
        }
        msg.removeMessageElement(srcAddressElement);
        EndpointAddress msgScrAddress = new EndpointAddress(srcAddressElement.toString());
        this.processIncomingMessage(msg, msgScrAddress, dstAddress);
    }

    public boolean ping(EndpointAddress addr) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessengerEventListener addMessageTransport(MessageTransport transpt) {
        ArrayList arrayList = this.messageTransports;
        synchronized (arrayList) {
            if (!this.messageTransports.contains(transpt)) {
                this.clearProtoFromAdv(transpt);
                this.messageTransports.add(transpt);
                this.addProtoToAdv(transpt);
                return this;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessageTransport(MessageTransport transpt) {
        boolean removed = false;
        ArrayList arrayList = this.messageTransports;
        synchronized (arrayList) {
            removed = this.messageTransports.remove(transpt);
        }
        if (removed) {
            this.clearProtoFromAdv(transpt);
        }
        return removed;
    }

    public Iterator getAllMessageTransports() {
        if (null != this.parentEndpoint) {
            return new SequenceIterator(this.getAllLocalTransports(), this.parentEndpoint.getAllMessageTransports());
        }
        return this.getAllLocalTransports();
    }

    public MessageTransport getMessageTransport(String name) {
        if (null != this.parentEndpoint) {
            SequenceIterator allTransports = new SequenceIterator(this.getAllLocalTransports(), this.parentEndpoint.getAllMessageTransports());
            while (allTransports.hasNext()) {
                MessageTransport transpt = (MessageTransport)allTransports.next();
                if (!transpt.getProtocolName().equals(name)) continue;
                return transpt;
            }
        } else {
            return null;
        }
        return null;
    }

    private void addProtoToAdv(MessageTransport proto) {
        block13: {
            boolean relay = false;
            try {
                if (!(proto instanceof MessageReceiver)) {
                    return;
                }
                if (proto instanceof EndpointRouter) {
                    this.addActiveRelayListener(this.group);
                    return;
                }
                if (proto instanceof RelayClient) {
                    relay = true;
                    ((RelayClient)proto).addActiveRelayListener(this.group);
                }
                PeerAdvertisement padv = this.group.getPeerAdvertisement();
                StructuredDocument myParam = padv.getServiceParam(this.assignedID);
                Iterator allAddresses = ((MessageReceiver)proto).getPublicAddresses();
                Vector<String> ea = new Vector<String>();
                while (allAddresses.hasNext()) {
                    EndpointAddress anEndpointAddress = (EndpointAddress)allAddresses.next();
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Adding endpoint address to route advertisement : " + anEndpointAddress));
                    }
                    ea.addElement(anEndpointAddress.toString());
                }
                RouteAdvertisement route = null;
                if (myParam == null) {
                    Vector hops;
                    AccessPointAdvertisement destAP = (AccessPointAdvertisement)AdvertisementFactory.newAdvertisement(AccessPointAdvertisement.getAdvertisementType());
                    destAP.setEndpointAddresses(ea);
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement(RouteAdvertisement.getAdvertisementType());
                    route.setDest(destAP);
                    if (relay && (hops = ((RelayClient)proto).getActiveRelays(this.group)) != null) {
                        route.setHops(hops);
                    }
                } else {
                    Vector hops;
                    Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                    Element param = null;
                    if (paramChilds.hasMoreElements()) {
                        param = (Element)paramChilds.nextElement();
                    }
                    route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                    route.addDestEndpointAddresses(ea);
                    if (relay && (hops = ((RelayClient)proto).getActiveRelays(this.group)) != null) {
                        route.setHops(hops);
                    }
                }
                myParam = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(myParam, myParam, xptDoc);
                padv.putServiceParam(this.assignedID, myParam);
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block13;
                LOG.warn((Object)"exception adding protocol transport ", (Throwable)ex);
            }
        }
    }

    private void clearProtoFromAdv(MessageTransport transpt) {
        block9: {
            try {
                PeerAdvertisement padv;
                StructuredDocument myParam;
                if (!(transpt instanceof MessageReceiver)) {
                    return;
                }
                if (transpt instanceof EndpointRouter) {
                    this.removeActiveRelayListener(this.group);
                    return;
                }
                if (transpt instanceof RelayClient) {
                    ((RelayClient)transpt).removeActiveRelayListener(this.group);
                }
                if ((myParam = (padv = this.group.getPeerAdvertisement()).getServiceParam(this.assignedID)) == null) {
                    return;
                }
                Enumeration paramChilds = myParam.getChildren(RouteAdvertisement.getAdvertisementType());
                Element param = null;
                if (paramChilds.hasMoreElements()) {
                    param = (Element)paramChilds.nextElement();
                }
                RouteAdvertisement route = (RouteAdvertisement)AdvertisementFactory.newAdvertisement((TextElement)param);
                Iterator allAddresses = ((MessageReceiver)transpt).getPublicAddresses();
                Vector ea = new Vector();
                while (allAddresses.hasNext()) {
                    EndpointAddress anEndpointAddress = (EndpointAddress)allAddresses.next();
                    if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                    LOG.debug((Object)("Removing endpoint address from route advertisement : " + anEndpointAddress));
                }
                route.removeDestEndpointAddresses(ea);
                StructuredDocument newParam = StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, "Parm");
                StructuredTextDocument xptDoc = (StructuredTextDocument)route.getDocument(MimeMediaType.XMLUTF8);
                StructuredDocumentUtils.copyElements(newParam, newParam, xptDoc);
                padv.putServiceParam(this.assignedID, newParam);
                DiscoveryService discovery = this.group.getDiscoveryService();
                if (discovery != null) {
                    discovery.publish(padv, 31536000000L, 0x6DDD00L);
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                LOG.warn((Object)"exception removing protocol transport ", (Throwable)ex);
            }
        }
    }

    public boolean addMessengerEventListener(MessengerEventListener listener, int prio) {
        if (prio > 2) {
            prio = 2;
        }
        if (prio < 0) {
            prio = 0;
        }
        this.passiveMessengerListeners[prio].add(listener);
        return true;
    }

    public boolean removeMessengerEventListener(MessengerEventListener listener, int prio) {
        if (prio > 2) {
            prio = 2;
        }
        if (prio < 0) {
            prio = 0;
        }
        this.passiveMessengerListeners[prio].remove(listener);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addIncomingMessageListener(EndpointListener listener, String serviceName, String serviceParam) {
        if (null == listener) {
            throw new IllegalArgumentException("EndpointListener must be non-null");
        }
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        if (-1 != serviceName.indexOf(47)) {
            throw new IllegalArgumentException("serviceName may not contain '/' characters");
        }
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        Map map = this.incomingMessageListeners;
        synchronized (map) {
            if (this.incomingMessageListeners.containsKey(address)) {
                return false;
            }
            InboundMeter incomingMessageListenerMeter = null;
            if (!(listener instanceof QuotaIncomingMessageListener)) {
                listener = new QuotaIncomingMessageListener(address, listener, incomingMessageListenerMeter);
            }
            this.incomingMessageListeners.put(address, listener);
        }
        if (this.parentEndpoint != null) {
            if (serviceName.startsWith("EndpointService:")) {
                this.parentEndpoint.addIncomingMessageListener(listener, serviceName, serviceParam);
            } else {
                this.parentEndpoint.addIncomingMessageListener(listener, this.myServiceName, address);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointListener removeIncomingMessageListener(String serviceName, String serviceParam) {
        if (null == serviceName) {
            throw new IllegalArgumentException("serviceName must not be null");
        }
        if (-1 != serviceName.indexOf(47)) {
            throw new IllegalArgumentException("serviceName may not contain '/' characters");
        }
        String address = serviceName;
        if (null != serviceParam) {
            address = address + "/" + serviceParam;
        }
        QuotaIncomingMessageListener removedListener = null;
        EndpointListener result = null;
        Map map = this.incomingMessageListeners;
        synchronized (map) {
            removedListener = (QuotaIncomingMessageListener)this.incomingMessageListeners.remove(address);
            if (removedListener != null) {
                result = removedListener.getListener();
                removedListener.close();
            }
        }
        if (this.parentEndpoint != null) {
            if (serviceName.startsWith("EndpointService:")) {
                this.parentEndpoint.removeIncomingMessageListener(serviceName, serviceParam);
            } else {
                this.parentEndpoint.removeIncomingMessageListener(this.myServiceName, address);
            }
        }
        return result;
    }

    private MessageSender getLocalSenderForAddress(EndpointAddress addr) {
        Iterator localTransports = this.getAllLocalTransports();
        while (localTransports.hasNext()) {
            MessageTransport transpt = (MessageTransport)localTransports.next();
            if (!transpt.getProtocolName().equals(addr.getProtocolName()) || !(transpt instanceof MessageSender)) continue;
            return (MessageSender)transpt;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Messenger getCanonicalMessenger(EndpointAddress addr, Object hint) {
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            Throwable trace = new Throwable("Stack Trace");
            StackTraceElement[] elements = trace.getStackTrace();
            int position = 1;
            while (elements[position].getClassName().startsWith("net.jxta.impl.endpoint.EndpointService")) {
                ++position;
            }
            if (elements.length - 1 == position) {
                --position;
            }
            LOG.debug((Object)("Get Messenger for " + addr + " by " + elements[position]));
        }
        if (addr == null) {
            throw new IllegalArgumentException("null endpoint address not allowed.");
        }
        Map map = this.messengerMap;
        synchronized (map) {
            Reference ref = (Reference)this.messengerMap.get(addr);
            if (ref != null) {
                Messenger found = (Messenger)ref.get();
                if (found != null && (found.getState() & 0x3FF) != 0) {
                    return found;
                }
                this.messengerMap.remove(ref);
            }
            if (this.getLocalSenderForAddress(addr) != null) {
                OutboundMeter messengerMeter = null;
                CanonicalMessenger m = new CanonicalMessenger(this.vmQueueSize, addr, null, hint, messengerMeter);
                this.messengerMap.put(m.getDestinationAddressObject(), new SoftReference<CanonicalMessenger>(m));
                return m;
            }
        }
        if (this.parentEndpoint == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("getMessenger : Couldn't create messenger for : '" + addr + "'"));
            }
            return null;
        }
        return this.parentEndpoint.getCanonicalMessenger(addr, hint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator getAllLocalTransports() {
        List<Object> transportList;
        ArrayList arrayList = this.messageTransports;
        synchronized (arrayList) {
            transportList = Arrays.asList(this.messageTransports.toArray());
        }
        return Collections.unmodifiableList(transportList).iterator();
    }

    protected Messenger getLocalTransportMessenger(EndpointAddress addr, Object hint) {
        MessageSender sender = this.getLocalSenderForAddress(addr);
        Messenger messenger = null;
        if (sender != null) {
            EndpointAddress addressToUse = (EndpointAddress)addr.clone();
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Trying address '" + addressToUse + "' with : " + sender));
            }
            messenger = sender.getMessenger(addressToUse, hint);
        }
        if (LOG.isEnabledFor((Priority)Level.INFO) && messenger == null) {
            LOG.info((Object)("Couldn't create messenger for : '" + addr + "'"));
        }
        return messenger;
    }

    public synchronized void addIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        if (null == listener) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        FilterListenerAndMask aFilter = new FilterListenerAndMask(listener, namespace, name);
        this.incomingFilterListeners.add(aFilter);
    }

    public synchronized void addOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        if (null == listener) {
            throw new IllegalArgumentException("listener must be non-null");
        }
        FilterListenerAndMask aFilter = new FilterListenerAndMask(listener, namespace, name);
        this.outgoingFilterListeners.add(aFilter);
    }

    public synchronized MessageFilterListener removeIncomingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        Iterator eachListener = this.incomingFilterListeners.iterator();
        while (eachListener.hasNext()) {
            FilterListenerAndMask aFilter = (FilterListenerAndMask)eachListener.next();
            if (listener != aFilter.listener) continue;
            eachListener.remove();
            return listener;
        }
        return null;
    }

    public synchronized MessageFilterListener removeOutgoingMessageFilterListener(MessageFilterListener listener, String namespace, String name) {
        Iterator eachListener = this.outgoingFilterListeners.iterator();
        while (eachListener.hasNext()) {
            FilterListenerAndMask aFilter = (FilterListenerAndMask)eachListener.next();
            if (listener != aFilter.listener || !(null != namespace ? namespace.equals(aFilter.namespace) : null == aFilter.namespace) || !(null != name ? name.equals(aFilter.name) : null == aFilter.name)) continue;
            eachListener.remove();
            return listener;
        }
        return null;
    }

    public boolean messengerReady(MessengerEvent event) {
        String cgServiceName;
        Messenger messenger;
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("New messenger event for : " + event.getMessenger().getDestinationAddress()));
        }
        if (!(event.getSource() instanceof MessageTransport)) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"New messenger from non-transport. Ignored");
            }
            return false;
        }
        MessageTransport source = (MessageTransport)event.getSource();
        Messenger messengerForHere = messenger = event.getMessenger();
        EndpointAddress connAddr = event.getConnectionAddress();
        int highestPrec = 2;
        int lowestPrec = 0;
        if (connAddr != null && (cgServiceName = connAddr.getServiceName()) != null && cgServiceName.startsWith("EndpointService:")) {
            if (!this.myServiceName.equals(cgServiceName)) {
                highestPrec = 0;
            } else {
                lowestPrec = 1;
                String serviceParam = connAddr.getServiceParameter();
                String realService = null;
                String realParam = null;
                if (null != serviceParam) {
                    int slashAt = serviceParam.indexOf(47);
                    if (-1 == slashAt) {
                        realService = serviceParam;
                    } else {
                        realService = serviceParam.substring(0, slashAt);
                        realParam = serviceParam.substring(slashAt + 1);
                    }
                }
                connAddr.setServiceName(realService);
                connAddr.setServiceParameter(realParam);
            }
        }
        messengerForHere = event.getMessenger().getChannelMessenger(this.group.getPeerGroupID(), null, null);
        int prec = highestPrec + 1;
        while (prec-- > lowestPrec) {
            List l = this.passiveMessengerListeners[prec];
            if (l == null) continue;
            Object[] allML = l.toArray();
            int i = allML.length;
            while (i-- > 0) {
                MessengerEventListener listener = (MessengerEventListener)allML[i];
                try {
                    if (!listener.messengerReady(new MessengerEvent(source, prec == 0 ? messenger : messengerForHere, connAddr))) continue;
                    return true;
                }
                catch (Throwable all) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) continue;
                    LOG.error((Object)"Uncaught Throwable in listener", all);
                }
            }
        }
        return false;
    }

    private void addActiveRelayListener(PeerGroup listeningGroup) {
        PeerGroup parentGroup = ((RefPeerGroup)this.group).getParentGroup();
        while (parentGroup != null) {
            EndpointService parentEndpoint = parentGroup.getEndpointService();
            Iterator it = parentEndpoint.getAllMessageTransports();
            while (it.hasNext()) {
                MessageTransport mt = (MessageTransport)it.next();
                if (!(mt instanceof RelayClient)) continue;
                ((RelayClient)mt).addActiveRelayListener(listeningGroup);
                break;
            }
            parentGroup = ((RefPeerGroup)parentGroup).getParentGroup();
        }
    }

    private void removeActiveRelayListener(PeerGroup listeningGroup) {
        PeerGroup parentGroup = ((RefPeerGroup)this.group).getParentGroup();
        while (parentGroup != null) {
            EndpointService parentEndpoint = parentGroup.getEndpointService();
            Iterator it = parentEndpoint.getAllMessageTransports();
            while (it.hasNext()) {
                MessageTransport mt = (MessageTransport)it.next();
                if (!(mt instanceof RelayClient)) continue;
                ((RelayClient)mt).removeActiveRelayListener(listeningGroup);
                break;
            }
            parentGroup = ((RefPeerGroup)parentGroup).getParentGroup();
        }
    }

    public boolean getMessenger(MessengerEventListener listener, EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Legacy method not implemented. Use an interface object.");
    }

    public Messenger getMessenger(EndpointAddress addr) {
        throw new UnsupportedOperationException("Legacy method not implemented. Use an interface object.");
    }

    public Messenger getMessengerImmediate(EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Convenience method not implemented. Use an interface object.");
    }

    public Messenger getMessenger(EndpointAddress addr, Object hint) {
        throw new UnsupportedOperationException("Convenience method not implemented. Use an interface object.");
    }

    private class Metrics {
        int numFilteredOut = 0;
        int numPropagatedTo = 0;
        int numErrorsPropagated = 0;

        private Metrics() {
        }
    }

    private class CanonicalMessenger
    extends ThreadedMessenger {
        Object hint;
        Messenger cachedMessenger;

        public CanonicalMessenger(int vmQueueSize, EndpointAddress destination, EndpointAddress logicalDestination, Object hint, OutboundMeter messengerMeter) {
            super(EndpointServiceImpl.this.group.getPeerGroupID(), destination, logicalDestination, vmQueueSize);
            this.cachedMessenger = null;
            this.hint = hint;
        }

        public void close() {
        }

        protected void closeImpl() {
            if (this.cachedMessenger != null) {
                this.cachedMessenger.close();
                this.cachedMessenger = null;
            } else if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Internal messenger error: close requested while not connected.");
            }
        }

        protected boolean connectImpl() {
            block5: {
                if (this.cachedMessenger != null) {
                    if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                        LOG.error((Object)"Internal messenger error: connect requested while connected.");
                    }
                    this.cachedMessenger.close();
                    this.cachedMessenger = null;
                }
                Object theHint = this.hint;
                this.hint = null;
                this.cachedMessenger = EndpointServiceImpl.this.getLocalTransportMessenger(this.getDestinationAddress(), theHint);
                if (this.cachedMessenger == null) {
                    return false;
                }
                try {
                    ((BlockingMessenger)this.cachedMessenger).setOwner(this);
                }
                catch (ClassCastException cce) {
                    if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block5;
                    LOG.error((Object)("Transport messengers must all extend BlockingMessenger for now. " + this.cachedMessenger + " may remain open beyond its use."));
                }
            }
            return true;
        }

        protected EndpointAddress getLogicalDestinationImpl() {
            if (this.cachedMessenger == null) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Internal messenger error: logical destination requested while not connected.");
                }
                return null;
            }
            return this.cachedMessenger.getLogicalDestinationAddress();
        }

        protected void sendMessageBImpl(Message msg, String service, String param) throws IOException {
            if (this.cachedMessenger == null) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)"Internal messenger error: send requested while not connected.");
                }
                throw new IOException("Internal messenger error.");
            }
            try {
                this.cachedMessenger.sendMessageB(msg, service, param);
            }
            catch (IOException any) {
                this.cachedMessenger = null;
                throw any;
            }
        }
    }

    private static class FilterListenerAndMask {
        public String namespace;
        public String name;
        public MessageFilterListener listener;

        public FilterListenerAndMask(MessageFilterListener listener, String namespace, String name) {
            this.namespace = namespace;
            this.name = name;
            this.listener = listener;
        }

        public boolean equals(Object target) {
            if (this == target) {
                return true;
            }
            if (null == target) {
                return false;
            }
            if (target instanceof FilterListenerAndMask) {
                boolean result;
                FilterListenerAndMask likeMe = (FilterListenerAndMask)target;
                boolean bl = null != this.namespace ? this.namespace.equals(likeMe.namespace) : (result = null == likeMe.namespace);
                boolean bl2 = (result &= null != this.name ? this.name.equals(likeMe.name) : null == likeMe.name) & this.listener == likeMe.listener;
            }
            return false;
        }
    }
}

