/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.endpoint;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Timer;
import java.util.TimerTask;
import net.jxta.endpoint.AbstractMessenger;
import net.jxta.endpoint.ChannelMessenger;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerState;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.impl.util.TimerThreadNamer;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.util.SimpleSelectable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class BlockingMessenger
extends AbstractMessenger {
    private static final Logger LOG = Logger.getLogger((String)BlockingMessenger.class.getName());
    private Message currentMessage = null;
    private String currentService = null;
    private String currentParam = null;
    private Throwable currentThrowable = null;
    private boolean inputClosed = false;
    private PeerGroupID homeGroupID = null;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_SEND = 1;
    private static final int ACTION_CONNECT = 2;
    private int deferredAction = 0;
    private Object owner = null;
    private static Timer timer = new Timer(true);
    private TimerTask selfDestructTask = null;
    private BlockingMessengerState stateMachine = new BlockingMessengerState();
    private boolean lieToOldTransports = false;

    private void storeCurrent(Message msg, String service, String param) {
        this.currentMessage = msg;
        this.currentService = service;
        this.currentParam = param;
        this.currentThrowable = null;
    }

    public BlockingMessenger(PeerGroupID homeGroupID, EndpointAddress dest, boolean selfDestruct) {
        super(dest);
        this.homeGroupID = homeGroupID;
        this.setStateLock(this.stateMachine);
        if (selfDestruct) {
            this.selfDestructTask = new TimerTask(){

                public void run() {
                    if (BlockingMessenger.this.isIdleImpl()) {
                        BlockingMessenger.this.close();
                        this.cancel();
                    }
                }
            };
            timer.schedule(this.selfDestructTask, 60000L, 60000L);
        }
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }

    protected EndpointAddress getDestAddressToUse(String service, String serviceParam) {
        EndpointAddress result = this.getDestinationAddress();
        if (null != service) {
            result.setServiceName(service);
        }
        if (null != serviceParam) {
            result.setServiceParameter(serviceParam);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdown() {
        int action;
        BlockingMessengerState blockingMessengerState = this.stateMachine;
        synchronized (blockingMessengerState) {
            this.stateMachine.shutdownEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    public boolean isClosed() {
        return !this.lieToOldTransports && (this.getState() & 0x70000) != 0;
    }

    public final EndpointAddress getLogicalDestinationAddress() {
        return this.getLogicalDestinationImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        int action;
        BlockingMessengerState blockingMessengerState = this.stateMachine;
        synchronized (blockingMessengerState) {
            this.stateMachine.closeEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessageB(Message msg, String service, String serviceParam) throws IOException {
        int action = 0;
        BlockingMessengerState blockingMessengerState = this.stateMachine;
        synchronized (blockingMessengerState) {
            try {
                while (this.currentMessage != null && !this.inputClosed) {
                    this.stateMachine.wait();
                }
            }
            catch (InterruptedException ie) {
                throw new InterruptedIOException();
            }
            if (this.inputClosed) {
                throw new IOException("Messenger is closed. It cannot be used to send messages");
            }
            this.storeCurrent(msg, service, serviceParam);
            this.stateMachine.saturatedEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
        Throwable failure = null;
        BlockingMessengerState blockingMessengerState2 = this.stateMachine;
        synchronized (blockingMessengerState2) {
            if (this.currentMessage == msg) {
                failure = this.currentThrowable;
                if (failure == null) {
                    failure = new IOException("Unknown error");
                }
                this.storeCurrent(null, null, null);
            }
        }
        if (failure == null) {
            msg.setMessageProperty(Messenger.class, OutgoingMessageEvent.SUCCESS);
            return;
        }
        if (failure instanceof IOException) {
            throw (IOException)failure;
        }
        if (failure instanceof RuntimeException) {
            throw (RuntimeException)failure;
        }
        if (failure instanceof Error) {
            throw (Error)failure;
        }
        throw new UndeclaredThrowableException(failure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendMessageN(Message msg, String service, String serviceParam) {
        boolean closed;
        boolean queued = false;
        int action = 0;
        BlockingMessengerState blockingMessengerState = this.stateMachine;
        synchronized (blockingMessengerState) {
            closed = this.inputClosed;
            if (!closed && this.currentMessage == null) {
                this.storeCurrent(msg, service, serviceParam);
                this.stateMachine.saturatedEvent();
                action = this.eventCalled();
                queued = true;
            }
        }
        if (queued) {
            this.notifyChange();
            this.performDeferredAction(action);
            blockingMessengerState = this.stateMachine;
            synchronized (blockingMessengerState) {
                if (this.currentMessage == msg) {
                    if (this.currentThrowable == null) {
                        this.currentThrowable = new IOException("Unknown error");
                    }
                    msg.setMessageProperty(Message.class, this.currentThrowable);
                    this.storeCurrent(null, null, null);
                } else {
                    msg.setMessageProperty(Message.class, OutgoingMessageEvent.SUCCESS);
                }
            }
            return true;
        }
        msg.setMessageProperty(Messenger.class, closed ? new OutgoingMessageEvent(msg, new IOException("This messenger is closed. It cannot be used to send messages.")) : OutgoingMessageEvent.OVERFLOW);
        return false;
    }

    public final void resolve() {
    }

    public final int getState() {
        return this.stateMachine.getState();
    }

    public final Messenger getChannelMessenger(PeerGroupID redirection, String service, String serviceParam) {
        return new BlockingMessengerChannel(this.getDestinationAddress(), this.homeGroupID.equals(redirection) ? null : redirection, service, serviceParam);
    }

    private void performDeferredAction(int action) {
        switch (action) {
            case 1: {
                this.sendIt();
                break;
            }
            case 2: {
                this.cantConnect();
            }
        }
    }

    private int eventCalled() {
        int action = this.deferredAction;
        this.deferredAction = 0;
        this.stateMachine.notifyAll();
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendIt() {
        if (this.currentMessage == null) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Internal error. Asked to send with no message.");
            }
            return;
        }
        int action = 0;
        try {
            this.sendMessageBImpl(this.currentMessage, this.currentService, this.currentParam);
        }
        catch (Throwable any) {
            BlockingMessengerState blockingMessengerState = this.stateMachine;
            synchronized (blockingMessengerState) {
                this.currentThrowable = any;
                this.stateMachine.downEvent();
                action = this.eventCalled();
            }
            this.notifyChange();
            this.performDeferredAction(action);
            return;
        }
        BlockingMessengerState blockingMessengerState = this.stateMachine;
        synchronized (blockingMessengerState) {
            this.storeCurrent(null, null, null);
            this.stateMachine.idleEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cantConnect() {
        int action;
        BlockingMessengerState blockingMessengerState = this.stateMachine;
        synchronized (blockingMessengerState) {
            this.stateMachine.downEvent();
            action = this.eventCalled();
        }
        this.notifyChange();
        this.performDeferredAction(action);
    }

    protected abstract void closeImpl();

    protected abstract boolean sendMessageBImpl(Message var1, String var2, String var3) throws IOException;

    protected abstract boolean isIdleImpl();

    protected abstract EndpointAddress getLogicalDestinationImpl();

    static {
        timer.schedule((TimerTask)new TimerThreadNamer("BlockingMessenger self destruct timer"), 0L);
    }

    private class BlockingMessengerChannel
    extends ChannelMessenger {
        public BlockingMessengerChannel(EndpointAddress baseAddress, PeerGroupID redirection, String origService, String origServiceParam) {
            super(baseAddress, redirection, origService, origServiceParam);
            this.setStateLock(BlockingMessenger.this.stateMachine);
        }

        public int getState() {
            return BlockingMessenger.this.getState();
        }

        public void resolve() {
            BlockingMessenger.this.resolve();
        }

        public void close() {
            BlockingMessenger.this.close();
        }

        public boolean sendMessageN(Message msg, String service, String serviceParam) {
            return BlockingMessenger.this.sendMessageN(msg, this.effectiveService(service), this.effectiveParam(service, serviceParam));
        }

        public void sendMessageB(Message msg, String service, String serviceParam) throws IOException {
            BlockingMessenger.this.sendMessageB(msg, this.effectiveService(service), this.effectiveParam(service, serviceParam));
        }

        public EndpointAddress getLogicalDestinationAddress() {
            EndpointAddress rawLogical = BlockingMessenger.this.getLogicalDestinationImpl();
            if (rawLogical == null) {
                return null;
            }
            return new EndpointAddress(rawLogical, this.origService, this.origServiceParam);
        }

        public void itemChanged(Object changedObject) {
            if (!this.notifyChange()) {
                if (this.haveListeners()) {
                    return;
                }
                BlockingMessenger.this.unregisterListener(this);
                if (!this.haveListeners()) {
                    return;
                }
                BlockingMessenger.this.registerListener(this);
            }
        }

        protected void registerListener(SimpleSelectable l) {
            BlockingMessenger.this.registerListener(this);
            super.registerListener(l);
        }
    }

    private class BlockingMessengerState
    extends MessengerState {
        protected BlockingMessengerState() {
            super(true);
        }

        protected void connectAction() {
            BlockingMessenger.this.deferredAction = 2;
        }

        protected void startAction() {
            BlockingMessenger.this.deferredAction = 1;
        }

        protected void closeInputAction() {
            BlockingMessenger.this.inputClosed = true;
        }

        protected void closeOutputAction() {
            BlockingMessenger.this.lieToOldTransports = true;
            BlockingMessenger.this.closeImpl();
            BlockingMessenger.this.lieToOldTransports = false;
            if (BlockingMessenger.this.selfDestructTask != null) {
                BlockingMessenger.this.selfDestructTask.cancel();
            }
        }

        protected void failAllAction() {
            if (BlockingMessenger.this.currentMessage == null) {
                return;
            }
            if (BlockingMessenger.this.currentThrowable == null) {
                BlockingMessenger.this.currentThrowable = new IOException("Messenger unexpectedly closed");
            }
        }
    }
}

