/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.jxta.id.IDFactory;
import net.jxta.impl.cm.Cm;
import net.jxta.impl.cm.Indexer;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.PeerGroup;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SrdiIndex
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)SrdiIndex.class.getName());
    private long interval = 600000L;
    private volatile boolean stop = false;
    private Indexer srdiIndexer = null;
    private BTreeFiler cacheDB = null;
    private Thread gcThread = null;
    private final String indexName;

    public SrdiIndex(PeerGroup group, String indexName) {
        this.indexName = indexName;
        try {
            String pgdir = null;
            pgdir = group == null ? "srdi-index" : group.getPeerGroupID().getUniqueValue().toString();
            File rootDir = new File(Cm.ROOTDIRBASE, pgdir);
            rootDir = new File(rootDir, "srdi");
            if (!rootDir.exists() && !rootDir.mkdirs()) {
                throw new RuntimeException("Cm cannot create directory " + rootDir);
            }
            this.cacheDB = new BTreeFiler();
            this.cacheDB.setSync(false);
            this.cacheDB.setLocation(rootDir.getCanonicalPath(), indexName);
            if (!this.cacheDB.open()) {
                this.cacheDB.create();
                this.cacheDB.open();
            }
            this.srdiIndexer = new Indexer(false);
            this.srdiIndexer.setLocation(rootDir.getCanonicalPath(), indexName);
            if (!this.srdiIndexer.open()) {
                this.srdiIndexer.create();
                this.srdiIndexer.open();
            }
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("[" + (group == null ? "none" : group.getPeerGroupName()) + "] : " + "Initialized " + indexName));
            }
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)"Unable to Initialize databases", (Throwable)de);
            }
            throw new UndeclaredThrowableException(de, "Unable to Initialize databases");
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                LOG.error((Object)"Unable to create Cm", e);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new UndeclaredThrowableException(e, "Unable to create Cm");
        }
    }

    public SrdiIndex(PeerGroup group, String indexName, long interval) {
        this(group, indexName);
        this.interval = interval;
        this.startGC(group, indexName, interval);
    }

    protected synchronized void startGC(PeerGroup group, String indexName, long interval) {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)("[" + (group == null ? "none" : group.getPeerGroupName()) + "] : Starting SRDI GC Thread for " + indexName));
        }
        this.gcThread = new Thread(group.getHomeThreadGroup(), this, "SrdiIndex GC :" + indexName + " every " + interval + "ms");
        this.gcThread.setDaemon(true);
        this.gcThread.start();
    }

    public String getIndexName() {
        return this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(String primaryKey, String attribute, String value, PeerID pid, long expiration) {
        block12: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.indexName + "] Adding " + primaryKey + "/" + attribute + " = '" + value + "' for " + pid));
            }
            try {
                Key key = new Key(primaryKey + attribute + value);
                long expiresin = TimeUtils.toAbsoluteTimeMillis(expiration);
                BTreeFiler bTreeFiler = this.cacheDB;
                synchronized (bTreeFiler) {
                    Record record = this.cacheDB.readRecord(key);
                    ArrayList old = record != null ? SrdiIndex.readRecord(record) : new ArrayList();
                    Entry entry = new Entry(pid, expiresin);
                    if (!old.contains(entry)) {
                        old.add(entry);
                    } else {
                        old.remove(old.indexOf(entry));
                        old.add(entry);
                    }
                    old = SrdiIndex.removeExpired(old);
                    long t0 = System.currentTimeMillis();
                    byte[] data = SrdiIndex.getData(old);
                    if (data == null) {
                        if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                            LOG.error((Object)"Failed to serialize data");
                        }
                        return;
                    }
                    Value recordValue = new Value(data);
                    long pos = this.cacheDB.writeRecord(key, recordValue);
                    Map indexables = this.getIndexMap(primaryKey + attribute, value);
                    this.srdiIndexer.addToIndex(indexables, pos);
                }
            }
            catch (IOException de) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Failed to add SRDI", (Throwable)de);
                }
            }
            catch (DBException de) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block12;
                LOG.warn((Object)"Failed to add SRDI", (Throwable)de);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getRecord(String pkey, String skey, String value) {
        Record record;
        block5: {
            record = null;
            try {
                Key key = new Key(pkey + skey + value);
                BTreeFiler bTreeFiler = this.cacheDB;
                synchronized (bTreeFiler) {
                    record = this.cacheDB.readRecord(key);
                }
            }
            catch (DBException de) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"Failed to retrieve SrdiIndex record", (Throwable)de);
            }
        }
        return SrdiIndex.readRecord(record);
    }

    private Map getIndexMap(String primaryKey, String value) {
        if (primaryKey == null) {
            return null;
        }
        if (value == null) {
            value = "";
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(primaryKey, value.toUpperCase());
        return map;
    }

    public synchronized void remove(PeerID pid) {
        block4: {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("[" + this.indexName + "] Removing all keys for " + pid));
                }
                Map map = this.srdiIndexer.getIndexers();
                Iterator it = map.keySet().iterator();
                while (it != null && it.hasNext()) {
                    String indexName = (String)it.next();
                    NameIndexer idxr = (NameIndexer)map.get(indexName);
                    idxr.query(null, new PurgePeerCallback(this.cacheDB, pid));
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)("Failure during removal of " + pid), (Throwable)ex);
            }
        }
    }

    public synchronized Vector query(String primaryKey, String attribute, String value, int threshold) {
        Vector res;
        block7: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.indexName + "] Querying for " + threshold + " " + primaryKey + "/" + attribute + " = '" + value + "'"));
            }
            if (primaryKey == null) {
                return new Vector();
            }
            if (attribute == null) {
                res = this.query(primaryKey);
            } else {
                res = new Vector();
                IndexQuery iq = Cm.getIndexQuery(value);
                try {
                    this.srdiIndexer.search(iq, primaryKey + attribute, new SearchCallback(this.cacheDB, res, threshold));
                }
                catch (Exception ex) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block7;
                    LOG.warn((Object)"Exception while searching in index", (Throwable)ex);
                }
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.indexName + "] Returning " + res.size() + " results for " + primaryKey + "/" + attribute + " = '" + value + "'"));
        }
        return res;
    }

    public synchronized Vector query(String primaryKey) {
        Vector res;
        block5: {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("[" + this.indexName + "] Querying for " + primaryKey));
            }
            res = new Vector();
            try {
                Map map = this.srdiIndexer.getIndexers();
                Iterator it = map.keySet().iterator();
                while (it != null && it.hasNext()) {
                    String indexName = (String)it.next();
                    if (!indexName.startsWith(primaryKey)) continue;
                    NameIndexer idxr = (NameIndexer)map.get(indexName);
                    idxr.query(null, new SearchCallback(this.cacheDB, res, Integer.MAX_VALUE));
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block5;
                LOG.warn((Object)"Exception while searching in index", (Throwable)ex);
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("[" + this.indexName + "] Returning " + res.size() + " results for " + primaryKey));
        }
        return res;
    }

    private static void copyIntoVector(Vector to, ArrayList from) {
        for (int i = 0; i < from.size(); ++i) {
            Entry entry = (Entry)from.get(i);
            boolean expired = SrdiIndex.isExpired(entry.expiration);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Entry peerid : " + entry.peerid + " Expires at : " + entry.expiration));
                LOG.debug((Object)("Entry expired " + expired));
            }
            if (!to.contains(entry.peerid) && !expired) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("adding Entry :" + entry.peerid + " to list"));
                }
                to.add(entry.peerid);
                continue;
            }
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Skipping expired Entry :" + entry.peerid));
        }
    }

    private static byte[] getData(List list) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeInt(list.size());
            Iterator eachEntry = list.iterator();
            while (eachEntry.hasNext()) {
                Entry anEntry = (Entry)eachEntry.next();
                dos.writeUTF(anEntry.peerid.toString());
                dos.writeLong(anEntry.expiration);
            }
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException ie) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Exception while reading Entry", (Throwable)ie);
            }
            return null;
        }
    }

    public static ArrayList readRecord(Record record) {
        ArrayList<Entry> result;
        block9: {
            result = new ArrayList<Entry>();
            if (record == null) {
                return result;
            }
            if (record.getValue().getLength() <= 0) {
                return result;
            }
            InputStream is = record.getValue().getInputStream();
            try {
                DataInputStream ois = new DataInputStream(is);
                int size = ois.readInt();
                for (int i = 0; i < size; ++i) {
                    try {
                        String idstr = ois.readUTF();
                        PeerID pid = (PeerID)IDFactory.fromURI(new URI(idstr));
                        long exp = ois.readLong();
                        Entry entry = new Entry(pid, exp);
                        result.add(entry);
                        continue;
                    }
                    catch (URISyntaxException badID) {
                        // empty catch block
                    }
                }
                ois.close();
            }
            catch (EOFException eofe) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Empty record", (Throwable)eofe);
                }
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                LOG.warn((Object)"Exception while reading Entry", (Throwable)ie);
            }
        }
        return result;
    }

    public synchronized void clear() {
        block2: {
            try {
                this.srdiIndexer.close();
                this.cacheDB.close();
            }
            catch (Exception e) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"failed to close index", (Throwable)e);
            }
        }
    }

    public synchronized void garbageCollect() {
        block3: {
            try {
                Map map = this.srdiIndexer.getIndexers();
                Iterator it = map.keySet().iterator();
                while (it.hasNext()) {
                    String indexName = (String)it.next();
                    NameIndexer idxr = (NameIndexer)map.get(indexName);
                    idxr.query(null, new GcCallback(this.cacheDB));
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block3;
                LOG.warn((Object)"Failure during SRDI Garbage Collect", (Throwable)ex);
            }
        }
    }

    private static ArrayList removeExpired(ArrayList list) {
        for (int i = 0; i < list.size(); ++i) {
            Entry entry = (Entry)list.get(i);
            boolean expired = SrdiIndex.isExpired(entry.expiration);
            if (!expired) continue;
            list.remove(i);
            --i;
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Entry peerid :" + entry.peerid + " Expires at :" + entry.expiration));
            LOG.debug((Object)("Entry expired " + expired));
        }
        return list;
    }

    private static boolean isExpired(long expiration) {
        return expiration < System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        block8: {
            block7: {
                this.stop = true;
                try {
                    Thread temp = this.gcThread;
                    if (temp == null) break block7;
                    Thread thread = temp;
                    synchronized (thread) {
                        temp.notify();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try {
                this.srdiIndexer.close();
                this.cacheDB.close();
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block8;
                LOG.error((Object)"Unable to stop the Srdi Indexer", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {}
            catch (Throwable all) {
                if (LOG.isEnabledFor((Priority)Level.ERROR)) {
                    LOG.error((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
                }
                Object var4_5 = null;
                SrdiIndex srdiIndex = this;
                synchronized (srdiIndex) {
                    this.gcThread = null;
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            SrdiIndex srdiIndex3 = this;
            synchronized (srdiIndex3) {
                this.gcThread = null;
                throw throwable;
            }
        }
        while (!this.stop) {
            try {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Waiting for " + this.interval + "ms before garbage collection"));
                }
                Thread thread = this.gcThread;
                synchronized (thread) {
                    this.gcThread.wait(this.interval);
                }
            }
            catch (InterruptedException woken) {
                Thread.interrupted();
                continue;
            }
            if (this.stop) break;
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Garbage collection started");
            }
            this.garbageCollect();
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)"Garbage collection completed");
        }
        Object var4_4 = null;
        SrdiIndex srdiIndex = this;
        synchronized (srdiIndex) {
            this.gcThread = null;
            return;
        }
    }

    public static void clearSrdi(PeerGroup group) {
        block6: {
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Clearing SRDI for " + group.getPeerGroupName()));
            }
            try {
                String pgdir = null;
                pgdir = group == null ? "srdi-index" : group.getPeerGroupID().getUniqueValue().toString();
                File rootDir = new File(Cm.ROOTDIRBASE, pgdir);
                rootDir = new File(rootDir, "srdi");
                if (rootDir.exists()) {
                    String[] list = rootDir.list();
                    for (int i = 0; i < list.length; ++i) {
                        File file;
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("Removing : " + list[i]));
                        }
                        if ((file = new File(rootDir, list[i])).delete() || !LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)"Unable to delete the file");
                    }
                    rootDir.delete();
                }
            }
            catch (Throwable t) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block6;
                LOG.warn((Object)"Unable to clear Srdi", t);
            }
        }
    }

    public static final class Entry {
        public PeerID peerid;
        public long expiration;

        public Entry(PeerID peerid, long expiration) {
            this.peerid = peerid;
            this.expiration = expiration;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return this.peerid.equals(((Entry)obj).peerid);
            }
            return false;
        }

        public int hashCode() {
            return this.peerid.hashCode();
        }
    }

    private static final class PurgePeerCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private PeerID peerid = null;

        PurgePeerCallback(BTreeFiler cacheDB, PeerID peerid) {
            this.cacheDB = cacheDB;
            this.peerid = peerid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            BTreeFiler bTreeFiler = this.cacheDB;
            synchronized (bTreeFiler) {
                block16: {
                    try {
                        record = this.cacheDB.readRecord(pos);
                    }
                    catch (DBException ex) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                        }
                        return false;
                    }
                    if (record == null) {
                        return true;
                    }
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("PurgePeerCallback :" + pos));
                    }
                    ArrayList res = SrdiIndex.readRecord(record);
                    boolean changed = false;
                    for (int i = 0; i < res.size(); ++i) {
                        Entry entry = (Entry)res.get(i);
                        if (!entry.peerid.equals(this.peerid)) continue;
                        res.remove(i);
                        changed = true;
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                        LOG.debug((Object)("Removed position :" + pos));
                    }
                    if (changed) {
                        if (res.size() == 0) {
                            try {
                                this.cacheDB.deleteRecord(record.getKey());
                            }
                            catch (DBException e) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Exception while deleting blank record", (Throwable)e);
                                }
                                break block16;
                            }
                        }
                        byte[] data = SrdiIndex.getData(res);
                        Value recordValue = new Value(data);
                        try {
                            this.cacheDB.writeRecord(pos, recordValue);
                        }
                        catch (DBException ex) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block16;
                            LOG.warn((Object)"Exception while writing back record", (Throwable)ex);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static final class GcCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;

        GcCallback(BTreeFiler cacheDB) {
            this.cacheDB = cacheDB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexInfo(Value val, long pos) {
            Record record = null;
            BTreeFiler bTreeFiler = this.cacheDB;
            synchronized (bTreeFiler) {
                block15: {
                    try {
                        record = this.cacheDB.readRecord(pos);
                    }
                    catch (DBException ex) {
                        if (LOG.isEnabledFor((Priority)Level.WARN)) {
                            LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                        }
                        return false;
                    }
                    if (record == null) {
                        return true;
                    }
                    ArrayList res = SrdiIndex.readRecord(record);
                    boolean changed = false;
                    for (int i = 0; i < res.size(); ++i) {
                        Entry entry = (Entry)res.get(i);
                        if (!SrdiIndex.isExpired(entry.expiration)) continue;
                        res.remove(i);
                        changed = true;
                    }
                    if (changed) {
                        if (res.size() == 0) {
                            try {
                                this.cacheDB.deleteRecord(record.getKey());
                            }
                            catch (DBException e) {
                                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                    LOG.warn((Object)"Exception while deleting blank record", (Throwable)e);
                                }
                                break block15;
                            }
                        }
                        byte[] data = SrdiIndex.getData(res);
                        Value recordValue = new Value(data);
                        try {
                            this.cacheDB.writeRecord(pos, recordValue);
                        }
                        catch (DBException ex) {
                            if (!LOG.isEnabledFor((Priority)Level.WARN)) break block15;
                            LOG.warn((Object)"Exception while writing back record", (Throwable)ex);
                        }
                    }
                }
            }
            return true;
        }
    }

    private static final class SearchCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private int threshold;
        private Vector results;

        SearchCallback(BTreeFiler cacheDB, Vector results, int threshold) {
            this.cacheDB = cacheDB;
            this.threshold = threshold;
            this.results = results;
        }

        public boolean indexInfo(Value val, long pos) {
            if (this.results.size() >= this.threshold) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("SearchCallback.indexInfo reached Threshold :" + this.threshold));
                }
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Found " + val.toString()));
            }
            Record record = null;
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                }
                return false;
            }
            if (record == null) {
                return true;
            }
            long t0 = System.currentTimeMillis();
            ArrayList res = SrdiIndex.readRecord(record);
            SrdiIndex.copyIntoVector(this.results, res);
            return true;
        }
    }
}

