/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.cm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocument;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.impl.cm.Indexer;
import net.jxta.impl.config.Config;
import net.jxta.impl.util.JxtaHash;
import net.jxta.impl.util.TimeUtils;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.BTreeCallback;
import net.jxta.impl.xindice.core.filer.BTreeException;
import net.jxta.impl.xindice.core.filer.BTreeFiler;
import net.jxta.impl.xindice.core.indexer.IndexQuery;
import net.jxta.impl.xindice.core.indexer.NameIndexer;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.protocol.SrdiMessage;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class Cm
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)Cm.class.getName());
    public static final File ROOTDIRBASE = new File(Config.JXTA_HOME + "cm");
    private static final String[] DIRNAME = new String[]{"Peers", "Groups", "Adv", "Raw"};
    public static final long DEFAULT_GC_MAX_INTERVAL = 3600000L;
    private BTreeFiler cacheDB = null;
    private Indexer indexer = null;
    private static final String databaseFileName = "advertisements";
    private boolean stop = false;
    private boolean trackDeltas = false;
    private Map deltaMap = new HashMap(3);
    protected File rootDir;
    private ThreadGroup threads = null;
    private Thread gcThread = null;
    private long gcTime = 0L;
    private long gcMinInterval = 60000L;
    private long gcMaxInterval = 3600000L;
    private int maxInconvenienceLevel = 1000;
    private volatile int inconvenienceLevel = 0;

    public Cm(String areaName, boolean enableOptimize) {
        this(Thread.currentThread().getThreadGroup(), areaName, enableOptimize, 3600000L, false);
    }

    public Cm(ThreadGroup threads, String areaName, boolean enableOptimize, long gcinterval, boolean trackDeltas) {
        this.threads = threads;
        this.trackDeltas = trackDeltas;
        this.gcMaxInterval = gcinterval;
        this.gcTime = System.currentTimeMillis() + this.gcMaxInterval;
        try {
            this.rootDir = new File(ROOTDIRBASE, areaName);
            this.rootDir = new File(this.rootDir.getAbsolutePath());
            if (!this.rootDir.exists() && !this.rootDir.mkdirs()) {
                throw new RuntimeException("Cm cannot create directory " + this.rootDir);
            }
            boolean chkPoint = true;
            ResourceBundle jxtaRsrcs = ResourceBundle.getBundle("net.jxta.user");
            String checkpointStr = jxtaRsrcs.getString("impl.cm.defferedcheckpoint");
            if (checkpointStr != null) {
                chkPoint = !checkpointStr.equalsIgnoreCase("true");
            }
            this.cacheDB = new BTreeFiler();
            this.cacheDB.setSync(chkPoint);
            this.cacheDB.setLocation(this.rootDir.getAbsolutePath(), databaseFileName);
            if (!this.cacheDB.open()) {
                this.cacheDB.create();
                this.cacheDB.open();
            }
            this.indexer = new Indexer(chkPoint);
            this.indexer.setLocation(this.rootDir.getAbsolutePath(), databaseFileName);
            if (!this.indexer.open()) {
                this.indexer.create();
                this.indexer.open();
            }
            if (System.getProperty("net.jxta.impl.cm.index.rebuild") != null) {
                this.rebuildIndex();
            }
            this.gcThread = new Thread(threads, this, "CM GC Thread interval : " + this.gcMinInterval);
            this.gcThread.setDaemon(true);
            this.gcThread.start();
            if (LOG.isEnabledFor((Priority)Level.INFO)) {
                LOG.info((Object)("Instantiated Cm for: " + this.rootDir.getAbsolutePath()));
            }
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)"Unable to Initialize databases", (Throwable)de);
            }
            throw new UndeclaredThrowableException(de, "Unable to Initialize databases");
        }
        catch (Throwable e) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)"Unable to create Cm", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new UndeclaredThrowableException(e, "Unable to create Cm");
        }
    }

    public String toString() {
        return "CM for " + this.rootDir.getAbsolutePath() + "[" + super.toString() + "]";
    }

    private static String getDirName(Advertisement adv) {
        if (adv instanceof PeerAdvertisement) {
            return DIRNAME[0];
        }
        if (adv instanceof PeerGroupAdvertisement) {
            return DIRNAME[1];
        }
        return DIRNAME[2];
    }

    public static String createTmpName(StructuredDocument doc) {
        try {
            StringWriter out = new StringWriter();
            ((StructuredTextDocument)doc).sendToWriter(out);
            JxtaHash digester = new JxtaHash(out.toString());
            BigInteger hash = digester.getDigestInteger();
            if (hash.compareTo(BigInteger.ZERO) < 0) {
                hash = hash.negate();
            }
            String strHash = "cm" + hash.toString(16);
            out.close();
            return strHash;
        }
        catch (IOException ex) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Exception creating tmp name: ", (Throwable)ex);
            }
            return null;
        }
    }

    public Vector getRecords(String dn, int threshold, Vector values, Vector expirations) {
        return this.getRecords(dn, threshold, values, expirations, false);
    }

    public synchronized Vector getRecords(String dn, int threshold, Vector values, Vector expirations, boolean purge) {
        Vector res;
        block6: {
            res = new Vector();
            if (dn == null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"null directory name");
                }
                return res;
            }
            IndexQuery iq = new IndexQuery(7, new Value(dn));
            try {
                this.cacheDB.query(iq, new SearchCallback(this.cacheDB, this.indexer, res, expirations, threshold, purge));
            }
            catch (DBException dbe) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Exception during getRecords(): ", (Throwable)dbe);
                }
            }
            catch (IOException ie) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block6;
                LOG.debug((Object)"Exception during getRecords(): ", (Throwable)ie);
            }
        }
        return res;
    }

    public void garbageCollect() {
        Map map = this.indexer.getIndexers();
        Iterator it = map.keySet().iterator();
        long t0 = 0L;
        while (it != null && it.hasNext()) {
            t0 = System.currentTimeMillis();
            String indexName = (String)it.next();
            this.getRecords(indexName, Integer.MAX_VALUE, null, null, true);
            if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
            LOG.debug((Object)("Cm garbageCollect :" + indexName + " in :" + (System.currentTimeMillis() - t0)));
        }
    }

    public synchronized long getLifetime(String dn, String fn) {
        try {
            Long life;
            block9: {
                Key key = new Key(dn + "/" + fn);
                Record record = this.cacheDB.readRecord(key);
                if (record == null) {
                    return -1L;
                }
                life = (Long)record.getMetaData("lifetime");
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Lifetime for :" + fn + "  " + life.toString()));
                }
                if (life < System.currentTimeMillis()) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing expired record :" + fn));
                    }
                    try {
                        this.remove(dn, fn);
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block9;
                        LOG.debug((Object)"Failed to remove record", (Throwable)e);
                    }
                }
            }
            return TimeUtils.toRelativeTimeMillis(life);
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("failed to remove " + dn + "/" + fn), (Throwable)de);
            }
            return -1L;
        }
    }

    public synchronized long getExpirationtime(String dn, String fn) {
        try {
            long expiration;
            block8: {
                Key key = new Key(dn + "/" + fn);
                Record record = this.cacheDB.readRecord(key);
                expiration = Cm.calcExpiration(record);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Expiration for :" + fn + "  " + expiration));
                }
                if (expiration < 0L) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing expired record :" + fn));
                    }
                    try {
                        this.remove(dn, fn);
                    }
                    catch (IOException e) {
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block8;
                        LOG.debug((Object)"Failed to remove record", (Throwable)e);
                    }
                }
            }
            return expiration;
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("failed to get " + dn + "/" + fn), (Throwable)de);
            }
            return -1L;
        }
    }

    private static long calcExpiration(Record record) {
        if (record == null) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)"Record is null returning expiration of -1");
            }
            return -1L;
        }
        Long exp = (Long)record.getMetaData("expiration");
        Long life = (Long)record.getMetaData("lifetime");
        long expiresin = life - System.currentTimeMillis();
        if (expiresin <= 0L) {
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Record expired lifetime   : " + life + " expiration: " + exp + " expires in: " + expiresin));
                LOG.debug((Object)("Record expires on :" + new Date(life)));
            }
            return -1L;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Record lifetime: " + life + " expiration: " + exp + " expires in: " + expiresin));
            LOG.debug((Object)("Record expires on :" + new Date(life)));
        }
        return Math.min(expiresin, exp);
    }

    public InputStream getInputStream(String dn, String fn) throws IOException {
        Key key = new Key(dn + "/" + fn);
        try {
            Value val;
            Record record = this.cacheDB.readRecord(key);
            if (record == null) {
                return null;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Restored record for " + key));
            }
            if ((val = record.getValue()) != null) {
                return val.getInputStream();
            }
            return null;
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("Failed to restore record for " + key), (Throwable)de);
            }
            IOException failure = new IOException("Failed to restore record for " + key);
            failure.initCause(de);
            throw failure;
        }
    }

    public synchronized void remove(String dn, String fn) throws IOException {
        block7: {
            try {
                if (fn == null) {
                    return;
                }
                Key key = new Key(dn + "/" + fn);
                Record record = this.cacheDB.readRecord(key);
                long removePos = this.cacheDB.findValue(key);
                this.cacheDB.deleteRecord(key);
                if (record == null) break block7;
                try {
                    InputStream is = record.getValue().getInputStream();
                    Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, is);
                    Map indexables = Cm.getIndexfields(adv.getIndexFields(), (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8));
                    this.indexer.removeFromIndex(Cm.addKey(dn, indexables), removePos);
                    this.addDelta(dn, indexables, 0L);
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("removed " + record));
                    }
                }
                catch (Exception e) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)("failed to remove " + dn + "/" + fn), (Throwable)e);
                    }
                }
            }
            catch (DBException de) {
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block7;
                LOG.debug((Object)("failed to remove " + dn + "/" + fn));
            }
        }
    }

    public StructuredDocument restore(String dn, String fn) throws IOException {
        InputStream is = this.getInputStream(dn, fn);
        return StructuredDocumentFactory.newStructuredDocument(MimeMediaType.XMLUTF8, is);
    }

    public synchronized byte[] restoreBytes(String dn, String fn) throws IOException {
        try {
            Value val;
            Key key = new Key(dn + "/" + fn);
            Record record = this.cacheDB.readRecord(key);
            if (record == null) {
                return null;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("restored " + record));
            }
            if ((val = record.getValue()) != null) {
                return val.getData();
            }
            return null;
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("failed to restore " + dn + "/" + fn), (Throwable)de);
            }
            IOException failure = new IOException("failed to restore " + dn + "/" + fn);
            failure.initCause(de);
            throw failure;
        }
    }

    public void save(String dn, String fn, Advertisement adv) throws IOException {
        this.save(dn, fn, adv, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public synchronized void save(String dn, String fn, Advertisement adv, long lifetime, long expiration) throws IOException {
        try {
            StructuredDocument doc;
            if (expiration < 0L || lifetime < 0L) {
                throw new IllegalArgumentException("cannot schedule negative expiry");
            }
            try {
                doc = (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException failure = new IOException("Advertisement couldn't be saved");
                failure.initCause(e);
                throw failure;
            }
            Key key = new Key(dn + "/" + fn);
            Long oldLife = null;
            Long oldExp = null;
            Record record = this.cacheDB.readRecord(key);
            if (record != null) {
                oldLife = (Long)record.getMetaData("lifetime");
                oldExp = (Long)record.getMetaData("expiration");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            doc.sendToStream(baos);
            baos.close();
            Value value = new Value(baos.toByteArray());
            baos = null;
            long absoluteLifetime = TimeUtils.toAbsoluteTimeMillis(lifetime);
            if (absoluteLifetime < lifetime) {
                absoluteLifetime = Long.MAX_VALUE;
            }
            if (oldLife != null) {
                if (absoluteLifetime < oldLife) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Overriding attempt to decrease adv lifetime from : " + new Date(oldLife) + " to :" + new Date(absoluteLifetime)));
                    }
                    absoluteLifetime = oldLife;
                }
                if (expiration < oldExp) {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Overriding attempt to decrease adv expiration from : " + oldExp + " to :" + expiration));
                    }
                    expiration = oldExp;
                }
            }
            if (expiration > lifetime) {
                expiration = lifetime;
            }
            long pos = this.cacheDB.writeRecord(key, value, absoluteLifetime, expiration);
            Map indexables = Cm.getIndexfields(adv.getIndexFields(), doc);
            Map keyedIdx = Cm.addKey(dn, indexables);
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Indexing " + keyedIdx + " at " + pos));
            }
            this.indexer.addToIndex(keyedIdx, pos);
            this.addDelta(dn, indexables, TimeUtils.toRelativeTimeMillis(absoluteLifetime));
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Stored " + indexables + " at " + pos));
            }
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("failed to write " + dn + "/" + fn + " " + lifetime + " " + expiration), (Throwable)de);
            }
            throw new IOException(de.getMessage());
        }
        catch (IOException e) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Cm cannot write doc", (Throwable)e);
            }
            throw e;
        }
    }

    public synchronized void save(String dn, String fn, byte[] data, long lifetime, long expiration) throws IOException {
        try {
            if (expiration < 0L || lifetime < 0L) {
                throw new IllegalArgumentException("cannot schedule negative expiry");
            }
            Key key = new Key(dn + "/" + fn);
            Long oldLife = null;
            Record record = this.cacheDB.readRecord(key);
            if (record != null) {
                oldLife = (Long)record.getMetaData("lifetime");
            }
            Value value = new Value(data);
            long absoluteLifetime = TimeUtils.toAbsoluteTimeMillis(lifetime);
            if (absoluteLifetime < lifetime) {
                absoluteLifetime = Long.MAX_VALUE;
            }
            if (oldLife != null) {
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Overriding attempt to decrease adv lifetime from : " + new Date(oldLife) + " to :" + new Date(absoluteLifetime)));
                }
                if (absoluteLifetime < oldLife) {
                    absoluteLifetime = oldLife;
                }
            }
            if (expiration > lifetime) {
                expiration = lifetime;
            }
            this.cacheDB.writeRecord(key, value, absoluteLifetime, expiration);
        }
        catch (DBException de) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)("failed to write " + dn + "/" + fn + " " + lifetime + " " + expiration), (Throwable)de);
            }
            throw new IOException(de.getMessage());
        }
    }

    private static Map getIndexfields(String[] fields, StructuredDocument doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (doc == null) {
            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                LOG.warn((Object)"Null document");
            }
            return map;
        }
        if (fields == null) {
            return map;
        }
        for (int i = 0; i < fields.length; ++i) {
            Enumeration en = doc.getChildren(fields[i]);
            while (en.hasMoreElements()) {
                String val = (String)((Element)en.nextElement()).getValue();
                if (val == null) continue;
                map.put(fields[i], val.toUpperCase());
            }
        }
        return map;
    }

    private static Map addKey(String dn, Map map) {
        if (map == null) {
            return null;
        }
        HashMap tmp = new HashMap();
        if (map.size() > 0) {
            Iterator it = map.keySet().iterator();
            while (it != null && it.hasNext()) {
                String name = (String)it.next();
                tmp.put(dn + name, map.get(name));
            }
        }
        return tmp;
    }

    protected static IndexQuery getIndexQuery(String value) {
        int operator = 0;
        if (value == null) {
            return null;
        }
        if (value.length() == 0 || "*".equals(value)) {
            return null;
        }
        if (value.indexOf("*") < 0) {
            operator = 1;
        } else if (value.charAt(0) == '*' && value.charAt(value.length() - 1) != '*') {
            operator = 8;
            value = value.substring(1, value.length());
        } else if (value.charAt(value.length() - 1) == '*' && value.charAt(0) != '*') {
            operator = 7;
            value = value.substring(0, value.length() - 1);
        } else {
            operator = 5;
            value = value.substring(1, value.length() - 1);
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("Index query operator :" + operator));
        }
        return new IndexQuery(operator, new Value(value.toUpperCase()));
    }

    public synchronized Vector search(String dn, String attribute, String value, int threshold, Vector expirations) {
        Vector res;
        block2: {
            res = new Vector();
            IndexQuery iq = Cm.getIndexQuery(value);
            try {
                this.indexer.search(iq, dn + attribute, new SearchCallback(this.cacheDB, this.indexer, res, expirations, threshold));
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block2;
                LOG.warn((Object)"Exception while searching in index", (Throwable)ex);
            }
        }
        return res;
    }

    public synchronized Vector getEntries(String dn, boolean clearDeltas) {
        Vector res;
        block4: {
            res = new Vector();
            try {
                Map map = this.indexer.getIndexers();
                BTreeFiler listDB = this.indexer.getListDB();
                Iterator it = map.keySet().iterator();
                while (it != null && it.hasNext()) {
                    String indexName = (String)it.next();
                    if (!indexName.startsWith(dn)) continue;
                    String attr = indexName.substring(dn.length());
                    NameIndexer idxr = (NameIndexer)map.get(indexName);
                    idxr.query(null, new Indexer.SearchCallback(listDB, new EntriesCallback(this.cacheDB, res, attr, Integer.MAX_VALUE)));
                }
            }
            catch (Exception ex) {
                if (!LOG.isEnabledFor((Priority)Level.WARN)) break block4;
                LOG.warn((Object)"Exception while searching in index", (Throwable)ex);
            }
        }
        if (clearDeltas) {
            this.clearDeltas(dn);
        }
        return res;
    }

    public synchronized Vector getDeltas(String dn) {
        Vector result = new Vector();
        List deltas = (List)this.deltaMap.get(dn);
        if (deltas != null) {
            result.addAll(deltas);
            deltas.clear();
        }
        return result;
    }

    private synchronized void clearDeltas(String dn) {
        List deltas = (List)this.deltaMap.get(dn);
        if (deltas == null) {
            return;
        }
        deltas.clear();
    }

    private synchronized void addDelta(String dn, Map indexables, long exp) {
        Iterator eachIndex;
        if (this.trackDeltas && (eachIndex = indexables.entrySet().iterator()).hasNext()) {
            ArrayList<SrdiMessage.Entry> deltas = (ArrayList<SrdiMessage.Entry>)this.deltaMap.get(dn);
            if (deltas == null) {
                deltas = new ArrayList<SrdiMessage.Entry>();
                this.deltaMap.put(dn, deltas);
            }
            while (eachIndex.hasNext()) {
                Map.Entry anEntry = eachIndex.next();
                String attr = (String)anEntry.getKey();
                String value = (String)anEntry.getValue();
                SrdiMessage.Entry entry = new SrdiMessage.Entry(attr, value, exp);
                deltas.add(entry);
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)("Added entry  :" + entry + " to deltas"));
            }
        }
    }

    public synchronized void setTrackDeltas(boolean trackDeltas) {
        this.trackDeltas = trackDeltas;
        if (!trackDeltas) {
            this.deltaMap.clear();
        }
    }

    public synchronized void stop() {
        block2: {
            try {
                this.cacheDB.close();
                this.indexer.close();
                this.stop = true;
                this.notify();
            }
            catch (DBException ex) {
                if (!LOG.isEnabledFor((Priority)Level.ERROR)) break block2;
                LOG.error((Object)"Unable to close advertisments.tbl", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void run() {
        try {
            while (!this.stop) {
                block12: {
                    try {
                        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                            LOG.debug((Object)("waiting " + this.gcMinInterval + "ms before garbage collection"));
                        }
                        this.wait(this.gcMinInterval);
                    }
                    catch (InterruptedException woken) {
                        Thread.interrupted();
                        if (!LOG.isEnabledFor((Priority)Level.DEBUG)) break block12;
                        LOG.debug((Object)"Thread interrupted", (Throwable)woken);
                    }
                }
                if (this.stop) {
                    break;
                }
                if (this.inconvenienceLevel <= this.maxInconvenienceLevel && System.currentTimeMillis() <= this.gcTime) continue;
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)"Garbage collection started");
                }
                this.garbageCollect();
                this.inconvenienceLevel = 0;
                this.gcTime = System.currentTimeMillis() + this.gcMaxInterval;
                if (!LOG.isEnabledFor((Priority)Level.DEBUG)) continue;
                LOG.debug((Object)"Garbage collection completed");
            }
        }
        catch (Throwable all) {
            if (LOG.isEnabledFor((Priority)Level.FATAL)) {
                LOG.fatal((Object)("Uncaught Throwable in thread :" + Thread.currentThread().getName()), all);
            }
        }
        finally {
            this.gcThread = null;
        }
    }

    private synchronized void rebuildIndex() throws BTreeException, DBException, IOException {
        if (LOG.isEnabledFor((Priority)Level.INFO)) {
            LOG.info((Object)"Rebuilding indices");
        }
        String pattern = "*";
        IndexQuery any = new IndexQuery(0, pattern);
        this.cacheDB.query(any, new RebuildIndexCallback(this.cacheDB, this.indexer));
    }

    private static final class RebuildIndexCallback
    implements BTreeCallback {
        private BTreeFiler database = null;
        private Indexer index = null;

        RebuildIndexCallback(BTreeFiler database, Indexer index) {
            this.database = database;
            this.index = index;
        }

        public boolean indexInfo(Value val, long pos) {
            try {
                Record record = this.database.readRecord(pos);
                if (record == null) {
                    return true;
                }
                InputStream is = record.getValue().getInputStream();
                Advertisement adv = AdvertisementFactory.newAdvertisement(MimeMediaType.XMLUTF8, is);
                Map indexables = Cm.getIndexfields(adv.getIndexFields(), (StructuredDocument)adv.getDocument(MimeMediaType.XMLUTF8));
                String dn = Cm.getDirName(adv);
                Map keyedIdx = Cm.addKey(dn, indexables);
                if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                    LOG.debug((Object)("Restoring index " + keyedIdx + " at " + pos));
                }
                this.index.addToIndex(keyedIdx, pos);
            }
            catch (Exception ex) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)("Exception rebuilding index  at " + pos), (Throwable)ex);
                }
                return true;
            }
            return true;
        }
    }

    private static final class removeCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private Indexer indexer = null;

        removeCallback(BTreeFiler cacheDB, Indexer indexer) {
            this.cacheDB = cacheDB;
            this.indexer = indexer;
        }

        public boolean indexInfo(Value val, long pos) {
            block9: {
                Record record = null;
                try {
                    record = this.cacheDB.readRecord(pos);
                }
                catch (DBException ex) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Exception while reading record", (Throwable)ex);
                    }
                    return false;
                }
                if (record == null) {
                    return true;
                }
                try {
                    if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                        LOG.debug((Object)("Removing Record at position :" + pos));
                    }
                    this.indexer.purge(pos);
                    this.cacheDB.deleteRecord(record.getKey());
                }
                catch (DBException ex) {
                    if (LOG.isEnabledFor((Priority)Level.WARN)) {
                        LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                    }
                }
                catch (IOException ie) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) break block9;
                    LOG.warn((Object)"Exception while reading indexed", (Throwable)ie);
                }
            }
            return true;
        }
    }

    private final class SearchCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private Indexer indexer = null;
        private int threshold;
        private Vector results;
        private Vector expirations;
        private boolean purge;

        SearchCallback(BTreeFiler cacheDB, Indexer indexer, Vector results, Vector expirations, int threshold) {
            this(cacheDB, indexer, results, expirations, threshold, false);
        }

        SearchCallback(BTreeFiler cacheDB, Indexer indexer, Vector results, Vector expirations, int threshold, boolean purge) {
            this.cacheDB = cacheDB;
            this.indexer = indexer;
            this.results = results;
            this.threshold = threshold;
            this.expirations = expirations;
            this.purge = purge;
        }

        public boolean indexInfo(Value val, long pos) {
            if (this.results.size() >= this.threshold) {
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Found " + val.toString() + " at " + pos));
            }
            Record record = null;
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                }
                return false;
            }
            if (record == null) {
                return true;
            }
            long exp = Cm.calcExpiration(record);
            if (exp < 0L) {
                block14: {
                    if (this.purge) {
                        try {
                            this.indexer.purge(pos);
                            this.cacheDB.deleteRecord(record.getKey());
                        }
                        catch (DBException ex) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                            }
                            break block14;
                        }
                        catch (IOException ie) {
                            if (LOG.isEnabledFor((Priority)Level.WARN)) {
                                LOG.warn((Object)"Exception while reading indexed", (Throwable)ie);
                            }
                            break block14;
                        }
                    }
                    ++Cm.this.inconvenienceLevel;
                }
                return true;
            }
            if (this.expirations != null) {
                this.expirations.addElement(new Long(exp));
            }
            this.results.addElement(record.getValue().getInputStream());
            return true;
        }
    }

    private static final class EntriesCallback
    implements BTreeCallback {
        private BTreeFiler cacheDB = null;
        private int threshold;
        private Vector results;
        private String key;

        EntriesCallback(BTreeFiler cacheDB, Vector results, String key, int threshold) {
            this.cacheDB = cacheDB;
            this.results = results;
            this.key = key;
            this.threshold = threshold;
        }

        public boolean indexInfo(Value val, long pos) {
            if (this.results.size() >= this.threshold) {
                return false;
            }
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)("Found " + val.toString() + " at " + pos));
            }
            Record record = null;
            try {
                record = this.cacheDB.readRecord(pos);
            }
            catch (DBException ex) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"Exception while reading indexed", (Throwable)ex);
                }
                return false;
            }
            if (record == null) {
                return true;
            }
            long exp = Cm.calcExpiration(record);
            if (exp < 0L) {
                return true;
            }
            Long life = (Long)record.getMetaData("lifetime");
            SrdiMessage.Entry entry = new SrdiMessage.Entry(this.key, val.toString(), life - System.currentTimeMillis());
            if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
                LOG.debug((Object)(" key [" + entry.key + "] value [" + entry.value + "] exp [" + entry.expiration + "]"));
            }
            this.results.addElement(entry);
            return true;
        }
    }
}

