/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.ref.SoftReference;
import net.jxta.document.MimeMediaType;
import net.jxta.document.TextDocument;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.TextMessageElement;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TextDocumentMessageElement
extends TextMessageElement {
    private static final Logger LOG = Logger.getLogger((String)TextDocumentMessageElement.class.getName());
    protected TextDocument doc;

    public TextDocumentMessageElement(String name, TextDocument doc, MessageElement sig) {
        super(name, doc.getMimeType(), sig);
        this.doc = doc;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (target instanceof MessageElement) {
            if (!super.equals(target)) {
                return false;
            }
            if (target instanceof TextMessageElement) {
                TextMessageElement likeMe = (TextMessageElement)target;
                try {
                    int its;
                    int mine;
                    Reader myReader = this.getReader();
                    Reader itsReader = likeMe.getReader();
                    do {
                        if ((mine = myReader.read()) == (its = itsReader.read())) continue;
                        return false;
                    } while (-1 != mine && -1 != its);
                    return -1 == mine && -1 == its;
                }
                catch (IOException fatal) {
                    throw new IllegalStateException("MessageElements could not be compared." + fatal);
                }
            }
            MessageElement likeMe = (MessageElement)target;
            try {
                int its;
                int mine;
                InputStream myStream = this.getStream();
                InputStream itsStream = likeMe.getStream();
                do {
                    if ((mine = myStream.read()) == (its = itsStream.read())) continue;
                    return false;
                } while (-1 != mine && -1 != its);
                return -1 == mine && -1 == its;
            }
            catch (IOException fatal) {
                throw new IllegalStateException("MessageElements could not be compared." + fatal);
            }
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode() * 6037 + this.toString().hashCode();
        return result;
    }

    public synchronized String toString() {
        String result = null;
        if (null != this.cachedToString && null != (result = (String)this.cachedToString.get())) {
            return result;
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating toString of " + this.getClass().getName() + "@" + super.hashCode()));
        }
        result = ((Object)this.doc).toString();
        this.cachedToString = new SoftReference<String>(result);
        return result;
    }

    public MimeMediaType getMimeType() {
        return this.doc.getMimeType();
    }

    public String getFileExtension() {
        return this.doc.getFileExtension();
    }

    public InputStream getStream() throws IOException {
        byte[] sending = this.getBytes(false);
        return new ByteArrayInputStream(sending);
    }

    public void sendToStream(OutputStream sendTo) throws IOException {
        byte[] sending = this.getBytes(false);
        sendTo.write(sending, 0, sending.length);
    }

    public Reader getReader() throws IOException {
        return this.doc.getReader();
    }

    public void sendToWriter(Writer sendTo) throws IOException {
        this.doc.sendToWriter(sendTo);
    }

    public byte[] getBytes(boolean copy) {
        String charset;
        byte[] result = null;
        if (null != this.cachedGetBytes && null != (result = (byte[])this.cachedGetBytes.get())) {
            if (copy) {
                byte[] theCopy = new byte[result.length];
                System.arraycopy(theCopy, 0, result, 0, result.length);
            } else {
                return result;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating getBytes of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        if (null == (charset = this.type.getParameter("charset"))) {
            result = this.toString().getBytes();
        } else {
            try {
                result = this.toString().getBytes(charset);
            }
            catch (UnsupportedEncodingException caught) {
                if (LOG.isEnabledFor((Priority)Level.WARN)) {
                    LOG.warn((Object)"MessageElement Data could not be generated", (Throwable)caught);
                }
                throw new IllegalStateException("MessageElement Data could not be generated due to " + caught.getMessage());
            }
        }
        if (!copy) {
            this.cachedGetBytes = new SoftReference<byte[]>(result);
        }
        return result;
    }

    public long getCharLength() {
        return this.toString().length();
    }

    public char[] getChars(boolean copy) {
        char[] result = null;
        if (null != this.cachedGetChars && null != (result = (char[])this.cachedGetChars.get())) {
            if (copy) {
                char[] theCopy = new char[result.length];
                System.arraycopy(theCopy, 0, result, 0, result.length);
            } else {
                return result;
            }
        }
        if (LOG.isEnabledFor((Priority)Level.DEBUG)) {
            LOG.debug((Object)("creating getChars of " + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode())));
        }
        String asString = this.toString();
        result = asString.toCharArray();
        if (!copy) {
            this.cachedGetChars = new SoftReference<char[]>(result);
        }
        return result;
    }
}

