/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.MessengerEvent;
import net.jxta.endpoint.MessengerEventListener;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.util.SimpleSelectable;
import net.jxta.util.SimpleSelector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ListenerAdaptor
implements Runnable {
    private static final Logger LOG = Logger.getLogger((String)ListenerAdaptor.class.getName());
    HashMap inprogress = null;
    private Thread bgThread = null;
    private SimpleSelector selector = null;
    private boolean stopped = false;
    private ThreadGroup threadGroup = null;
    static /* synthetic */ Class class$net$jxta$endpoint$Messenger;

    public ListenerAdaptor(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    private void stop() {
        this.stopped = true;
        if (this.bgThread != null) {
            this.bgThread.interrupt();
            this.bgThread = null;
        }
    }

    private void init() {
        if (this.bgThread != null) {
            return;
        }
        this.inprogress = new HashMap(32);
        this.selector = new SimpleSelector();
        this.bgThread = new Thread(this.threadGroup, this, "Listener Adaptor");
        this.bgThread.setDaemon(true);
        this.bgThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetSelectable(SimpleSelectable ts) {
        ts.unregister(this.selector);
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            this.inprogress.remove(ts.getIdentityReference());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watchMessage(OutgoingMessageEventListener listener, Message m) {
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            if (this.stopped) {
                return false;
            }
            if (listener == null) {
                return true;
            }
            this.init();
            ListenerContainer allListeners = (ListenerContainer)this.inprogress.get(m.getIdentityReference());
            if (allListeners == null) {
                allListeners = new MessageListenerContainer();
                this.inprogress.put(m.getIdentityReference(), allListeners);
            }
            allListeners.add(listener);
        }
        m.register(this.selector);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean watchMessenger(MessengerEventListener listener, Messenger m) {
        ListenerAdaptor listenerAdaptor = this;
        synchronized (listenerAdaptor) {
            if (this.stopped) {
                return false;
            }
            if (listener == null) {
                return true;
            }
            this.init();
            ListenerContainer allListeners = (ListenerContainer)this.inprogress.get(m.getIdentityReference());
            if (allListeners == null) {
                allListeners = new MessengerListenerContainer();
                this.inprogress.put(m.getIdentityReference(), allListeners);
            }
            allListeners.add(listener);
        }
        m.register(this.selector);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object i;
        block13: {
            try {
                while (!this.stopped) {
                    List changed = this.selector.select();
                    i = changed.iterator();
                    while (i.hasNext()) {
                        SimpleSelectable m = (SimpleSelectable)i.next();
                        ListenerContainer listeners = null;
                        ListenerAdaptor listenerAdaptor = this;
                        synchronized (listenerAdaptor) {
                            listeners = (ListenerContainer)this.inprogress.get(m.getIdentityReference());
                        }
                        if (listeners == null) {
                            m.unregister(this.selector);
                            continue;
                        }
                        listeners.process(m);
                    }
                }
            }
            catch (InterruptedException ie) {
            }
            catch (Throwable anyOther) {
                if (!LOG.isEnabledFor((Priority)Level.FATAL)) break block13;
                LOG.fatal((Object)"Uncaught throwable in background thread", anyOther);
                i = this;
                synchronized (i) {
                    this.stopped = true;
                }
            }
        }
        IOException failed = new IOException("Endpoint interface terminated");
        i = this.inprogress.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            SimpleSelectable m = (SimpleSelectable)((SimpleSelectable.IdentityReference)entry.getKey()).getObject();
            ListenerContainer listeners = (ListenerContainer)entry.getValue();
            m.unregister(this.selector);
            if (listeners == null) continue;
            listeners.giveUp(m, failed);
        }
        this.inprogress.clear();
    }

    class MessengerListenerContainer
    extends ListenerContainer {
        MessengerListenerContainer() {
        }

        private void messengerDone(Messenger m) {
            int i = this.size();
            MessengerEvent event = new MessengerEvent(ListenerAdaptor.this, m, null);
            while (i-- > 0) {
                try {
                    ((MessengerEventListener)this.get(i)).messengerReady(event);
                }
                catch (Throwable any) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)"Uncaught throwable in listener", any);
                }
            }
        }

        protected void process(SimpleSelectable what) {
            Messenger m = (Messenger)what;
            if ((m.getState() & 0x7DBCC) == 0) {
                return;
            }
            ListenerAdaptor.this.forgetSelectable(what);
            if ((m.getState() & 0x3FF) == 0) {
                m = null;
            }
            this.messengerDone(m);
        }

        protected void giveUp(SimpleSelectable what, Throwable how) {
            this.messengerDone(null);
        }
    }

    class MessageListenerContainer
    extends ListenerContainer {
        MessageListenerContainer() {
        }

        private void messageDone(Message m, OutgoingMessageEvent event) {
            int i = this.size();
            if (event == OutgoingMessageEvent.SUCCESS) {
                event = new OutgoingMessageEvent(m, null);
                while (i-- > 0) {
                    try {
                        ((OutgoingMessageEventListener)this.get(i)).messageSendSucceeded(event);
                    }
                    catch (Throwable any) {
                        if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                        LOG.warn((Object)"Uncaught throwable in listener", any);
                    }
                }
                return;
            }
            if (event == OutgoingMessageEvent.OVERFLOW) {
                event = new OutgoingMessageEvent(m, null);
            }
            while (i-- > 0) {
                try {
                    ((OutgoingMessageEventListener)this.get(i)).messageSendFailed(event);
                }
                catch (Throwable any) {
                    if (!LOG.isEnabledFor((Priority)Level.WARN)) continue;
                    LOG.warn((Object)"Uncaught throwable in listener", any);
                }
            }
        }

        protected void process(SimpleSelectable what) {
            Message m = (Message)what;
            OutgoingMessageEvent event = (OutgoingMessageEvent)m.getMessageProperty(class$net$jxta$endpoint$Messenger == null ? (class$net$jxta$endpoint$Messenger = ListenerAdaptor.class$("net.jxta.endpoint.Messenger")) : class$net$jxta$endpoint$Messenger);
            if (event == null) {
                return;
            }
            ListenerAdaptor.this.forgetSelectable(what);
            this.messageDone(m, event);
        }

        protected void giveUp(SimpleSelectable what, Throwable how) {
            this.messageDone((Message)what, new OutgoingMessageEvent((Message)what, how));
        }
    }

    static abstract class ListenerContainer
    extends ArrayList {
        public ListenerContainer() {
            super(1);
        }

        protected abstract void giveUp(SimpleSelectable var1, Throwable var2);

        protected abstract void process(SimpleSelectable var1);
    }
}

