/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.endpoint;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.impl.util.TimeUtils;
import net.jxta.util.AbstractSimpleSelectable;
import net.jxta.util.SimpleSelectable;

public abstract class AbstractMessenger
extends AbstractSimpleSelectable
implements Messenger {
    protected static final long DEFAULT_MTU = 65536L;
    protected EndpointAddress dstAddress = null;
    private Object stateLock;

    public AbstractMessenger(EndpointAddress dest) {
        this.dstAddress = (EndpointAddress)dest.clone();
    }

    protected void setStateLock(Object stateLock) {
        this.stateLock = stateLock;
    }

    public final boolean isIdle() {
        return false;
    }

    public final boolean isSynchronous() {
        return false;
    }

    public EndpointAddress getDestinationAddress() {
        return (EndpointAddress)this.dstAddress.clone();
    }

    public EndpointAddress getDestinationAddressObject() {
        return this.dstAddress;
    }

    public long getMTU() {
        return 65536L;
    }

    public boolean isClosed() {
        return (this.getState() & 0x3FF) == 0;
    }

    public final void flush() throws IOException {
        int currentState = 0;
        try {
            currentState = this.waitState(458767, 0L);
        }
        catch (InterruptedException ie) {
            InterruptedIOException iio = new InterruptedIOException();
            iio.initCause(ie);
            throw iio;
        }
        if ((currentState & 0x403FF) != 0) {
            return;
        }
        throw new IOException("Messenger was unexpectedly closed.");
    }

    public final boolean sendMessage(Message msg) throws IOException {
        return this.sendMessage(msg, null, null);
    }

    public void sendMessage(Message msg, String service, String serviceParam, OutgoingMessageEventListener listener) {
        throw new UnsupportedOperationException("This legacy method is not supported by this messenger.");
    }

    public final boolean sendMessage(Message msg, String rService, String rServiceParam) throws IOException {
        if (this.sendMessageN(msg, rService, rServiceParam)) {
            return true;
        }
        Object failed = msg.getMessageProperty(Messenger.class);
        if (failed == null || !(failed instanceof OutgoingMessageEvent)) {
            return false;
        }
        Throwable t = ((OutgoingMessageEvent)failed).getFailure();
        if (t == null) {
            return false;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new UndeclaredThrowableException(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int waitState(int wantedStates, long timeout) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            if (timeout == 0L) {
                while ((wantedStates & this.getState()) == 0) {
                    this.stateLock.wait();
                }
                return this.getState();
            }
            if (timeout < 0L) {
                this.stateLock.wait(timeout);
            }
            long start = TimeUtils.timeNow();
            long left = timeout;
            while (left > 0L && (wantedStates & this.getState()) == 0) {
                this.stateLock.wait(left);
                left = timeout + TimeUtils.toRelativeTimeMillis(start);
            }
            return this.getState();
        }
    }

    public void itemChanged(SimpleSelectable changedObject) {
        this.notifyChange();
    }
}

