/*
 * Decompiled with CFR 0.152.
 */
package madkit.utils.agents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import madkit.kernel.AbstractAgent;
import madkit.kernel.JTextAreaWriter;
import madkit.kernel.Utils;
import madkit.utils.agents.SwingFileFilter;

public abstract class AbstractEditorPanel
extends JRootPane
implements ActionListener {
    protected JTextArea inputArea;
    protected JTextArea outputArea;
    protected PrintWriter out;
    protected AbstractAgent ag;
    protected JToolBar toolBar;
    protected JMenuBar menubar;
    protected JPanel commandPanel;
    String currentFile = null;
    protected String extens = null;
    public static final boolean LOAD = true;
    public static final boolean SAVE = false;

    public PrintWriter stdout() {
        return this.out;
    }

    public PrintWriter stderr() {
        return this.out;
    }

    public InputStream stdin() {
        return System.in;
    }

    public JTextArea getInputArea() {
        return this.inputArea;
    }

    public JTextArea getOutputArea() {
        return this.outputArea;
    }

    public JToolBar getToolbar() {
        return this.toolBar;
    }

    public JMenuBar getMenubar() {
        return this.menubar;
    }

    public AbstractEditorPanel(AbstractAgent abstractAgent) {
        this.ag = abstractAgent;
        this.menubar = new JMenuBar();
        this.setJMenuBar(this.menubar);
        JMenu jMenu = new JMenu("File");
        this.menubar.add(jMenu);
        AbstractEditorPanel.addMenuItem(this, jMenu, "New file", "new", 78);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Open", "openfile", -1);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Save", "save", 83, 83);
        AbstractEditorPanel.addMenuItem(this, jMenu, "Save as", "saveAs", -1);
        JMenu jMenu2 = new JMenu("Edit");
        this.menubar.add(jMenu2);
        AbstractEditorPanel.addMenuItem(this, jMenu2, "Cut", "cut", 88, 88);
        AbstractEditorPanel.addMenuItem(this, jMenu2, "Copy", "copy", 67, 67);
        AbstractEditorPanel.addMenuItem(this, jMenu2, "Paste", "paste", 86, 86);
        AbstractEditorPanel.addMenuItem(this, jMenu2, "Delete", "delete", 127, 127);
        AbstractEditorPanel.addMenuItem(this, jMenu2, "Clear output", "clear", 0, 0);
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.commandPanel = new JPanel();
        this.commandPanel.setAlignmentX(0.0f);
        this.commandPanel.setAlignmentY(0.0f);
        this.commandPanel.setLayout(new FlowLayout(0));
        this.toolBar = new JToolBar();
        this.addTool(this.toolBar, "new", "new file", "/toolbarButtonGraphics/general/New24.gif");
        this.addTool(this.toolBar, "openfile", "Open file", "/toolbarButtonGraphics/general/Open24.gif");
        this.addTool(this.toolBar, "save", "Save file", "/toolbarButtonGraphics/general/Save24.gif");
        this.toolBar.addSeparator();
        this.addTool(this.toolBar, "cut", "Cut", "/toolbarButtonGraphics/general/Cut24.gif");
        this.addTool(this.toolBar, "copy", "Copy", "/toolbarButtonGraphics/general/Copy24.gif");
        this.addTool(this.toolBar, "paste", "Paste", "/toolbarButtonGraphics/general/Paste24.gif");
        this.commandPanel.add(this.toolBar);
        this.getContentPane().add("North", this.commandPanel);
        this.inputArea = new JTextArea(10, 40);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setSize(300, 200);
        jScrollPane.getViewport().add(this.inputArea);
        this.outputArea = new JTextArea(";; EditorAgent 1.1 (c) Madkit team\n", 10, 40);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setSize(300, 200);
        jScrollPane2.getViewport().add(this.outputArea);
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(150);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.out = new PrintWriter((Writer)new JTextAreaWriter(this.outputArea), true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        this.command(string);
    }

    public void command(String string) {
        if (string.equals("openfile")) {
            this.openFile();
        } else if (string.equals("new")) {
            this.newFile();
        } else if (string.equals("save")) {
            this.save();
        } else if (string.equals("copy")) {
            this.inputArea.copy();
        } else if (string.equals("cut")) {
            this.inputArea.cut();
        } else if (string.equals("paste")) {
            this.inputArea.paste();
        } else if (string.equals("saveAs")) {
            this.saveAs();
        } else if (string.equals("clear")) {
            this.clear();
        }
    }

    public void clearOutputArea() {
        this.outputArea.setText("");
    }

    public void newFile() {
        this.saveIfModified();
        this.inputArea.setText("");
        this.setCurrentFile(null);
    }

    public void setCurrentFile(String string) {
        this.currentFile = string;
    }

    public String getCurrentFile() {
        return this.currentFile;
    }

    public Frame getFrameParent() {
        Container container = this;
        while (!(container instanceof Frame)) {
            if (container == null) {
                return null;
            }
            container = container.getParent();
        }
        return (Frame)container;
    }

    public void setExtens(String string) {
        this.extens = string;
    }

    protected boolean getFileDialog(boolean bl, String string, String string2) {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir", null));
        if (string2 != null) {
            System.out.println("set filter: " + string2);
            jFileChooser.setFileFilter(new SwingFileFilter(string2));
        }
        jFileChooser.setDialogTitle(string);
        int n = 0;
        n = bl ? jFileChooser.showOpenDialog(this) : jFileChooser.showSaveDialog(this);
        if (n == 0) {
            if (jFileChooser.getSelectedFile() != null) {
                this.setCurrentFile(jFileChooser.getSelectedFile().getPath());
                return true;
            }
            return false;
        }
        return false;
    }

    public void openFile() {
        if (this.getFileDialog(true, "Open file", this.extens) && this.currentFile != null) {
            this.readFile(this.getCurrentFile());
        }
    }

    public void readFile(String string) {
        this.readFile(new File(string));
    }

    public void readFile(File file) {
        String string = new String();
        String string2 = new String();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            while (string2 != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                string = string + string2 + "\n";
            }
            this.inputArea.setText(string);
            Utils.setFrameParentTitle((Container)this, (String)file.getName());
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Cannot open file " + this.getCurrentFile());
        }
    }

    void saveIfModified() {
        int n;
        if (!this.inputArea.getText().equals("") && (n = JOptionPane.showConfirmDialog(this, "Buffer is not empty, do you want to save it?", "Warning", 0, 3, null)) == 0) {
            this.save();
        }
    }

    public void saveAs() {
        if (this.getFileDialog(false, "Save file", this.extens)) {
            this.save1(true);
        }
    }

    public void save() {
        if (this.getCurrentFile() == null) {
            this.saveAs();
        } else {
            this.save1(true);
        }
    }

    void save1(boolean bl) {
        if (bl) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(this.getCurrentFile()));
                String string = this.inputArea.getText();
                printWriter.print(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("saveContent: " + fileNotFoundException);
            }
            catch (IOException iOException) {
                System.err.println("saveContent: " + iOException);
            }
            System.out.println(":: file " + this.getCurrentFile() + " saved");
            Utils.setFrameParentTitle((Container)this, (String)Utils.getFileNameFromPath((String)this.getCurrentFile()));
        }
    }

    public void clear() {
        this.clearOutputArea();
    }

    public void print(String string) {
        this.stdout().print(string);
    }

    public void println(String string) {
        this.stdout().println(string);
    }

    public void addTool(JToolBar jToolBar, String string, String string2, String string3) {
        JButton jButton;
        if (string3.equals("")) {
            jButton = (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        } else {
            URL uRL = this.getClass().getResource(string3);
            jButton = uRL != null ? (JButton)jToolBar.add(new JButton(new ImageIcon(uRL))) : (JButton)jToolBar.add(new JButton(string));
            jButton.setActionCommand(string);
        }
        jButton.setToolTipText(string2);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AbstractEditorPanel.this.command(actionEvent.getActionCommand());
            }
        });
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n) {
        AbstractEditorPanel.addMenuItem(actionListener, jMenu, string, string2, n, -1);
    }

    public static void addMenuItem(ActionListener actionListener, JMenu jMenu, String string, String string2, int n, int n2) {
        JMenuItem jMenuItem = n > 0 ? new JMenuItem(string, n) : new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        if (n2 > 0) {
            if (n2 != 127) {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 2, false));
            } else {
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, 0, false));
            }
        }
    }
}

