/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.AbstractSequence;
import gnu.lists.PositionConsumer;
import gnu.lists.TreePosition;
import gnu.xml.VariableProvider;
import gnu.xml.XPath;
import gnu.xml.XPathConstants;
import gnu.xml.XPathVariable;
import java.io.PrintStream;

public class XPathContext
implements XPathConstants,
PositionConsumer {
    int currentPosition;
    int currentSize = -1;
    TreePosition position;
    VariableProvider variableProvider = null;
    int stepPc;
    int predPc;
    int[] counters;
    int resultType;
    public double numResult;
    public boolean boolResult;
    public Object objResult;
    public int consumeKind;
    public static final int CONSUME_COUNT = 1;
    public static final int CONSUME_BOOL = 2;
    public static final int CONSUME_STRING = 3;
    public static final int CONSUME_STRING_APPEND = 4;
    public static final int CONSUME_NAME = 5;
    public int consumeCount;
    public Object consumeObject;

    public XPathContext() {
        this.position = new TreePosition();
    }

    public XPathContext(TreePosition treePosition) {
        this.position = treePosition;
    }

    public XPathContext(Object object2) {
        this.position = new TreePosition(object2);
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public int getCurrentSize() {
        return this.currentSize;
    }

    public String getCurrentTypeName() {
        throw new Error("not implemented");
    }

    public TreePosition getPosition() {
        return this.position;
    }

    public int getAncestorDepth() {
        return this.position.getDepth();
    }

    public int getCounter(int n) {
        if (this.counters == null) {
            this.counters = new int[n > 10 ? n : 10];
        }
        if (n <= this.counters.length) {
            int n2 = this.counters.length;
            if (n >= n2) {
                n2 = n + 5;
            }
            int[] nArray = new int[n2];
            System.arraycopy(this.counters, 0, nArray, 0, this.counters.length);
            this.counters = nArray;
        }
        return this.counters[n];
    }

    public void setCounter(int n, int n2) {
        this.getCounter(n);
        this.counters[n] = n2;
    }

    public void incrementCounter(int n) {
        this.getCounter(n);
        int n2 = n;
        this.counters[n2] = this.counters[n2] + 1;
    }

    public boolean consume(TreePosition treePosition) {
        switch (this.consumeKind) {
            case 1: {
                ++this.consumeCount;
                return true;
            }
            case 2: {
                this.consumeCount = 1;
                return false;
            }
        }
        throw new Error("unknown consumeKind");
    }

    public boolean writePosition(AbstractSequence abstractSequence, int n, Object object2) {
        switch (this.consumeKind) {
            case 1: {
                ++this.consumeCount;
                return true;
            }
            case 2: {
                this.consumeCount = 1;
                return false;
            }
        }
        throw new Error("unknown consumeKind");
    }

    public void setVariableProvider(VariableProvider variableProvider) {
        this.variableProvider = variableProvider;
    }

    public void getVariableReference(Object object2, int n) {
        if (this.variableProvider != null) {
            XPathVariable xPathVariable = this.variableProvider.getVariable(object2);
            if (xPathVariable != null) {
                xPathVariable.result(this, n);
            } else {
                XPath.result(this, "<unknown variable " + object2.toString() + '>', n);
            }
        } else {
            String string = System.getProperty(object2.toString());
            if (string == null) {
                string = "<unknown property " + object2 + '>';
            }
            XPath.result(this, string, n);
        }
    }

    public static void dump(TreePosition treePosition, PrintStream printStream) {
        new XPathContext(treePosition).dump("", printStream);
    }

    public void dump(PrintStream printStream) {
        this.dump("", printStream);
    }

    public void dump(String string, PrintStream printStream) {
        String string2 = this.getCurrentTypeName();
        if (string2.equals("#text")) {
            printStream.print(string);
            printStream.println(this.position.getNext());
        } else {
            int n;
            int n2;
            printStream.print(string);
            printStream.print('<');
            printStream.print(string2);
            if (this.position.gotoAttributesStart()) {
                n2 = this.currentPosition;
                n = this.currentSize;
                this.currentSize = this.position.fromEndIndex();
                this.currentPosition = 0;
                try {
                    while (this.position.hasMoreElements()) {
                        printStream.print(' ');
                        printStream.print(this.getCurrentTypeName());
                        printStream.print("=\"");
                        printStream.print(this.position.getNext());
                        printStream.print('\"');
                        this.position.gotoNext();
                        ++this.currentPosition;
                    }
                    Object var7_6 = null;
                    this.currentPosition = n2;
                    this.currentSize = n;
                    this.position.gotoParent();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.currentPosition = n2;
                    this.currentSize = n;
                    this.position.gotoParent();
                    throw throwable;
                }
                {
                }
            }
            printStream.print(">");
            if (!this.position.gotoChildrenStart()) {
                n2 = 0;
            } else {
                n = this.currentPosition;
                int n3 = this.currentSize;
                this.currentSize = n2 = this.position.fromEndIndex();
                this.currentPosition = 0;
                try {
                    while (this.position.hasMoreElements()) {
                        if (this.currentPosition == 0) {
                            printStream.println();
                        }
                        this.dump(string + " ", printStream);
                        this.position.gotoNext();
                        ++this.currentPosition;
                    }
                    Object var9_10 = null;
                    this.currentPosition = n;
                    this.currentSize = n3;
                    this.position.gotoParent();
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.currentPosition = n;
                    this.currentSize = n3;
                    this.position.gotoParent();
                    throw throwable;
                }
                {
                }
            }
            if (n2 > 0) {
                printStream.print(string);
            }
            printStream.print("</");
            printStream.print(string2);
            printStream.print('>');
            if (n2 > 0) {
                printStream.print(string);
            }
        }
    }
}

