/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.brl;

import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.kawa.brl.BRLRead;
import gnu.kawa.brl.Prompter;
import gnu.kawa.functions.AppendValues;
import gnu.lists.Consumer;
import gnu.lists.Sequence;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.XMLPrinter;
import java.io.IOException;
import java.util.Vector;
import kawa.lang.Translator;
import kawa.standard.Scheme;

public class BRL
extends Scheme {
    static BRL instance;
    boolean brlCompatible = false;

    public BRL() {
        instance = this;
        ModuleBody.setMainPrintValues(true);
        Environment.setCurrent(this.getEnvironment());
        try {
            this.loadClass("gnu.brl.stringfun");
            this.loadClass("gnu.kawa.brl.progfun");
            this.loadClass("gnu.kawa.servlet.HTTP");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("caught " + classNotFoundException);
        }
    }

    public static Interpreter getInstance(boolean bl) {
        if (instance == null) {
            new BRL();
        }
        instance.setBrlCompatible(bl);
        return instance;
    }

    public static BRL getKrlInstance() {
        BRL.getInstance(false);
        return instance;
    }

    public static BRL getBrlInstance() {
        BRL.getInstance(true);
        return instance;
    }

    public boolean isBrlCompatible() {
        return this.brlCompatible;
    }

    public void setBrlCompatible(boolean bl) {
        this.brlCompatible = bl;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        Compilation.usingTailCalls = true;
        BRLRead bRLRead = new BRLRead(inPort, sourceMessages);
        bRLRead.setBrlCompatible(this.isBrlCompatible());
        return bRLRead;
    }

    public Consumer getOutputConsumer(OutPort outPort) {
        if (this.isBrlCompatible()) {
            return super.getOutputConsumer(outPort);
        }
        return new XMLPrinter(outPort, false);
    }

    public ModuleExp parseFile(InPort inPort, SourceMessages sourceMessages) {
        Compilation.usingTailCalls = true;
        Translator translator = new Translator(Environment.user(), sourceMessages);
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(inPort.getName());
        Vector vector = new Vector(20);
        translator.push(moduleExp);
        try {
            BRLRead bRLRead = new BRLRead(inPort, sourceMessages);
            bRLRead.setBrlCompatible(this.isBrlCompatible());
            boolean bl = true;
            Object object2 = bRLRead.brlReader.read(bRLRead, 93, 0);
            while (object2 != Sequence.eofValue && (object2.toString().length() <= 0 || translator.scan_form(object2, vector, moduleExp))) {
                object2 = bRLRead.readObject();
            }
            if (inPort.readState != ']') {
                bRLRead.fatal("An unmatched '[' was read.");
            }
        }
        catch (SyntaxException syntaxException) {
            if (syntaxException.getMessages() != sourceMessages) {
                throw new RuntimeException("confussing syntax error: " + syntaxException);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("I/O exception reading file: " + iOException.toString());
        }
        translator.finishModule(moduleExp, vector);
        return moduleExp;
    }

    public static void registerEnvironment() {
        BRL bRL = new BRL();
        Interpreter.defaultInterpreter = bRL;
        Environment.setCurrent(bRL.getEnvironment());
    }

    public Expression makeBody(Expression[] expressionArray) {
        if (this.isBrlCompatible()) {
            return super.makeBody(expressionArray);
        }
        return new ApplyExp(AppendValues.appendValues, expressionArray);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }
}

