/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayType;
import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Target;
import gnu.mapping.Values;

public class StackTarget
extends Target {
    Type type;

    public StackTarget(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static Target getInstance(Type type) {
        return type == Type.pointer_type ? Target.pushObject : new StackTarget(type);
    }

    protected boolean compileFromStack0(Compilation compilation, Type type) {
        return StackTarget.compileFromStack0(compilation, type, this.type);
    }

    static boolean compileFromStack0(Compilation compilation, Type type, Type type2) {
        if (type2 == type) {
            return true;
        }
        CodeAttr codeAttr = compilation.getCode();
        if (type.isVoid()) {
            compilation.compileConstant(Values.empty);
            type = Type.pointer_type;
        } else if (type instanceof PrimType && type2 instanceof PrimType) {
            codeAttr.emitConvert(type, type2);
            return true;
        }
        type.emitCoerceToObject(codeAttr);
        if (type instanceof ArrayType && (type2 == Type.pointer_type || "java.lang.Cloneable".equals(type2.getName()))) {
            return true;
        }
        return type2 instanceof ClassType && type instanceof ClassType && ((ClassType)type).isSubclass((ClassType)type2);
    }

    public static void convert(Compilation compilation, Type type, Type type2) {
        if (!StackTarget.compileFromStack0(compilation, type, type2)) {
            type2.emitCoerceFromObject(compilation.getCode());
        }
    }

    public void compileFromStack(Compilation compilation, Type type) {
        if (!this.compileFromStack0(compilation, type)) {
            this.type.emitCoerceFromObject(compilation.getCode());
        }
    }
}

