/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class LetExp
extends ScopeExp {
    public Expression[] inits;
    public Expression body;
    Method makeBindingMethod = null;

    public LetExp(Expression[] expressionArray) {
        this.inits = expressionArray;
    }

    public Expression getBody() {
        return this.body;
    }

    public void setBody(Expression expression) {
        this.body = expression;
    }

    static void store_rest(Compilation compilation, Declaration declaration) {
        if (declaration != null) {
            LetExp.store_rest(compilation, declaration.nextDecl());
            if (declaration.needsInit()) {
                declaration.initBinding(compilation);
            }
        }
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (n < this.inits.length) {
            Type type;
            declaration.allocateVariable(codeAttr);
            Target target2 = !declaration.needsInit() ? Target.Ignore : ((type = declaration.getType()) == Type.pointer_type ? Target.pushObject : new StackTarget(type));
            this.inits[n].compile(compilation, target2);
            ++n;
            declaration = declaration.nextDecl();
        }
        codeAttr.enterScope(this.scope);
        LetExp.store_rest(compilation, this.firstDecl());
        this.body.compileWithPosition(compilation, target);
        codeAttr.popScope();
    }

    public final Type getType() {
        return this.body.getType();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLetExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.inits = expWalker.walkExps(this.inits);
        if (expWalker.exitValue == null) {
            this.body = this.body.walk(expWalker);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Let", ")", 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        outPort.startLogicalBlock("(", false, ")");
        Declaration declaration = this.firstDecl();
        int n = 0;
        while (declaration != null) {
            if (n > 0) {
                outPort.writeSpaceLinear();
            }
            outPort.print('(');
            outPort.print(declaration.getName());
            outPort.writeSpaceFill();
            if (this.inits[n] == null) {
                outPort.print("<null>");
            } else {
                this.inits[n].print(outPort);
            }
            ++n;
            outPort.print(')');
            declaration = declaration.nextDecl();
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        this.body.print(outPort);
        outPort.endLogicalBlock(")");
    }
}

