/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.SwitchState;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import gnu.mapping.Procedure;
import gnu.mapping.WrongArguments;
import java.util.Stack;

public class ApplyExp
extends Expression {
    Expression func;
    Expression[] args;
    boolean tailCall;
    LambdaExp context;
    public ApplyExp nextCall;

    public final Expression getFunction() {
        return this.func;
    }

    public final Expression[] getArgs() {
        return this.args;
    }

    public final int getArgCount() {
        return this.args.length;
    }

    public void setArgs(Expression[] expressionArray) {
        this.args = expressionArray;
    }

    public final boolean isTailCall() {
        return this.tailCall;
    }

    public final void setTailCall(boolean bl) {
        this.tailCall = bl;
    }

    public ApplyExp(Expression expression, Expression[] expressionArray) {
        this.func = expression;
        this.args = expressionArray;
    }

    public ApplyExp(Procedure procedure, Expression[] expressionArray) {
        this.func = new QuoteExp(procedure);
        this.args = expressionArray;
    }

    public ApplyExp(Method method, Expression[] expressionArray) {
        this.func = new QuoteExp(new PrimProcedure(method));
        this.args = expressionArray;
    }

    public Object eval(Environment environment) throws Throwable {
        Procedure procedure = (Procedure)this.func.eval(environment);
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.args[n2].eval(environment);
            ++n2;
        }
        return procedure.applyN(objectArray);
    }

    public void eval(Environment environment, CallContext callContext) throws Throwable {
        Procedure procedure = (Procedure)this.func.eval(environment);
        int n = this.args.length;
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = this.args[n2].eval(environment);
            ++n2;
        }
        callContext.setArgsN(objectArray);
        callContext.proc = procedure;
    }

    public static void compileToArray(Expression[] expressionArray, Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (expressionArray.length == 0) {
            codeAttr.emitGetStatic(Compilation.noArgsField);
            return;
        }
        LambdaExp lambdaExp = compilation.curLambda;
        codeAttr.emitPushInt(expressionArray.length);
        codeAttr.emitNewArray(Type.pointer_type);
        int n = 0;
        while (n < expressionArray.length) {
            Expression expression = expressionArray[n];
            if (Compilation.usingCPStyle && !(expression instanceof QuoteExp) && !(expression instanceof ReferenceExp)) {
                expression.compile(compilation, Target.pushObject);
                codeAttr.emitSwap();
                codeAttr.emitDup(1, 1);
                codeAttr.emitSwap();
                codeAttr.emitPushInt(n);
                codeAttr.emitSwap();
            } else {
                codeAttr.emitDup(Compilation.objArrayType);
                codeAttr.emitPushInt(n);
                expression.compile(compilation, Target.pushObject);
            }
            codeAttr.emitArrayStore(Type.pointer_type);
            ++n;
        }
    }

    public void compile(Compilation compilation, Target target) {
        ApplyExp.compile(this, compilation, target, true);
    }

    public static void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        ApplyExp.compile(applyExp, compilation, target, false);
    }

    static void compile(ApplyExp applyExp, Compilation compilation, Target target, boolean bl) {
        boolean bl2;
        boolean bl3;
        Printable printable;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        int n = applyExp.args.length;
        Expression expression = applyExp.func;
        LambdaExp lambdaExp = null;
        String string = null;
        if (expression instanceof LambdaExp) {
            lambdaExp = (LambdaExp)expression;
            string = lambdaExp.getName();
            if (string == null) {
                string = "<lambda>";
            }
        } else if (expression instanceof ReferenceExp) {
            object6 = ((ReferenceExp)expression).binding;
            if (!((Declaration)object6).getFlag(65536)) {
                object5 = ((Declaration)object6).getValue();
                string = ((Declaration)object6).getName();
                if (object5 != null && object5 instanceof LambdaExp) {
                    lambdaExp = (LambdaExp)object5;
                }
                if (object5 != null && object5 instanceof QuoteExp) {
                    object4 = ((QuoteExp)object5).getValue();
                    object3 = null;
                    if (!(object4 instanceof Procedure)) {
                        object2 = null;
                        object3 = "calling " + string + " which is not a procedure";
                    } else {
                        if (bl && object4 instanceof Inlineable) {
                            ((Inlineable)object4).compile(applyExp, compilation, target);
                            return;
                        }
                        object2 = (Procedure)object4;
                        object3 = WrongArguments.checkArgCount((Procedure)object2, n);
                    }
                    if (object3 != null) {
                        compilation.error('w', (String)object3);
                    } else {
                        printable = PrimProcedure.getMethodFor((Procedure)object2, (Declaration)object6, applyExp.args, compilation.getInterpreter());
                        if (printable != null) {
                            if (!((PrimProcedure)printable).getStaticFlag()) {
                                ((Declaration)object6).base.load(compilation);
                            }
                            ((PrimProcedure)printable).compile(null, applyExp.args, compilation, target);
                            return;
                        }
                    }
                }
            }
        } else if (expression instanceof QuoteExp && (object6 = ((QuoteExp)expression).getValue()) instanceof Inlineable) {
            if (bl) {
                ((Inlineable)object6).compile(applyExp, compilation, target);
                return;
            }
            object5 = PrimProcedure.getMethodFor((Procedure)object6, applyExp.args);
            if (object5 != null) {
                applyExp = new ApplyExp((Procedure)object5, applyExp.args);
                object5.compile(applyExp, compilation, target);
                return;
            }
        }
        object6 = compilation.getCode();
        if (lambdaExp != null) {
            object4 = null;
            if (n < lambdaExp.min_args) {
                object4 = "too few args for ";
            } else if (lambdaExp.max_args >= 0 && n > lambdaExp.max_args) {
                object4 = "too many args " + n + " for ";
            } else if (!lambdaExp.isHandlingTailCalls() && (object5 = lambdaExp.getMethod(n)) != null) {
                boolean bl4 = ((Method)object5).getStaticFlag();
                object3 = applyExp.getArgs();
                int n2 = 0;
                Type[] typeArray = ((Method)object5).getParameterTypes();
                if (!bl4 || lambdaExp.declareClosureEnv() != null) {
                    if (bl4) {
                        n2 = 1;
                    }
                    if (compilation.curLambda == lambdaExp) {
                        ((CodeAttr)object6).emitLoad(lambdaExp.closureEnv);
                    } else {
                        LambdaExp.getHeapLambda(lambdaExp.outerLambda()).loadHeapFrame(compilation);
                    }
                }
                boolean bl5 = lambdaExp.restArgType() != null;
                PrimProcedure.compileArgs((Expression[])object3, n2 > 0 ? Type.void_type : null, typeArray, bl5, string, lambdaExp, compilation);
                ((CodeAttr)object6).emitInvoke((Method)object5);
                target.compileFromStack(compilation, lambdaExp.getReturnType());
                return;
            }
            if (object4 != null) {
                compilation.error('w', (String)object4 + string);
                lambdaExp = null;
            }
        }
        if (Compilation.usingCPStyle()) {
            Field field;
            int n3;
            object4 = new Label((CodeAttr)object6);
            object2 = compilation.fswitch;
            int n4 = ((SwitchState)object2).getMaxValue() + 1;
            ((SwitchState)object2).addCase(n4, (Label)object4, (CodeAttr)object6);
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
            ((CodeAttr)object6).emitLoad(compilation.callStackContext);
            ((CodeAttr)object6).emitLoad(compilation.callStackContext);
            ((CodeAttr)object6).emitPushInt(n4);
            ((CodeAttr)object6).emitPutField(Compilation.pcCallContextField);
            ((CodeAttr)object6).emitInvokeVirtual(Compilation.applyCpsMethod);
            printable = ((CodeAttr)object6).saveStackTypeState(false);
            Stack<Field> stack = new Stack<Field>();
            if (printable != null) {
                n3 = ((Printable)printable).length;
                while (--n3 >= 0) {
                    field = compilation.allocLocalField((Type)((Object)printable[n3]), null);
                    ((CodeAttr)object6).emitPushThis();
                    ((CodeAttr)object6).emitSwap();
                    ((CodeAttr)object6).emitPutField(field);
                    stack.push(field);
                }
            }
            ((CodeAttr)object6).emitReturn();
            ((Label)object4).define((CodeAttr)object6);
            if (printable != null) {
                n3 = ((Printable)printable).length;
                while (--n3 >= 0) {
                    field = (Field)stack.pop();
                    ((CodeAttr)object6).emitPushThis();
                    ((CodeAttr)object6).emitGetField(field);
                    compilation.freeLocalField(field);
                }
            }
            return;
        }
        boolean bl6 = bl3 = applyExp.tailCall && lambdaExp != null && lambdaExp == compilation.curLambda;
        if (lambdaExp != null && lambdaExp.getInlineOnly() && !bl3 && lambdaExp.min_args == n) {
            object2 = lambdaExp.firstDecl();
            int n5 = 0;
            while (n5 < n) {
                applyExp.args[n5].compile(compilation, ((Declaration)object2).getType());
                object2 = ((Declaration)object2).nextDecl();
                ++n5;
            }
            printable = compilation.curLambda;
            compilation.curLambda = lambdaExp;
            lambdaExp.allocChildClasses(compilation);
            lambdaExp.allocParameters(compilation);
            ApplyExp.popParams((CodeAttr)object6, lambdaExp, false);
            lambdaExp.enterFunction(compilation);
            lambdaExp.body.compileWithPosition(compilation, target);
            lambdaExp.compileEnd(compilation);
            lambdaExp.compileChildMethods(compilation);
            compilation.curLambda = printable;
            return;
        }
        if (compilation.curLambda.isHandlingTailCalls() && !compilation.curLambda.getInlineOnly()) {
            object2 = Compilation.typeCallContext;
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
            ((CodeAttr)object6).emitLoad(compilation.callStackContext);
            ((CodeAttr)object6).emitDupX();
            if (!applyExp.isTailCall()) {
                ((CodeAttr)object6).emitDupX();
            }
            if (n <= 4) {
                int n6 = 0;
                while (n6 < n) {
                    applyExp.args[n6].compile(compilation, Target.pushObject);
                    ++n6;
                }
                ((CodeAttr)object6).emitInvoke(((ClassType)object2).getDeclaredMethod("setArgs", n));
            } else {
                ApplyExp.compileToArray(applyExp.args, compilation);
                ((CodeAttr)object6).emitInvoke(((ClassType)object2).getDeclaredMethod("setArgsN", 1));
            }
            ((CodeAttr)object6).emitPutField(Compilation.procCallContextField);
            if (applyExp.isTailCall()) {
                ((CodeAttr)object6).emitReturn();
            } else if (target instanceof ConsumerTarget) {
                ((CodeAttr)object6).emitLoad(((ConsumerTarget)target).getConsumerVariable());
                ((CodeAttr)object6).emitInvoke(((ClassType)object2).getDeclaredMethod("runUntilValue", 1));
            } else {
                ((CodeAttr)object6).emitInvoke(((ClassType)object2).getDeclaredMethod("runUntilValue", 0));
                target.compileFromStack(compilation, Type.pointer_type);
            }
            return;
        }
        if (!bl3) {
            expression.compile(compilation, new StackTarget(Compilation.typeProcedure));
        }
        boolean bl7 = bl3 ? lambdaExp.min_args != lambdaExp.max_args : (bl2 = n > 4);
        if (bl2) {
            ApplyExp.compileToArray(applyExp.args, compilation);
            object5 = Compilation.applyNmethod;
        } else if (bl3) {
            object3 = lambdaExp.firstDecl();
            int n7 = 0;
            while (n7 < n) {
                applyExp.args[n7].compile(compilation, ((Declaration)object3).getType());
                object3 = ((Declaration)object3).nextDecl();
                ++n7;
            }
            object5 = null;
        } else {
            int n8 = 0;
            while (n8 < n) {
                applyExp.args[n8].compile(compilation, Target.pushObject);
                ++n8;
            }
            object5 = Compilation.applymethods[n];
        }
        if (bl3) {
            ApplyExp.popParams((CodeAttr)object6, lambdaExp, bl2);
            ((CodeAttr)object6).emitTailCall(false, lambdaExp.scope);
            return;
        }
        ((CodeAttr)object6).emitInvokeVirtual((Method)object5);
        target.compileFromStack(compilation, Type.pointer_type);
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkApplyExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.func = this.func.walk(expWalker);
        if (expWalker.exitValue == null) {
            this.args = expWalker.walkExps(this.args);
        }
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Apply", ")", 2);
        if (this.tailCall) {
            outPort.print(" [tailcall]");
        }
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        this.func.print(outPort);
        int n = 0;
        while (n < this.args.length) {
            outPort.writeSpaceLinear();
            this.args[n].print(outPort);
            ++n;
        }
        outPort.endLogicalBlock(")");
    }

    private static void popParams(CodeAttr codeAttr, LambdaExp lambdaExp, boolean bl) {
        Variable variable = lambdaExp.scope.firstVar();
        if (variable != null && variable.getName() == "this") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "$ctx") {
            variable = variable.nextVar();
        }
        if (variable != null && variable.getName() == "argsArray") {
            if (bl) {
                ApplyExp.popParams(codeAttr, variable, 1);
                return;
            }
            variable = variable.nextVar();
        }
        ApplyExp.popParams(codeAttr, variable, lambdaExp.min_args);
    }

    private static void popParams(CodeAttr codeAttr, Variable variable, int n) {
        if (n > 0) {
            ApplyExp.popParams(codeAttr, variable.nextVar(), n - 1);
            codeAttr.emitStore(variable);
        }
    }

    public final Type getType() {
        Object object2;
        Expression expression = this.func;
        if (expression instanceof ReferenceExp && (object2 = ((ReferenceExp)expression).binding) != null && !((Declaration)object2).getFlag(65536)) {
            expression = ((Declaration)object2).getValue();
        }
        if (expression instanceof QuoteExp && (object2 = ((QuoteExp)expression).getValue()) instanceof Inlineable) {
            return ((Inlineable)object2).getReturnType(this.args);
        }
        if (expression instanceof LambdaExp) {
            return ((LambdaExp)expression).getReturnType();
        }
        return super.getType();
    }

    public static Expression inlineIfConstant(Procedure procedure, ApplyExp applyExp) {
        int n;
        int n2 = n = applyExp.args.length;
        while (--n2 >= 0) {
            if (applyExp.args[n2] instanceof QuoteExp) continue;
            return applyExp;
        }
        Object[] objectArray = new Object[n];
        int n3 = n;
        while (--n3 >= 0) {
            objectArray[n3] = ((QuoteExp)applyExp.args[n3]).getValue();
        }
        try {
            return new QuoteExp(procedure.applyN(objectArray));
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

