/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.AWTEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import madkit.boot.Madkit;
import madkit.kernel.AGRTrio;
import madkit.kernel.AbstractAgent;
import madkit.kernel.AbstractMadkitBooter;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRException;
import madkit.kernel.ConnectionMessage;
import madkit.kernel.Group;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelAgent;
import madkit.kernel.KernelMessage;
import madkit.kernel.LaunchAgentException;
import madkit.kernel.Message;
import madkit.kernel.MessageException;
import madkit.kernel.Mirror;
import madkit.kernel.Mobile;
import madkit.kernel.NetworkRequest;
import madkit.kernel.Organization;
import madkit.kernel.OrganizationRequestException;
import madkit.kernel.PrivateMessage;
import madkit.kernel.SecuredMessage;
import madkit.kernel.StringMessage;
import madkit.kernel.SynchroMessage;
import madkit.kernel.siteAgentGUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SiteAgent
extends Agent {
    public static final String SITE = "site".intern();
    private AgentAddress myCommunicator = null;
    private final Map<String, Organization> organizations;
    private final Organization communities;
    private final KernelAgent kernelAgent;
    private final Collection<AgentAddress> distantKernels;
    private siteAgentGUI gui;

    SiteAgent(Map<String, Organization> map, KernelAgent kernelAgent) {
        this.organizations = map;
        this.communities = new Organization();
        map.put(Kernel.COMMUNITIES, this.communities);
        this.kernelAgent = new KernelAgent();
        this.distantKernels = new HashSet<AgentAddress>();
    }

    @Override
    public void initGUI() {
        this.gui = new siteAgentGUI(this);
        this.setGUIObject(this.gui);
    }

    @Override
    public final void activate() {
        this.setDebug(Madkit.debug);
        this.setName("SITE:" + this.getAddress().getKernel().getHost());
        this.createCommunity(Kernel.DEFAULT_COMMUNITY);
        this.createGroup(false, "communications", null, null);
        this.requestRole("communications", "site", null);
        this.createGroup(false, "system", null, null);
        this.requestRole("system", SITE, null);
        this.kernelAgent.setLocalOrg(this.organizations.get(Kernel.DEFAULT_COMMUNITY));
        try {
            this.getCurrentKernel().launchAgent(this.kernelAgent, "KernelAgent", this.getCurrentKernel(), false);
        }
        catch (LaunchAgentException launchAgentException) {
            launchAgentException.printStackTrace();
        }
    }

    @Override
    public final void live() {
        try {
            while (true) {
                Message message;
                if ((message = this.waitNextMessage()) instanceof SynchroMessage) {
                    this.handleSynchroMessage((SynchroMessage)message);
                    continue;
                }
                if (message instanceof ConnectionMessage) {
                    this.handleConnectionMessage((ConnectionMessage)message);
                    continue;
                }
                if (message instanceof NetworkRequest) {
                    this.handleNetworkRequest((NetworkRequest)message);
                    continue;
                }
                if (message instanceof StringMessage) {
                    this.handleMessage((StringMessage)message);
                    continue;
                }
                this.debug("receive an unknown message type :" + message);
            }
        }
        catch (Exception exception) {
            this.debug("Error : " + exception);
            exception.printStackTrace();
            return;
        }
    }

    protected void handleMessage(StringMessage stringMessage) {
        String string = stringMessage.getString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("$url")) {
            AbstractAgent abstractAgent;
            string2 = stringTokenizer.nextToken();
            AgentAddress agentAddress = this.getAgentWithRole("system", "browser");
            if (agentAddress == null && (agentAddress = (abstractAgent = AbstractMadkitBooter.getBooter().makeJavaAgent(this, "agents.system.WebBrowserAgent", true)).getAddress()) == null) {
                System.err.println("Error: cannot create WebBrowserAgent upon reception of a $url request");
            }
            this.sendMessage(agentAddress, new StringMessage("$goto " + string2));
        } else if (string2.equalsIgnoreCase("$message")) {
            try {
                AbstractAgent abstractAgent;
                String string3 = string.substring("$message".length() + 1, string.length());
                AgentAddress agentAddress = this.getAgentWithRole("system", "pager");
                if (agentAddress == null && (agentAddress = (abstractAgent = AbstractMadkitBooter.getBooter().makeJavaAgent(this, "madkit.system.Pager", true)).getAddress()) == null) {
                    System.err.println("Error: cannot create a Pager upon reception of a $message request");
                }
                this.sendMessage(agentAddress, new StringMessage("$display Received a remote message from " + stringMessage.getSender() + ": \n" + string3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void end() {
        System.err.println("SITE AGENT KILLED !!!!!!!!!!!!!");
        System.err.println("UNSTABLE SYSTEM ....");
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void handleSynchroMessage(SynchroMessage var1_1) {
        block24: {
            var2_2 = var1_1.community;
            if (!this.connectedWith(var2_2)) break block24;
            var3_3 = this.organizations.get(var2_2);
            if (var3_3 == null) {
                this.kernelAgent.callHooks(11, var2_2);
                var3_3 = new Organization();
                this.organizations.put(var2_2, var3_3);
            }
            switch (var1_1.code) {
                case 4: {
                    var3_3.createGroup(var1_1.initiator, true, var1_1.groupName, var1_1.newGroup.getDescription(), var1_1.newGroup.getGroupIdentifier());
                    this.kernelAgent.callHooks(4, new AGRTrio(var1_1.initiator, var2_2, var1_1.groupName, null));
                    return;
                }
                case 6: {
                    try {
                        var3_3.requestRole(var1_1.initiator, var1_1.groupName, var1_1.roleName, var1_1.memberCard);
                    }
                    catch (CGRException var4_4) {
                        if (!Madkit.debug) ** GOTO lbl24
                        this.debug("problem handling synchro message\n" + var1_1);
                        this.debug(var4_4.toString());
                        var4_4.printStackTrace();
                    }
lbl24:
                    // 3 sources

                    this.kernelAgent.callHooks(6, new AGRTrio(var1_1.initiator, var2_2, var1_1.groupName, var1_1.roleName));
                    return;
                }
                case 5: {
                    try {
                        if (var3_3.leaveGroup(var1_1.initiator, var1_1.groupName)) {
                            this.removeCommunity(var2_2);
                        }
                    }
                    catch (CGRException var4_5) {
                        if (!Madkit.debug) ** GOTO lbl36
                        this.debug("problem handling synchro message\n" + var1_1);
                        this.debug(var4_5.toString());
                        var4_5.printStackTrace();
                    }
lbl36:
                    // 3 sources

                    this.kernelAgent.callHooks(5, new AGRTrio(var1_1.initiator, var2_2, var1_1.groupName, null));
                    return;
                }
                case 11: {
                    this.establishConnectionWith(var1_1.getSender(), true);
                    return;
                }
                case 12: {
                    var3_3.removeAgentsFromKernel(var1_1.getSender().getKernel());
                    if (!var3_3.isEmpty()) return;
                    this.removeCommunity(var2_2);
                    this.kernelAgent.callHooks(12, var2_2);
                    return;
                }
                case 7: {
                    try {
                        if (var3_3.leaveRole(var1_1.initiator, var1_1.groupName, var1_1.roleName)) {
                            this.removeCommunity(var2_2);
                        }
                        this.kernelAgent.callHooks(7, new AGRTrio(var1_1.initiator, var2_2, var1_1.groupName, var1_1.roleName));
                        return;
                    }
                    catch (CGRException var4_6) {
                        if (!Madkit.debug) return;
                        this.debug("problem handling synchro message\n" + var1_1);
                        var4_6.setCommunity(var2_2);
                        this.debug(var4_6.toString());
                        var4_6.printStackTrace();
                    }
                    return;
                }
                case 13: {
                    if (Madkit.debug) {
                        this.debug("receiving a migration " + var1_1.ref.toString());
                    }
                    this.getCurrentKernel().receiveAgent(var1_1.ref);
                }
            }
            return;
        }
        switch (var1_1.code) {
            case 11: {
                this.kernelAgent.callHooks(11, var2_2);
                if (!Madkit.debug) break;
                this.debug("new community detected");
                break;
            }
            case 12: {
                this.kernelAgent.callHooks(12, var2_2);
                if (Madkit.debug) {
                    this.debug("a community has been deleted ");
                }
                if (this.gui == null) break;
                this.gui.refreshCommunities();
            }
        }
        if (this.gui == null) return;
        this.gui.refreshCommunities();
    }

    final void handleConnectionMessage(ConnectionMessage connectionMessage) {
        if (connectionMessage.isTheFirstMessage()) {
            this.getCurrentKernel().synchronizeKernel(connectionMessage.getOrgs(), true);
            this.establishConnectionWith(connectionMessage.getSender(), false);
        } else {
            this.getCurrentKernel().synchronizeKernel(connectionMessage.getOrgs(), false);
        }
        AgentAddress agentAddress = connectionMessage.getSender();
        if (this.distantKernels.add(agentAddress)) {
            if (Madkit.debug) {
                this.debug("*********************Connecting to " + agentAddress + "*******************");
            }
            this.kernelAgent.callHooks(9, agentAddress.getKernel());
            this.kernelAgent.callHooks(6, agentAddress, Kernel.COMMUNITIES, Kernel.DEFAULT_COMMUNITY, SITE);
        }
    }

    final synchronized void handleNetworkRequest(NetworkRequest networkRequest) {
        switch (networkRequest.getRequestCode()) {
            case 7: {
                try {
                    Message message = (Message)networkRequest.getArgument();
                    this.getCurrentKernel().sendLocalMessage(message);
                    if (message instanceof PrivateMessage) break;
                    if (message instanceof SecuredMessage) {
                        this.kernelAgent.callHooks(1, message.clone());
                        break;
                    }
                    this.kernelAgent.callHooks(1, message);
                }
                catch (MessageException messageException) {
                    if (!this.getDebug()) break;
                    System.err.println(messageException);
                }
                break;
            }
            case 3: {
                if (!networkRequest.getSender().equals(this.myCommunicator)) break;
                this.establishConnectionWith((AgentAddress)networkRequest.getArgument(), true);
                break;
            }
            case 4: {
                this.distantKernels.remove(networkRequest.getArgument());
                this.deconnection((String)networkRequest.getArgument());
                break;
            }
            case 1: {
                if (this.myCommunicator != null) break;
                this.redisplayMyGUI();
                this.myCommunicator = networkRequest.getSender();
                break;
            }
            case 2: {
                if (!networkRequest.getSender().equals(this.myCommunicator)) break;
                this.disposeMyGUI();
                this.myCommunicator = null;
                Iterator<Map.Entry<String, Organization>> iterator = this.organizations.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Organization> entry = iterator.next();
                    if (!entry.getValue().removeAgentsFromKernel(null)) continue;
                    this.leaveGroup("communities", entry.getKey());
                    iterator.remove();
                }
                this.distantKernels.clear();
                System.gc();
                System.runFinalization();
                break;
            }
            case 5: {
                this.sendMessage(networkRequest.getSender(), new NetworkRequest(5, this.distantKernels.toArray(new KernelAddress[this.distantKernels.size()])));
                break;
            }
            case 6: {
                if (Madkit.debug) {
                    this.println("receiving a migration request of " + networkRequest.getSender());
                }
                this.tryMigration((KernelAddress)networkRequest.getArgument(), networkRequest.getSender());
            }
        }
    }

    final synchronized void establishConnectionWith(AgentAddress agentAddress, boolean bl) {
        HashMap<String, Organization> hashMap = new HashMap<String, Organization>();
        for (Map.Entry<String, Organization> entry : this.organizations.entrySet()) {
            if (!this.connectedWith(entry.getKey())) continue;
            hashMap.put(entry.getKey(), entry.getValue().exportOrg());
        }
        this.sendMessage(agentAddress, new ConnectionMessage(hashMap, bl));
        if (Madkit.debug) {
            this.debug("sending connection message to " + agentAddress);
        }
    }

    final synchronized void deconnection(String string) {
        Iterator<AgentAddress> iterator = this.distantKernels.iterator();
        while (iterator.hasNext()) {
            AgentAddress agentAddress = iterator.next();
            if (!agentAddress.getKernel().getID().equals(string)) continue;
            if (Madkit.debug) {
                this.debug("disconnected from " + string);
            }
            Iterator<Map.Entry<String, Organization>> iterator2 = this.organizations.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Organization> entry = iterator2.next();
                if (!entry.getValue().removeAgentsFromKernel(agentAddress.getKernel())) continue;
                String string2 = entry.getKey();
                this.leaveGroup("communities", string2);
                this.sendAll(new SynchroMessage(5, this.getAddress(), Kernel.COMMUNITIES, string2, null, null));
                this.sendAll(new SynchroMessage(12, string2));
                iterator2.remove();
            }
            this.kernelAgent.callHooks(10, agentAddress.getKernel());
            this.kernelAgent.callHooks(7, agentAddress, Kernel.COMMUNITIES, Kernel.DEFAULT_COMMUNITY, SITE);
            iterator.remove();
            break;
        }
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    final synchronized void updateDistantOrgs(AgentAddress agentAddress, String string, String string2) {
        Collection<AgentAddress> collection = null;
        try {
            collection = this.communities.getRolePlayers(string, SITE);
        }
        catch (CGRException cGRException) {
            cGRException.setCommunity(string);
            if (!string.equals(Kernel.COMMUNITIES)) {
                // empty if block
            }
        }
        if (collection != null) {
            Organization organization = this.organizations.get(string);
            for (AgentAddress agentAddress2 : collection) {
                if (agentAddress2.equals(this.getAddress())) continue;
                SynchroMessage synchroMessage = new SynchroMessage(agentAddress, string, (Group)organization.get(string2), string2);
                synchroMessage.setSender(this.getAddress());
                synchroMessage.setReceiver(agentAddress2);
                this.sendDistantMessage(synchroMessage);
            }
        }
    }

    final synchronized void updateDistantOrgs(int n, AgentAddress agentAddress, String string, String string2, String string3, Object object) throws CGRException {
        SynchroMessage synchroMessage = new SynchroMessage(n, agentAddress, string, string2, string3, object);
        for (AgentAddress agentAddress2 : this.communities.getRolePlayers(string, SITE)) {
            if (agentAddress2.equals(this.getAddress())) continue;
            synchroMessage.setSender(this.getAddress());
            synchroMessage.setReceiver(agentAddress2);
            this.sendDistantMessage(synchroMessage);
        }
    }

    final synchronized void updateDistantOrgs(SynchroMessage synchroMessage) {
        String string = synchroMessage.community;
        if (this.connectedWith(string)) {
            try {
                if (string.equals(Kernel.COMMUNITIES)) {
                    string = synchroMessage.groupName;
                }
                for (AgentAddress agentAddress : this.communities.getRolePlayers(string, SITE)) {
                    if (agentAddress.equals(this.getAddress())) continue;
                    synchroMessage.setSender(this.getAddress());
                    synchroMessage.setReceiver(agentAddress);
                    this.sendDistantMessage(synchroMessage);
                }
            }
            catch (CGRException cGRException) {
                // empty catch block
            }
        }
    }

    final synchronized void tryMigration(KernelAddress kernelAddress, AgentAddress agentAddress) {
        AbstractAgent abstractAgent = Kernel.getReference(agentAddress);
        SynchroMessage synchroMessage = new SynchroMessage(abstractAgent);
        for (AgentAddress object : this.distantKernels) {
            if (!object.getKernel().equals(kernelAddress)) continue;
            synchroMessage.setReceiver(object);
            break;
        }
        if (synchroMessage.getReceiver() != null && abstractAgent != null && abstractAgent instanceof Mobile) {
            ((Agent)abstractAgent).getAgentThread().stop();
            if (Kernel.getAddress().equals(((Mobile)((Object)abstractAgent)).getMyAgency())) {
                AgentAddress agentAddress2 = ((Mobile)((Object)abstractAgent)).getMyBirthAddress();
                Mirror mirror = ((Mobile)((Object)abstractAgent)).createMirror(kernelAddress);
                this.getCurrentKernel().removeAgentFromOrganizations(agentAddress);
                this.getCurrentKernel().removeReferenceOf(agentAddress);
                abstractAgent.setCurrentKernel(null);
                this.currentKernel.launchMirror(mirror, agentAddress2, "mirroAgentOf" + this.getName(), this.getCurrentKernel(), true);
                ((Mobile)((Object)abstractAgent)).createMirror(kernelAddress);
            } else {
                this.getCurrentKernel().removeAgentFromOrganizations(agentAddress);
                this.getCurrentKernel().removeReferenceOf(agentAddress);
                abstractAgent.setCurrentKernel(null);
            }
            synchroMessage.setSender(this.getAddress());
            this.sendDistantMessage(synchroMessage);
        }
    }

    final synchronized void sendDistantMessage(Message message) {
        block3: {
            if (this.myCommunicator != null) {
                KernelMessage kernelMessage = null;
                kernelMessage = new KernelMessage(1, 1, message);
                kernelMessage.setSender(this.getAddress());
                kernelMessage.setReceiver(this.myCommunicator);
                try {
                    this.getCurrentKernel().sendLocalMessage(kernelMessage);
                    this.kernelAgent.callHooks(1, message instanceof SecuredMessage ? message.clone() : message);
                }
                catch (MessageException messageException) {
                    if (!Madkit.debug) break block3;
                    this.println("Unable to send distant message !!");
                    messageException.printStackTrace();
                }
            }
        }
    }

    private void sendAll(Message message) {
        message.setSender(this.getAddress());
        for (AgentAddress agentAddress : this.distantKernels) {
            message.setReceiver(agentAddress);
            this.sendDistantMessage(message);
        }
    }

    synchronized void joinCommunity(String string) {
        if (!this.connectedWith(string)) {
            if (Madkit.debug) {
                this.debug("connecting to community : " + string);
            }
            if (this.createGroup(true, Kernel.COMMUNITIES, string, null, null) == 1) {
                this.sendAll(new SynchroMessage(this.getAddress(), Kernel.COMMUNITIES, (Group)this.communities.get(string), string));
            }
            this.requestRole(Kernel.COMMUNITIES, string, SITE, null);
            this.sendAll(new SynchroMessage(6, this.getAddress(), Kernel.COMMUNITIES, string, SITE, null));
            this.sendAll(new SynchroMessage(11, string));
        } else if (Madkit.debug) {
            this.debug("already connected with " + string);
        }
    }

    synchronized void leaveCommunity(String string) {
        if (Madkit.debug) {
            this.debug("deconnecting community " + string);
        }
        if (this.organizations.get(string).removeAgentsFromKernel(null)) {
            this.leaveGroup(Kernel.COMMUNITIES, string);
            this.sendAll(new SynchroMessage(5, this.getAddress(), Kernel.COMMUNITIES, string, null, null));
            this.organizations.remove(string);
            this.kernelAgent.callHooks(12, string);
        } else {
            this.leaveRole(Kernel.COMMUNITIES, string, SITE);
            this.sendAll(new SynchroMessage(7, this.getAddress(), Kernel.COMMUNITIES, string, "site", null));
            this.sendAll(new SynchroMessage(12, string));
        }
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    synchronized void removeCommunity(String string) {
        if (Madkit.debug) {
            this.debug("removing community : " + string);
        }
        this.organizations.remove(string);
        this.kernelAgent.callHooks(12, string);
        this.leaveGroup(Kernel.COMMUNITIES, string);
        this.sendAll(new SynchroMessage(5, this.getAddress(), Kernel.COMMUNITIES, string, null, null));
        this.sendAll(new SynchroMessage(12, string));
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    synchronized boolean connectedWith(String string) {
        return string.equals(Kernel.COMMUNITIES) || this.communities.isPlayingRole(this.getAddress(), string, SITE);
    }

    synchronized Organization createCommunity(String string) {
        if (!this.organizations.containsKey(string)) {
            if (Madkit.debug) {
                this.debug("creating community : " + string);
            }
            Organization organization = new Organization();
            this.organizations.put(string.intern(), organization);
            this.createGroup(true, Kernel.COMMUNITIES, string, null, null);
            this.requestRole(Kernel.COMMUNITIES, string, SITE, null);
            this.sendAll(new SynchroMessage(this.getAddress(), Kernel.COMMUNITIES, (Group)this.communities.get(string), string));
            this.sendAll(new SynchroMessage(6, this.getAddress(), Kernel.COMMUNITIES, string, SITE, null));
            this.sendAll(new SynchroMessage(11, string));
            this.kernelAgent.callHooks(11, string);
            if (this.hasGUI()) {
                this.gui.refreshCommunities();
            }
            if (Madkit.debug) {
                this.debug("community <" + string + "> created");
            }
            return organization;
        }
        return null;
    }

    synchronized void refreshCommunities() {
        if (this.gui != null) {
            this.gui.refreshCommunities();
        }
    }

    synchronized String[] getCommunities() {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.communities.getGroups()) {
            try {
                if (!this.communities.isPlayingRole(this.getAddress(), string, Group.MEMBER_DEFAULT_ROLE) && ((Group)this.communities.get(string)).getRolePlayers(SITE).size() <= 0) continue;
                hashSet.add(string);
            }
            catch (CGRException cGRException) {
                // empty catch block
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public void windowClosing(AWTEvent aWTEvent) {
    }

    @Override
    public int createGroup(boolean bl, String string, String string2, String string3, GroupIdentifier groupIdentifier) {
        if (string3 == null) {
            string3 = string2;
        }
        try {
            this.currentKernel.createGroup(this.getAddress(), bl, string, string2, string3, groupIdentifier);
        }
        catch (OrganizationRequestException organizationRequestException) {
            if (this.getDebug()) {
                this.debug(organizationRequestException.getClass().getSimpleName() + organizationRequestException.getMessage());
                organizationRequestException.printStackTrace();
            }
            return organizationRequestException.getCode();
        }
        return 1;
    }
}

