/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.PrintStream;
import java.io.PrintWriter;
import madkit.boot.Madkit;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRException;
import madkit.kernel.MadkitException;

class OrganizationRequestException
extends Exception
implements MadkitException {
    private final AgentAddress requester;
    private final CGRException orgException;
    private final int code;

    OrganizationRequestException(AgentAddress agentAddress, CGRException cGRException) {
        super(null, Madkit.debug ? cGRException.getCause() : null);
        this.orgException = cGRException;
        this.requester = agentAddress;
        this.code = cGRException.getCode();
    }

    OrganizationRequestException(int n, AgentAddress agentAddress, String string, Throwable throwable) {
        super(string, throwable);
        this.requester = agentAddress;
        this.orgException = null;
        this.code = n;
    }

    public final String getMessage() {
        if (this.orgException != null) {
            return this.orgException.buildCGRMessage();
        }
        return super.getMessage();
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println("[" + this.requester.getName() + "]'s request failed : " + this.getMessage());
        super.printStackTrace(printStream);
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println("[" + this.requester.getName() + "]'s request failed : " + this.getMessage());
        super.printStackTrace(printWriter);
    }

    public int getCode() {
        return this.code;
    }
}

