/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.Dimension;
import java.awt.Point;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import madkit.boot.Madkit;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Agent;
import madkit.kernel.AgentAddress;
import madkit.kernel.CGRException;
import madkit.kernel.Communicator;
import madkit.kernel.Controller;
import madkit.kernel.CreateGroupException;
import madkit.kernel.GraphicShell;
import madkit.kernel.Group;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Keeper;
import madkit.kernel.KernelAddress;
import madkit.kernel.KernelAgent;
import madkit.kernel.KillAgentException;
import madkit.kernel.LaunchAgentException;
import madkit.kernel.LeaveGroupException;
import madkit.kernel.LeaveRoleException;
import madkit.kernel.Message;
import madkit.kernel.MessageException;
import madkit.kernel.Mirror;
import madkit.kernel.Mobile;
import madkit.kernel.Organization;
import madkit.kernel.OrganizationRequestException;
import madkit.kernel.Overlooker;
import madkit.kernel.PlaceKeeper;
import madkit.kernel.PrivateMessage;
import madkit.kernel.RequestRoleException;
import madkit.kernel.Scheduler;
import madkit.kernel.SecuredMessage;
import madkit.kernel.SiteAgent;
import madkit.kernel.SynchroMessage;
import madkit.kernel.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Kernel {
    public static boolean debug = false;
    static final boolean onLineMode = true;
    public static final String VERSION = "4.4.0 - Exodus";
    public static final String BUGREPORT = "Please file bug reports on the madkit forum at http://www.madkit.net";
    static final String COMMUNITIES = "communities".intern();
    public static final String DEFAULT_COMMUNITY = "public".intern();
    private static final ThreadGroup systemAgentsThread = new ThreadGroup("System agents");
    private static final ThreadGroup regularAgentsThread = new ThreadGroup("Regular agents");
    private static final ThreadGroup schedulerAgentsThread = new ThreadGroup("Scheduler agents");
    public static final int SEND_MESSAGE = 1;
    public static final int SEND_BROADCAST_MESSAGE = 2;
    public static final int KILL_AGENT = 3;
    public static final int CREATE_GROUP = 4;
    public static final int LEAVE_GROUP = 5;
    public static final int ADD_MEMBER_ROLE = 6;
    public static final int REMOVE_MEMBER_ROLE = 7;
    public static final int RESTORE_AGENT = 8;
    public static final int LAUNCH_AGENT = 0;
    public static final int CONNECTED_TO = 9;
    public static final int DISCONNECTED_FROM = 10;
    public static final int NEW_COMMUNITY = 11;
    public static final int DELETE_COMMUNITY = 12;
    public static final int MIGRATION = 13;
    static final int HOOKS_NUMBER = 14;
    public static final int GET_GROUPS = 20;
    public static final int GET_AGENTS = 21;
    public static final int DUMP_ORGANIZATION = 22;
    public static final int GET_AGENTINFO = 23;
    public static final int CONNECTION = 24;
    public static final int DECONNECTION = 25;
    public static final int DUMP_COMMUNITIES = 27;
    static KernelAddress kernelAddress;
    private String kernelName;
    private Writer ostream = new OutputStreamWriter(System.err);
    private SiteAgent siteAgent;
    private KernelAgent kernelAgent;
    GraphicShell gui = null;
    private static Map<AgentAddress, AbstractAgent> localAgents;
    private Map<String, Organization> organizations;
    public static boolean agressiveHeapMode;
    public static int defaultAgentsAllocation;
    static boolean interGroupMessage;
    static int agentsNb;
    static Communicator net;
    private Keeper KeeperAgent = null;

    public static int getAgentsNb() {
        return agentsNb;
    }

    public static KernelAddress getAddress() {
        return kernelAddress;
    }

    public void registerGUI(GraphicShell graphicShell) {
        this.gui = graphicShell;
    }

    public String getName() {
        return this.kernelName;
    }

    public Kernel(String string, boolean bl) {
        kernelAddress = new KernelAddress(bl);
        this.kernelName = string;
        this.initialization();
    }

    public Kernel(String string, boolean bl, String string2) {
        kernelAddress = new KernelAddress(bl, string2);
        this.kernelName = string;
        this.initialization();
    }

    public Kernel(String string) {
        this(string, false);
    }

    void initialization() {
        systemAgentsThread.setMaxPriority(10);
        regularAgentsThread.setMaxPriority(5);
        schedulerAgentsThread.setMaxPriority(4);
        this.organizations = new Hashtable<String, Organization>();
        this.kernelAgent = new KernelAgent();
        this.siteAgent = new SiteAgent(this.organizations, this.kernelAgent);
        localAgents = agressiveHeapMode ? new HashMap<AgentAddress, AbstractAgent>(defaultAgentsAllocation) : new HashMap<AgentAddress, AbstractAgent>();
        try {
            this.launchAgent(this.siteAgent, "SITEAGENT", this, false);
        }
        catch (LaunchAgentException launchAgentException) {
            this.display("!!!!!!!!!!!!!!!   system unstable !!!!!!!!!!!!!! ");
            launchAgentException.printStackTrace();
        }
        System.err.println("\n\t-----------------------------------------------------");
        System.err.println("\n\t\t\tMadKit/Aalaadin \n\n\t\t  by MadKit Team (c) 1997-2008\n");
        System.err.println("\t\t     version: 4.4.0 - Exodus");
        System.err.println("\n\t-----------------------------------------------------\n");
        System.err.println("Please file bug reports on the madkit forum at http://www.madkit.net\n");
        this.displayln("MadKit Agent microKernel " + Kernel.getAddress() + " is up and running\n");
    }

    final synchronized void createGroup(AgentAddress agentAddress, boolean bl, String string, String string2, String string3, GroupIdentifier groupIdentifier) throws OrganizationRequestException {
        Organization organization = this.getOrganizationFor(string);
        if (organization == null) {
            organization = this.siteAgent.createCommunity(string);
        }
        if (organization.createGroup(agentAddress, bl, string2, string3, groupIdentifier)) {
            this.kernelAgent.callHooks(4, agentAddress, string, string2, null);
            if (bl) {
                this.siteAgent.updateDistantOrgs(new SynchroMessage(agentAddress, string, (Group)organization.get(string2), string2));
            }
        } else {
            throw new CreateGroupException(agentAddress, " Group <" + string + "," + string2 + "> : already exists (set agent debug on for a trace)");
        }
    }

    final int joinPlace(Agent agent, String string, String string2) {
        return this.joinPlace(agent, "public", string, string2);
    }

    final int joinPlace(Agent agent, String string, String string2, String string3) {
        return this.KeeperAgent.joinPlace(agent, string, string2, string3);
    }

    final int createPlace(AgentAddress agentAddress, String string, String string2) {
        if (!this.isGroup("public", "Mobility")) {
            System.err.println("This application is not yet able to be a mobile one ! You must create a mobile Group first.");
            return -1;
        }
        if (this.isGroup("public", string)) {
            System.err.println("Place : " + string + " already existing!");
            return -2;
        }
        System.err.println("Creating the placeKeeper");
        PlaceKeeper placeKeeper = null;
        try {
            Class<?> clazz = Utils.loadClass("madkit.mobility.PlaceKeeperAgent");
            Constructor<?> constructor = clazz.getConstructor(Kernel.class, String.class);
            Agent agent = (Agent)constructor.newInstance(this, string);
            placeKeeper = (PlaceKeeper)((Object)agent);
            this.launchAgent(agent, string + ":placeKeeper", this, true);
        }
        catch (Exception exception) {
            System.err.println("Cannot create a placeKeeper: check if the Mobility plugin is available");
            return -1;
        }
        if (this.KeeperAgent.addPlace(placeKeeper, string)) {
            return 1;
        }
        this.killAgent((Agent)((Object)placeKeeper));
        return -1;
    }

    final boolean enableMobility(String string, int n) {
        if (this.KeeperAgent == null) {
            try {
                Class<?> clazz = Utils.loadClass("madkit.mobility.AgencyKeeper");
                Constructor<?> constructor = clazz.getConstructor(KernelAddress.class, String.class);
                Agent agent = (Agent)constructor.newInstance(Kernel.getAddress(), "agencyKeeperOf : " + string);
                this.KeeperAgent = (Keeper)((Object)agent);
                this.launchAgent(agent, "agencyKeeperOf" + Kernel.getAddress(), this, true);
            }
            catch (Exception exception) {
                System.err.println("Cannot create an AgencyKeeper: check if the Mobility plugin is available");
                return false;
            }
            this.kernelName = string;
            kernelAddress.setKernelName(this.kernelName);
            kernelAddress.enableMobility();
            boolean bl = this.launchCommunicator(n);
            if (bl) {
                System.err.println("Mobiliy activated : " + Kernel.getAddress().getInformation());
            } else {
                System.err.println("Cannot activate mobility...");
            }
            return bl;
        }
        System.err.println("A mobility group is already existing!");
        return true;
    }

    boolean launchCommunicator(int n) {
        if (net == null) {
            try {
                Agent agent = null;
                Class<?> clazz = Utils.loadClass("madkit.netcomm.NetAgent");
                if (n == 0) {
                    agent = (Agent)clazz.newInstance();
                } else {
                    Constructor<?> constructor = clazz.getConstructor(Integer.TYPE);
                    agent = (Agent)constructor.newInstance(new Integer(n));
                }
                net = (Communicator)((Object)agent);
                this.launchAgent(agent, "SiteAgent", this, true);
                return true;
            }
            catch (Exception exception) {
                System.err.println("Cannot create a communicator agent" + exception.toString());
                return false;
            }
        }
        return true;
    }

    final boolean supportMobility() {
        return kernelAddress.supportMobility();
    }

    final boolean connectAgencyToAgency(String string, int n) {
        if (this.supportMobility()) {
            if (net == null) {
                this.launchCommunicator(n);
            }
            net.connectAgency(this.kernelName, string, n);
            return true;
        }
        System.err.println("Mobility is not supported yet!! ");
        return false;
    }

    public KernelAddress getAgencyNamed(String string) {
        return this.KeeperAgent.getAgencyNamed(string);
    }

    public synchronized void launchMirror(Mirror mirror, AgentAddress agentAddress, String string, Object object, boolean bl) {
        Point point = new Point(100, 100);
        Dimension dimension = new Dimension(120, 120);
        Agent agent = (Agent)((Object)mirror);
        if (debug) {
            this.displayln("Agent launch: " + string + ", created by " + object.toString());
        }
        if (agent.getAddress() == null) {
            agent.setMyAddress(new AgentAddress(string, Kernel.getAddress()));
            agent.setCurrentKernel(this);
            agent.getAddress().update(agentAddress);
            agent.setCurrentKernel(this);
            localAgents.put(agent.getAddress(), agent);
            if (bl && this.gui != null) {
                this.gui.setupGUI(agent, point, dimension);
            }
            Thread thread = null;
            if (agent instanceof Agent) {
                thread = new Thread(regularAgentsThread, agent, agent.getName() + "_thread");
            }
            if (thread != null) {
                thread.start();
            } else {
                Controller controller = agent.getController();
                if (controller != null) {
                    controller.activate();
                } else {
                    agent.activate();
                }
            }
            ++agentsNb;
            this.kernelAgent.callHooks(0, agent.getAddress());
        } else if (debug) {
            this.displayln("ASSERT: agent already registred");
        }
    }

    final synchronized void receiveAgent(AbstractAgent abstractAgent) {
        Thread thread = null;
        if (abstractAgent instanceof Mobile) {
            thread = new Thread((Runnable)((Agent)abstractAgent), abstractAgent.getName() + "_thread");
            if (((Mobile)((Object)abstractAgent)).getMyAgency().equals(kernelAddress)) {
                System.out.println("One of my Mobile Agents is coming back. Welcome!");
                Mirror mirror = (Mirror)((Object)localAgents.get(((Mobile)((Object)abstractAgent)).getMyBirthAddress()));
                this.killAgent((Agent)((Object)mirror));
                ((Mobile)((Object)abstractAgent)).setMirrorAgent(mirror);
                abstractAgent.getAddress().update(((Mobile)((Object)abstractAgent)).getMyBirthAddress());
            } else {
                abstractAgent.getAddress().update(kernelAddress);
            }
            abstractAgent.setCurrentKernel(this);
            localAgents.put(abstractAgent.getAddress(), abstractAgent);
            if (this.gui != null) {
                this.gui.setupGUI(abstractAgent);
            }
            if (thread != null) {
                thread.start();
            } else {
                abstractAgent.activate();
            }
        }
    }

    final void requestRole(AgentAddress agentAddress, String string, String string2, String string3, Object object) throws RequestRoleException {
        try {
            Organization organization = this.getOrganizationFor(string);
            organization.requestRole(agentAddress, string2, string3, object);
            if (organization.isDistributed(string2)) {
                this.siteAgent.updateDistantOrgs(new SynchroMessage(6, agentAddress, string, string2, string3, object));
            }
            this.kernelAgent.callHooks(6, agentAddress, string, string2, string3);
        }
        catch (NullPointerException nullPointerException) {
            throw new RequestRoleException(agentAddress, new CGRException(-1, string, null, null, nullPointerException));
        }
        catch (CGRException cGRException) {
            cGRException.setCommunity(string);
            throw new RequestRoleException(agentAddress, cGRException);
        }
    }

    final boolean leaveGroup(AgentAddress agentAddress, String string, String string2) throws LeaveGroupException {
        Organization organization = this.getOrganizationFor(string);
        try {
            if (organization.leaveGroup(agentAddress, string2)) {
                this.siteAgent.removeCommunity(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new LeaveGroupException(agentAddress, new CGRException(-1, string, null, null, nullPointerException));
        }
        catch (CGRException cGRException) {
            cGRException.setCommunity(string);
            throw new LeaveGroupException(agentAddress, cGRException);
        }
        if (organization.isDistributed(string2)) {
            this.siteAgent.updateDistantOrgs(new SynchroMessage(5, agentAddress, string, string2, null, null));
        }
        this.kernelAgent.callHooks(5, agentAddress, string, string2, null);
        return true;
    }

    final void leaveRole(AgentAddress agentAddress, String string, String string2, String string3) throws LeaveRoleException {
        Organization organization = this.getOrganizationFor(string);
        try {
            boolean bl = organization.leaveRole(agentAddress, string2, string3);
            if (organization.isDistributed(string2)) {
                this.siteAgent.updateDistantOrgs(new SynchroMessage(7, agentAddress, string, string2, string3, null));
            }
            this.kernelAgent.callHooks(7, agentAddress, string, string2, string3);
            if (bl) {
                this.siteAgent.removeCommunity(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new LeaveRoleException(agentAddress, new CGRException(-1, string, null, null, nullPointerException));
        }
        catch (CGRException cGRException) {
            cGRException.setCommunity(string);
            throw new LeaveRoleException(agentAddress, cGRException);
        }
    }

    final boolean isBelongingToGroup(AgentAddress agentAddress, String string, String string2) {
        try {
            return this.getOrganizationFor(string).isPlayingRole(agentAddress, string2, Group.MEMBER_DEFAULT_ROLE);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    final boolean addOverlooker(AgentAddress agentAddress, Overlooker<? extends AbstractAgent> overlooker, Object object) {
        try {
            return this.getOrganizationFor(overlooker.community).addOverlooker(agentAddress, overlooker, object);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    final void removeOverlooker(Overlooker<? extends AbstractAgent> overlooker) {
        try {
            if (this.getOrganizationFor(overlooker.community).removeOverlooker(overlooker)) {
                this.siteAgent.removeCommunity(overlooker.community);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("error while removing overlooker " + nullPointerException.getStackTrace());
        }
        catch (Exception exception) {
            System.err.println("error while removing overlooker " + exception.getStackTrace());
        }
    }

    public final synchronized void launchAgent(AbstractAgent abstractAgent, String string, Object object, boolean bl) throws LaunchAgentException {
        this.launchAgent(abstractAgent, string, object, bl, new Point(-1, -1), new Dimension(-1, -1));
    }

    public final synchronized void launchAgent(AbstractAgent abstractAgent, String string, Object object, boolean bl, Point point, Dimension dimension) throws LaunchAgentException {
        if (abstractAgent.getAddress() == null) {
            Thread thread;
            abstractAgent.setMyAddress(new AgentAddress(string, Kernel.getAddress()));
            abstractAgent.setCurrentKernel(this);
            localAgents.put(abstractAgent.getAddress(), abstractAgent);
            if (bl && this.gui != null) {
                this.gui.setupGUI(abstractAgent, point, dimension);
            }
            if ((thread = abstractAgent.getAgentThread()) != null) {
                if (!(abstractAgent instanceof Scheduler)) {
                    if (!(abstractAgent instanceof SiteAgent) && !(abstractAgent instanceof KernelAgent)) {
                        thread = new Thread(regularAgentsThread, (Agent)abstractAgent, abstractAgent.getName() + "_thread");
                        thread.setPriority(4);
                    } else {
                        thread = new Thread(systemAgentsThread, (Agent)abstractAgent, abstractAgent.getName() + "_thread");
                        thread.setDaemon(true);
                        thread.setPriority(5);
                    }
                } else {
                    thread = new Thread(schedulerAgentsThread, (Agent)abstractAgent, abstractAgent.getName() + "_thread");
                    thread.setPriority(3);
                }
            }
            if (thread != null) {
                thread.start();
            } else {
                Controller controller = abstractAgent.getController();
                if (controller != null) {
                    controller.activate();
                } else {
                    abstractAgent.activate();
                }
            }
            ++agentsNb;
            if (Madkit.debug) {
                if (object instanceof AbstractAgent) {
                    this.displayln("Agent launched : <" + abstractAgent.getAddress() + ">, created by agent <" + ((AbstractAgent)object).getAddress() + ">");
                } else {
                    this.displayln("Agent launched : <" + abstractAgent.getAddress() + ">, created by <" + this.getName() + (object instanceof Kernel ? ">" : ">, requested by " + object.getClass().getSimpleName()));
                }
            }
        } else {
            throw new LaunchAgentException(-30, abstractAgent.getAddress(), " unable to launch agent " + string + " : it is already registred", null);
        }
        this.kernelAgent.callHooks(0, abstractAgent.getAddress());
    }

    final void killAgent(AbstractAgent abstractAgent, AbstractAgent abstractAgent2) throws KillAgentException {
        this.killAgent(abstractAgent);
    }

    public final synchronized void killAgent(AbstractAgent abstractAgent) {
        Controller controller;
        if (abstractAgent.getCurrentKernel() == null) {
            return;
        }
        Thread thread = abstractAgent.getAgentThread();
        if (thread != null && thread != Thread.currentThread()) {
            thread.stop();
        }
        if ((controller = abstractAgent.getController()) != null) {
            controller.end();
        } else {
            abstractAgent.end();
        }
        this.removeAgentFromOrganizations(abstractAgent.getAddress());
        localAgents.remove(abstractAgent.getAddress());
        if (this.gui != null) {
            this.gui.disposeGUI(abstractAgent);
        }
        abstractAgent.setCurrentKernel(null);
        this.kernelAgent.callHooks(3, abstractAgent.getAddress());
        --agentsNb;
        abstractAgent.setMyAddress(null);
        abstractAgent = null;
    }

    final synchronized void restoreAgent(AbstractAgent abstractAgent, String string, Object object, boolean bl) {
        if (debug) {
            this.displayln("Agent restoration: " + string + ", restored by " + object.toString());
        }
        if (abstractAgent.getAddress() != null) {
            abstractAgent.setCurrentKernel(this);
            localAgents.put(abstractAgent.getAddress(), abstractAgent);
            if (bl && this.gui != null) {
                this.gui.setupGUI(abstractAgent);
            }
            Thread thread = null;
            if (abstractAgent instanceof Agent) {
                thread = new Thread((Runnable)((Agent)abstractAgent), abstractAgent.getName() + "_thread");
            }
            if (thread != null) {
                thread.start();
            } else {
                abstractAgent.activate();
            }
            this.kernelAgent.callHooks(8, abstractAgent.getAddress());
        } else if (debug) {
            this.displayln("ASSERT: restoration impossible: agent has not been previously launched");
        }
    }

    private final synchronized void killAgents() {
        Iterator<AgentAddress> iterator = localAgents.keySet().iterator();
        while (iterator.hasNext()) {
            AgentAddress agentAddress = iterator.next();
            if (!agentAddress.equals(this.kernelAgent.getAddress())) {
                this.removeAgentFromOrganizations(agentAddress);
            }
            iterator.remove();
        }
    }

    final synchronized void removeReferenceOf(AgentAddress agentAddress) {
        block3: {
            if (this.gui != null) {
                try {
                    this.gui.disposeGUI(localAgents.get(agentAddress));
                }
                catch (Exception exception) {
                    if (!Madkit.debug) break block3;
                    exception.printStackTrace();
                }
            }
        }
        localAgents.remove(agentAddress);
    }

    final void sendMessage(Message message) {
        if (message.getReceiver().isLocal()) {
            if (message instanceof PrivateMessage) {
                this.sendLocalMessage(message);
            } else if (message instanceof SecuredMessage) {
                this.sendLocalMessage(message.clone());
                this.kernelAgent.callHooks(1, message.clone());
            } else {
                this.sendLocalMessage(message);
                this.kernelAgent.callHooks(1, message);
            }
        } else {
            this.siteAgent.sendDistantMessage(message);
        }
    }

    final void sendLocalMessage(Message message) throws MessageException {
        try {
            localAgents.get(message.getReceiver()).receiveMessage(message);
        }
        catch (NullPointerException nullPointerException) {
            throw new MessageException(message.getSender(), " Unable to send message : unknown agent -> " + message.getReceiver(), Madkit.debug ? nullPointerException : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendBroadcastMessage(String string, String string2, String string3, Message message) throws MessageException {
        Organization organization = this.getOrganizationFor(string);
        if (organization != null) {
            Collection<AgentAddress> collection = null;
            Organization organization2 = organization;
            synchronized (organization2) {
                block14: {
                    try {
                        collection = organization.getRolePlayers(string2, string3);
                    }
                    catch (CGRException cGRException) {
                        throw new MessageException(message.getSender(), " Unable to broadcast message : " + cGRException.getMessage(), Madkit.debug ? cGRException : null);
                    }
                    if (collection == null) {
                        throw new MessageException(message.getSender(), " Unable to broadcast message : nobody as receiver", null);
                    }
                    if (!(message instanceof PrivateMessage)) {
                        ArrayList arrayList = new ArrayList();
                        arrayList.add(string2);
                        arrayList.add(string3);
                        if (message instanceof SecuredMessage) {
                            arrayList.add(message.clone());
                        } else {
                            arrayList.add(message);
                        }
                        this.kernelAgent.callHooks(2, arrayList);
                    }
                    try {
                        for (AgentAddress agentAddress : collection) {
                            if (agentAddress.isLocal()) {
                                message = message.clone();
                                message.setReceiver(agentAddress);
                                this.sendLocalMessage(message);
                                continue;
                            }
                            message.setReceiver(agentAddress);
                            this.siteAgent.sendDistantMessage(message);
                        }
                    }
                    catch (MessageException messageException) {
                        if (!Madkit.debug) break block14;
                        this.siteAgent.debug("Unable to send message : " + message + " : " + messageException);
                        messageException.printStackTrace();
                    }
                }
            }
        }
    }

    static final synchronized AbstractAgent getReference(Object object) {
        return localAgents.get(object);
    }

    static final synchronized AgentAddress[] getLocalAgents() {
        return localAgents.keySet().toArray(new AgentAddress[localAgents.size()]);
    }

    final Organization getOrganizationFor(String string) {
        return this.organizations.get(string);
    }

    final boolean isGroup(String string, String string2) {
        try {
            return this.getOrganizationFor(string).getNotEmptyGroup(string2) != null;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public final synchronized String[] getCurrentGroupsOf(AgentAddress agentAddress, String string) {
        try {
            Collection<String> collection = this.getOrganizationFor(string).getCurrentGroupsOf(agentAddress);
            return collection.toArray(new String[collection.size()]);
        }
        catch (NullPointerException nullPointerException) {
            return new String[0];
        }
    }

    public final synchronized String[] getExistingGroups(String string) {
        try {
            return this.getOrganizationFor(string).getGroups();
        }
        catch (NullPointerException nullPointerException) {
            return new String[0];
        }
    }

    public final synchronized AgentAddress[] getRolePlayers(String string, String string2, String string3) throws CGRException {
        try {
            Collection<AgentAddress> collection = this.getOrganizationFor(string).getRolePlayers(string2, string3);
            return collection.toArray(new AgentAddress[collection.size()]);
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-1, string, null, null, nullPointerException);
        }
        catch (CGRException cGRException) {
            cGRException.setCommunity(string);
            throw cGRException;
        }
    }

    final synchronized AgentAddress getAnotherRolePlayer(AbstractAgent abstractAgent, String string, String string2, String string3) throws CGRException {
        try {
            ArrayList<AgentAddress> arrayList = new ArrayList<AgentAddress>(this.getOrganizationFor(string).getRolePlayers(string2, string3));
            arrayList.remove(abstractAgent.getAddress());
            int n = arrayList.size();
            if (n == 0) {
                return null;
            }
            return (AgentAddress)arrayList.get((int)(Math.random() * (double)n));
        }
        catch (NullPointerException nullPointerException) {
            throw new CGRException(-1, string, null, null, nullPointerException);
        }
        catch (CGRException cGRException) {
            cGRException.setCommunity(string);
            throw cGRException;
        }
    }

    final synchronized String[] getGroupRolesOf(AgentAddress agentAddress, String string, String string2) {
        try {
            return this.getOrganizationFor(string).getGroupRolesOf(agentAddress, string2);
        }
        catch (NullPointerException nullPointerException) {
            return new String[0];
        }
    }

    public final synchronized String[] getExistingRoles(String string, String string2) {
        try {
            return this.getOrganizationFor(string).getRolesIn(string2);
        }
        catch (NullPointerException nullPointerException) {
            return new String[0];
        }
    }

    final synchronized boolean isCommunity(String string) {
        Organization organization = this.getOrganizationFor(COMMUNITIES);
        try {
            return organization.isPlayingRole(this.siteAgent.getAddress(), string, Group.MEMBER_DEFAULT_ROLE) || organization.getRolePlayer(string, "site") != null;
        }
        catch (CGRException cGRException) {
            return false;
        }
    }

    final synchronized String[] getCommunities() {
        return this.siteAgent.getCommunities();
    }

    final synchronized boolean connectedWithCommunity(String string) {
        return this.getOrganizationFor(COMMUNITIES).isPlayingRole(this.siteAgent.getAddress(), string, "site");
    }

    final synchronized void removeAgentFromOrganizations(AgentAddress agentAddress) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Organization> entry : this.organizations.entrySet()) {
            Organization organization = entry.getValue();
            if (!organization.agentIn(agentAddress)) continue;
            String string = entry.getKey();
            for (String string2 : organization.removeAgentFromAllGroups(agentAddress)) {
                if (organization.isDistributed(string2)) {
                    this.siteAgent.updateDistantOrgs(new SynchroMessage(5, agentAddress, string, string2, null, null));
                }
                this.kernelAgent.callHooks(5, agentAddress, string, string2, null);
            }
            if (!organization.isEmpty()) continue;
            arrayList.add(string);
        }
        for (String string : arrayList) {
            this.siteAgent.removeCommunity(string);
        }
    }

    synchronized Map<String, Map> getDumpCommunities() {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (Map.Entry<String, Organization> entry : this.organizations.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getLocalOrganization());
        }
        return hashMap;
    }

    public void stopKernel() {
        this.displayln("Disconnecting MadKit Kernel: " + this.getName());
        this.displayln("- killing local agents " + this.getName());
        this.killAgents();
        this.displayln("MadKit Kernel closed.");
        System.exit(0);
    }

    public void displayln(String string) {
        this.display(string + '\n');
    }

    public void display(String string) {
        System.err.print("<" + this.getName() + "> : " + string);
    }

    public void setOutputStream(Writer writer) {
        this.ostream = writer;
    }

    final void disposeGUIOf(AbstractAgent abstractAgent) {
        if (this.gui != null) {
            this.gui.disposeGUIImmediatly(abstractAgent);
        }
    }

    final void redisplayGUIOf(AbstractAgent abstractAgent) {
        if (this.gui != null) {
            this.gui.setupGUI(abstractAgent);
        }
    }

    @Deprecated
    public synchronized Vector getMemberRoles(String string, AgentAddress agentAddress) {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.getGroupRolesOf(agentAddress, DEFAULT_COMMUNITY, string);
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    void synchronizeKernel(Map<String, Organization> map, boolean bl) {
        for (Map.Entry<String, Organization> entry : map.entrySet()) {
            if (!this.siteAgent.connectedWith(entry.getKey())) continue;
            if (!this.organizations.containsKey(entry.getKey())) {
                this.organizations.put(entry.getKey(), new Organization());
            }
            this.organizations.get(entry.getKey()).importOrg(entry.getValue(), bl);
        }
        this.siteAgent.refreshCommunities();
    }

    public static void debugString() {
        System.err.println("--------------------------------------kernel status");
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Thread[] threadArray = new Thread[threadGroup.activeCount()];
        threadGroup.enumerate(threadArray);
        for (int i = 0; i < threadArray.length; ++i) {
            if (threadArray[i] == null) continue;
            System.err.println("" + i + ":  " + threadArray[i] + " is demon " + threadArray[i].isDaemon());
        }
        System.err.println("used memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        System.err.println("locals agents are " + localAgents.size());
    }

    public void destroyGroup(String string, String string2) {
        Organization organization = this.organizations.get(string);
        ((Group)organization.remove(string2)).clear();
        if (organization.isEmpty()) {
            this.siteAgent.removeCommunity(string);
        }
    }

    static {
        localAgents = null;
        agressiveHeapMode = true;
        defaultAgentsAllocation = 150000;
        interGroupMessage = true;
        agentsNb = 0;
        net = null;
    }
}

