/*
 * Decompiled with CFR 0.152.
 */
package madkit.boot;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import madkit.boot.MadkitClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Madkit {
    public static boolean debug = false;
    public static boolean outputOnRequestErrors = true;
    public static final String madkitdirname = "$MADKIT";
    public static final String homedirname = "$HOME";
    public static final String libDirName = "lib";
    public static final String autoloadDir = "autoload";
    public static final String pluginsDirName = "plugins";
    public static final String libDirectory = Madkit.lookForDirectory("lib").getPath();
    public static final String madkitDirectory = new File(libDirectory).getParent();
    public static MadkitClassLoader madkitClassLoader;

    public static MadkitClassLoader getClassLoader() {
        return madkitClassLoader;
    }

    public static File lookForDirectory(String string) {
        File file = new File(System.getProperty("user.dir"));
        do {
            File file2;
            if (!(file2 = new File(file + File.separator + string)).exists() || !file2.isDirectory()) continue;
            return file2;
        } while ((file = file.getParentFile()) != null);
        return new File(".");
    }

    public static void newMadkitClassLoader(File[] fileArray) {
        MadkitClassLoader madkitClassLoader = Madkit.madkitClassLoader;
        Madkit.madkitClassLoader = MadkitClassLoader.newMadkitClassLoader(fileArray, madkitClassLoader);
    }

    public static URL[] getAllURL() {
        System.setProperty("madkit.dir", madkitDirectory);
        Vector<URL> vector = new Vector<URL>();
        String string = "";
        Madkit.addMadkitClassLoader(vector, Madkit.lookForDirectory(libDirName));
        Madkit.addMadkitClassLoader(vector, Madkit.lookForDirectory(pluginsDirName));
        Madkit.addMadkitClassLoader(vector, Madkit.lookForDirectory(autoloadDir));
        System.setProperty("user.dir", madkitDirectory);
        URL[] uRLArray = new URL[vector.size()];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = vector.elementAt(i);
            string = string + File.pathSeparator + vector.elementAt(i).getFile();
        }
        System.setProperty("python.path", string);
        System.setProperty("java.class.path", System.getProperty("java.class.path") + File.pathSeparator + string);
        return uRLArray;
    }

    public static void addMadkitClassLoader(Vector<URL> vector, File file) {
        if (file != null && file.isDirectory()) {
            for (String string : file.list()) {
                File file2 = new File(file.getAbsolutePath() + File.separator + string);
                if (file2.isDirectory()) {
                    Madkit.addMadkitClassLoader(vector, file2);
                    continue;
                }
                if (!file2.getPath().endsWith(".jar")) continue;
                try {
                    vector.add(file2.toURL());
                }
                catch (MalformedURLException malformedURLException) {
                    System.err.println("Error: bad file " + file2.getPath());
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Error: no boot class for booting MadKit");
            System.exit(0);
        }
        String string = stringArray[0];
        URL[] uRLArray = Madkit.getAllURL();
        madkitClassLoader = new MadkitClassLoader(uRLArray);
        try {
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            Class<?> clazz = madkitClassLoader.loadClass(string);
            Class[] classArray = new Class[]{String[].class};
            Object[] objectArray = new Object[]{stringArray2};
            Method method = clazz.getMethod("main", classArray);
            method.invoke(clazz, objectArray);
        }
        catch (Exception exception) {
            System.err.println("Error while booting Madkit " + stringArray[0]);
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }
}

