/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import warbot.kernel.Brain;
import warbot.kernel.Food;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class HomeKiller
extends Brain {
    String groupName = "warbot-";
    String roleName = "launcher";
    int waitingForRocket = 0;
    int waitingMax = 3;

    public void activate() {
        this.groupName = String.valueOf(String.valueOf(this.groupName)).concat(String.valueOf(String.valueOf(this.getTeam())));
        this.randomHeading();
        this.println("I am a home killer robot");
        this.createGroup(false, this.groupName, null, null);
        this.requestRole(this.groupName, this.roleName, null);
        this.requestRole(this.groupName, "mobile", null);
    }

    void decrWaitingForRocket() {
        --this.waitingForRocket;
        if (this.waitingForRocket < 0) {
            this.waitingForRocket = 0;
        }
    }

    public void doIt() {
        String act;
        Percept[] detectedEntities;
        this.decrWaitingForRocket();
        if (!this.isMoving()) {
            this.randomHeading();
        }
        if ((detectedEntities = this.getPercepts()).length > 0) {
            for (int i = 0; i < detectedEntities.length; ++i) {
                Percept e = detectedEntities[i];
                if (e.getPerceptType().equals("Home") && !e.getTeam().equals(this.getTeam())) {
                    this.launchRocket(this.towards(e.getX(), e.getY()));
                    this.waitingForRocket = this.waitingMax;
                    return;
                }
                if (!e.getPerceptType().equals("RocketLauncher") && !e.getPerceptType().equals("Explorer") || this.waitingForRocket > 0 || e.getTeam().equals(this.getTeam())) continue;
                this.launchRocket(this.towards(e.getX(), e.getY()));
                this.waitingForRocket = this.waitingMax;
                return;
            }
        }
        int min = 0;
        for (int i = 0; i < detectedEntities.length; ++i) {
            Percept e = detectedEntities[i];
            if (!(this.distanceTo(e) < this.distanceTo(detectedEntities[min])) || !e.getPerceptType().equals("Food")) continue;
            min = i;
        }
        if (detectedEntities.length > 0 && detectedEntities[min].getPerceptType().equals("Food")) {
            if (this.distanceTo(detectedEntities[min]) < (double)2) {
                this.eat((Food)detectedEntities[min]);
                return;
            }
            this.setHeading(this.towards(detectedEntities[min].getX(), detectedEntities[min].getY()));
            this.move();
            return;
        }
        WarbotMessage m = null;
        WarbotMessage lastMessage = null;
        while ((m = this.readMessage()) != null) {
            lastMessage = m;
        }
        if (lastMessage != null && (act = lastMessage.getAct()).equals("homeposition")) {
            double xpos = Double.parseDouble(lastMessage.getArg1());
            double ypos = Double.parseDouble(lastMessage.getArg2());
            this.setHeading(this.towardsAbsolute(xpos, ypos));
        }
        this.move();
    }
}

