/*
 * Decompiled with CFR 0.152.
 */
package warbot.demo;

import java.awt.Point;
import warbot.demo.Assault;
import warbot.demo.Courageux;
import warbot.demo.FearfullAssault;
import warbot.demo.Garde;
import warbot.demo.HalBrain;
import warbot.demo.Mefiant;
import warbot.demo.Memoire;
import warbot.demo.Peureux;
import warbot.demo.Tache;
import warbot.kernel.Percept;
import warbot.kernel.WarbotMessage;

public class HalLauncher
extends HalBrain {
    private boolean dejaVu = false;

    public void checkMess(int act, WarbotMessage m) {
        super.checkMess(act, m);
        switch (act) {
            case 3: {
                this.mem.setCap(Integer.parseInt(m.getArg1()));
                this.setHeading(this.mem.getCap());
                break;
            }
            case 4: {
                this.mem.setEtat("peureux");
                break;
            }
            case 5: {
                this.mem.setEtat("mefiant");
                break;
            }
            case 6: {
                int xpos = Integer.parseInt(m.getArg1());
                int ypos = Integer.parseInt(m.getArg2());
                this.mem.newBase(xpos, ypos);
                break;
            }
            case 7: {
                if (m.getSender().equals((Object)this.getAddress()) || this.mem.monSquad.equals(m.getArg1())) break;
                this.send(m.getSender(), "" + 2, this.mem.getEtat());
                break;
            }
            case 8: {
                if (m.getArg1().equals(this.mem.monSquad)) break;
                int i = 0;
                while (i < this.mem.nbAmis()) {
                    Percept am = this.mem.getAmi(i);
                    if (Math.abs(am.getX() - m.getFromX()) < 3.0 && Math.abs(am.getY() - m.getFromY()) < 3.0) {
                        this.mem.messAskFu.addElement(m);
                    }
                    ++i;
                }
                break;
            }
            case 9: {
                if (this.dejaVu) break;
                this.dejaVu = true;
                this.mem.squadSize += Integer.parseInt(m.getArg2());
                this.broadcast(this.mem.monSquad, "lieutenant", "" + 11, m.getArg1(), "" + this.mem.squadSize);
                this.randomHeading();
                this.broadcast(m.getArg1(), "lieutenant", "" + 10, "" + this.mem.squadSize);
                break;
            }
            case 10: {
                this.mem.squadSize = Integer.parseInt(m.getArg1());
                this.mem.voisin = this.mem.nbAmis();
                this.unionFaitLaForce();
                break;
            }
            case 11: {
                this.dejaVu = false;
                this.leaveGroup(this.mem.monSquad);
                this.mem.monSquad = m.getArg1();
                this.requestRole(this.mem.monSquad, "lieutenant", null);
                this.mem.voisin = this.mem.nbAmis();
                this.mem.squadSize = Integer.parseInt(m.getArg2());
                this.unionFaitLaForce();
                break;
            }
            case 12: {
                if (!this.mem.getEtat().equals("peureux") || !(Math.pow(m.getFromX(), 2.0) + Math.pow(m.getFromY(), 2.0) < 160000.0) || this.mem.posSOSX != 0 || this.mem.posSOSY != 0) break;
                this.mem.posSOSX = Integer.parseInt(m.getArg1());
                this.mem.posSOSY = Integer.parseInt(m.getArg2());
                break;
            }
            case 13: {
                if (this.mem.squadSize > 1) {
                    this.mem.squadSize += -1;
                }
                if (!this.mem.monSquad.equals(m.getArg1())) break;
                this.jeMcasse();
                break;
            }
            case 14: {
                this.send(m.getSender(), "" + 2, this.mem.getEtat());
                break;
            }
            case 16: {
                if (this.mem.getEtat().equals("peureux") || !this.mem.monNom.equals(this.mem.monSquad)) break;
                this.send(m.getSender(), "" + 18, this.mem.monNom);
                break;
            }
            case 17: {
                this.mem.setMaison(new Point(Integer.parseInt(m.getArg1()), Integer.parseInt(m.getArg1())));
                break;
            }
        }
    }

    public void end() {
        super.end();
        this.broadcast(this.mem.monSquad, "lieutenant", "" + 13, this.mem.monNom);
        this.broadcast(this.mem.monGroupe, "concierge", "" + 13, this.mem.monNom);
    }

    public HalLauncher() {
        this.mem = new Memoire("les Mechants", "Hal" + (int)(Math.random() * 10000.0), 0);
        this.mesTaches = new Tache[6];
        this.mesTaches[0] = new Peureux();
        this.mesTaches[1] = new Mefiant();
        this.mesTaches[2] = new Courageux();
        this.mesTaches[3] = new Garde();
        this.mesTaches[4] = new Assault();
        this.mesTaches[5] = new FearfullAssault();
    }

    public void activate() {
        super.activate();
        this.createGroup(false, this.mem.monGroupe, null, null);
        this.requestRole(this.mem.monGroupe, "soldat", null);
        this.createGroup(false, this.mem.monSquad, null, null);
        this.requestRole(this.mem.monSquad, "lieutenant", null);
        this.randomHeading();
        this.println("I am a Hal9000: Launcher-type robot\nmember of squad " + this.mem.monSquad);
        this.println("and I am angry");
    }

    protected void updatePer() {
        if (this.mem.getCap() != this.getHeading()) {
            this.mem.setCap(this.getHeading());
            if (this.mem.squadSize > 1) {
                this.broadcast(this.mem.monSquad, "lieutenant", "" + 3, "" + (int)this.mem.getCap());
            }
        }
        this.setHeading(this.mem.getCap());
        int nbE = this.mem.nbLaunchers();
        super.updatePer();
        if (this.mem.nbLaunchers() > this.mem.squadSize) {
            this.broadcast(this.mem.monSquad, "lieutenant", "" + 4);
        }
        if (this.mem.nbAmis() < this.mem.voisin) {
            this.mem.voisin = this.mem.nbAmis();
        }
        if (this.mem.squadSize == 1) {
            this.mem.setEtat("peureux");
        }
        if (this.mem.nbLaunchers() < nbE || this.mem.voisin == 0 && this.mem.squadSize > 1) {
            this.jeMcasse();
        }
    }
}

