/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.ActionDesc;
import SEdit.ArrowDesc;
import SEdit.ElementDesc;
import SEdit.Graphics.GNode;
import SEdit.Graphics.GObject;
import SEdit.NewArrowCommand;
import SEdit.NewNodeCommand;
import SEdit.NodeDesc;
import SEdit.SArrow;
import SEdit.SComponent;
import SEdit.SConnect;
import SEdit.SElement;
import SEdit.SInConnect;
import SEdit.SNode;
import SEdit.Structure;
import SEdit.StructureAgent;
import SEdit.StructureBean;
import SEdit.Utils;
import SEdit.XMLStructureSaver;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import madkit.utils.graphics.GraphicUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureEditor
extends JDesktopPane
implements MouseListener,
MouseMotionListener {
    public StructureAgent agent;
    static String clipBoard = "";
    protected JPopupMenu globalPopup;
    Hashtable globalActions;
    GObject popupTarget;
    protected Hashtable<ElementDesc, JPopupMenu> popupTable = new Hashtable();
    boolean firstTime = true;
    Color backgroundColor = Color.white;
    int color;
    public static final int SELECT_FLECHE = 0;
    public static final int SELECT_RECT = 1;
    public static final int SELECT_POLY = 2;
    public static final int COUPER = 3;
    public static final int COPIER = 4;
    public static final int COLLER = 5;
    public static final int DETACHER = 6;
    public static final int DEPLACER = 7;
    public static final int AFFICHER_TEXTE = 8;
    public static final int RAFRAICHIR = 9;
    public static final int ADD_NODE = 10;
    public static final int ADD_ARROW = 11;
    public static final int AJOUTER_NODE = 10;
    public static final int AJOUTER_ARROW = 11;
    public static final int DEPLACEMENT = 12;
    private Vector<GObject> listeObjets = new Vector();
    private Vector<GObject> listeFleches = new Vector();
    private Vector<GObject> listeNoeuds = new Vector();
    private Vector<GObject> listeConnecteurs = new Vector();
    Cursor insertCursor = new Cursor(1);
    Cursor defaultCursor = Cursor.getDefaultCursor();
    private int mode;
    private Vector<GObject> vSelected;
    private Vector vRefreshed;
    private Vector<GObject> translateList = new Vector();
    private ElementDesc typeElement;
    private StructureBean structureBean;
    private int xd;
    private int yd;
    private int xold;
    private int yold;
    private int xnew;
    private int ynew;
    public Graphics GC;
    protected boolean displayCnxLabels = true;
    protected boolean displayNodeLabels = true;
    protected boolean displayArrowLabels = true;

    public static String getClipBoard() {
        return clipBoard;
    }

    public static void setClipBoard(String string) {
        clipBoard = string;
    }

    public void setColor(int n) {
        this.color = n;
        switch (n) {
            case 0: {
                this.setBackground(Color.white);
                break;
            }
            case 1: {
                this.setBackground(Color.blue);
                break;
            }
            case 2: {
                this.setBackground(Color.cyan);
                break;
            }
            case 3: {
                this.setBackground(Color.darkGray);
                break;
            }
            case 4: {
                this.setBackground(Color.red);
                break;
            }
            case 5: {
                this.setBackground(Color.green);
                break;
            }
            case 6: {
                this.setBackground(Color.lightGray);
                break;
            }
            case 7: {
                this.setBackground(Color.magenta);
                break;
            }
            case 8: {
                this.setBackground(Color.orange);
                break;
            }
            case 9: {
                this.setBackground(Color.gray);
                break;
            }
            case 10: {
                this.setBackground(Color.pink);
                break;
            }
            case 11: {
                this.setBackground(Color.yellow);
                break;
            }
            default: {
                this.setBackground(Color.white);
            }
        }
    }

    public int getColor() {
        return this.color;
    }

    public StructureBean getStructureBean() {
        return this.structureBean;
    }

    public void setStructureBean(StructureBean structureBean) {
        this.structureBean = structureBean;
    }

    public void setDisplayGrid(boolean bl) {
        this.getStructure().setDisplayGrid(bl);
    }

    public boolean getDisplayGrid() {
        return this.getStructure().getDisplayGrid();
    }

    public void toggleShowGrid() {
        this.getStructure().toggleShowGrid();
        this.repaint();
    }

    public void setSnapToGrid(boolean bl) {
        this.getStructureBean().setSnapToGrid(bl);
    }

    public void setSnapToGrid1(boolean bl) {
        this.getStructure().setSnapToGrid1(bl);
    }

    public int getGridSize() {
        return this.getStructure().getGridSize();
    }

    public void switchConn() {
        this.displayCnxLabels = !this.displayCnxLabels;
        this.repaint();
    }

    public void switchNodes() {
        this.displayNodeLabels = !this.displayNodeLabels;
        this.repaint();
    }

    public void switchArrows() {
        this.displayArrowLabels = !this.displayArrowLabels;
        this.repaint();
    }

    public StructureEditor(StructureAgent structureAgent) {
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font("Courier", 0, 12));
        this.mode = 0;
        this.vSelected = new Vector();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.agent = structureAgent;
        this.getStructure().setEditor(this);
        super.setSize(1200, 800);
        String string = System.getProperty("java.version");
        if (string.compareTo("1.3") >= 0) {
            this.setDragMode(1);
        } else {
            System.out.println(", this Java Machine is a little bit old, but it's all right");
            this.putClientProperty("JDesktopPane.dragMode", "outline");
        }
    }

    public void installActions(ElementDesc elementDesc) {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionDesc actionDesc = null;
                Object object = StructureEditor.this.popupTarget;
                if (object instanceof GObject) {
                    object = ((GObject)object).getSElement();
                    actionDesc = ((SElement)object).getDescriptor().getAction(actionEvent.getActionCommand());
                }
                if (object instanceof Structure) {
                    actionDesc = ((Structure)object).getFormalism().getAction(actionEvent.getActionCommand());
                }
                actionDesc.execute(object);
                StructureEditor.this.translateList.removeAllElements();
                StructureEditor.this.computeGlobalList(StructureEditor.this.translateList, StructureEditor.this.vSelected);
                StructureEditor.this.repaint();
            }
        };
        JPopupMenu jPopupMenu = new JPopupMenu();
        Utils.addPopupItems(jPopupMenu, elementDesc.getActions(), actionListener);
        this.add(jPopupMenu);
        this.popupTable.put(elementDesc, jPopupMenu);
    }

    public void processElementPopUp(int n, int n2) {
        JPopupMenu jPopupMenu = this.popupTable.get(this.popupTarget.getSElement().getDescriptor());
        jPopupMenu.show(this, n, n2);
    }

    @Override
    public Dimension getSize() {
        return super.getSize();
    }

    @Override
    public void setSize(Dimension dimension) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        super.setSize(n, n2);
    }

    public Structure getStructure() {
        return this.agent.getStructure();
    }

    public void addGObject(GObject gObject) {
        this.listeObjets.addElement(gObject);
        if (gObject.getSElement() instanceof SArrow) {
            this.listeFleches.addElement(gObject);
        } else if (gObject.getSElement() instanceof SConnect) {
            this.listeConnecteurs.addElement(gObject);
        } else {
            this.listeNoeuds.addElement(gObject);
        }
    }

    public void addGObjectFirst(GObject gObject) {
        this.listeObjets.insertElementAt(gObject, 0);
        if (gObject.getSElement() instanceof SArrow) {
            this.listeFleches.addElement(gObject);
        } else if (gObject.getSElement() instanceof SConnect) {
            this.listeConnecteurs.addElement(gObject);
        } else {
            this.listeNoeuds.addElement(gObject);
        }
    }

    public void removeGObject(GObject gObject) {
        this.listeObjets.removeElement(gObject);
        this.listeFleches.removeElement(gObject);
        this.listeConnecteurs.removeElement(gObject);
        this.listeNoeuds.removeElement(gObject);
    }

    public void deleteSelection() {
        Enumeration<GObject> enumeration = this.vSelected.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().getSElement().delete();
        }
        this.repaint();
    }

    public Vector<GObject> getSelection() {
        return this.vSelected;
    }

    public void setSelection(Vector<GObject> vector) {
        this.vSelected = vector;
        for (int i = 0; i < this.vSelected.size(); ++i) {
            this.vSelected.elementAt(i).select(true);
        }
        this.computeGlobalList(this.translateList, this.vSelected);
    }

    public void addSelection(Vector<GObject> vector) {
        Enumeration<GObject> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addSelected(enumeration.nextElement());
        }
        this.computeGlobalList(this.translateList, this.vSelected);
    }

    public void updateTranslateList() {
        this.computeGlobalList(this.translateList, this.vSelected);
    }

    public void addSelected(GObject gObject) {
        if (this.vSelected.isEmpty()) {
            this.getStructureBean().inspectElement(gObject.getSElement());
        }
        if (!this.vSelected.contains(gObject)) {
            this.vSelected.addElement(gObject);
            gObject.select(true);
            this.computeGlobalList(this.translateList, this.vSelected);
        }
    }

    public void removeSelected(GObject gObject) {
        this.vSelected.removeElement(gObject);
        gObject.select(false);
        this.computeGlobalList(this.translateList, this.vSelected);
    }

    public void clearSelection() {
        Enumeration<GObject> enumeration = this.vSelected.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().select(false);
        }
        this.vSelected.removeAllElements();
        this.translateList.removeAllElements();
        this.getStructureBean().inspectElement(null);
    }

    public void clearAll() {
        this.vSelected.removeAllElements();
        this.listeObjets.removeAllElements();
        this.listeNoeuds.removeAllElements();
        this.listeFleches.removeAllElements();
        this.listeConnecteurs.removeAllElements();
        this.getStructure().clearAll();
        this.repaint();
    }

    void pasteClipBoard() {
        this.clearSelection();
        this.agent.insertClipBoard();
        this.updateTranslateList();
    }

    void copyToClipBoard() {
        Vector<GObject> vector = new Vector<GObject>();
        this.computeGlobalList(vector, this.vSelected);
        Vector<SElement> vector2 = new Vector<SElement>();
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            SElement sElement = object.nextElement().getSElement();
            vector2.addElement(sElement);
        }
        if (vector2.size() > 0) {
            object = new XMLStructureSaver(this.agent);
            ((XMLStructureSaver)object).generateDOM(this.getStructure(), this.getStructure().getFormalism(), vector2);
            this.agent.setClipBoard(((XMLStructureSaver)object).generateDOM(this.getStructure(), this.getStructure().getFormalism(), vector2));
        }
    }

    void paste() {
        this.clearSelection();
        String string = StructureEditor.getClipBoard();
        if (!string.equals("")) {
            // empty if block
        }
        this.repaint();
    }

    void cut() {
        this.copyToClipBoard();
        this.deleteSelection();
    }

    public String askForNewName(String string) {
        String string2 = JOptionPane.showInputDialog(this, "Modification de : " + string, "Nouveau nom", -1);
        if (string.equals(string2)) {
            return null;
        }
        return string2;
    }

    public String askForString(String string) {
        return this.askForString(string, "");
    }

    public String askForString(String string, String string2) {
        String string3 = JOptionPane.showInputDialog(this, string, string2, -1);
        if (string3 == null || string3.equals("")) {
            return null;
        }
        return string3;
    }

    public GObject find(int n, int n2) {
        GObject gObject;
        int n3 = this.listeObjets.size();
        Point point = new Point(n, n2);
        Vector<GObject> vector = new Vector<GObject>();
        Enumeration<GObject> enumeration = this.listeObjets.elements();
        while (enumeration.hasMoreElements()) {
            gObject = enumeration.nextElement();
            if (!gObject.contains(point)) continue;
            vector.addElement(gObject);
        }
        if (vector.size() == 0) {
            return null;
        }
        if (vector.size() == 1) {
            return (GObject)vector.elementAt(0);
        }
        if (vector.size() > 1) {
            enumeration = vector.elements();
            GObject gObject2 = enumeration.nextElement();
            if (gObject2.getSElement() instanceof SComponent) {
                while (enumeration.hasMoreElements()) {
                    gObject = enumeration.nextElement();
                    if (gObject.getSElement() instanceof SConnect && ((SConnect)gObject.getSElement()).getComponent() == gObject2.getSElement()) {
                        return gObject;
                    }
                    if (!(gObject.getSElement() instanceof SArrow)) continue;
                    return gObject;
                }
            }
            return gObject2;
        }
        return null;
    }

    public Vector<GObject> find(Rectangle rectangle) {
        Vector<GObject> vector = new Vector<GObject>();
        Enumeration<GObject> enumeration = this.listeObjets.elements();
        while (enumeration.hasMoreElements()) {
            GObject gObject = enumeration.nextElement();
            if (!gObject.isContainedIn(rectangle) || !gObject.isSelectable()) continue;
            vector.addElement(gObject);
        }
        return vector;
    }

    void computeGlobalList(Vector<GObject> vector, Vector<GObject> vector2) {
        Enumeration<GObject> enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            GObject gObject = enumeration.nextElement();
            if (vector.contains(gObject)) continue;
            if (gObject.getSElement() instanceof SConnect || gObject.getSElement() instanceof SComponent) {
                SComponent sComponent = gObject.getSElement() instanceof SConnect ? ((SConnect)gObject.getSElement()).getComponent() : (SComponent)gObject.getSElement();
                if (sComponent == null || vector.contains(sComponent.getGObject())) continue;
                vector.addElement(sComponent.getGObject());
                Enumeration<SConnect> enumeration2 = sComponent.getInConnectors();
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(((SConnect)enumeration2.nextElement()).getGObject());
                }
                enumeration2 = sComponent.getOutConnectors();
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement().getGObject());
                }
                continue;
            }
            vector.addElement(gObject);
        }
    }

    void translateSelection(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        Rectangle rectangle = null;
        rectangle = this.vSelected.elementAt(0).getBounds();
        this.computeBounds(rectangle, this.vSelected, false);
        GObject gObject = this.translateList.firstElement();
        if (this.vSelected.size() == 1 && gObject instanceof GNode && ((GNode)gObject).getResizable() && ((GNode)gObject).getSelectedHandle() != 0) {
            ((GNode)gObject).doDrag(n, n2);
        } else {
            Enumeration<GObject> enumeration = this.translateList.elements();
            while (enumeration.hasMoreElements()) {
                gObject = enumeration.nextElement();
                gObject.translate(n, n2);
                rectangle.add(gObject.getBounds());
            }
            rectangle.setSize(rectangle.getSize().width + 2, rectangle.getSize().height + 2);
        }
        this.repaint(rectangle);
    }

    void snapToGridSelection(int n) {
        Enumeration<GObject> enumeration = this.translateList.elements();
        while (enumeration.hasMoreElements()) {
            GObject gObject = enumeration.nextElement();
            gObject.snapToGrid(n);
        }
    }

    void alignVertical() {
        if (this.vSelected.size() > 1) {
            Object object;
            GObject gObject;
            Vector<GObject> vector = new Vector<GObject>();
            Vector vector2 = new Vector();
            Enumeration<GObject> enumeration = this.vSelected.elements();
            GObject gObject2 = enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                gObject = enumeration.nextElement();
                if (gObject.getSElement() instanceof SConnect) {
                    object = ((SConnect)gObject.getSElement()).getComponent().getGObject();
                    if (vector.contains(object)) continue;
                    vector.addElement((GObject)object);
                    continue;
                }
                if (vector.contains(gObject)) continue;
                vector.addElement(gObject);
            }
            if (gObject2.getSElement() instanceof SConnect && vector.contains(gObject = ((SConnect)gObject2.getSElement()).getComponent().getGObject())) {
                gObject2 = gObject;
                vector.removeElement(gObject);
            }
            if (vector.size() > 0) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = enumeration.nextElement();
                    if (gObject.getSElement() instanceof SComponent) {
                        object = gObject.getLocation();
                        gObject.alignVerticalTo(gObject2);
                        Point point = gObject.getLocation();
                        Enumeration<SConnect> enumeration2 = ((SComponent)gObject.getSElement()).getInConnectors();
                        while (enumeration2.hasMoreElements()) {
                            ((SConnect)enumeration2.nextElement()).getGObject().translate(point.x - ((Point)object).x, point.y - ((Point)object).y);
                        }
                        enumeration2 = ((SComponent)gObject.getSElement()).getOutConnectors();
                        while (enumeration2.hasMoreElements()) {
                            enumeration2.nextElement().getGObject().translate(point.x - ((Point)object).x, point.y - ((Point)object).y);
                        }
                        continue;
                    }
                    gObject.alignVerticalTo(gObject2);
                }
                this.repaint();
            }
        }
    }

    void alignHorizontal() {
        if (this.vSelected.size() > 1) {
            Object object;
            GObject gObject;
            Vector<GObject> vector = new Vector<GObject>();
            Vector vector2 = new Vector();
            Enumeration<GObject> enumeration = this.vSelected.elements();
            GObject gObject2 = enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                gObject = enumeration.nextElement();
                if (gObject.getSElement() instanceof SConnect) {
                    object = ((SConnect)gObject.getSElement()).getComponent().getGObject();
                    if (vector.contains(object)) continue;
                    vector.addElement((GObject)object);
                    continue;
                }
                if (vector.contains(gObject)) continue;
                vector.addElement(gObject);
            }
            if (gObject2.getSElement() instanceof SConnect && vector.contains(gObject = ((SConnect)gObject2.getSElement()).getComponent().getGObject())) {
                gObject2 = gObject;
                vector.removeElement(gObject);
            }
            if (vector.size() > 0) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    gObject = enumeration.nextElement();
                    if (gObject.getSElement() instanceof SComponent) {
                        object = gObject.getLocation();
                        gObject.alignHorizontalTo(gObject2);
                        Point point = gObject.getLocation();
                        Enumeration<SConnect> enumeration2 = ((SComponent)gObject.getSElement()).getInConnectors();
                        while (enumeration2.hasMoreElements()) {
                            ((SConnect)enumeration2.nextElement()).getGObject().translate(point.x - ((Point)object).x, point.y - ((Point)object).y);
                        }
                        enumeration2 = ((SComponent)gObject.getSElement()).getOutConnectors();
                        while (enumeration2.hasMoreElements()) {
                            enumeration2.nextElement().getGObject().translate(point.x - ((Point)object).x, point.y - ((Point)object).y);
                        }
                        continue;
                    }
                    gObject.alignHorizontalTo(gObject2);
                }
                this.repaint();
            }
        }
    }

    void setInsertMode(ElementDesc elementDesc) {
        if (elementDesc instanceof ArrowDesc) {
            this.setMode(11);
        } else {
            this.setMode(10);
        }
        this.typeElement = elementDesc;
    }

    void setInsertMode(int n, ElementDesc elementDesc) {
        this.setMode(n);
        this.typeElement = elementDesc;
    }

    void setMode(int n) {
        this.mode = n;
        if (this.mode == 11 || this.mode == 10) {
            this.setCursor(this.insertCursor);
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    void installNode(GObject gObject, boolean bl) {
        this.addGObject(gObject);
        gObject.setEditor(this);
        this.installActions(gObject.getSElement().getDescriptor());
        if (bl) {
            this.addSelected(gObject);
        }
        this.repaint();
    }

    void installArrow(GObject gObject, boolean bl) {
        this.addGObject(gObject);
        gObject.setEditor(this);
        this.installActions(gObject.getSElement().getDescriptor());
        if (bl) {
            this.addSelected(gObject);
        }
        this.repaint();
    }

    void prepareNewArrow() {
        GObject gObject = this.find(this.xd, this.yd);
        GObject gObject2 = this.find(this.xnew, this.ynew);
        if (gObject == null || gObject2 == null) {
            return;
        }
        SElement sElement = gObject.getSElement();
        SElement sElement2 = gObject2.getSElement();
        if (!(gObject.getSElement() instanceof SNode) || !(gObject2.getSElement() instanceof SNode)) {
            return;
        }
        Point point = gObject.getLocation();
        Point point2 = gObject2.getLocation();
        Dimension dimension = gObject.getDimension();
        Dimension dimension2 = gObject2.getDimension();
        int n = (point.x + dimension.width / 2 + point2.x + dimension2.width / 2) / 2;
        int n2 = (point.y + dimension.height / 2 + point2.y + dimension2.height / 2) / 2;
        this.agent.doCommand(new NewArrowCommand(this.typeElement, new Point(n, n2), sElement, sElement2));
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    public void setGraphics(Graphics graphics) {
        this.GC = graphics;
    }

    public void computeBounds(Rectangle rectangle, Object object, boolean bl) {
        if (object instanceof Vector || object instanceof Enumeration) {
            Enumeration enumeration = object instanceof Vector ? ((Vector)object).elements() : (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                this.computeBounds(rectangle, enumeration.nextElement(), bl);
            }
        } else if (object instanceof GObject || object instanceof SElement) {
            Enumeration<SInConnect> enumeration;
            GObject gObject = null;
            SElement sElement = null;
            if (object instanceof GObject) {
                gObject = (GObject)object;
                sElement = gObject.getSElement();
            }
            if (object instanceof SElement) {
                sElement = (SElement)object;
                gObject = sElement.getGObject();
            }
            rectangle.add(gObject.getBounds());
            if (sElement instanceof SNode) {
                enumeration = ((SNode)sElement).getInArrows();
                if (enumeration != null) {
                    this.computeBounds(rectangle, enumeration, bl);
                }
                if ((enumeration = ((SNode)sElement).getOutArrows()) != null) {
                    this.computeBounds(rectangle, enumeration, bl);
                }
            }
            if (sElement instanceof SComponent) {
                enumeration = ((SComponent)sElement).getInConnectors();
                if (enumeration != null) {
                    this.computeBounds(rectangle, enumeration, bl);
                }
                if ((enumeration = ((SComponent)sElement).getOutConnectors()) != null) {
                    this.computeBounds(rectangle, enumeration, bl);
                }
            }
            if (sElement instanceof SConnect && !bl) {
                this.computeBounds(rectangle, ((SConnect)sElement).getComponent(), true);
            }
        }
    }

    public Dimension getDimension() {
        Object object;
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.getStructure().getNodes().elements();
        while (enumeration.hasMoreElements()) {
            object = (SNode)enumeration.nextElement();
            GObject gObject = ((SElement)object).getGObject();
            Point point = gObject.getLocation();
            if (point.x > n) {
                n = point.x + gObject.getDimension().width;
            }
            if (point.y <= n2) continue;
            n2 = point.y + gObject.getDimension().height;
        }
        enumeration = this.getStructure().getArrows().elements();
        while (enumeration.hasMoreElements()) {
            object = ((SElement)enumeration.nextElement()).getGObject().getLocation();
            if (((Point)object).x > n) {
                n = ((Point)object).x;
            }
            if (((Point)object).y <= n2) continue;
            n2 = ((Point)object).y;
        }
        return new Dimension(n, n2);
    }

    public void setCanvasSize() {
        Dimension dimension = this.getDimension();
        if (dimension.width != 0) {
            this.setSize(dimension.width * 2, dimension.height * 2);
        }
    }

    public void addGlobalPopUp() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("commande globale: " + actionEvent.getActionCommand());
            }
        };
        this.globalPopup = new JPopupMenu();
        Utils.addPopupItems(this.globalPopup, this.globalActions, actionListener);
        this.add(this.globalPopup);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (GraphicUtils.isPopupTrigger((MouseEvent)mouseEvent)) {
            this.popupTarget = this.find(mouseEvent.getX(), mouseEvent.getY());
            if (this.popupTarget != null) {
                this.processElementPopUp(mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.consume();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.xold = this.xnew = n;
        this.xd = this.xnew;
        this.yold = this.ynew = n2;
        this.yd = this.ynew;
        switch (this.mode) {
            case 10: {
                this.clearSelection();
                if (this.getStructure().getSnapToGrid()) {
                    int n3 = this.getGridSize();
                    n = n3 * Math.round(n / n3);
                    n2 = n3 * Math.round(n2 / n3);
                }
                this.agent.doCommand(new NewNodeCommand((NodeDesc)this.typeElement, new Point(n, n2)));
                break;
            }
            case 11: {
                this.clearSelection();
                break;
            }
            case 0: {
                GObject gObject = this.find(n, n2);
                if (gObject == null) {
                    if ((mouseEvent.getModifiers() & 1) != 0) break;
                    this.clearSelection();
                    break;
                }
                if (this.vSelected.contains(gObject)) {
                    if ((mouseEvent.getModifiers() & 1) != 0) {
                        this.removeSelected(gObject);
                        break;
                    }
                    if (gObject instanceof GNode && ((GNode)gObject).getResizable()) {
                        ((GNode)gObject).doReSelect(n, n2);
                    }
                    this.setMode(12);
                    break;
                }
                if (!gObject.isSelectable()) break;
                if ((mouseEvent.getModifiers() & 1) == 0) {
                    this.clearSelection();
                }
                this.addSelected(gObject);
                this.setMode(12);
                break;
            }
            case 1: {
                this.clearSelection();
            }
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.xold = this.xnew;
        this.yold = this.ynew;
        this.xnew = n;
        this.ynew = n2;
        switch (this.mode) {
            case 10: {
                break;
            }
            case 11: {
                this.GC.setColor(Color.black);
                if (this.xd != this.xold || this.yd != this.yold) {
                    this.GC.drawLine(this.xd, this.yd, this.xold, this.yold);
                }
                if (this.xd == this.xnew && this.yd == this.ynew) break;
                this.GC.drawLine(this.xd, this.yd, this.xnew, this.ynew);
                break;
            }
            case 12: {
                this.translateSelection(this.xnew - this.xold, this.ynew - this.yold);
                break;
            }
            case 0: {
                this.setMode(1);
            }
            case 1: {
                this.GC.setColor(Color.red);
                if (this.xd != this.xold) {
                    this.GC.drawLine(this.xd, this.yd, this.xold, this.yd);
                    this.GC.drawLine(this.xd, this.yold, this.xold, this.yold);
                }
                if (this.yd != this.yold) {
                    this.GC.drawLine(this.xd, this.yd, this.xd, this.yold);
                    this.GC.drawLine(this.xold, this.yd, this.xold, this.yold);
                }
                if (this.xd != this.xnew) {
                    this.GC.drawLine(this.xd, this.yd, this.xnew, this.yd);
                    this.GC.drawLine(this.xd, this.ynew, this.xnew, this.ynew);
                }
                if (this.yd == this.ynew) break;
                this.GC.drawLine(this.xd, this.yd, this.xd, this.ynew);
                this.GC.drawLine(this.xnew, this.yd, this.xnew, this.ynew);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.consume();
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        this.xold = this.xnew;
        this.yold = this.ynew;
        this.xnew = n;
        this.ynew = n2;
        switch (this.mode) {
            case 11: {
                this.GC.drawLine(this.xd, this.yd, this.xold, this.yold);
                this.GC.setColor(Color.white);
                if (this.xd != this.xold || this.yd != this.yold) {
                    this.GC.drawLine(this.xd, this.yd, this.xold, this.yold);
                }
                this.prepareNewArrow();
                break;
            }
            case 12: {
                this.setMode(0);
                if (this.getStructure().getSnapToGrid()) {
                    int n3 = this.getGridSize();
                    this.snapToGridSelection(n3);
                }
                this.repaint();
                break;
            }
            case 1: {
                this.GC.setColor(Color.red);
                if (this.xd != this.xold) {
                    this.GC.drawLine(this.xd, this.yd, this.xold, this.yd);
                    this.GC.drawLine(this.xd, this.yold, this.xold, this.yold);
                }
                if (this.yd != this.yold) {
                    this.GC.drawLine(this.xd, this.yd, this.xd, this.yold);
                    this.GC.drawLine(this.xold, this.yd, this.xold, this.yold);
                }
                Rectangle rectangle = new Rectangle(Math.min(this.xd, this.xnew), Math.min(this.yd, this.ynew), Math.abs(this.xnew - this.xd), Math.abs(this.ynew - this.yd));
                if ((mouseEvent.getModifiers() & 1) == 0) {
                    this.setSelection(this.find(rectangle));
                } else {
                    this.addSelection(this.find(rectangle));
                }
                this.setMode(0);
                this.repaint();
                break;
            }
        }
    }

    void drawGrid(Graphics graphics) {
        int n;
        Dimension dimension = this.getSize();
        int n2 = this.getGridSize();
        int n3 = Math.round(dimension.width / n2);
        int n4 = Math.round(dimension.height / n2);
        graphics.setColor(Color.lightGray);
        for (n = 0; n < n3; ++n) {
            graphics.drawLine(n * n2, 0, n * n2, dimension.height);
        }
        for (n = 0; n < n4; ++n) {
            graphics.drawLine(0, n * n2, dimension.width, n * n2);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.doUpdate(graphics);
    }

    public void doUpdate(Graphics graphics) {
        Object object;
        this.GC = this.getGraphics();
        this.GC.setXORMode(this.getBackground());
        graphics.setPaintMode();
        this.getStructure().drawBackground(graphics);
        if (this.getDisplayGrid()) {
            this.drawGrid(graphics);
        }
        Enumeration<GObject> enumeration = this.listeNoeuds.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (((GObject)object).selected) {
                graphics.setColor(Color.red);
            } else if (this.mode == 12) {
                graphics.setColor(Color.gray);
            } else {
                graphics.setColor(((GObject)object).getForeground());
            }
            ((GObject)object).paint(graphics);
        }
        enumeration = this.listeFleches.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (((GObject)object).selected) {
                graphics.setColor(Color.red);
            } else if (this.mode == 12) {
                graphics.setColor(Color.gray);
            } else {
                graphics.setColor(((GObject)object).getForeground());
            }
            ((GObject)object).paint(graphics);
        }
        enumeration = this.listeConnecteurs.elements();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (((GObject)object).selected) {
                graphics.setColor(Color.red);
            } else if (this.mode == 12) {
                graphics.setColor(Color.gray);
            } else {
                graphics.setColor(((GObject)object).getForeground());
            }
            ((GObject)object).paint(graphics);
        }
        int n = this.listeObjets.size();
        object = graphics.getFont();
        Font font = new Font(((Font)object).getName(), ((Font)object).getStyle(), ((Font)object).getSize() - 4);
        if (this.mode != 12) {
            GObject gObject;
            Enumeration<GObject> enumeration2;
            if (this.displayNodeLabels) {
                enumeration2 = this.listeNoeuds.elements();
                while (enumeration2.hasMoreElements()) {
                    gObject = enumeration2.nextElement();
                    if (gObject.selected) {
                        graphics.setColor(Color.red);
                    } else {
                        graphics.setColor(Color.black);
                    }
                    gObject.displayName(graphics);
                }
            }
            if (this.displayArrowLabels) {
                enumeration2 = this.listeFleches.elements();
                while (enumeration2.hasMoreElements()) {
                    gObject = enumeration2.nextElement();
                    if (gObject.selected) {
                        graphics.setColor(Color.red);
                    } else {
                        graphics.setColor(Color.black);
                    }
                    gObject.displayName(graphics);
                }
            }
            graphics.setFont(font);
            if (this.displayCnxLabels) {
                enumeration2 = this.listeConnecteurs.elements();
                while (enumeration2.hasMoreElements()) {
                    gObject = enumeration2.nextElement();
                    if (gObject.selected) {
                        graphics.setColor(Color.red);
                    } else {
                        graphics.setColor(Color.black);
                    }
                    gObject.displayName(graphics);
                }
            }
            graphics.setFont((Font)object);
        }
        if (this.vSelected.size() == 1 && this.vSelected.firstElement() instanceof GNode) {
            ((GNode)this.vSelected.firstElement()).displayHandles(graphics);
        }
    }

    public void print(Frame frame) {
        this.printEditor();
    }

    public void printEditor() {
        Frame frame = new Frame(" ");
        frame.setSize(1, 1);
        frame.show();
        PrintJob printJob = this.getToolkit().getPrintJob(frame, "Printed with SEdit", null);
        if (printJob != null) {
            Graphics graphics = printJob.getGraphics();
            Dimension dimension = this.getSize();
            if (graphics != null) {
                graphics.drawRect(0, 0, dimension.width, dimension.height);
                this.printAll(graphics);
                graphics.dispose();
            }
            printJob.end();
        }
        frame.dispose();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

