/*
 * Decompiled with CFR 0.152.
 */
package madkit.linechart.linechartgui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import madkit.linechart.linechartgui.Adjustment;
import madkit.linechart.linechartgui.Graph;
import madkit.linechart.linechartgui.GraphComponent;
import madkit.linechart.linechartgui.ToolBar;
import madkit.linechart.linechartgui.WindowResized;

public class LineChartGUI
extends JPanel {
    public GraphComponent monGraphComponent;
    int sizeX = 400;
    int sizeY = 300;
    int largeur;
    int hauteur;
    Dimension tailleEcran;
    ToolBar toolbar;
    JScrollBar hScroll;

    public LineChartGUI(int n, int n2) {
        this.sizeX = n;
        this.sizeY = n2;
        this.setPreferredSize(new Dimension(400, 300));
    }

    public LineChartGUI() {
        this.sizeX = 400;
        this.sizeY = 300;
        this.setPreferredSize(new Dimension(400, 300));
    }

    public Dimension getPreferredSize() {
        return this.getSize();
    }

    public void init() {
        this.setLayout(new BorderLayout(2, 1));
        this.setBackground(Color.white);
        this.hScroll = new JScrollBar(0, 0, 5, 0, 100000);
        this.monGraphComponent = new GraphComponent(this.sizeX, this.sizeY, this.hScroll);
        this.toolbar = new ToolBar(this.monGraphComponent);
        this.hScroll.addAdjustmentListener(new Adjustment(this.monGraphComponent, this.hScroll));
        this.addComponentListener(new WindowResized(this.monGraphComponent, this));
        this.add((Component)this.monGraphComponent, "Center");
        this.add((Component)this.hScroll, "South");
        this.add((Component)this.toolbar, "North");
        this.setSize(this.sizeX, this.sizeY);
        this.validate();
        this.monGraphComponent.doLayout();
    }

    public void Dimensionner() {
        this.tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
        this.sizeX = this.tailleEcran.width - this.tailleEcran.width * 25 / 100;
        this.sizeY = this.tailleEcran.height - this.tailleEcran.height * 25 / 100;
        this.largeur = this.getSize().width;
        this.hauteur = this.getSize().height;
        int n = (this.tailleEcran.width - this.largeur) / 8;
        int n2 = (this.tailleEcran.height - this.hauteur) / 8;
    }

    public void setScaleX(int n) {
        this.monGraphComponent.setEchelleX(n);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public void setScaleY(int n) {
        this.monGraphComponent.setEchelleY(n);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public int getEchelleX() {
        return this.monGraphComponent.getEchelleX();
    }

    public int getEchelleY() {
        return this.monGraphComponent.getEchelleY();
    }

    public void setSpaceX(int n) {
        this.monGraphComponent.setEspaceX(n);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public void setSpaceY(int n) {
        this.monGraphComponent.setEspaceY(n);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public int getEspaceX() {
        return this.monGraphComponent.getEspaceX();
    }

    public int getEspaceY() {
        return this.monGraphComponent.getEspaceY();
    }

    public void addNewGraph(String string) {
        Graph graph = new Graph();
        graph.setName(string);
        graph.Activate();
        this.monGraphComponent.addGraph(graph);
    }

    public void setGraphColor(String string, Color color) {
        for (int i = 0; i < this.monGraphComponent.TabGraph.size(); ++i) {
            Graph graph = (Graph)this.monGraphComponent.TabGraph.elementAt(i);
            if (!graph.getName().equals(string)) continue;
            graph.setColor(color);
            this.monGraphComponent.update();
            i = this.monGraphComponent.TabGraph.size() + 1;
        }
    }

    public synchronized void drawPoint(String string, int n, int n2) {
        this.monGraphComponent.drawPoint(string, n, n2);
    }

    public void activate(String string) {
        for (int i = 0; i < this.monGraphComponent.TabGraph.size(); ++i) {
            Graph graph = (Graph)this.monGraphComponent.TabGraph.elementAt(i);
            if (!graph.getName().equals(string)) continue;
            graph.Activate();
            i = this.monGraphComponent.TabGraph.size() + 1;
        }
    }

    public void desactivate(String string) {
        for (int i = 0; i < this.monGraphComponent.TabGraph.size(); ++i) {
            Graph graph = (Graph)this.monGraphComponent.TabGraph.elementAt(i);
            if (!graph.getName().equals(string)) continue;
            graph.Desactivate();
            i = this.monGraphComponent.TabGraph.size() + 1;
        }
    }

    public boolean isActivated(String string) {
        boolean bl = false;
        for (int i = 0; i < this.monGraphComponent.TabGraph.size(); ++i) {
            Graph graph = (Graph)this.monGraphComponent.TabGraph.elementAt(i);
            if (!graph.getName().equals(string)) continue;
            bl = graph.isActivated();
            i = this.monGraphComponent.TabGraph.size() + 1;
        }
        return bl;
    }

    public Color getColor(String string) {
        Color color = Color.black;
        for (int i = 0; i < this.monGraphComponent.TabGraph.size(); ++i) {
            Graph graph = (Graph)this.monGraphComponent.TabGraph.elementAt(i);
            if (!graph.getName().equals(string)) continue;
            color = graph.getColor();
            i = this.monGraphComponent.TabGraph.size() + 1;
        }
        return color;
    }

    public void setTitleAxeX(String string) {
        this.monGraphComponent.drTitleX = true;
        this.monGraphComponent.setTitleAxeX(string);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public void setTitleAxeY(String string) {
        this.monGraphComponent.drTitleY = true;
        this.monGraphComponent.setTitleAxeY(string);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public void setTitleGraph(String string) {
        this.monGraphComponent.drTitleGraphe = true;
        this.monGraphComponent.setTitleGraph(string);
        this.monGraphComponent.paintImmediately(0, 0, this.monGraphComponent.sizeX, this.monGraphComponent.sizeY);
    }

    public void setDrawScaleX(boolean bl) {
        this.monGraphComponent.drIndiceX = bl;
    }

    public boolean getDrawScaleX() {
        return this.monGraphComponent.drIndiceX;
    }

    public void setDrawScaleY(boolean bl) {
        this.monGraphComponent.drIndiceY = bl;
    }

    public boolean getDrawScaleY() {
        return this.monGraphComponent.drIndiceY;
    }
}

