/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.io.Serializable;
import java.util.Vector;
import madkit.kernel.AbstractAgent;
import madkit.kernel.Controller;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;

public abstract class Agent
extends AbstractAgent
implements Runnable,
Serializable {
    transient Thread agentThread;

    public final void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    final Thread getAgentThread() {
        return this.agentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message waitNextMessage() {
        try {
            Vector vector = this.messageBox;
            synchronized (vector) {
                while (this.messageBox.isEmpty()) {
                    this.messageBox.wait();
                }
            }
            return this.nextMessage();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Message waitNextMessage(long l) {
        try {
            Vector vector = this.messageBox;
            synchronized (vector) {
                if (this.messageBox.isEmpty()) {
                    this.messageBox.wait(l);
                }
            }
            return this.nextMessage();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(Message message) {
        super.receiveMessage(message);
        Vector vector = this.messageBox;
        synchronized (vector) {
            this.messageBox.notifyAll();
        }
    }

    public void live() {
    }

    public final void run() {
        try {
            this.agentThread = Thread.currentThread();
            Controller controller = this.getController();
            if (controller != null) {
                controller.activate();
                controller.live();
            } else {
                this.activate();
                this.live();
            }
        }
        catch (RuntimeException runtimeException) {
            if (this.currentKernel == null) {
                return;
            }
            this.currentKernel.display("Runtime Agent Exception : " + runtimeException.toString());
            runtimeException.getMessage();
            runtimeException.printStackTrace();
            this.currentKernel.display(this + " Agent killed.");
        }
        catch (Exception exception) {
            System.err.println("exception");
            if (this.currentKernel == null) {
                return;
            }
            this.currentKernel.display("### UNDEFINED EXCEPTION ! : " + exception.toString());
            exception.printStackTrace();
            this.currentKernel.display(this + "Agent killed. (MadKit internal error)");
            this.currentKernel.display("Please send a bug report !");
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println("Exception class non trouv\ufffde:::::::::::::::::::::::::::::" + noClassDefFoundError.toString());
        }
        if (this.currentKernel != null) {
            this.currentKernel.killAgent(this);
        }
    }

    public void createPlace(String string, String string2) {
        this.getCurrentKernel().createPlace(this.getAddress(), string, string2);
    }

    public void createPlace(String string) {
        this.createPlace(string, "");
    }

    public void enableMobility(String string) {
        this.enableMobility(string, 4444);
    }

    public void enableMobility(String string, int n) {
        this.getCurrentKernel().enableMobility(string, n);
        this.pause(500);
    }

    public boolean connectAgencyToAgency(String string, int n) {
        if (this.getCurrentKernel().connectAgencyToAgency(string, n)) {
            return true;
        }
        System.err.println("You must enable mobility before requesting connexion to agency!");
        return false;
    }

    public int joinPlace(String string) {
        return this.joinPlace(string, "");
    }

    public int joinPlace(String string, String string2, String string3) {
        this.pause(500);
        if (this.getCurrentKernel().joinPlace(this, string, string2, string3) == 1) {
            // empty if block
        }
        this.joinGroup(string2);
        return this.getCurrentKernel().joinPlace(this, string, string2, string3);
    }

    public int joinPlace(String string, String string2) {
        return this.joinPlace("public", string, string2);
    }

    public KernelAddress getAgencyNamed(String string) {
        return this.getCurrentKernel().getAgencyNamed(string);
    }

    protected final void exitImmediatlyOnKill() {
        this.getMyGroups();
    }
}

