/*
 * Decompiled with CFR 0.152.
 */
package madkit.kernel;

import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Vector;
import madkit.kernel.AgentAddress;
import madkit.kernel.AgentInformation;
import madkit.kernel.Controller;
import madkit.kernel.GroupIdentifier;
import madkit.kernel.Kernel;
import madkit.kernel.KernelAddress;
import madkit.kernel.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAgent
implements Serializable {
    private transient Object currentBean;
    private transient Writer ostream;
    static final String DEFAULT_COMMUNITY = "public";
    private boolean debugFlag = false;
    private AgentInformation agentInformation = null;
    transient Kernel currentKernel = null;
    Vector<Message> messageBox;
    private Controller controller = null;
    private boolean bean_mode;
    private final int _hashCode = ++agentCounter;
    private static int agentCounter = 0;

    public AbstractAgent() {
        this.messageBox = new Vector();
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void activate() {
    }

    public void end() {
    }

    public int createGroup(boolean bl, String string, String string2, String string3, GroupIdentifier groupIdentifier) {
        if (string3 == null) {
            return this.currentKernel.createGroup(this.getAddress(), bl, string, string2, string2, groupIdentifier);
        }
        return this.currentKernel.createGroup(this.getAddress(), bl, string, string2, string3, groupIdentifier);
    }

    public int createGroup(boolean bl, String string, String string2, GroupIdentifier groupIdentifier) {
        return this.createGroup(bl, DEFAULT_COMMUNITY, string, string2, groupIdentifier);
    }

    public int requestRole(String string, String string2, String string3, Object object) {
        return this.currentKernel.requestRole(this.getAddress(), string, string2, string3, object);
    }

    public int requestRole(String string, String string2, Object object) {
        return this.currentKernel.requestRole(this.getAddress(), DEFAULT_COMMUNITY, string, string2, object);
    }

    public boolean leaveRole(String string, String string2, String string3) {
        return this.currentKernel.leaveRole(this.getAddress(), string, string2, string3);
    }

    public boolean leaveRole(String string, String string2) {
        return this.currentKernel.leaveRole(this.getAddress(), DEFAULT_COMMUNITY, string, string2);
    }

    public boolean leaveGroup(String string, String string2) {
        return this.currentKernel.leaveGroup(this.getAddress(), string, string2);
    }

    public boolean leaveGroup(String string) {
        return this.currentKernel.leaveGroup(this.getAddress(), DEFAULT_COMMUNITY, string);
    }

    public void joinGroup(String string) {
        if (this.currentKernel.isGroup(DEFAULT_COMMUNITY, string)) {
            this.requestRole(DEFAULT_COMMUNITY, string, "member", null);
        } else {
            this.createGroup(true, DEFAULT_COMMUNITY, string, null, null);
        }
    }

    public void requestRole(String string, String string2) {
        this.currentKernel.requestRole(this.getAddress(), DEFAULT_COMMUNITY, string, string2, null);
    }

    public void foundGroup(String string) {
        this.currentKernel.createGroup(this.getAddress(), true, DEFAULT_COMMUNITY, string, string, null);
    }

    public AgentAddress[] getAgentsWithRole(String string, String string2, String string3) {
        return this.currentKernel.getRolePlayers(string, string2, string3);
    }

    public AgentAddress[] getAgentsWithRole(String string, String string2) {
        return this.currentKernel.getRolePlayers(DEFAULT_COMMUNITY, string, string2);
    }

    public AgentAddress getAgentWithRole(String string, String string2, String string3) {
        return this.currentKernel.getRolePlayer(string, string2, string3);
    }

    public AgentAddress getAgentWithRole(String string, String string2) {
        return this.currentKernel.getRolePlayer(DEFAULT_COMMUNITY, string, string2);
    }

    public String[] getMyGroups(String string) {
        return this.currentKernel.getCurrentGroupsOf(this.getAddress(), string);
    }

    public String[] getMyGroups() {
        return this.currentKernel.getCurrentGroupsOf(this.getAddress(), DEFAULT_COMMUNITY);
    }

    public String[] getExistingGroups(String string) {
        return this.currentKernel.getExistingGroups(string);
    }

    public String[] getExistingGroups() {
        return this.currentKernel.getExistingGroups(DEFAULT_COMMUNITY);
    }

    public boolean isMemberOf(String string, String string2) {
        return this.currentKernel.isBelongingToGroup(this.getAddress(), string, string2);
    }

    public boolean isMemberOf(String string) {
        return this.currentKernel.isBelongingToGroup(this.getAddress(), DEFAULT_COMMUNITY, string);
    }

    public boolean isBelongingToGroup(AgentAddress agentAddress, String string, String string2) {
        return this.currentKernel.isBelongingToGroup(agentAddress, string, string2);
    }

    public boolean isBelongingToGroup(AgentAddress agentAddress, String string) {
        return this.currentKernel.isBelongingToGroup(agentAddress, DEFAULT_COMMUNITY, string);
    }

    public String[] getMyRoles(String string, String string2) {
        return this.currentKernel.getGroupRolesOf(this.getAddress(), string, string2);
    }

    public String[] getMyRoles(String string) {
        return this.currentKernel.getGroupRolesOf(this.getAddress(), DEFAULT_COMMUNITY, string);
    }

    public String[] getExistingRoles(String string, String string2) {
        return this.currentKernel.getExistingRoles(string, string2);
    }

    public String[] getExistingRoles(String string) {
        return this.currentKernel.getExistingRoles(DEFAULT_COMMUNITY, string);
    }

    public String[] getRoles(String string) {
        return this.getExistingRoles(DEFAULT_COMMUNITY, string);
    }

    public boolean isRole(String string, String string2, String string3) {
        return this.getAgentWithRole(string, string2, string3) != null;
    }

    public boolean isRole(String string, String string2) {
        return this.isRole(DEFAULT_COMMUNITY, string, string2);
    }

    public Vector<String> getGroups() {
        String[] stringArray = this.currentKernel.getCurrentGroupsOf(this.getAddress(), DEFAULT_COMMUNITY);
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public boolean isGroup(String string, String string2) {
        return this.currentKernel.isGroup(string, string2);
    }

    public boolean isGroup(String string) {
        return this.currentKernel.isGroup(DEFAULT_COMMUNITY, string);
    }

    public boolean isCommunity(String string) {
        return this.currentKernel.isCommunity(string);
    }

    public String[] getAvailableCommunities() {
        return this.currentKernel.getCommunities();
    }

    public boolean connectedWithCommunity(String string) {
        return this.currentKernel.connectedWithCommunity(string);
    }

    public boolean isMessageBoxEmpty() {
        return this.messageBox.isEmpty();
    }

    public int getMessageBoxSize() {
        return this.messageBox.size();
    }

    public Message nextMessage() {
        if (!this.isMessageBoxEmpty()) {
            return this.messageBox.remove(0);
        }
        return null;
    }

    public void receiveMessage(Message message) {
        this.messageBox.add(message);
    }

    public void sendMessage(AgentAddress agentAddress, Message message) {
        if (agentAddress != null) {
            message.setReceiver(agentAddress);
            message.setSender(this.getAddress());
            this.currentKernel.sendMessage(message);
        }
    }

    public void sendMessage(String string, String string2, String string3, Message message) {
        if (!Kernel.interGroupMessage && !this.currentKernel.isBelongingToGroup(this.getAddress(), string, string2)) {
            this.println("I'm not allowed to send inter group messages !");
            return;
        }
        message.setReceiver(this.getAgentWithRole(string, string2, string3));
        message.setSender(this.getAddress());
        if (message.getReceiver() != null) {
            this.currentKernel.sendMessage(message);
        }
    }

    public void sendMessage(String string, String string2, Message message) {
        this.sendMessage(DEFAULT_COMMUNITY, string, string2, message);
    }

    public void broadcastMessage(String string, String string2, String string3, Message message) {
        message.setSender(this.getAddress());
        this.currentKernel.sendBroadcastMessage(string, string2, string3, message);
    }

    public void broadcastMessage(String string, String string2, Message message) {
        this.broadcastMessage(DEFAULT_COMMUNITY, string, string2, message);
    }

    public void launchAgent(AbstractAgent abstractAgent, String string, boolean bl) {
        if (string == null || string.equals("")) {
            this.currentKernel.launchAgent(abstractAgent, "unamed", this, bl);
        } else {
            this.currentKernel.launchAgent(abstractAgent, string, this, bl);
        }
    }

    public void launchAgent(AbstractAgent abstractAgent, String string, Point point, Dimension dimension) {
        if (string == null || string.equals("")) {
            this.currentKernel.launchAgent(abstractAgent, "unamed", this, true, point, dimension);
        } else {
            this.currentKernel.launchAgent(abstractAgent, string, this, true, point, dimension);
        }
    }

    public void restoreAgent(AbstractAgent abstractAgent) {
        this.currentKernel.restoreAgent(abstractAgent, abstractAgent.getName(), this, abstractAgent.hasGUI());
    }

    public void killAgent(AbstractAgent abstractAgent) {
        this.currentKernel.killAgent(abstractAgent, this);
    }

    public AgentAddress getAddress() {
        return this.agentInformation.getAddress();
    }

    public AgentInformation getAgentInformation() {
        return this.agentInformation;
    }

    public void setName(String string) {
        this.agentInformation.setName(string);
    }

    public String getName() {
        return this.agentInformation.getName();
    }

    final void setCurrentKernel(Kernel kernel) {
        this.currentKernel = kernel;
    }

    final Kernel getCurrentKernel() {
        return this.currentKernel;
    }

    final void setAgentInformation(AgentInformation agentInformation) {
        this.agentInformation = agentInformation;
    }

    public KernelAddress getCurrentKernelAddress() {
        return Kernel.getAddress();
    }

    public boolean hasGUI() {
        return this.currentBean != null;
    }

    public void initGUI() {
        if (this.currentKernel != null) {
            this.setGUIObject(this.currentKernel.gui.getDefaultGUIObject(this));
        }
    }

    public void setBean(Object object) {
        this.currentBean = object;
        this.bean_mode = true;
    }

    public Object getBean() {
        return this.currentBean;
    }

    public void setGUIObject(Object object) {
        this.currentBean = object;
        this.bean_mode = true;
    }

    public Object getGUIObject() {
        return this.currentBean;
    }

    public void debug(String string) {
        if (this.debugFlag) {
            this.println("*Debug* " + string);
        }
    }

    public void setDebug(boolean bl) {
        this.debugFlag = bl;
    }

    public boolean getDebug() {
        return this.debugFlag;
    }

    public void println(String string) {
        try {
            if (this.ostream != null) {
                this.ostream.write(string + "\n");
            } else {
                this.currentKernel.display("[" + this.getAgentInformation().getName() + "] " + string + "\n");
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException println: " + iOException.toString());
            iOException.printStackTrace();
        }
    }

    public void print(String string) {
        System.err.print(string);
    }

    public void setOutput(Writer writer) {
        this.setOutputWriter(writer);
    }

    public void setOutputWriter(Writer writer) {
        this.ostream = writer;
    }

    public void disposeMyGUI() {
        this.setOutputWriter(null);
        this.bean_mode = false;
        this.currentKernel.disposeGUIOf(this);
    }

    public void redisplayMyGUI() {
        this.currentKernel.redisplayGUIOf(this);
    }

    public void windowClosing(AWTEvent aWTEvent) {
        this.killAgent(this);
    }

    public int hashCode() {
        return this._hashCode;
    }
}

