/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.MacroDef;

public class MacroInstance
extends Task
implements DynamicConfigurator {
    private MacroDef macroDef;
    private Map map = new HashMap();
    private Map elements = new HashMap();
    private Hashtable localProperties = new Hashtable();

    public void setMacroDef(MacroDef macroDef) {
        this.macroDef = macroDef;
    }

    public void setDynamicAttribute(String name, String value) {
        this.map.put(name, value);
    }

    public Object createDynamicElement(String name) throws BuildException {
        if (this.macroDef.getElements().get(name) == null) {
            throw new BuildException("unsupported element " + name);
        }
        if (this.elements.get(name) != null) {
            throw new BuildException("Element " + name + " already present");
        }
        Element ret = new Element();
        this.elements.put(name, ret);
        return ret;
    }

    private String macroSubs(String s, Map macroMapping) {
        StringBuffer ret = new StringBuffer();
        StringBuffer macroName = new StringBuffer();
        boolean inMacro = false;
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '$') {
                inMacro = true;
            } else if (inMacro) {
                if (s.charAt(i) != '{') {
                    if (s.charAt(i) == '}') {
                        String name = macroName.toString();
                        String value = (String)macroMapping.get(name);
                        if (value == null) {
                            ret.append("${" + name + "}");
                        } else {
                            ret.append(value);
                        }
                        macroName = new StringBuffer();
                        inMacro = false;
                    } else {
                        macroName.append(s.charAt(i));
                    }
                }
            } else {
                ret.append(s.charAt(i));
            }
            ++i;
        }
        return ret.toString();
    }

    private UnknownElement copy(UnknownElement ue) {
        UnknownElement ret = new UnknownElement(ue.getTag());
        ret.setNamespace(ue.getNamespace());
        ret.setProject(this.getProject());
        ret.setQName(ue.getQName());
        ret.setTaskName(ue.getTaskName());
        ret.setLocation(ue.getLocation());
        ret.setOwningTarget(this.getOwningTarget());
        RuntimeConfigurable rc = new RuntimeConfigurable(ret, ue.getTaskName());
        rc.setPolyType(ue.getWrapper().getPolyType());
        Hashtable map = ue.getWrapper().getAttributeMap();
        Iterator i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            rc.setAttribute((String)entry.getKey(), this.macroSubs((String)entry.getValue(), this.localProperties));
        }
        rc.addText(this.macroSubs(ue.getWrapper().getText().toString(), this.localProperties));
        Enumeration e = ue.getWrapper().getChildren();
        while (e.hasMoreElements()) {
            RuntimeConfigurable r = (RuntimeConfigurable)e.nextElement();
            UnknownElement unknownElement = (UnknownElement)r.getProxy();
            String tag = unknownElement.getTag();
            MacroDef.TemplateElement templateElement = (MacroDef.TemplateElement)this.macroDef.getElements().get(tag);
            if (templateElement == null) {
                UnknownElement child = this.copy(unknownElement);
                rc.addChild(child.getWrapper());
                ret.addChild(child);
                continue;
            }
            Element element = (Element)this.elements.get(tag);
            if (element == null) {
                if (templateElement.isOptional()) continue;
                throw new BuildException("Required nested element " + templateElement.getName() + " missing");
            }
            Iterator i2 = element.getUnknownElements().iterator();
            while (i2.hasNext()) {
                UnknownElement child = (UnknownElement)i2.next();
                rc.addChild(child.getWrapper());
                ret.addChild(child);
            }
        }
        return ret;
    }

    public void execute() {
        this.localProperties = new Hashtable();
        HashSet copyKeys = new HashSet(this.map.keySet());
        int i = 0;
        while (i < this.macroDef.getAttributes().size()) {
            MacroDef.Attribute attribute = (MacroDef.Attribute)this.macroDef.getAttributes().get(i);
            String value = (String)this.map.get(attribute.getName());
            if (value == null) {
                value = attribute.getDefault();
            }
            if (value == null) {
                throw new BuildException("required attribute " + attribute.getName() + " not set");
            }
            this.localProperties.put(attribute.getName(), value);
            copyKeys.remove(attribute.getName());
            ++i;
        }
        if (copyKeys.size() != 0) {
            throw new BuildException("Unknown attribute" + (copyKeys.size() > 1 ? "s " : " ") + copyKeys);
        }
        UnknownElement c = this.copy(this.macroDef.getNestedTask());
        c.init();
        c.perform();
    }

    public static class Element
    implements TaskContainer {
        private List unknownElements = new ArrayList();

        public void addTask(Task nestedTask) {
            this.unknownElements.add(nestedTask);
        }

        public List getUnknownElements() {
            return this.unknownElements;
        }
    }
}

