/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.input;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.input.InputHandler;
import org.apache.tools.ant.input.InputRequest;
import org.apache.tools.ant.input.MultipleChoiceInputRequest;
import org.apache.tools.ant.util.KeepAliveInputStream;

public class DefaultInputHandler
implements InputHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInput(InputRequest request) throws BuildException {
        String prompt = this.getPrompt(request);
        FilterInputStream in = null;
        try {
            in = new DataInputStream(new KeepAliveInputStream(this.getInputStream()));
            do {
                System.err.println(prompt);
                try {
                    String input = ((DataInputStream)in).readLine();
                    request.setInput(input);
                }
                catch (IOException e) {
                    throw new BuildException("Failed to read input from Console.", e);
                }
            } while (!request.isInputValid());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new BuildException("Failed to close input.", e);
                }
            }
        }
    }

    protected String getPrompt(InputRequest request) {
        String prompt = request.getPrompt();
        if (request instanceof MultipleChoiceInputRequest) {
            StringBuffer sb = new StringBuffer(prompt);
            sb.append("(");
            Enumeration e = ((MultipleChoiceInputRequest)request).getChoices().elements();
            boolean first = true;
            while (e.hasMoreElements()) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(e.nextElement());
                first = false;
            }
            sb.append(")");
            prompt = sb.toString();
        }
        return prompt;
    }

    protected InputStream getInputStream() {
        return System.in;
    }
}

