/*
 * Decompiled with CFR 0.152.
 */
package SEdit;

import SEdit.Formalism;
import SEdit.NewNodeCommand;
import SEdit.NodeDesc;
import SEdit.SArrow;
import SEdit.SNode;
import SEdit.StructureAgent;
import SEdit.StructureEditor;
import java.awt.Graphics;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public class Structure {
    protected Formalism formalism;
    protected String description = "";
    protected Vector nodeList = new Vector();
    protected Vector arrowList = new Vector();
    private int numArrow = 0;
    private int numNode = 0;
    protected boolean modified = false;
    protected StructureEditor editor;
    protected StructureAgent agent;
    protected boolean snapToGrid = false;
    protected boolean displayGrid = false;
    protected int gridSize = 10;

    public void setFormalism(Formalism formalism) {
        this.formalism = formalism;
    }

    public Formalism getFormalism() {
        return this.formalism;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public Vector getNodes() {
        return this.nodeList;
    }

    public Vector getArrows() {
        return this.arrowList;
    }

    public StructureEditor getEditor() {
        return this.editor;
    }

    public void setEditor(StructureEditor structureEditor) {
        this.editor = structureEditor;
    }

    public StructureAgent getAgent() {
        return this.agent;
    }

    public void setAgent(StructureAgent structureAgent) {
        this.agent = structureAgent;
    }

    public void setSnapToGrid(boolean bl) {
        boolean bl2 = false;
        if (bl == this.snapToGrid) {
            bl2 = true;
        }
        this.snapToGrid = bl;
        if (bl2) {
            this.getEditor().setSnapToGrid(true);
        }
    }

    public boolean getSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid1(boolean bl) {
        this.snapToGrid = bl;
    }

    public void setDisplayGrid(boolean bl) {
        this.displayGrid = bl;
    }

    public boolean getDisplayGrid() {
        return this.displayGrid;
    }

    public void toggleShowGrid() {
        this.displayGrid = !this.displayGrid;
    }

    public void setGridSize(int n) {
        this.gridSize = n;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void initStructure() {
    }

    public void end() {
    }

    public void activate() {
        Enumeration enumeration = this.getNodes().elements();
        while (enumeration.hasMoreElements()) {
            ((SNode)enumeration.nextElement()).activate();
        }
    }

    public void preactivate() {
    }

    public void clearAll() {
        this.nodeList.removeAllElements();
        this.arrowList.removeAllElements();
    }

    public String newNodeID() {
        String string;
        while (this.existID(string = "N" + this.numNode++)) {
        }
        return string;
    }

    public String newArrowID() {
        String string;
        while (this.existID(string = "A" + this.numArrow++)) {
        }
        return string;
    }

    public boolean existID(String string) {
        return this.getNode(string) != null || this.getArrow(string) != null;
    }

    public void addNode(SNode sNode) {
        sNode.setID(this.newNodeID());
        this.nodeList.addElement(sNode);
        sNode.setStructure(this);
    }

    public void addNode(SNode sNode, String string) {
        sNode.setID(string);
        this.nodeList.addElement(sNode);
        sNode.setStructure(this);
    }

    public void addArrow(SArrow sArrow, SNode sNode, SNode sNode2) {
        sArrow.setID(this.newArrowID());
        this.arrowList.addElement(sArrow);
        sArrow.setStructure(this);
        sNode.addOutArrow(sArrow);
        sNode2.addInArrow(sArrow);
        sArrow.setOrigin(sNode);
        sArrow.setTarget(sNode2);
    }

    public void addArrow(SArrow sArrow, String string, SNode sNode, SNode sNode2) {
        sArrow.setID(string);
        this.arrowList.addElement(sArrow);
        sArrow.setStructure(this);
        sNode.addOutArrow(sArrow);
        sNode2.addInArrow(sArrow);
        sArrow.setOrigin(sNode);
        sArrow.setTarget(sNode2);
    }

    public boolean isConnectable(SArrow sArrow, SNode sNode, SNode sNode2) {
        return sArrow.isConnectable(sNode, sNode2) && sNode.isConnectable(sArrow, false) && sNode2.isConnectable(sArrow, true);
    }

    public void removeNode(SNode sNode) {
        this.nodeList.removeElement(sNode);
    }

    public void removeArrow(SArrow sArrow) {
        this.arrowList.removeElement(sArrow);
    }

    public void deleteAll() {
        Vector vector = (Vector)this.nodeList.clone();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((SNode)iterator.next()).delete();
        }
        vector = (Vector)this.arrowList.clone();
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((SArrow)iterator.next()).delete();
        }
        this.nodeList.removeAllElements();
        this.arrowList.removeAllElements();
    }

    public SNode getNode(String string) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            SNode sNode = (SNode)this.nodeList.elementAt(i);
            if (!sNode.getID().equals(string)) continue;
            return sNode;
        }
        return null;
    }

    public SArrow getArrow(String string) {
        for (int i = 0; i < this.arrowList.size(); ++i) {
            SArrow sArrow = (SArrow)this.arrowList.elementAt(i);
            if (!sArrow.getID().equals(string)) continue;
            return sArrow;
        }
        return null;
    }

    public SNode getNodeFromLabel(String string) {
        for (int i = 0; i < this.nodeList.size(); ++i) {
            SNode sNode = (SNode)this.nodeList.elementAt(i);
            if (sNode.getLabel() == null || !sNode.getLabel().equals(string)) continue;
            return sNode;
        }
        return null;
    }

    public SArrow getArrowFromLabel(String string) {
        for (int i = 0; i < this.arrowList.size(); ++i) {
            SArrow sArrow = (SArrow)this.arrowList.elementAt(i);
            if (sArrow.getLabel() == null || !sArrow.getLabel().equals(string)) continue;
            return sArrow;
        }
        return null;
    }

    public void drawBackground(Graphics graphics) {
    }

    public SNode createNode(String string, int n, int n2) {
        NodeDesc nodeDesc = this.getFormalism().getNodeDesc(string);
        return (SNode)this.getAgent().doCommand(new NewNodeCommand(nodeDesc, new Point(n, n2)));
    }

    public void dump() {
        int n;
        System.out.println("nodes:");
        for (n = 0; n < this.nodeList.size(); ++n) {
            System.out.println(this.nodeList.elementAt(n));
        }
        System.out.println("arrows:");
        for (n = 0; n < this.arrowList.size(); ++n) {
            System.out.println(this.arrowList.elementAt(n));
        }
    }

    public String toString() {
        String string = "anonymous";
        return "<Model \"" + string + "\" : \"" + this.getFormalism() + "\">";
    }
}

