/*
 * Decompiled with CFR 0.152.
 */
package SEdit.Formalisms.Petri;

import SEdit.Formalisms.Petri.PetriInLink;
import SEdit.Formalisms.Petri.PetriOutLink;
import SEdit.Formalisms.Petri.PetriScheduler;
import SEdit.Formalisms.Petri.PetriStructure;
import SEdit.Formalisms.Petri.PetriTransitionBehavior;
import SEdit.SEditTools;
import SEdit.Scheme.STools;
import SEdit.SimpleNode;
import gnu.lists.LList;
import gnu.lists.Pair;
import java.awt.Color;
import java.util.Hashtable;

public class PetriTransition
extends SimpleNode
implements PetriTransitionBehavior {
    boolean activated = false;
    Hashtable currentEnv;
    Object predicate;
    Object action;
    String actionString = null;
    String predicateString = null;

    public Object getPredicate() {
        return this.predicate;
    }

    void setPredicate(Object object) {
        this.predicate = object;
    }

    public Object getAction() {
        return this.action;
    }

    void setAction(Object object) {
        this.action = object;
    }

    public void setActionString(String string) {
        try {
            if (string != null) {
                this.action = STools.readFromString(string);
                this.actionString = string;
            }
        }
        catch (Exception exception) {
            System.out.println(":: Erreur de saisie d'action");
        }
    }

    public String getActionString() {
        return this.actionString;
    }

    public void setPredicateString(String string) {
        try {
            if (string != null) {
                this.predicate = STools.readFromString(string);
                this.predicateString = string;
            }
        }
        catch (Exception exception) {
            System.out.println(":: Erreur de saisie de pr\ufffddicat");
        }
    }

    public String getPredicateString() {
        return this.predicateString;
    }

    public void wakeUp() {
        if (!this.activated) {
            this.currentEnv = null;
            if (this.inArrows.size() > 0) {
                this.currentEnv = this.saturer(0, new Hashtable());
                if (this.currentEnv != null) {
                    this.activated = true;
                }
            }
        }
        if (this.activated) {
            int n;
            for (n = 0; n < this.inArrows.size(); ++n) {
                ((PetriInLink)this.inArrows.elementAt(n)).active(true);
            }
            for (n = 0; n < this.outArrows.size(); ++n) {
                ((PetriOutLink)this.outArrows.elementAt(n)).active(true);
            }
            ((PetriScheduler)((Object)this.structure)).addActivated(this);
            if (this.activated) {
                this.getGObject().setForeground(Color.magenta);
            } else {
                this.getGObject().setForeground(Color.black);
            }
            this.getGObject().getEditor().repaint();
        }
    }

    Hashtable saturer(int n, Hashtable hashtable) {
        if (n >= this.inArrows.size()) {
            if (this.predicate != null) {
                ((PetriStructure)this.structure).getSchemeModule().setAsCurrentEnv();
                Object object = STools.evalit(this.predicate, hashtable);
                if (object == Boolean.TRUE) {
                    return hashtable;
                }
                return null;
            }
            return hashtable;
        }
        Object object = ((PetriInLink)this.inArrows.elementAt(n)).getFilter();
        if (object == null) {
            if (((PetriInLink)this.inArrows.elementAt(n)).isEmpty()) {
                return null;
            }
            return this.saturer(n + 1, hashtable);
        }
        Object object2 = object;
        LList lList = ((PetriInLink)this.inArrows.elementAt(n)).getTokens();
        if (lList == null || lList.size() == 0) {
            return null;
        }
        for (int i = lList.size(); i > 0; --i) {
            Hashtable hashtable2 = (Hashtable)hashtable.clone();
            Hashtable hashtable3 = STools.match(object2, ((Pair)lList).car, hashtable2);
            if (hashtable3 != null) {
                if (n > this.inArrows.size()) {
                    if (this.predicate != null) {
                        ((PetriStructure)this.structure).getSchemeModule().setAsCurrentEnv();
                        Object object3 = STools.evalit(this.predicate, hashtable3);
                        if (object3 == Boolean.TRUE) {
                            return hashtable3;
                        }
                    }
                } else if ((hashtable3 = this.saturer(n + 1, hashtable3)) != null) {
                    return hashtable3;
                }
            }
            lList = (LList)((Pair)lList).cdr;
        }
        return null;
    }

    public void goToSleep() {
        if (this.activated) {
            this.activated = false;
            if (this.inArrows.size() > 0) {
                Hashtable hashtable;
                this.currentEnv = hashtable = this.saturer(0, new Hashtable());
                if (hashtable != null) {
                    this.activated = true;
                }
            }
            if (!this.activated) {
                int n;
                for (n = 0; n < this.inArrows.size(); ++n) {
                    ((PetriInLink)this.inArrows.elementAt(n)).active(false);
                }
                for (n = 0; n < this.outArrows.size(); ++n) {
                    ((PetriOutLink)this.outArrows.elementAt(n)).active(false);
                }
                ((PetriScheduler)((Object)this.structure)).removeActivated(this);
            }
            if (this.activated) {
                this.getGObject().setForeground(Color.magenta);
            } else {
                this.getGObject().setForeground(Color.black);
            }
            this.getGObject().getEditor().repaint();
        }
    }

    public void validate() {
        if (this.activated) {
            int n;
            Hashtable hashtable = this.currentEnv;
            for (n = 0; n < this.inArrows.size(); ++n) {
                ((PetriInLink)this.inArrows.elementAt(n)).consume(hashtable);
            }
            if (this.action != null) {
                String string = STools.writeToString(this.action);
                System.out.println(":: on evalue: " + string + " dans " + hashtable);
                ((PetriStructure)this.structure).getSchemeModule().setAsCurrentEnv();
                Object object = STools.evalit(this.action, hashtable);
                System.out.println(">> " + object + " : " + STools.prinToString(object));
            }
            for (n = 0; n < this.outArrows.size(); ++n) {
                ((PetriOutLink)this.outArrows.elementAt(n)).produce(hashtable);
            }
        } else {
            System.out.println("erreur, transition validee non active!!");
        }
    }

    public void modifyPredicate() {
        String string = this.predicate != null ? STools.writeToString(this.predicate) : "";
        String string2 = SEditTools.editText(this.getStructure().getAgent().gui, "Editing predicate of " + this.getLabel(), string);
        this.setPredicateString(string2);
    }

    public void modifyAction() {
        String string = this.action != null ? STools.writeToString(this.action) : "";
        String string2 = SEditTools.editText(this.getStructure().getAgent().gui, "Editing action of " + this.getLabel(), string);
        this.setActionString(string2);
    }
}

